﻿-- ----------------------------------------------------------------------------
-- GridStatusRaidIcons by kunda
-- ----------------------------------------------------------------------------
local RL = AceLibrary("Roster-2.1")
local L = AceLibrary("AceLocale-2.2"):new("GridStatusRaidIcons")

GridStatusRaidIcons = GridStatus:NewModule("GridStatusRaidIcons")
GridStatusRaidIcons.menuName = L["Raid Icons"]

local icontext = {
	[1] = L["Star"], -- Yellow 4-point Star
	[2] = L["Circle"], -- Orange Circle
	[3] = L["Diamond"], -- Purple Diamond
	[4] = L["Triangle"], -- Green Triangle
	[5] = L["Moon"], -- White Crescent Moon
	[6] = L["Square"], -- Blue Square
	[7] = L["X"], -- Red 'X' Cross
	[8] = L["Skull"] -- White Skull
}
local icontextcolor = {
	[1] = { r = 1, g = 1, b = 0 }, -- Yellow 4-point Star
	[2] = { r = 1, g = 0.5, b = 0 }, -- Orange Circle
	[3] = { r = 1, g = 0, b = 1 }, -- Purple Diamond
	[4] = { r = 0, g = 1, b = 0 }, -- Green Triangle
	[5] = { r = 0, g = 0.5, b = 1 }, -- White Crescent Moon
	[6] = { r = 0, g = 0, b = 1 }, -- Blue Square
	[7] = { r = 1, g = 0, b = 0 }, -- Red 'X' Cross
	[8] = { r = 1, g = 1, b = 1 } -- White Skull
}

GridStatusRaidIcons.defaultDB = {
	debug = false,
	alert_raidicons_player = {
		text =  L["Raid Icons: Player"],
		enable = true,
		color = { r = 1, g = 1, b = 1, a = 0.8 },
		priority = 50,
		range = false,
	},
	alert_raidicons_playertarget = {
		text =  L["Raid Icons: Player Target"],
		enable = true,
		color = { r = 1, g = 1, b = 1, a = 0.8 },
		priority = 50,
		range = false,
	}
}

GridStatusRaidIcons.options = false

function GridStatusRaidIcons:OnInitialize()
	self.super.OnInitialize(self)
	self:RegisterStatus("alert_raidicons_player", L["Raid Icons: Player"], nil, true)
	self:RegisterStatus("alert_raidicons_playertarget", L["Raid Icons: Player Target"], nil, true)
end

function GridStatusRaidIcons:OnEnable()
	self:RegisterEvent("RAID_TARGET_UPDATE", "Update")
	self:RegisterEvent("UNIT_TARGET")
	self:RegisterEvent("PARTY_MEMBERS_CHANGED", "Update")
end

function GridStatusRaidIcons:Update()
	for u in RL:IterateRoster() do
		self:UNIT_TARGET(u.unitid)
	end
end

function GridStatusRaidIcons:UNIT_TARGET(e_unitid)
	local settings1 = self.db.profile.alert_raidicons_player
	local settings2 = self.db.profile.alert_raidicons_playertarget
	local unitname = UnitName(e_unitid)
	local raidicon = GetRaidTargetIndex(e_unitid)
	local targetid

	-- group-/raidmember
	if type(raidicon) == "number" and settings1.enable then
		self.core:SendStatusGained(unitname, "alert_raidicons_player",
			settings1.priority,
			(settings1.range and 40),
			{ r = icontextcolor[raidicon].r, g = icontextcolor[raidicon].g, b = icontextcolor[raidicon].b, a = settings1.color.a },
			icontext[raidicon],
			nil,
			nil,
			"Interface\\AddOns\\Grid\\GridStatusRaidIcons\\icons\\icon".. raidicon ..".tga")
	else
		self.core:SendStatusLost(unitname, "alert_raidicons_player")
	end

	-- group-/raidmember target
	if UnitExists(e_unitid.."target") and settings2.enable then
		targetid = e_unitid.."target"
		raidicon = GetRaidTargetIndex(targetid)
		if type(raidicon) == "number" then
			self.core:SendStatusGained(unitname, "alert_raidicons_playertarget",
				settings2.priority,
				(settings2.range and 40),
				{ r = icontextcolor[raidicon].r, g = icontextcolor[raidicon].g, b = icontextcolor[raidicon].b, a = settings2.color.a },
				icontext[raidicon],
				nil,
				nil,
				"Interface\\AddOns\\Grid\\GridStatusRaidIcons\\icons\\icon".. raidicon ..".tga")
		else
			self.core:SendStatusLost(unitname, "alert_raidicons_playertarget")
		end
	else
		self.core:SendStatusLost(unitname, "alert_raidicons_playertarget")
	end
end