﻿-- ----------------------------------------------------------------------------
-- GridStatusMTs by kunda
-- ----------------------------------------------------------------------------
local RL = AceLibrary("Roster-2.1")
local L = AceLibrary("AceLocale-2.2"):new("GridStatusMTs")

GridStatusMTs = GridStatus:NewModule("GridStatusMTs")
GridStatusMTs.menuName = L["MTs"]

GridStatusMTs.defaultDB = {
	debug = false,
	alert_mt = {
		text =  L["MTs"],
		enable = true,
		color = { r = 1, g = 1, b = 1, a = 0.4 },
		priority = 60,
		range = false,
	}
}

GridStatusMTs.options = false

function GridStatusMTs:OnInitialize()
	self.super.OnInitialize(self)
	self:RegisterStatus("alert_mt", L["MTs"], nil, true)
end

function GridStatusMTs:OnEnable()
	self:RegisterEvent("oRA_MainTankUpdate", "GetMainTankTable")
	self:RegisterEvent("RAID_ROSTER_UPDATE", "GetMainTankTable")
	if CT_RAOptions_UpdateMTs then
		hooksecurefunc("CT_RAOptions_UpdateMTs", function() self:GetMainTankTable() end)
	end
end

function GridStatusMTs:GetMainTankTable()
	local maintanktable
	if oRA then
		maintanktable = maintanktable or oRA.maintanktable
	else
		maintanktable = CT_RA_MainTanks
	end
	if not maintanktable then return end
	self:MainTankUpdate(maintanktable)
end

function GridStatusMTs:MainTankUpdate(maintanktable)
	local settings = self.db.profile.alert_mt
	local name

	for u in RL:IterateRoster() do
		self.core:SendStatusLost(UnitName(u.unitid), "alert_mt")
	end

	if not settings.enable then
		return
	end
	
	for i = 1, 10 do
		if maintanktable[i] then
			for u in RL:IterateRoster() do
				name = UnitName(u.unitid)
				if maintanktable[i] == name then
					self.core:SendStatusGained(name, "alert_mt",
						settings.priority,
						(settings.range and 40),
						settings.color,
						"MT"..i,
						nil,
						nil,
						"Interface\\AddOns\\GridStatusMTs\\icons\\mt"..i..".tga")
				end
			end
		end
	end

end