﻿--[[
	Name: GridStatusIncomingHeals
	Revision: $Revision: 74953 $
	Developed by: wT (Wizuntryeh/Wiz) @ Emerald Dream-EU (wt@iki.fi)
	Description: IncomingHealsLib module for Grid

	Initially, I think I butchered the GridStatusHots addon and used it as base for this,
	credits to the creator of GridStatusHots and other Grid-modules for guideline.

	ToDo:
		- Utilize colors, maybe to show under-/overheals?
]]

--{{{ Libraries

local L = AceLibrary("AceLocale-2.2"):new("GridStatusIncomingHeals")
local RL = AceLibrary("Roster-2.1")
local IHL = AceLibrary("IncomingHealsLib-1.0")

local player = UnitName("player")

--}}}

L:RegisterTranslations("enUS", function()
	return {
		["IncomingHeals"] = true,
		["IH:Target"] = true,
		["IH:Heals"] = true,
		["Custom text"] = true,
		["Ignore self"] = true,
		["Hide your own heals."] = true,
		-- Hack'ish...
		["Custom text for the "] = true,
		["target"] = true,
		["amount"] = true,
		[" display. Use %t for target and %a for amount. Empty to disable."] = true,
		["<any string>"] = true,
	}
end)

L:RegisterTranslations("koKR", function()
	return {
		["IncomingHeals"] = "받는 치유",
		["IH:Target"] = "IH:대상",
		["IH:Heals"] = "IH:치유",
		["Custom text"] = "사용자 문자",
		["Ignore self"] = "자신 무시",
		["Hide your own heals."] = "자신 치유는 숨김니다.",
		-- Hack'ish...
		["Custom text for the "] = "사용자 문자에 ",
		["target"] = "대상",
		["amount"] = "치유양",
		[" display. Use %t for target and %a for amount. Empty to disable."] = "을 표시합니다. %t는 대상 그리고 %a는 치유량으로 사용 가능합니다.",
		["<any string>"] = "<모든 문자열>",
	}
end)

L:RegisterTranslations("zhCN", function()
	return {
		["IncomingHeals"] = "接受治疗（IH）",
		["IH:Target"] = "IH：目标",
		["IH:Heals"] = "IH：治疗",
		["Custom text"] = "自定义文本",
		["Ignore self"] = "忽略自身",
		["Hide your own heals."] = "隐藏你自身治疗。",
		-- Hack'ish...
		["Custom text for the "] = "自定义文本：",
		["target"] = "目标",
		["amount"] = "数值",
		[" display. Use %t for target and %a for amount. Empty to disable."] = "显示。使用%t为目标、%a为数值。空白为禁用。",
		["<any string>"] = "<任意字符串>",
	}
end)

L:RegisterTranslations("zhTW", function()
	return {
		["IncomingHeals"] = "接受治療（IH）",
		["IH:Target"] = "IH：目標",
		["IH:Heals"] = "IH：治療",
		["Custom text"] = "自訂文字",
		["Ignore self"] = "忽略自身",
		["Hide your own heals."] = "隱藏你自身治療。",
		-- Hack'ish...
		["Custom text for the "] = "自訂文字：",
		["target"] = "目標",
		["amount"] = "數值",
		[" display. Use %t for target and %a for amount. Empty to disable."] = "顯示。使用%t為目標、%a為數值。空白為停用。",
		["<any string>"] = "<任意字串>",
	}
end)

GridStatusIncomingHeals = GridStatus:NewModule("GridStatusIncomingHeals")
GridStatusIncomingHeals.menuName = L["IncomingHeals"]

--{{{ AceDB defaults

GridStatusIncomingHeals.defaultDB = {
	debug = false,
	alert_IncomingHealstarget = {
		text = "Target",
		enable = true,
		priority = 89,
		range = false,
		color = { r = 1, g = 0, b = 0, a = 1 },
		customText = "",
		hideOwn = false,
	},
	alert_IncomingHealsamount = {
		text = "Heals",
		enable = true,
		priority = 90,
		range = false,
		color = { r = 0, g = 1, b = 0, a = 1 },
		customText = "",
		hideOwn = false,
	},
}

--}}}

function GridStatusIncomingHeals:OnInitialize()
	self.super.OnInitialize(self)

	local options = {
		customText = {
			name = L["Custom text"],
			desc = L["Custom text for the "]..L["target"]..L[" display. Use %t for target and %a for amount. Empty to disable."],
			type = "text",
			get = function() return GridStatusIncomingHeals.db.profile.alert_IncomingHealstarget.customText end,
			set = function(v) GridStatusIncomingHeals.db.profile.alert_IncomingHealstarget.customText = v end,
			usage = L["<any string>"],
		},
		hideOwn = {
			name = L["Ignore self"],
			desc = L["Hide your own heals."],
			type = "toggle",
			get = function() return GridStatusIncomingHeals.db.profile.alert_IncomingHealstarget.hideOwn end,
			set = function(v) GridStatusIncomingHeals.db.profile.alert_IncomingHealstarget.hideOwn = v end,
		}
	}
	self:RegisterStatus("alert_IncomingHealstarget", L["IH:Target"], options, true)

	options = {
		customText = {
			name = L["Custom text"],
			desc = L["Custom text for the "]..L["amount"]..L[" display. Use %t for target and %a for amount. Empty to disable."],
			type = "text",
			get = function() return GridStatusIncomingHeals.db.profile.alert_IncomingHealsamount.customText end,
			set = function(v) GridStatusIncomingHeals.db.profile.alert_IncomingHealsamount.customText = v end,
			usage = L["<any string>"],
		},
		hideOwn = {
			name = L["Ignore self"],
			desc = L["Hide your own heals."],
			type = "toggle",
			get = function() return GridStatusIncomingHeals.db.profile.alert_IncomingHealsamount.hideOwn end,
			set = function(v) GridStatusIncomingHeals.db.profile.alert_IncomingHealsamount.hideOwn = v end,
		},
	}
	self:RegisterStatus("alert_IncomingHealsamount", L["IH:Heals"], options, true)
	options = nil
end

function GridStatusIncomingHeals:OnEnable()
	self:RegisterEvent("IncomingHealsLib_HealStart", "HealStart")
	self:RegisterEvent("IncomingHealsLib_HealCancel", "HealEnd")
	self:RegisterEvent("IncomingHealsLib_HealEnd", "HealEnd")
end

function GridStatusTarget:Reset()
	self.super.Reset(self)
	self:ClearStatus()
end

function GridStatusIncomingHeals:ClearStatus()
	local name
	for name in self.core:CachedStatusIterator("alert_IncomingHealstarget") do
		self.core:SendStatusLost(name, "alert_IncomingHealstarget")
	end
	for name in self.core:CachedStatusIterator("alert_IncomingHealsamount") do
		self.core:SendStatusLost(name, "alert_IncomingHealsamount")
	end
end

function GridStatusIncomingHeals:HealStart(target, source)
	target = target:match("(.+)%-") or target
	source = source:match("(.+)%-") or source
	if not RL:GetUnitIDFromName(target) or not RL:GetUnitIDFromName(source) then return end

	local targetSettings = self.db.profile.alert_IncomingHealstarget
	local amountSettings = self.db.profile.alert_IncomingHealsamount

	local amount, _, my_amount = IHL:GetTargetIncomingHealInfo(target)

	if amountSettings.hideOwn and my_amount then
		amount = amount - my_amount
	end
	if not amount or amount <= 0 then return end

	if amount < 10000 then
		amount = string.format("%.1f", amount / 1000)
	else
		amount = string.format("%.0fk", amount / 1000)
	end

	local str

	str = "+"..target
	if targetSettings.customText ~= "" then
		str = string.gsub(targetSettings.customText, "%%t", target)
		str = string.gsub(str, "%%a", amount)
	end
	self:AddStatus(source, "target", str)

	str = "+"..amount
	if amountSettings.customText ~= "" then
		str = string.gsub(amountSettings.customText, "%%t", target)
		str = string.gsub(str, "%%a", amount)
	end
	self:AddStatus(target, "amount", str)
end

function GridStatusIncomingHeals:HealEnd(target, source)
	target = target:match("(.+)%-") or target
	source = source:match("(.+)%-") or source
	local amount = IHL:GetTargetIncomingHealInfo(target)

	self.core:SendStatusLost(source, "alert_IncomingHealstarget")

	if not amount or amount == 0 then
		self.core:SendStatusLost(target, "alert_IncomingHealsamount")
	end
end

function GridStatusIncomingHeals:AddStatus(who, what, value)
	local settings = self.db.profile["alert_IncomingHeals"..what]

	if settings.hideOwn and who == player then return end

	self.core:SendStatusGained(who, "alert_IncomingHeals"..what,
		settings.priority,
		settings.range,
		settings.color,
		value)
end