--[[
	Name: GridStatusHostileUnit
	Revision: $Revision: 82146 $
	Developed by: Julith @ Perenolde-EU (billgatesgut@web.de)
	Description: Publishes the state if a Unit is hostile to the player.

	Credits to oodyboo from WoWAce for the idea of this addon.
]]

--{{{ Libraries

local L = AceLibrary("AceLocale-2.2"):new("GridStatusHostileUnit")
local Roster = AceLibrary("Roster-2.1")

--}}}

L:RegisterTranslations("enUS", function()
	return {
		    ["HostileUnit"] = true,
        ["hostile unit"] = true,
        ["WarningNotice"] = "Note from GridStatusHostileUnit:\n\n"..
                            "To reduce CPU-usage overhead of the last version I've changed some things which might "..
                            "result in not noticed hostile units or (worse) errors. If this happens, please let me "..
                            "know about it in the WowAce-Forums, I'll fix it as fast as I can.\n\nThank you for your patience in advance.",
	}
end)

L:RegisterTranslations("koKR", function()
	return {
		["HostileUnit"] = "적대적 유닛",
        ["hostile unit"] = "적대적 유닛",
	}
end)

L:RegisterTranslations("zhCN", function()
	return {
		["HostileUnit"] = "敌对单位",
        ["hostile unit"] = "敌对单位",
	["is hostile"] = "敌对的",
	}
end)

L:RegisterTranslations("zhTW", function()
	return {
		["HostileUnit"] = "敵對單位",
        ["hostile unit"] = "敵對單位",
	["is hostile"] = "敵對的",
	}
end)

L:RegisterTranslations("frFR", function()
	return {
		    ["HostileUnit"] = "Unit\195\169 hostile",
        ["hostile unit"] = "Unit\195\169 hostile",
        ["WarningNotice"] = "Note from GridStatusHostileUnit:\n\n"..
                            "To reduce CPU-usage overhead of the last version I've changed some things which might "..
                            "result in not noticed hostile units or (worse) errors. If this happens, please let me "..
                            "know about it in the WowAce-Forums, I'll fix it as fast as I can.\n\nThank you for your patience in advance.",
	
	}
end)

GridStatusHostileUnit = GridStatus:NewModule("GridStatusHostileUnit")
GridStatusHostileUnit.menuName = L["HostileUnit"]


--{{{ AceDB defaults

GridStatusHostileUnit.defaultDB = {
	unitIsHostile = {
		enable = true,
		priority = 90,
		color = { r = 1, g = 0, b = 0, a = 1 },
	},
    warningDisplayed = false,
}

--}}}

--{{{ Options
local amountOptions = {
}
--}}}

local playerIsHostile = false
local settings

function GridStatusHostileUnit:OnInitialize()
	self.super.OnInitialize(self)
	self:RegisterStatus("unitIsHostile", L["hostile unit"], amountOptions, true)
    settings = GridStatusHostileUnit.db.profile
end

function GridStatusHostileUnit:OnEnable()
	self:RegisterEvent("UNIT_AURA")
    self:RegisterEvent("Grid_UnitJoined")
	self:RegisterEvent("Grid_UnitChanged")
    self:RegisterEvent("PLAYER_ENTERING_WORLD", "UpdateAllUnits")
    
    if not settings.warningDisplayed then
        StaticPopupDialogs["GRID_HOSTILE_NOTE"] = {
          text = L["WarningNotice"],
          button1 = "Ok.",
          timeout = 0,
          whileDead = 1,
        };
        StaticPopup_Show ("GRID_HOSTILE_NOTE");
        settings.warningDisplayed = true;
    end
end


function GridStatusHostileUnit:UpdateAllUnits()
	local name, status, statusTbl

	for name, status, statusTbl in self.core:CachedStatusIterator("unitIsHostile") do
		self:Grid_UnitJoined(name)
	end
end

function GridStatusHostileUnit:Grid_UnitJoined(name, unitid)
	if unitid then
		self:Update(unitid)
	end
end

function GridStatusHostileUnit:Grid_UnitChanged(name, unitid)
	self:Update(unitid)
end

local function xor(v1, v2)
    return (v1 or false) ~= (v2 or false)
end

function GridStatusHostileUnit:Update(unitid)
    if not unitid then
        return
    end

    if not Roster:GetUnitObjectFromUnit(unitid) then return end

    local name = UnitName(unitid);

    local hostile = UnitIsCharmed(unitid);
    
    if hostile then
        self.core:SendStatusGained(name, "unitIsHostile",
				    settings.unitIsHostile.priority,
				    nil,
				    settings.unitIsHostile.color)
    else
        self.core:SendStatusLost(name, "unitIsHostile")
    end
end

function GridStatusHostileUnit:UNIT_AURA(unitid)    
    self:Update(unitid)
end


