﻿--{{{ Libraries
local RL = AceLibrary("Roster-2.1")
local L = AceLibrary("AceLocale-2.2"):new("GridStatusGroupnumber")
--}}}

GridStatusGroupnumber = GridStatus:NewModule("GridStatusGroupnumber")
GridStatusGroupnumber.menuName = L["Unit Groupnumber"]

--{{{ AceDB defaults
GridStatusGroupnumber.defaultDB = {
	debug = false,
	unit_groupnumber = {
		text = L["Unit Groupnumber"],
		enable = true,
		color = { r = .6, g = .6, b = .6, a = .35 },
		priority = 1,
		range = false,
	},
}
--}}}	

GridStatusGroupnumber.options = nil

function GridStatusGroupnumber:OnInitialize()
	self.super.OnInitialize(self)
	self:RegisterStatus("unit_groupnumber", L["Unit Groupnumber"], nil, true)
end

function GridStatusGroupnumber:OnEnable()
	self:RegisterEvent("Grid_UnitChanged", "UpdateUnit")
	self:RegisterEvent("Grid_UnitJoined", "UpdateUnit")
	self:RegisterEvent("Grid_UnitLeft", "UpdateUnit")
	self:UpdateAllUnits()
end

function GridStatusGroupnumber:Reset()
	self.super.Reset(self)
	self:UpdateAllUnits()
end

function GridStatusGroupnumber:UpdateUnit(name, unitid)
	local settings = self.db.profile.unit_groupnumber
	local u = RL:GetUnitObjectFromName(name)

	if not u then
		self.core:SendStatusLost(name, "unit_groupnumber")
		return
	end
	
	local text = ""..u.subgroup
	
	self.core:SendStatusGained(name, "unit_groupnumber",
				    settings.priority,
				    nil,
				    settings.color,
				    text)
end

function GridStatusGroupnumber:UpdateAllUnits()
	local name, status, statusTbl

	for name, status, statusTbl in self.core:CachedStatusIterator("unit_groupnumber") do
		self:UpdateUnit(name)
	end
end
