local L = AceLibrary("AceLocale-2.2"):new("GridStatusControlPipes")
local RL = AceLibrary("Roster-2.1")

BINDING_HEADER_STATUS_PIPES = "Grid status control pipes"
BINDING_NAME_pipe_1 = "Pipe 1"
BINDING_NAME_pipe_2 = "Pipe 2"

GridStatusControlPipes = GridStatus:NewModule("GridStatusControlPipes")

GridStatusControlPipes.menuName = "GridStatusControlPipes"

GridStatusControlPipes.defaultDB = {
    status_pipe_1 = {
        enable = true,
		color = { r = 1, g = 1, b = 1, a = 1 },
		priority = 50,
        usePipeColor = false,
        pipeInCombat = true,
        pipeOOC = true,
--        pipeOnMouse = false,
--        blockOnMouse = false,
    },
    status_pipe_2 = {
        enable = true,
		color = { r = 1, g = 1, b = 1, a = 1 },
		priority = 50,
        usePipeColor = false,
        pipeInCombat = true,
        pipeOOC = true,
--        pipeOnMouse = false,
--        blockOnMouse = false,
    },
}

GridStatusControlPipes.options = false

local pipe1_options = {
    ["key_pipe_1"] = {
        type = "text",
        name = "Key for pipe",
        desc = "Sets the key binding for this pipe.",
        get = function() return GetBindingKey("pipe_1") end,
        usage = "<key>",
        set = function(v) GridStatusControlPipes.SetPipeKey(GridStatusControlPipes, v, "pipe_1") end,
        order = -3,
    },
    ["combat_pipe_1"] = {
        type = "toggle",
        name = "In combat piping",
        desc = "If enabled, the pipe is active in combat. (Updates as soon as your combat state changes)",
        get = function() return GridStatusControlPipes.db.profile.status_pipe_1.pipeInCombat end,
        set = function(v) GridStatusControlPipes.db.profile.status_pipe_1.pipeInCombat = v end,
        order = -2,
    },
    ["ooc_pipe_1"] = {
        type = "toggle",
        name = "Out of combat piping",
        desc = "If enabled, the pipe is active in out of combat. (Updates as soon as your combat state changes)",
        get = function() return GridStatusControlPipes.db.profile.status_pipe_1.pipeOOC end,
        set = function(v) GridStatusControlPipes.db.profile.status_pipe_1.pipeOOC = v end,
        order = -2,
    },
    ["color_pipe_1"] = {
        type = "toggle",
        name = "Use pipe color",
        desc = "If enabled, it will use the color of the pipes status instead the color of the piped status.",
        get = function() return GridStatusControlPipes.db.profile.status_pipe_1.usePipeColor end,
        set = function(v) GridStatusControlPipes.db.profile.status_pipe_1.usePipeColor = v end,
        order = -2,
    },
--[[    ["show_onMouse_pipe_1"] = {
        type = "toggle",
        name = "Show on mouse over",
        desc = "If enabled, the pipe is active when the mouse is over the unitframe. ",
        get = function() return GridStatusControlPipes.db.profile.status_pipe_1.pipeOnMouse end,
        set = function(v) GridStatusControlPipes.db.profile.status_pipe_1.pipeOnMouse = v end,
        order = -2,
    },
    ["hide_onMouse_pipe_1"] = {
        type = "toggle",
        name = "Hide on mouse over",
        desc = "If enabled, the pipe is blocking when the mouse is over the unitframe. ",
        get = function() return GridStatusControlPipes.db.profile.status_pipe_1.blockOnMouse end,
        set = function(v) GridStatusControlPipes.db.profile.status_pipe_1.blockOnMouse = v end,
        order = -2,
    },]]
}

local pipe2_options = {
    ["key_pipe_2"] = {
        type = "text",
        name = "Key for pipe",
        desc = "Sets the key binding for this pipe.",
        get = function() return GetBindingKey("pipe_2") end,
        usage = "<key>",
        set = function(v) GridStatusControlPipes.SetPipeKey(GridStatusControlPipes, v, "pipe_2") end,
        order = -3,
    },
    ["combat_pipe_2"] = {
        type = "toggle",
        name = "In combat piping",
        desc = "If enabled, the pipe is active in combat. (Updates as soon as your combat state changes)",
        get = function() return GridStatusControlPipes.db.profile.status_pipe_2.pipeInCombat end,
        set = function(v) GridStatusControlPipes.db.profile.status_pipe_2.pipeInCombat = v end,
        order = -2,
    },
    ["ooc_pipe_2"] = {
        type = "toggle",
        name = "Out of combat piping",
        desc = "If enabled, the pipe is active in out of combat. (Updates as soon as your combat state changes)",
        get = function() return GridStatusControlPipes.db.profile.status_pipe_2.pipeOOC end,
        set = function(v) GridStatusControlPipes.db.profile.status_pipe_2.pipeOOC = v end,
        order = -2,
    },
    ["color_pipe_1"] = {
        type = "toggle",
        name = "Use pipe color",
        desc = "If enabled, it will use the color of the pipes status instead the color of the piped status.",
        get = function() return GridStatusControlPipes.db.profile.status_pipe_1.usePipeColor end,
        set = function(v) GridStatusControlPipes.db.profile.status_pipe_1.usePipeColor = v end,
        order = -2,
    },
--[[    ["show_onMouse_pipe_2"] = {
        type = "toggle",
        name = "Show on mouse over",
        desc = "If enabled, the pipe is active when the mouse is over the unitframe. ",
        get = function() return GridStatusControlPipes.db.profile.status_pipe_2.pipeOnMouse end,
        set = function(v) GridStatusControlPipes.db.profile.status_pipe_2.pipeOnMouse = v end,
        order = -2,
    },
    ["hide_onMouse_pipe_2"] = {
        type = "toggle",
        name = "Hide on mouse over",
        desc = "If enabled, the pipe is blocking when the mouse is over the unitframe. ",
        get = function() return GridStatusControlPipes.db.profile.status_pipe_2.blockOnMouse end,
        set = function(v) GridStatusControlPipes.db.profile.status_pipe_2.blockOnMouse = v end,
        order = -2,
    },]]
}

local indicators = GridFrame.frameClass.prototype.indicators
table.insert(indicators, { type = "pipe_1",    order = 15,  name = "Pipe 1" })
table.insert(indicators, { type = "pipe_2",    order = 15,  name = "Pipe 2" })

local statusmap = GridFrame.db.profile.statusmap
if ( not statusmap["pipe_1"] ) then
	statusmap["pipe_1"] = { unit_name = true }
    statusmap["text"].unit_name = false
    statusmap["text"].pipe_1 = true
end
if ( not statusmap["pipe_2"] ) then
    statusmap["pipe_1"] = {}
end
    
local AceOO = AceLibrary("AceOO-2.0")
local PipeFrameClass = AceOO.Class(GridFrame.frameClass)

local _frameClass = nil
if ( not _frameClass ) then
	_frameClass = GridFrame.frameClass
	GridFrame.frameClass = PipeFrameClass
end
--[[
local function OnMouseEnter(frame)
    local unitid = frame and SecureButton_GetModifiedUnit(frame)
    if not unitid then return end
    GridStatusControlPipes:SetPipeControl("pipe_1", 
                        "combat_mode", settings.status_pipe_1.pipeInCombat)
    GridStatusControlPipes:SetPipeControl("pipe_2", "combat_mode", settings.status_pipe_2.pipeInCombat)
end

function PipeFrameClass.prototype:CreateFrames()
	PipeFrameClass.super.prototype.CreateFrames(self)
	
    local f = self.frame
    f.SetScript("OnEnter", OnMouseEnter);
    f.SetScript("OnLeave", OnMouseLeave);
end
]]

function PipeFrameClass.prototype:SetIndicator(indicator, color, text, value, maxValue, texture, start, duration, stack, ...)
	PipeFrameClass.super.prototype.SetIndicator(self,indicator, color, text, value, maxValue, texture, start, duration, stack, ...)
    
    if indicator == "pipe_1" or indicator == "pipe_2" then
        local unitid = self.frame and SecureButton_GetModifiedUnit(self.frame)
        if not unitid then return end
        --DEFAULT_CHAT_FRAME:AddMessage(unitid or "nil")
        GridStatusControlPipes:SendStatus(UnitName(unitid), indicator, color, text, value, maxValue, texture, start, duration, stack, ...)
    end
end

function PipeFrameClass.prototype:ClearIndicator(indicator)
    PipeFrameClass.super.prototype.ClearIndicator(self,indicator)
    
    if indicator == "pipe_1" or indicator == "pipe_2" then
        local unitid = self.frame and SecureButton_GetModifiedUnit(self.frame)
        if not unitid then return end
        --DEFAULT_CHAT_FRAME:AddMessage(SecureButton_GetModifiedUnit(self.frame) or "nil")
        GridStatusControlPipes:ClearStatus(UnitName(unitid), indicator)
    end
end


local statusCache = {}
local pipeActive = {}
local pipeControls = {}
local pipeKeyDownTime = {}

    
function GridStatusControlPipes:OnInitialize()
	self.super.OnInitialize(self)
    
	self:RegisterStatus('status_pipe_1',"Pipe 1",pipe1_options, true)    
    self:RegisterStatus('status_pipe_2',"Pipe 2",pipe2_options, true)    
end

function GridStatusControlPipes:OnEnable()	
    self:RegisterEvent("PLAYER_REGEN_DISABLED")
    self:RegisterEvent("PLAYER_REGEN_ENABLED")
end

---Event handling---------------------------------------



function GridStatusControlPipes:PipeKeyDown(pipe)
    self:SetPipeControl(pipe, "key")
    
    pipeKeyDownTime[pipe] = GetTime()
    --DEFAULT_CHAT_FRAME:AddMessage("key down for pipe "..pipe)
end

function GridStatusControlPipes:PipeKeyUp(pipe)
    
    
    local gone = GetTime() - pipeKeyDownTime[pipe]
    
    if gone > 0.3 then
        self:SetPipeControl(pipe, "key")
    end
    --DEFAULT_CHAT_FRAME:AddMessage("key up for pipe "..pipe)
end

function GridStatusControlPipes:PLAYER_REGEN_DISABLED()
    local settings = self.db.profile
    self:SetPipeControl("pipe_1", "combat_mode", settings.status_pipe_1.pipeInCombat)
    self:SetPipeControl("pipe_2", "combat_mode", settings.status_pipe_2.pipeInCombat)
end

function GridStatusControlPipes:PLAYER_REGEN_ENABLED()
    local settings = self.db.profile
    self:SetPipeControl("pipe_1", "combat_mode", settings.status_pipe_1.pipeOOC)
    self:SetPipeControl("pipe_2", "combat_mode", settings.status_pipe_2.pipeOOC)
end

---Generell status piping--------------------------------

function GridStatusControlPipes:SetPipeControl(pipe, control, isPiping)
    local pipeControl = pipeControls[pipe]
    if not pipeControl then
        pipeControls[pipe] = {}
        pipeControl = pipeControls[pipe]
    end
    
    local oldState = pipeControl[control]
    if oldState == nil then 
        pipeControl[control] = true 
        oldState = true
    end
    
    if isPiping == nil then
        pipeControl[control] = not oldState
    else
        if oldState == isPiping then
            return
        else
            pipeControl[control] = isPiping
        end
    end
    
    local newPipeState = true
    for _,s in pairs(pipeControl) do
        newPipeState = newPipeState and s
        if not newPipeState then break end
    end
    
    if newPipeState ~= pipeActive[pipe] then
        pipeActive[pipe] = newPipeState
        self:UpdateAllUnits(pipe)
    end
end

function GridStatusControlPipes:SetPipeKey(key, pipe)
    local oldKey = GetBindingKey(pipe)
    
    local suc = SetBinding(key, pipe)
    if suc then
        if oldKey then SetBinding(oldKey) end
        SaveBindings(2)
    end    
end

function GridStatusControlPipes:UpdateAllUnits(pipe)
    if pipeActive[pipe] then
        for u in RL:IterateRoster() do
            self:SendCachedStatus(u.name, pipe)
        end
    else
        local status = "status_"..pipe
        for u in RL:IterateRoster() do
            self.core:SendStatusLost(u.name, status)
        end
    end
end

function GridStatusControlPipes:SendPipeStatus(unitName, pipe, color, text, value, maxValue, texture, start, duration, stack)
    pipe = "status_"..pipe
    
    local settings = self.db.profile[pipe]
    if settings.usePipeColor then
        color = settings.color
    end
    local prio = settings.priority
    self.core:SendStatusGained(unitName, pipe, 
                prio, nil, 
                color, 
                text, 
                value, maxValue, 
                texture, 
                start, duration, stack)
end

function GridStatusControlPipes:SendCachedStatus(unitName, pipe)
    --DEFAULT_CHAT_FRAME:AddMessage("sending cached status for "..unitName.." at pipe "..pipe)
    local indTbl = statusCache[unitName] 
    if indTbl then
        --DEFAULT_CHAT_FRAME:AddMessage("found unit table")
        local cacheTbl = indTbl[pipe]
        if cacheTbl then
            --[[DEFAULT_CHAT_FRAME:AddMessage("found cache table")
            DEFAULT_CHAT_FRAME:AddMessage("color:"..((cacheTbl.color and "col") or "nil"))
            DEFAULT_CHAT_FRAME:AddMessage("text:"..(cacheTbl.text or "nil"))
            DEFAULT_CHAT_FRAME:AddMessage("value:"..(cacheTbl.value or "nil"))
            DEFAULT_CHAT_FRAME:AddMessage("maxvalue:"..(cacheTbl.maxValue or "nil"))
            DEFAULT_CHAT_FRAME:AddMessage("texture:"..(cacheTbl.texture or "nil")) ]]
            
            self:SendPipeStatus(unitName, pipe, 
                cacheTbl.color, 
                cacheTbl.text, 
                cacheTbl.value, cacheTbl.maxValue, 
                cacheTbl.texture, 
                cacheTbl.start, cacheTbl.duration, cacheTbl.stack)
            return
        end
    end
    
    self.core:SendStatusLost(unitName, "status_"..pipe)
end

function GridStatusControlPipes:SendStatus(unitName, pipe, color, text, value, maxValue, texture, start, duration, stack, ...)
    if pipeActive[pipe] then
        --DEFAULT_CHAT_FRAME:AddMessage("piping status for "..unitName.." at pipe "..pipe)
        self:SendPipeStatus(unitName, pipe, 
                color, 
                text, 
                value, maxValue, 
                texture, 
                start, duration, stack, ...)
    else
        --DEFAULT_CHAT_FRAME:AddMessage("cache status for "..unitName.." at pipe "..pipe)
        local indTbl = statusCache[unitName] 
        if not indTbl then
            statusCache[unitName] = {}
            indTbl = statusCache[unitName]
        end
        local cacheTbl = indTbl[pipe]
        if not cacheTbl then
            indTbl[pipe] = {}
            cacheTbl = indTbl[pipe]
        end
        cacheTbl.color = color
        cacheTbl.text = text
        cacheTbl.value = value
        cacheTbl.maxValue = maxValue
        cacheTbl.texture = texture
        cacheTbl.start = start
        cacheTbl.duration = duration
        cacheTbl.stack = stack
    end
end

function GridStatusControlPipes:ClearStatus(unitName, pipe)
    if pipeActive[pipe] then
        --DEFAULT_CHAT_FRAME:AddMessage("piping status lost for "..unitName.." at pipe "..pipe)
        self.core:SendStatusLost(unitName, "status_"..pipe)
    else
        --DEFAULT_CHAT_FRAME:AddMessage("clear cache status for "..unitName.." at pipe "..pipe)
        local indTbl = statusCache[unitName]
        if indTbl then
            indTbl[pipe] = nil
        end
    end
end