﻿local L = AceLibrary("AceLocale-2.2"):new("GridStatusAFK")

--{{{ Localization

L:RegisterTranslations("enUS", function() return {
	["AFK"] = true,
	["<AFK>"] = true,
	["AFK alert"] = true,
} end)

L:RegisterTranslations("deDE", function() return {
	["AFK"] = "AFK",
	["<AFK>"] = "<AFK>",
	["AFK alert"] = "AFK Alarm",
} end)

L:RegisterTranslations("koKR", function() return {
	["AFK"] = "자리비움",
	["<AFK>"] = "<자리비움>",
	["AFK alert"] = "자리비움 경고",
} end)

L:RegisterTranslations("zhTW", function() return {
	["AFK"] = "暫離",
	["<AFK>"] = "<暫離>",
	["AFK alert"] = "暫離警告",
} end)

L:RegisterTranslations("zhCN", function() return {
	["AFK"] = "暂离",
	["<AFK>"] = "<暂离>",
	["AFK alert"] = "暂离警告",
} end)

---}}}

GridStatusAFK = GridStatus:NewModule("GridStatusAFK")
GridStatusAFK.menuName = L["AFK"]

--{{{ AceDB defaults

GridStatusAFK.defaultDB = {
	debug = false,
	alert_afk = {
		text =  L["<AFK>"],
		enable = false,
		color = { r = 0.5, g = 0.5, b = 0.5, a = 0.5 },
		priority = 20,
		range = false,
	},
}

--}}}

GridStatusAFK.options = false

function GridStatusAFK:OnInitialize()
	self.super.OnInitialize(self)
	self:RegisterStatus("alert_afk", L["AFK alert"], nil, true)
end

function GridStatusAFK:OnEnable()
	self:RegisterEvent("PLAYER_FLAGS_CHANGED")
	self:RegisterEvent("ZONE_CHANGED_NEW_AREA")
	self:RegisterEvent("Grid_UnitJoined")
	self:RegisterEvent("Grid_UnitOffline")
end

local instanceType
function GridStatusAFK:ZONE_CHANGED_NEW_AREA()
	instanceType = select(2, IsInInstance())
	if instanceType == "pvp" or instanceType == "arena" then
		self.core:SendStatusLost(UnitName("player"), "alert_afk")
	else
		instanceType = nil
	end
end

function GridStatusAFK:PLAYER_FLAGS_CHANGED(unitid)
	if instanceType then return end
	local settings = self.db.profile.alert_afk
	if not settings.enable then return end
	if string.find(unitid, "pet") then return end

	if UnitIsAFK(unitid) then
		self.core:SendStatusGained(UnitName(unitid), "alert_afk",
						settings.priority,
						(settings.range and 40),
						settings.color,
						settings.text,
						nil,
						nil,
						settings.icon)
	else
		self.core:SendStatusLost(UnitName(unitid), "alert_afk")
	end
end

function GridStatusAFK:Grid_UnitJoined(name,unitid)
	self:PLAYER_FLAGS_CHANGED(unitid)
end

function GridStatusAFK:Grid_UnitOffline(name)
	self.core:SendStatusLost(name, "alert_afk")
end