--Grid Healing Layout
local L = AceLibrary("AceLocale-2.2"):new("GridLayoutForHealers")

L:RegisterTranslations("enUS", function()
	return {
		["By Tanks, healers, dps"] = true,
		["By war/dru, healers"] = true,
		["All in one row"] = true,
	}
end)

L:RegisterTranslations("zhCN", function()
	return {
		["By Tanks, healers, dps"] = "坦克/治疗/DPS",
		["By war/dru, healers"] = "战/德, 治疗",
		["All in one row"] = "所有人排列一行",
	}
end)

GridLayout:AddLayout(L["By Tanks, healers, dps"], {
	[1] = {
		groupFilter = "WARRIOR,DRUID",
		groupBy = "CLASS",
		groupingOrder = "WARRIOR,DRUID",
		unitsPerColumn = 5,
		maxColumns = 2,
	},
	[2] = {
		groupFilter = "PRIEST,SHAMAN,PALADIN",
		groupBy = "CLASS",
		groupingOrder = "PRIEST,SHAMAN,PALADIN",
		unitsPerColumn = 5,
		maxColumns = 2,
	},
	[3] = {
		groupFilter = "MAGE,ROGUE,WARLOCK,HUNTER",
		groupBy = "CLASS",
		groupingOrder = "MAGE,WARLOCK,ROGUE,HUNTER",
		unitsPerColumn = 5,
		maxColumns = 2,
	}
})

GridLayout:AddLayout(L["By war/dru, healers"], {
	[1] = {
		groupFilter = "WARRIOR,DRUID",
		groupBy = "CLASS",
		groupingOrder = "WARRIOR,DRUID",
		unitsPerColumn = 8,
		maxColumns = 2,
	},
	[2] = {
		groupFilter = "PRIEST,SHAMAN,PALADIN",
		groupBy = "CLASS",
		groupingOrder = "PRIEST,SHAMAN,PALADIN",
		unitsPerColumn = 8,
		maxColumns = 2,
	}
})

GridLayout:AddLayout(L["All in one row"], {
	[1] = {
		groupFilter = "WARRIOR,DRUID,PRIEST,SHAMAN,PALADIN,MAGE,WARLOCK,HUNTER,ROGUE",
		groupBy = "CLASS",
		groupingOrder = "HUNTER,ROGUE,WARRIOR,DRUID,PRIEST,SHAMAN,PALADIN,MAGE,WARLOCK"
	},
})

--[[
GridLayout:AddLayout(L["By Class w/Pets (Plus)"], {
		[1] = {
			groupFilter = "WARRIOR",
			unitsPerColumn = 5,
			maxColumns = 8,
		},
		[2] = {
			groupFilter = "ROGUE",
			unitsPerColumn = 5,
			maxColumns = 8,
		},
		[3] = {
			groupFilter = "DRUID",
			unitsPerColumn = 5,
			maxColumns = 8,
		},
		[4] = {
			groupFilter = "PALADIN",
			unitsPerColumn = 5,
			maxColumns = 8,
		},
		[5] = {
			groupFilter = "SHAMAN",
			unitsPerColumn = 5,
			maxColumns = 8,
		},
		[6] = {
			groupFilter = "PRIEST",
			unitsPerColumn = 5,
			maxColumns = 8,
		},
		[7] = {
			groupFilter = "MAGE",
			unitsPerColumn = 5,
			maxColumns = 8,
		},
		[8] = {
			groupFilter = "WARLOCK",
			unitsPerColumn = 5,
			maxColumns = 8,
		},
		[9] = {
			isPetGroup = true,
			groupFilter = "WARLOCK",
			filterOnPet = true,
			unitsPerColumn = 5,
			maxColumns = 8,
		},
		[10] = {
			groupFilter = "HUNTER",
			unitsPerColumn = 5,
			maxColumns = 8,
		},
		[11] = {
			isPetGroup = true,
			groupFilter = "HUNTER",
			filterOnPet = true,
			unitsPerColumn = 5,
			maxColumns = 8,
		},
	})
]]