﻿------------ Local constants ---------------
local UPDATE_DELAY = 5

------------ Grid and ACE stuff ------------

local GDZSdb = AceLibrary("AceAddon-2.0"):new("AceDB-2.0")
local GridDynamicZoneSwitch = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0")
local L = AceLibrary("AceLocale-2.2"):new("GridDynamicZoneSwitch")
local BZ = AceLibrary("Babble-Zone-2.2")

L:RegisterTranslations("enUS", function()
	return {
		["Dynamic Zone Switch"] = true,
		["Options for GridDynamicZoneSwitch."] = true,
		
		["Enable_name"] = "Enable",
		["Enable_desc"] = "Toggle dynamic zone switching on/off",
		["AddZone_name"] = "Add zone",
		["AddZone_desc"] = "Type zone name and press enter",
		
		["DefaultSettingsHeader_title"] = "Default zone settings",
		
		["EnableZone_name"] = "Enable",
		["EnableZone_desc"] = "Toggle dynamic zone switching on/off for ",
		["Mode_name"] = "Mode",
		["Mode_desc"] = "Set object to load when entering ",
		["ModeChoice_layout"] = "Layout",
		["ModeChoice_profile"] = "Profile",
		["ModeChoice_both"] = "Both",
		["Profile_name"] = "Profile",
		["Profile_desc"] = "Set profile to use for ",
		["Layout_name"] = "Layout",
		["Layout_desc"] = "Set layout to use for ",
		["Reset_name"] = "Reset",
		["Reset_desc"] = "Reset settings for ",
		
		["DeleteGroup_name"] = "Delete zone settings",
		["Delete_desc"] = "Delete settings for ",
	}
end)

L:RegisterTranslations("deDE", function()
	return {
		["Dynamic Zone Switch"] = "Dynamischer Zonenwechsel",
		["Options for GridDynamicZoneSwitch."] = "Optionen für Dynamischer Zonenwechsel (GridDynamicZoneSwitch).",
		
		["Enable_name"] = "Aktiviert",
		["Enable_desc"] = "Dynamischer Zonenwechsel an-/ausschalten",
		["AddZone_name"] = "Zone hinzufügen",
		["AddZone_desc"] = "Zonenname eingeben und Return drücken",
		
		["DefaultSettingsHeader_title"] = "Standard Zoneneinstellungen",
		
		["EnableZone_name"] = "Aktiviert",
		["EnableZone_desc"] = "Dynamischer Zonenwechsel an-/ausschalten für: ",
		["Mode_name"] = "Anzeigeart",
		["Mode_desc"] = "Anzeigeart wählen die geladen wird, wenn folgende Zone betreten wird: ",
		["ModeChoice_layout"] = "Schlachtzug-Anordnung",
		["ModeChoice_profile"] = "Profil",
		["ModeChoice_both"] = "Beide",
		["Profile_name"] = "Profil",
		["Profile_desc"] = "Profil wählen für: ",
		["Layout_name"] = "Schlachtzug-Anordnung",
		["Layout_desc"] = "Schlachtzug-Anordnung wählen für: ",
		["Reset_name"] = "Zurücksetzen",
		["Reset_desc"] = "Einstellungen zurücksetzen für: ",
		
		["DeleteGroup_name"] = "Zoneneinstellungen löschen",
		["Delete_desc"] = "Einstellungen löschen für: ",
	}
end)

L:RegisterTranslations("zhTW", function()
	return {
		["Dynamic Zone Switch"] = "動態切換地區",
		["Options for GridDynamicZoneSwitch."] = "動態切換地區選項",
		
		["Enable_name"] = "啟動",
		["Enable_desc"] = "開啟/關閉 動態調整地區",
		["AddZone_name"] = "新增地區",
		["AddZone_desc"] = "輸入區域名稱後按『Enter』",
		
		["DefaultSettingsHeader_title"] = "預設地區設定",

		["EnableZone_name"] = "啟用",
		["EnableZone_desc"] = "開啟/關閉 動態調整地區 - ",
		["Mode_name"] = "模式",
		["Mode_desc"] = "設定進入時要載入的項目",
		["ModeChoice_layout"] = "地區配置",
		["ModeChoice_profile"] = "設定檔",
		["ModeChoice_both"] = "兩者",
		["Profile_name"] = "設定檔",
		["Profile_desc"] = "設定使用者設定檔 - ",
		["Layout_name"] = "地區配置",
		["Layout_desc"] = "設定使用者地區配置 - ",
		["Reset_name"] = "重設",
		["Reset_desc"] = "重置設定 - ",
		
		["DeleteGroup_name"] = "刪除設定區域",
		["Delete_desc"] = "刪除設定為 ",
	}
end)

GridDynamicZoneSwitch = Grid:NewModule("GridDynamicZoneSwitch")
GridDynamicZoneSwitch.menuName = L["Dynamic Zone Switch"]

------------ GridDynamicZoneSwitch ACE Options -------------

GridDynamicZoneSwitch.options = {
}

-- Hook into GridLayout options
Grid.options.args["DynamicLayout"] = {
	type = "group",
	name = L["Dynamic Zone Switch"],
	desc = L["Options for GridDynamicZoneSwitch."],
	disabled = InCombatLockdown,
	args = GridDynamicZoneSwitch.options
}

------------ GridDynamicZoneSwitchDefaultDB -------------

GridDynamicZoneSwitch.defaultDB = {
	debug=false,
}

GDZSdb.defaultDB = {
	enable=true,
	defaultZoneSettings = {
		mode="",
		layout="",
		profile="",
	},
	zoneList={
		[BZ["Magtheridon's Lair"]] = {
			enable=true,
			mode="layout",
			profile="",
			layout="",
		},
		[BZ["Gruul's Lair"]] = {
			enable=true,
			mode="layout",
			profile="",
			layout="",
		},
		[BZ["Serpentshrine Cavern"]] = {
			enable=true,
			mode="layout",
			profile="",
			layout="",
		},
		[BZ["Tempest Keep"]] = {
			enable=true,
			mode="layout",
			profile="",
			layout="",
		},
		[BZ["Black Temple"]] = {
			enable=true,
			mode="layout",
			profile="",
			layout="",
		},
		[BZ["Hyjal Summit"]] = {
			enable=true,
			mode="layout",
			profile="",
			layout="",
		},
		[BZ["Alterac Valley"]] = {
			enable=true,
			mode="layout",
			profile="",
			layout="",
		},
		[BZ["Warsong Gulch"]] = {
			enable=true,
			mode="layout",
			profile="",
			layout="",
		},
		[BZ["Eye of the Storm"]] = {
			enable=true,
			mode="layout",
			profile="",
			layout="",
		},
		[BZ["Arathi Basin"]] = {
			enable=true,
			mode="layout",
			profile="",
			layout="",
		},
		[BZ["Zul'Aman"]] = {
			enable=true,
			mode="layout",
			profile="",
			layout="",
		},
		[BZ["Karazhan"]] = {
			enable=true,
			mode="layout",
			profile="",
			layout="",
		},
		[BZ["Blade's Edge Arena"]] = {
			enable=true,
			mode="layout",
			profile="",
			layout="",
		},
		[BZ["Nagrand Arena"]] = {
			enable=true,
			mode="layout",
			profile="",
			layout="",
		},
		[BZ["Ruins of Lordaeron"]] = {
			enable=true,
			mode="layout",
			profile="",
			layout="",
		},
	}
}

GDZSdb:RegisterDB("GridDynamicZoneSwitchDB")
GDZSdb:RegisterDefaults('profile', GDZSdb.defaultDB)

------------ GridDynamicZoneSwitch ------------

function GDZSdb:onInitialize()
	
end

function GridDynamicZoneSwitch:OnInitialize()
	self.super.OnInitialize(self)
	
	-- Populate options
	self:populateAllZonesOptions()
end

--[[function GridDynamicZoneSwitch:Reset()
	self.super.Reset(self)

	self:populateAllZonesOptions()
end]]--

function GridDynamicZoneSwitch:OnEnable()
	self:Debug("OnEnable")
	self:RegisterEvent("PLAYER_ENTERING_WORLD", "scheduleUpdate")
	self:RegisterEvent("GridDynamicZoneSwitch_ZoneChange", "checkZone")
end

function GridDynamicZoneSwitch:populateAllZonesOptions()
	GridDynamicZoneSwitch.options.Enable = {
		type = "toggle",
		name = L["Enable_name"],
		desc = L["Enable_desc"],
		get = function() return GDZSdb.db.profile.enable end,
		set = function(v)
			GDZSdb.db.profile.enable = v	
		end,
		order = 1,
	}
	GridDynamicZoneSwitch.options.AddZone = {
		type = "text",
		name = L["AddZone_name"],
		desc = L["AddZone_desc"],
		usage = L["AddZone_desc"],
		get = function() return "" end,
		set = function(v)
			if GDZSdb.db.profile.zoneList[v] == nil then
				GDZSdb.db.profile.zoneList[v] = {}
			end
			GDZSdb.db.profile.zoneList[v].enable=true
			GDZSdb.db.profile.zoneList[v].mode="layout"
			GDZSdb.db.profile.zoneList[v].profile=""
			GDZSdb.db.profile.zoneList[v].layout=""
			
			GridDynamicZoneSwitch:populateAllZonesOptions()
		end,
		order = 2,
	}
	
	GridDynamicZoneSwitch.options.DefaultSettingsHeader = {
		type = "header",
		name = L["DefaultSettingsHeader_title"],
		order = 10,
	}
	GridDynamicZoneSwitch.options.DefaultSettingsMode = {
		type = "text",
		name = L["Mode_name"],
		desc = L["Mode_desc"].."default",
		usage = L["Mode_desc"].."default",
		validate = {["layout"]=L["ModeChoice_layout"], ["profile"]=L["ModeChoice_profile"], ["both"]=L["ModeChoice_both"]},
		get = function() return GDZSdb.db.profile.defaultZoneSettings.mode end,
		set = function(v)
			GDZSdb.db.profile.defaultZoneSettings.mode = v
		end,
		order = 11,
	}
	GridDynamicZoneSwitch.options.DefaultSettingsLayout = {
		type = "text",
		name = L["Layout_name"],
		desc = L["Layout_desc"].."default",
		usage = L["Layout_desc"].."default",
		validate = GridLayout.options.args.layout.validate,
		get = function() return GDZSdb.db.profile.defaultZoneSettings.layout end,
		set = function(v)
			GDZSdb.db.profile.defaultZoneSettings.layout = v
		end,
		order = 12,
	}
	GridDynamicZoneSwitch.options.DefaultSettingsProfile = {
		type = "text",
		name = L["Profile_name"],
		desc = L["Profile_desc"].."default",
		usage = L["Profile_desc"].."default",
		validate = GridDynamicZoneSwitch:getProfileList(),
		get = function() return GDZSdb.db.profile.defaultZoneSettings.profile end,
		set = function(v)
			GDZSdb.db.profile.defaultZoneSettings.profile = v
		end,
		order = 13,
	}
	
	GridDynamicZoneSwitch.options.DeleteZoneSettings = {
		type = "group",
		name = L["DeleteGroup_name"],
		desc = L["DeleteGroup_name"],
		disabled = InCombatLockdown,
		args = GridDynamicZoneSwitch:generateDeleteZoneSettingsButtons()
	}
	
	for zoneName, zoneChoice in pairs(GDZSdb.db.profile.zoneList) do
		self:populateZoneOptions(zoneName, zoneChoice)
	end
end

function GridDynamicZoneSwitch:generateDeleteZoneSettingsButtons()
	local t={}
	for zoneName, zoneSettings in pairs(GDZSdb.db.profile.zoneList) do
		t[string.gsub(zoneName, " ", "")] = {
			type = "execute",
			name = zoneName,
			desc = L["Delete_desc"]..zoneName,
			func = function()
				for k in pairs(zoneSettings) do
					GDZSdb.db.profile.zoneList[zoneName] = nil
				end
				GDZSdb.db.profile.zoneList[zoneName] = nil
				
				GridDynamicZoneSwitch.options[zoneName] = nil
				GridDynamicZoneSwitch:populateAllZonesOptions()
			end,
			order = 1,
		}
	end
	return t
end

function GridDynamicZoneSwitch:populateZoneOptions(zoneName, zoneChoice)
	local zoneName, zoneChoice = zoneName, zoneChoice
	GridDynamicZoneSwitch.options[string.gsub(zoneName, " ", "")] = {
		type = "group",
		name = zoneName,
		desc = zoneName,
		disabled = InCombatLockdown,
		args = {
			Enable = {
				type = "toggle",
				name = L["EnableZone_name"],
				desc = L["EnableZone_desc"]..zoneName,
				get = function() return GDZSdb.db.profile.zoneList[zoneName].enable end,
				set = function(v)
					GDZSdb.db.profile.zoneList[zoneName].enable = v	
				end,
				order = 1,
			},
			Mode = {
				type = "text",
				name = L["Mode_name"],
				desc = L["Mode_desc"]..zoneName,
				usage = L["Mode_desc"]..zoneName,
				validate = {["layout"]=L["ModeChoice_layout"], ["profile"]=L["ModeChoice_profile"], ["both"]=L["ModeChoice_both"]},
				get = function() return GDZSdb.db.profile.zoneList[zoneName].mode end,
				set = function(v)
					GDZSdb.db.profile.zoneList[zoneName].mode = v
				end,
				order = 2,
			},
			Layout = {
				type = "text",
				name = L["Layout_name"],
				desc = L["Layout_desc"]..zoneName,
				usage = L["Layout_desc"]..zoneName,
				validate = GridLayout.options.args.layout.validate, --GridDynamicZoneSwitch:getLayoutList(zoneName, zoneChoice),
				get = function() return GDZSdb.db.profile.zoneList[zoneName].layout end,
				set = function(v)
					GDZSdb.db.profile.zoneList[zoneName].layout = v
				end,
				order = 3,
			},
			Profile = {
				type = "text",
				name = L["Profile_name"],
				desc = L["Profile_desc"]..zoneName,
				usage = L["Profile_desc"]..zoneName,
				validate = GridDynamicZoneSwitch:getProfileList(zoneName, zoneChoice),
				get = function() return GDZSdb.db.profile.zoneList[zoneName].profile end,
				set = function(v)
					GDZSdb.db.profile.zoneList[zoneName].profile = v
				end,
				order = 4,
			},
			Reset={
				type = "execute",
				passValue = zoneName,
				name = L["Reset_name"],
				desc = L["Reset_desc"]..zoneName,
				func = function(zoneName)
					GDZSdb.db.profile.zoneList[zoneName].mode=""
					GDZSdb.db.profile.zoneList[zoneName].layout=""
					GDZSdb.db.profile.zoneList[zoneName].profile=""
				end,
				order = 5,
			}
		},
		order=3,
	}
end

function GridDynamicZoneSwitch:getProfileList()
	local t={}
	for k in pairs(GridDB.profiles) do
		if not k:find("^char/") and not k:find("^realm/") and not k:find("^class/") then
			t[k] = k
		end
	end
	return t
end

function GridDynamicZoneSwitch:scheduleUpdate()
	self:ScheduleEvent("GridDynamicZoneSwitch_ZoneChange", UPDATE_DELAY)
end

function GridDynamicZoneSwitch:checkZone()
	self:Debug("----" .. GetRealZoneText())
	
	local currentZone = GetRealZoneText()
	
	for zoneName, zoneSettings in pairs(GDZSdb.db.profile.zoneList) do
		if zoneName==currentZone then
			self:Debug("Zoning to " .. zoneName .. " detected")
			if zoneSettings.enable then
				local changeDone = self:applyZoneSettings(zoneSettings)
				
				if not changeDone then
					self:Debug("No specific settings found, attempting to apply default settings if defined.")
					self:applyZoneSettings(GDZSdb.db.profile.defaultZoneSettings)
				end
			end
		end
	end
end

-- Apply zone settings if found, return true if zone settings have been found and applied
function GridDynamicZoneSwitch:applyZoneSettings(zoneSettings)
	local changeDone = false
	if (zoneSettings.mode=="profile" or zoneSettings.mode=="both") and zoneSettings.profile ~= "" then
		self:Debug("Changing profile")
		Grid:SetProfile(zoneSettings.profile)
		changeDone = true
	end
	if (zoneSettings.mode=="layout" or zoneSettings.mode=="both") and zoneSettings.layout ~= "" then
		self:Debug("Changing layout")
		GridLayout:LoadLayout(zoneSettings.layout)
		changeDone = true
	end
	return changeDone
end
