----------------------------
--      Declaration       --
----------------------------

local AceOO = AceLibrary("AceOO-2.0")
local BS = AceLibrary("Babble-Spell-2.2")

GotWood.button = AceOO.Class(GotWood.abstractview, "AceDB-2.0", "AceEvent-2.0")

local defaults = {
}

----------------------------
--      Main Functions    --
----------------------------

function GotWood.button.prototype:init(totemOrder)
	-- Call Superclass
	GotWood.button.super.prototype.init(self)

	-- Save the totem order
	self.totemOrder = totemOrder
	self.totemLife = {}
	self.buttons = {}

	-- Acquire db namespace
	self.db = GotWood:AcquireDBNamespace("button")
	--GotWood:RegisterDefaults("button", "profile", defaults)
	
	self.api24 = GotWood.api24
	self.slotmaprev = GotWood.slotmaprev

	self:CreateButtons()
end

function GotWood.button.prototype:ButtonOnClick(mousebutton)
	if (mousebutton == "RightButton" and this.slot ) then
		DestroyTotem( this.slot )
	end
end

function GotWood.button.prototype:ButtonOnEnter()
	if ( this.slot ) then
		-- setting the tooltip
		GameTooltip_SetDefaultAnchor(GameTooltip, this);
		GameTooltip:SetTotem(this.slot);
	end
end

function GotWood.button.prototype:ButtonOnLeave()
	-- hiding the tooltip
	GameTooltip:Hide();
end

function GotWood.button.prototype:CreateButtons()
	for k,v in ipairs(self.totemOrder) do
		self.buttons[v] = {}
		self.buttons[v].frame = CreateFrame("Button", nil, UIParent)
		self.buttons[v].frame:SetWidth(30)
		self.buttons[v].frame:SetHeight(30)
		-- past-2.4-only features
		if (GotWood.api24 == true) then
			-- setting this property so the scripts belong can find out what totem slot they're being executed upon
			self.buttons[v].frame.slot = GotWood.slotmaprev[v]
			-- click handling for destroying single totems
			self.buttons[v].frame:RegisterForClicks("RightButtonUp")
			self.buttons[v].frame:SetScript("OnClick", self.ButtonOnClick)
			-- tooltip handling
			self.buttons[v].frame:SetScript("OnEnter", self.ButtonOnEnter)
			self.buttons[v].frame:SetScript("OnLeave", self.ButtonOnLeave)
		end

		self.buttons[v].time = self.buttons[v].frame:CreateFontString("$parentTime","ARTWORK","GameFontNormalSmall")
		self.buttons[v].time:SetWidth(36)
		self.buttons[v].time:SetHeight(10)
		self.buttons[v].time:SetPoint("TOP", self.buttons[v].frame, "BOTTOM", 0, -2)
		self.buttons[v].time:Show()

		self.buttons[v].frame:Hide()
	end
end

function GotWood.button.prototype:SetTotem(tName, tRank)
	-- Get the ele type of the totem
	local ele = GotWoodData[tName].ele

	-- Set the texture
	self.buttons[ele].frame:SetNormalTexture(BS:GetSpellIcon(tName) or GotWoodData[tName].icon)

	-- Set the time
	local time
	if tRank and GotWoodData[tName][tRank] and GotWoodData[tName][tRank].duration then
		time = GotWoodData[tName][tRank].duration
	else
		time = GotWoodData[tName].duration
	end
	self.buttons[ele].frame:SetAlpha(1)
	self.buttons[ele].time:SetText(self:SecondsToTimeAbbrev(time))
	self.buttons[ele].timeleft = time-1

	-- Store the life in our local table
	local life
	if tRank and GotWoodData[tName][tRank] and GotWoodData[tName][tRank].life then
		life = GotWoodData[tName][tRank].life
	else
		life = GotWoodData[tName].life
	end
	self.totemLife[ele] = {["name"] = tName, ["life"] = life}

	-- Start the timer
	self.buttons[ele].frame:Show()
	if self:IsEventScheduled("gotwoodtimer"..ele) then
		self:CancelScheduledEvent("gotwoodtimer"..ele)
	end
	self:ScheduleRepeatingEvent("gotwoodtimer"..ele, self.UpdateTime, 1, self, ele)
end

function GotWood.button.prototype:SetTotemFromEvent(name, startTime, duration, icon, ele)
	-- Set the texture
	self.buttons[ele].frame:SetNormalTexture(icon)

	-- Set the time
	self.buttons[ele].frame:SetAlpha(1)
	self.buttons[ele].time:SetText(self:SecondsToTimeAbbrev(duration))
	self.buttons[ele].timeleft = duration-1

	-- life code removed. no need when totem death triggers events now.
	
	-- Start the timer
	self.buttons[ele].frame:Show()
	if self:IsEventScheduled("gotwoodtimer"..ele) then
		self:CancelScheduledEvent("gotwoodtimer"..ele)
	end
	self:ScheduleRepeatingEvent("gotwoodtimer"..ele, self.UpdateTime, 1, self, ele)
end

-- Thanks to neronix for that function
function GotWood.button.prototype:SecondsToTimeAbbrev(time)
	local m, s
	if( time < 0 ) then
		text = ""
	elseif( time < 3600 ) then
		m = floor(time / 60)
		s = mod(time, 60)
		if (m==0) then 
			text = format("0:%02d", s)
		else
			text = format("%01d:%02d", m, s)
		end
	end
	return text
end

function GotWood.button.prototype:UpdateTime(ele)
	local time = 0
	
	if ( self.api24 ) then
		time = GetTotemTimeLeft(self.slotmaprev[ele])
	else
		time = self.buttons[ele].timeleft
	end
	
	if time > 0 then
		self.buttons[ele].timeleft = time - 1
		self.buttons[ele].time:SetText(self:SecondsToTimeAbbrev(time))
	else
		self:CancelScheduledEvent("gotwoodtimer"..ele)
		self.buttons[ele].frame:SetAlpha(0.5)
		self.buttons[ele].time:SetText("")
	end
end

function GotWood.button.prototype:RemoveTotem(ele)
	if self:IsEventScheduled("gotwoodtimer"..ele) then
		self:CancelScheduledEvent("gotwoodtimer"..ele)
	end
	self.buttons[ele].frame:SetAlpha(0.5)
	self.buttons[ele].time:SetText("")
end

function GotWood.button.prototype:SetTotemDamage(tName, dmg)
	-- Search for the correct button
	for ele,v in pairs(self.totemLife) do
		if string.find(tName, v.name) then
			v.life = v.life-dmg
			if v.life<0 then
				if self:IsEventScheduled("gotwoodtimer"..ele) then
					self:CancelScheduledEvent("gotwoodtimer"..ele)
				end
				self.buttons[ele].frame:SetAlpha(0.5)
				self.buttons[ele].time:SetText("")
				self.totemLife[ele] = nil
			end
			break
		end
	end
end

function GotWood.button.prototype:UpdateOrder()
	-- Set the positions
	for k,v in ipairs(self.totemOrder) do
		if k==1 then
			self.buttons[v].frame:SetPoint("TOPLEFT", GotWood.frame, "TOPLEFT", 10, -15)
		else
			-- Attach the button to the previous one
			self.buttons[v].frame:SetPoint("TOPLEFT", self.buttons[self.totemOrder[k-1]].frame, "TOPRIGHT", 5, 0)
		end
	end
end

--[[function GotWood.button.prototype:GetOptions()
	return self.options
end]]

function GotWood.button.prototype:GetWidth()
	return 155
end

function GotWood.button.prototype:GetHeight()
	return 65
end

function GotWood.button.prototype:SetScale(scale)
	for k,v in ipairs(self.totemOrder) do
		self.buttons[v].frame:SetScale(scale)
	end
end

function GotWood.button.prototype:UpdatePosition()
	self:UpdateOrder()
end

function GotWood.button.prototype:Disable()
	for _,ele in ipairs(self.totemOrder) do
		if self:IsEventScheduled("gotwoodtimer"..ele) then
			self:CancelScheduledEvent("gotwoodtimer"..ele)
		end
		self.buttons[ele].frame:Hide()
	end
end

-- Important: GotWood needs to know that this view exists, so add it to its table
-- The second abbreviation has to be the same name as the class name
GotWood:AddView("Buttons", "button")