------------------------------------------
-- All views have to inherit this class --
------------------------------------------

local AceOO = AceLibrary("AceOO-2.0")

GotWood.abstractview = AceOO.Class()
GotWood.abstractview.virtual = true

-------------------------------
-- Abstract Class Definition --
-------------------------------

function GotWood.abstractview.prototype:init(parent)
	-- Call Superclass
	GotWood.abstractview.super.prototype.init(self)
end

-- This method is called when a totem is registered from the
-- user so the view actually has to do something with it.
--
-- arg1: Totem name
-- arg2: (Optional) Totem rank
function GotWood.abstractview.prototype:SetTotem()
	error("SetTotem not implemented!", 2)
end

-- This method is called when a totem is registered from the
-- user so the view actually has to do something with it.
-- The difference to the "SetTotem" function is that this one has to be called
-- with the info obtained from GetTotemInfo, introduced in patch 2.4.
--
-- arg1: Totem name (includes romanian rank number)
-- arg2: int, timestamp when the totem was created
-- arg3: int, duration (in seconds) that the totem still lives
-- arg4: icon, string containing the full texturepath to the icon
-- arg5: gotwood element string, can be one of: "earth", "water", "fire", "air"
function GotWood.abstractview.prototype:SetTotemFromEvent()
	error("SetTotemFromEvent not implemented!", 2)
end

-- This method is called when a totem has to be removed
-- (death of player etc.)
--
-- arg1: Ele type
function GotWood.abstractview.prototype:RemoveTotem()
	error("Remove not implemented!", 2)
end

-- This method is called a totem receives damage. Damage
-- handling (like removing bars/buttons) has to be done in
-- here. No other method will be called
--
-- arg1: Totem name
-- arg2: Damage (number)
function GotWood.abstractview.prototype:SetTotemDamage()
	error("SetTotemDamage not implemented!", 2)
end

-- This method is called a totem receives damage. Damage
-- handling (like removing bars/buttons) has to be done in
-- here. No other method will be called
--
-- arg1: Table of current ordering (ex: {[1] = "air",[2] = "water",[3] = "earth",[4] = "fire"})
function GotWood.abstractview.prototype:UpdateOrder()
	error("UpdateOrder not implemented!", 2)
end

-- This method is called when the option menu is opened
-- through text mode/dewdrop. If there are no view specific
-- options, then there is no need to inherit this method.
function GotWood.abstractview.prototype:GetOptions()
	return {}
end

-- This method returns the width of the GotWood frame
function GotWood.abstractview.prototype:GetWidth()
	error("GetWidth not implemented!", 2)
end

-- This method returns the height of the GotWood frame
function GotWood.abstractview.prototype:GetHeight()
	error("GetHeight not implemented!", 2)
end

-- This method is called when the scales changes
--
-- arg1: Scale (number)
function GotWood.abstractview.prototype:SetScale()
	error("SetScale not implemented!", 2)
end

-- This method is called when the view can update his position
function GotWood.abstractview.prototype:UpdatePosition()
	error("UpdatePosition not implemented!", 2)
end

-- This method is called when GotWood goes into standby
-- mode
function GotWood.abstractview.prototype:Disable()
	error("Disable not implemented!", 2)
end