---------
function GoGoPet_OnLoad()
---------
	SlashCmdList["GOGOPET"] = function(msg) GoGoPet_OnSlash(msg) end
	SLASH_GOGOPET1 = "/gogopet"
	SlashCmdList["GOGOPETID"] = function(msg) GoGoPet_Msg(GoGoPet_Id(msg)) end
	SLASH_GOGOID1 = "/id"
	this:RegisterEvent("VARIABLES_LOADED")
	this:RegisterEvent("UPDATE_BINDINGS")
	this:RegisterEvent("CHAT_MSG_ADDON");
	this:RegisterEvent("CHAT_MSG_SYSTEM");
end --function

---------
function GoGoPet_OnEvent(event)
---------
	if event == "VARIABLES_LOADED" then
		if not GoGoPet_Prefs then
			GoGoPet_Prefs = {useconsume = true,}
		end --if
		if not GoGoPet_Prefs.version or GoGoPet_Prefs.version ~= GetAddOnMetadata("GoGoMount", "Version") then
			GoGoPet_Prefs.version = GetAddOnMetadata("GoGoMount", "Version")
			GoGoPet_Prefs.useconsume = true
		end --if
	elseif event == "ZONE_CHANGED_NEW_AREA" then
		SetMapToCurrentZone()
	elseif event == "UPDATE_BINDINGS" then
		GoGoPet_CheckBindings()
	elseif (event == "CHAT_MSG_ADDON") and (arg1 == "GoGoPetVER") then
		if (arg2 > GetAddOnMetadata("GoGoPet", "Version")) and not GoGoShownUpdate then
			GoGoShownUpdate = true
			DEFAULT_CHAT_FRAME:AddMessage("** GoGoPet update is available and is being used by "..arg4)
		end --if
	end --if
end --function

---------
function GoGoPet_OnSlash(msg)
---------
	if GoGoPet_COMMANDS[string.lower(msg)] then
		GoGoPet_COMMANDS[string.lower(msg)]()
	elseif string.find(msg, "item:%d+") then
		GoGoPet_AddPrefPet(GetItemInfo(msg))
		GoGoPet_Msg("pref")
	else
		GoGoPet_Msg("pref")
	end --if
end --function

---------
function GoGoPet_PreClick(button)
---------
	if not InCombatLockdown() then
		GoGoPet_FillButton(button, GoGoPet_ChoosePet())
	end --if

	if ( IsInGuild() ) then
		SendAddonMessage("GoGoPetVER", GetAddOnMetadata("GoGoPet", "Version"), "GUILD")
	end --if
		SendAddonMessage("GoGoPetVER", GetAddOnMetadata("GoGoPet", "Version"), "BATTLEGROUND")
		SendAddonMessage("GoGoPetVER", GetAddOnMetadata("GoGoPet", "Version"), "RAID")

end --function

---------
function GoGoPet_ChoosePet(some_pets)
---------
	local pets = GoGoPet_Findpets(some_pets or GoGoPet_ChoosePets())
	if pets then
		return pets[math.random(table.getn(pets))]
	end --if
end --function

---------
function GoGoPet_ChoosePets(pets)
---------
	local loc = GetRealZoneText()

	if not pets then
		if GoGoPet_Prefs[loc] then
			return GoGoPet_Prefs[loc]
		end --if
	end --if

--	if pets == GoGoPet_Prefs[loc] then
--		if loc == "Ahn'Qiraj" then
--			return GoGoPet_BUGS
--		elseif GoGoPet_CanFly() and not GoGoPet_SkipFlying and GoGoPet_InOutlands() then
--			return GoGoPet_AIR_FAST[GoGoPet_FACTION]
--		elseif GoGoPet_CanRide() then
--			return GoGoPet_LAND_FAST[GoGoPet_FACTION]
--		elseif GoGoPet_AllLevelsMount() then
--			return GoGoPet_NORESTRICTION
--		else
--			return GoGoPet_SPELLS
--		end --if
--	else
		return GoGoPets_Critters
--	end --if
end --function

---------
function GoGoPet_Findpets(some_pets, skip)
---------
	local pets = {}
	if table.getn(some_pets) > 0 then
		for i, item in ipairs(some_pets) do
			local name = GoGoPet_InBags(item)
			if name then
				table.insert(pets, name)
			end --if
		end --for
	end --if
	if table.getn(pets) > 0 then
		return pets
	elseif skip then
		return nil
	else
		local next_pets = GoGoPet_ChoosePets(some_pets)
		if next_pets then
			return GoGoPet_Findpets(next_pets)
		else
			return nil
		end --if
	end --if
end --function

---------
function GoGoPet_InBags(item)
---------
	for bag = 0, NUM_BAG_FRAMES do
		for slot = 1, GetContainerNumSlots(bag) do
			local link = GetContainerItemLink(bag, slot)
			if link and string.find(link, item) then
				return GetItemInfo(link)
			end --if
		end --for
	end --for
end --function

---------
function GoGoPet_AddPrefPet(item)
---------
	local loc = GetRealZoneText()
	if not GoGoPet_Prefs[loc] then GoGoPet_Prefs[loc] = {} end
	table.insert(GoGoPet_Prefs[loc], item)
	if table.getn(GoGoPet_Prefs[loc]) > 1 then
		local i = 2
		repeat
			if GoGoPet_Prefs[loc][i] == GoGoPet_Prefs[loc][i - 1] then
				table.remove(GoGoPet_Prefs[loc], i)
			else
				i = i + 1
			end --if
		until i > table.getn(GoGoPet_Prefs[loc])
	end --if
end --function

---------
function GoGoPet_FillButton(button, pet)
---------
	if pet then
		button:SetAttribute("macrotext", "/cast "..pet)
	else
		button:SetAttribute("macrotext", nil)
	end --if
end --function

---------
function GoGoPet_CheckBindings()
---------
	for binding, button in pairs({GOGOPETBINDING = GoGoPetButton}) do
		ClearOverrideBindings(button)
		local key1, key2 = GetBindingKey(binding)
		if key1 then
			SetOverrideBindingClick(button, true, key1, button:GetName())
		end --if
		if key2 then
			SetOverrideBindingClick(button, true, key2, button:GetName())
		end --if
	end --if
end --function

---------
function GoGoPet_CheckMoving(time)
---------
	local pos = GetPlayerMapPosition("player")
	if pos ~= GoGoPet_Position then
		GoGoPet_Position = pos
		GoGoPet_IsMoving = true
	else
		GoGoPet_IsMoving = nil
	end --if
end --function

---------
function GoGoPet_Msg(msg)
---------
	if msg then
		if GoGoPet_MESSAGES[msg] then
			GoGoPet_Msg(GoGoPet_MESSAGES[msg]())
		else
			msg = string.gsub(msg, "<", LIGHTYELLOW_FONT_COLOR_CODE)
			msg = string.gsub(msg, ">", "|r")
			DEFAULT_CHAT_FRAME:AddMessage(GREEN_FONT_COLOR_CODE.."GoGo: |r"..msg)
		end --if
	end --if
end --function

---------
function GoGoPet_Id(itemstring)
---------
	local _, _, itemid = string.find(itemstring,"(item:%d+)")
	if itemid then
		return itemid.." - "..itemstring
	end --if
end --function

GoGoPets_Critters = {

	"item:32588:",  -- monkey
	"item:11026:", "item:11027:", "item:19450:", "item:33993:",  -- frogs
	"item:4401:", "item:10398:", "item:11825:", "item:11826:", "item:15996:", "item:34425:", "item:21277:",  -- mechanical
	"item:34493:",  -- dragon kite
	"item:20371:", "item:30360:",  -- murloc
	"item:23713:",	-- hippogryph
	"item:13584:",  -- diablo
	"item:13583:", "item:22781:",  -- bear
	"item:11023:", "item:11110:", "item:34492:",  -- chicken
	"item:13582:",  -- zergling
	"item:8498:", "item:8499:", "item:10822:", "item:25535:", "item:34535:",  -- whelpling
	"item:10360:", "item:10361:", "item:10392:",  -- snakes
	"item:8485:", "item:8486:", "item:8487:", "item:8488:", "item:8489:", "item:8490:", "item:8491:",  -- cats
	"item:29953:", "item:29956:", "item:29957:", "item:29958:",  -- dragonhawks
	"item:29901:", "item:29902:", "item:29903:", "item:29904:",  -- moths
	"item:10394:", "item:12264:",  -- dogs
	"item:8497:", "item:29364:",  -- rabbits
	"item:8492:", "item:8494:", "item:8495:", "item:8496:",  -- parrots
	"item:10393:",  -- cockroach
	"item:20769:",  -- oozeling
	"item:32616:",  -- eggbert
	"item:21301:", "item:21305:",  -- helper
	"item:29960:",  -- firefly
	"item:8500:", "item:8501:",  -- owl
	"item:27445:",  -- crawdad
	"item:38628:",  -- nether ray
	"item:29363:",  -- wyrmling
	"item:31760:",  -- miniwing
	"item:23007:", "item:32498:",  -- pigs
	"item:32622:",  -- elephant
	"item:12529:",  -- spiders
	"item:21308:", "item:21309:", "item:22235:", "item:23083:", "item:32233:", "item:32617:", "item:33154:",  -- misc
	"item:23002:",  -- turtles
	"item:11474:",  -- darter
	"item:34478:",  -- sporebat
	"item:23015:",  -- rats
	"item:35504:",  -- phoenix hatchling
	"item:33816:", "item:33818:", "item:35349:", "item:35350:",  -- baby crocolisk
	"item:34955:", -- scorched stone
	"item:39656:", -- tyrael
	"item:37297:", -- gold medallian
	
}


GoGoPet_ERRORS = {
	[SPELL_FAILED_NOT_MOUNTED] = true,
	[SPELL_FAILED_NOT_SHAPESHIFT] = true,
	[ERR_ATTACK_MOUNTED] = true,
}

GoGoPet_COMMANDS = {
	["clear"] = function()
		GoGoPet_Prefs[GetRealZoneText()] = nil
		if not InCombatLockdown() then
			for i, button in ipairs({GoGoPetButton}) do
				GoGoPet_FillButton(button)
			end --for
		end --if
		GoGoPet_Msg("pref")
	end, --function
}

GoGoPet_MESSAGES = {
	["pref"] = function()
		local loc = GetRealZoneText()
		local list = ""
		if GoGoPet_Prefs[loc] then
			list = list..table.concat(GoGoPet_Prefs[loc], ", ")
			return loc..": "..list.." - </gogopet clear> to clear"
		else
			return loc..": ?".." - </gogopet ItemLink> to add"
		end --if
	end, --function
}