---------
function GoGo_OnLoad()
---------
	SlashCmdList["GOGOMOUNT"] = function(msg) GoGo_OnSlash(msg) end
	SLASH_GOGOMOUNT1 = "/gogo"
	SlashCmdList["GOGOID"] = function(msg) GoGo_Msg(GoGo_Id(msg)) end
	SLASH_GOGOID1 = "/id"
	this:RegisterEvent("VARIABLES_LOADED")
	this:RegisterEvent("UPDATE_BINDINGS")
	this:RegisterEvent("TAXIMAP_OPENED")
	this:RegisterEvent("CHAT_MSG_ADDON")
	-- this:RegisterEvent("CHAT_MSG_SYSTEM")

end --function

---------
function GoGo_OnEvent(event)
---------
	if event == "VARIABLES_LOADED" then
		TESTVERSION = false
		if not GoGo_Prefs then
			GoGo_Prefs = {checkspells = true, autodismount = true, preferflight = true}
		end --if
		if GoGo_Prefs.autodismount then
			this:RegisterEvent("UI_ERROR_MESSAGE")
		end --if
		_, GOGO_CLASS = UnitClass("player")
		if GOGO_SPELLS[GOGO_CLASS] then
			this:RegisterEvent("PLAYER_REGEN_DISABLED")
		end --if
		if (GOGO_CLASS == "DRUID" or GOGO_CLASS == "SHAMAN") then
			GoGoFrame:RegisterEvent("ZONE_CHANGED_NEW_AREA")
			GoGoFrame:SetScript("OnUpdate", GoGo_CheckMoving)
		end --if
		GOGO_OUTLANDS = table.concat({GetMapZones(3)}, ":")..":"..GOGO_TWISTING_NETHER
		if not GoGo_Prefs.version or GoGo_Prefs.version ~= GetAddOnMetadata("GoGoMount", "Version") then
			GoGo_Prefs.version = GetAddOnMetadata("GoGoMount", "Version")
			GoGo_Prefs.checkspells = true
			GoGo_Prefs.autodismount = true
			GoGo_Prefs.preferflight = true
			GoGo_Prefs.DisableUpdateNotice = false
		end --if
	elseif event == "PLAYER_REGEN_DISABLED" then
		for i, button in ipairs({GoGoButton, GoGoButton2}) do
			if GoGo_Prefs.checkspells then
				GoGo_FillButton(button, GoGo_ChooseMount(GOGO_SPELLS))
			else
				GoGo_FillButton(button)
			end --if
		end --for
	elseif event == "ZONE_CHANGED_NEW_AREA" then
		SetMapToCurrentZone()
	elseif event == "TAXIMAP_OPENED" then
		GoGo_Dismount()
	elseif event == "UPDATE_BINDINGS" then
		GoGo_CheckBindings()
	elseif event == "UI_ERROR_MESSAGE" then
		if GOGO_ERRORS[arg1] and not IsFlying() then
			GoGo_Dismount()
		end --if
	elseif (event == "CHAT_MSG_ADDON") and (arg1 == "GoGoMountVER") and not GoGo_Prefs.DisableUpdateNotice then
		if (arg2 > GetAddOnMetadata("GoGoMount", "Version")) and not GoGoShownUpdate then
			GoGoShownUpdate = true
			DEFAULT_CHAT_FRAME:AddMessage("** GoGoMount update is available and is being used by "..arg4)
		end --if
	end --if
end --function

---------
function GoGo_OnSlash(msg)
---------
	if GOGO_COMMANDS[string.lower(msg)] then
		GOGO_COMMANDS[string.lower(msg)]()
	elseif string.find(msg, "item:%d+") then
		GoGo_AddPrefMount(GetItemInfo(msg))
		GoGo_Msg("pref")
	elseif GoGo_InBook(msg) then
		GoGo_AddPrefSpell(msg)
		GoGo_Msg("pref")
	else
		GoGo_Msg("spell")
		GoGo_Msg("auto")
		GoGo_Msg("fly")
		GoGo_Msg("pref")
		GoGo_Msg("disableupdatenotice")
	end --if
end --function

---------
function GoGo_PreClick(button)
---------
	if not InCombatLockdown() then
		GoGo_FillButton(button)
	end --if

	if IsMounted() then
		GoGo_Dismount()
	elseif GOGO_CLASS == "DRUID" and GoGo_IsShifted() then
		GoGo_Dismount()
	elseif GOGO_CLASS == "SHAMAN" and GetPlayerBuffName(GOGO_SHAMAN_GHOSTWOLF) then
		GoGo_Dismount()
	elseif not InCombatLockdown() then
		GoGo_FillButton(button, GoGo_ChooseMount())
	end --if
	
	if not TESTVERSION then
		if ( IsInGuild() ) then
			SendAddonMessage("GoGoMountVER", GetAddOnMetadata("GoGoMount", "Version"), "GUILD")
		end --if
			SendAddonMessage("GoGoMountVER", GetAddOnMetadata("GoGoMount", "Version"), "BATTLEGROUND")
			SendAddonMessage("GoGoMountVER", GetAddOnMetadata("GoGoMount", "Version"), "RAID")
	end --if
	
end --function

---------
function GoGo_ChooseMount(some_mounts)
---------
	local mounts = GoGo_FindMounts(some_mounts or GoGo_ChooseMounts())
	if mounts then
		return mounts[math.random(table.getn(mounts))]
	end --if
end --function

---------
function GoGo_ChooseMounts(mounts)
---------
	local loc = GetRealZoneText()
	if not mounts then
		if (GOGO_CLASS == "DRUID" or GOGO_CLASS == "SHAMAN") and (GoGo_IsMoving or IsSwimming()) then
			return GOGO_SPELLS
		--elseif GOGO_CLASS == "SHAMAN" and GoGo_IsMoving then
			--return GOGO_SPELLS
		elseif GoGo_Prefs[loc] then
			return GoGo_Prefs[loc]
		end --if
	end --if
	if mounts == GoGo_Prefs[loc] then
		if loc == "Ahn'Qiraj" then
			return GOGO_BUGS
		elseif GoGo_CanFly() and not GoGo_SkipFlying and GoGo_InOutlands() then
			return GOGO_AIR_FAST
		elseif GoGo_CanRide() then
			return GOGO_LAND_FAST
		elseif GoGo_AllLevelsMount() then
			return GOGO_NORESTRICTION
		else
			return GOGO_SPELLS
		end --if
	elseif mounts == GOGO_BUGS then
		return GOGO_LAND_FAST
	elseif mounts == GOGO_AIR_FAST then
		return GOGO_AIR_SLOW
	elseif mounts == GOGO_AIR_SLOW then
		return GOGO_LAND_FAST
	elseif mounts == GOGO_LAND_FAST then
		return GOGO_LAND_SLOW
	elseif mounts == GOGO_LAND_SLOW then
		return GOGO_NORESTRICTION
	elseif mounts == GOGO_NORESTRICTION then
		return GOGO_SPELLS
	elseif mounts == GOGO_SPELLS then
		return nil
	end --if
end --function

---------
function GoGo_FindMounts(some_mounts, skip)
---------
	local mounts = {}
	if table.getn(some_mounts) > 0 then
		for i, item in ipairs(some_mounts) do
			local name = GoGo_InBags(item)
			if name then
				table.insert(mounts, name)
			end --if
		end --for
	end --if
	if some_mounts[GOGO_CLASS] and GoGo_Prefs.checkspells then
		local spell = GoGo_InBook(some_mounts[GOGO_CLASS])
		if spell then
			table.insert(mounts, spell)
		end --if
	end --if
	if table.getn(mounts) > 0 then
		if not GoGo_Prefs.preferflight and some_mounts == GOGO_AIR_SLOW and GoGo_FindMounts(GOGO_LAND_FAST, true) then
			return GoGo_FindMounts(GOGO_LAND_FAST)
		else
			return mounts
		end --if
	elseif skip then
		return nil
	else
		local next_mounts = GoGo_ChooseMounts(some_mounts)
		if next_mounts then
			return GoGo_FindMounts(next_mounts)
		else
			return nil
		end --if
	end --if
end --function

---------
function GoGo_Dismount()
---------
	if IsMounted() then
		Dismount()
	elseif GOGO_CLASS == "DRUID" and GoGo_IsShifted() then
		CancelPlayerBuff(GoGo_IsShifted())
	elseif GOGO_CLASS == "SHAMAN" and GetPlayerBuffName(GOGO_SHAMAN_GHOSTWOLF) then
		CancelPlayerBuff(GOGO_SHAMAN_GHOSTWOLF)
	else
		return nil
	end --if
	return true
end --function

---------
function GoGo_InBags(item)
---------
	for bag = 0, NUM_BAG_FRAMES do
		for slot = 1, GetContainerNumSlots(bag) do
			local link = GetContainerItemLink(bag, slot)
			if link and string.find(link, item) then
				return GetItemInfo(link)
			end --if
		end --for
	end --for
end --function

---------
function GoGo_InBook(spell)
---------
	if type(spell) == "function" then
		return spell()
	else
		local slot = 1
		while GetSpellName(slot, "spell") do
			local name = GetSpellName(slot, "spell")
			if name == spell then
				return spell
			end --if
			slot = slot + 1
		end --while
	end --if
end --function

---------
function GoGo_IsShifted()
---------
	for i = 1, GetNumShapeshiftForms() do
		local _, name, active = GetShapeshiftFormInfo(i)
		if active then
			return name
		end
	end --for
end --function

---------
function GoGo_CanFly()
---------
	local level = UnitLevel("player")
	if level >=70 then
		return true
	elseif GOGO_CLASS == "DRUID" and level >= 68 then
		return true
	end --if
end --function

---------
function GoGo_CanRide()
---------
	local level = UnitLevel("player")
	if level >= 30 then
		return true
	end --if
end --function

---------
function GoGo_AllLevelsMount()
---------
	local level = UnitLevel("player")
	if level >= 1 then
		return true
	end --if
end --function

---------
function GoGo_InOutlands()
---------
	local loc = GetRealZoneText()
	if string.find(GOGO_OUTLANDS, loc) then
		return true
	end --if
end --function

---------
function GoGo_AddPrefMount(item)
---------
	local loc = GetRealZoneText()
	if not GoGo_Prefs[loc] then GoGo_Prefs[loc] = {} end
	table.insert(GoGo_Prefs[loc], item)
	if table.getn(GoGo_Prefs[loc]) > 1 then
		local i = 2
		repeat
			if GoGo_Prefs[loc][i] == GoGo_Prefs[loc][i - 1] then
				table.remove(GoGo_Prefs[loc], i)
			else
				i = i + 1
			end --if
		until i > table.getn(GoGo_Prefs[loc])
	end --if
end --function

---------
function GoGo_AddPrefSpell(spell)
---------
	local loc = GetRealZoneText()
	if not GoGo_Prefs[loc] then GoGo_Prefs[loc] = {} end
	GoGo_Prefs[loc][GOGO_CLASS] = spell
end --function

---------
function GoGo_FillButton(button, mount)
---------
	if mount then
		button:SetAttribute("macrotext", "/cast "..mount)
	else
		button:SetAttribute("macrotext", nil)
	end --if
end --function

---------
function GoGo_CheckBindings()
---------
	for binding, button in pairs({GOGOBINDING = GoGoButton, GOGOBINDING2 = GoGoButton2}) do
		ClearOverrideBindings(button)
		local key1, key2 = GetBindingKey(binding)
		if key1 then
			SetOverrideBindingClick(button, true, key1, button:GetName())
		end --if
		if key2 then
			SetOverrideBindingClick(button, true, key2, button:GetName())
		end --if
	end --if
end --function

---------
function GoGo_CheckMoving(time)
---------
	local pos = GetPlayerMapPosition("player")
	if pos ~= GoGo_Position then
		GoGo_Position = pos
		GoGo_IsMoving = true
	else
		GoGo_IsMoving = nil
	end --if
end --function

---------
function GoGo_Msg(msg)
---------
	if msg then
		if GOGO_MESSAGES[msg] then
			GoGo_Msg(GOGO_MESSAGES[msg]())
		else
			msg = string.gsub(msg, "<", LIGHTYELLOW_FONT_COLOR_CODE)
			msg = string.gsub(msg, ">", "|r")
			DEFAULT_CHAT_FRAME:AddMessage(GREEN_FONT_COLOR_CODE.."GoGo: |r"..msg)
		end --if
	end --if
end --function

---------
function GoGo_Id(itemstring)
---------
	local _, _, itemid = string.find(itemstring,"(item:%d+)")
	if itemid then
		return itemid.." - "..itemstring
	end --if
end --function

GOGO_AIR_FAST = {  -- Level 70 fast air mounts
	"item:25477:", "item:25531:", "item:25532:", "item:25533:", -- windriders
	"item:25473:", "item:25527:", "item:25528:", "item:25529:", -- gryphons
	"item:30609:", "item:32857:", "item:32858:", "item:32859:", "item:32860:", "item:32861:", "item:32862:", "item:34092:", "item:37676:", -- netherdrakes
	"item:32314:", "item:32316:", "item:32317:", "item:32318:", "item:32319:", "item:35700:", -- nether rays
	"item:34061:", -- engineering machines
	"item:25596:", "item:32458:", "item:33338:", "item:35800:",  -- phoenix
	"item:33999:", -- hippogryphs
	"item:33182:", -- broom
	"item:35226:", -- rocket
	["DRUID"] = GOGO_DRUID_FAST_FLIGHTFORM,
}

GOGO_AIR_SLOW = {  -- Level 70 slow air mounts
	"item:25474:", "item:25475:", "item:25476:", -- windriders
	"item:25470:", "item:25471:", "item:25472:", -- gryphons
	"item:34060:",  -- engineering machines
	"item:33176:",  -- broom
	"item:35225:", -- rocket
	["DRUID"] = GOGO_DRUID_FLIGHTFORM,
}

GOGO_LAND_FAST = {  -- Level 60 fast land mounts
	"item:12330:", "item:12351:", "item:18245:", "item:18796:", "item:18797:", "item:18798:", "item:29469:", -- wolves
	"item:15292:", "item:15293:", "item:18247:", "item:18793:", "item:18794:", "item:18795:", "item:29466:", -- kodos
	"item:8586:", "item:13317:", "item:18246:", "item:18788:", "item:18789:", "item:18790:", "item:29472:", -- raptors
	"item:13334:", "item:18248:", "item:18791:", "item:29470:", -- skeletals
	"item:28936:", "item:29223:", "item:29224:", "item:34129:", "item:35513:",  -- hawks
	"item:28915:", "item:29102:", "item:29103:", "item:29104:", "item:29105:", "item:29227:", "item:29228:", "item:29229:", "item:29230:", "item:29231:", "item:31829:", "item:31830:", "item:31831:", "item:31832:", "item:31833:", "item:31834:", "item:31835:", "item:31836:", -- talbuks
	"item:13328:", "item:13329:", "item:18244:", "item:18785:", "item:18786:", "item:18787:", "item:29467:", "item:33977:", -- rams
	"item:13326:", "item:13327:", "item:18243:", "item:18772:", "item:18773:", "item:18774:", "item:29465:", -- striders
	"item:33809:", "item:38576:", -- bears
	"item:12302:", "item:12303:", "item:18766:", "item:18767:", "item:18242:", "item:18902:", "item:29471:", "item:33225:", -- sabers
	"item:12353:", "item:12354:", "item:18241:", "item:18776:", "item:18777:", "item:18778:", "item:29468:", "item:30480:", -- horses
	"item:13086:", "item:13335:", "item:19029:", "item:19030:", "item:19872:", "item:19902:", "item:21176:", "item:32768:", -- misc
	"item:33184:", -- broom
	"item:29745:", "item:29746:", "item:29747:", "item:35906:",  -- elekks
	"item:37719:", -- zhevra
	["PALADIN"] = GOGO_PALADIN_FAST,
	["WARLOCK"] = GOGO_WARLOCK_FAST,
}

GOGO_LAND_SLOW = {   -- Level 30 slow land mounts
	"item:1132:", "item:5663:", "item:5665:", "item:5668:", -- wolves
	"item:15277:", "item:15290:", -- kodos
	"item:8588:", "item:8591:", "item:8592:", -- raptors
	"item:13331:", "item:13332:", "item:13333:", -- skeletals
	"item:28927:", "item:29220:", "item:29221:", "item:29222:", -- hawks
	"item:8563:", "item:8595:", "item:13321:", "item:13322:", -- striders
	"item:8629:", "item:8630:", "item:8631:", "item:8632:", "item:33224:", -- sabers
	"item:2411:", "item:2414:", "item:5655:", "item:5656:", -- horses
	"item:5864:", "item:5872:", "item:5873:", "item:33976:", -- rams
	"item:28481:", "item:29743:", "item:29744:", -- elekks
	"item:33183:", "item:37011:", -- broom
	["PALADIN"] = GOGO_PALADIN_SLOW,
	["WARLOCK"] = GOGO_WARLOCK_SLOW,
}

GOGO_NORESTRICTION = {  -- Level 1 mounts
	"item:23720:", -- turtle
	"item:33189:", -- broom
}

GOGO_SPELLS = {
	["DRUID"] = function()
		if GoGo_InBook(GOGO_DRUID_AQUAFORM) then
			if not GoGo_SkipFlying and GoGo_InOutlands() and GoGo_InBook(GOGO_DRUID_FAST_FLIGHTFORM) then
				return "[swimming] "..GOGO_DRUID_AQUAFORM.."; [combat]"..GOGO_DRUID_TRAVELFORM.."; "..GOGO_DRUID_FAST_FLIGHTFORM
			elseif not GoGo_SkipFlying and GoGo_InOutlands() and GoGo_InBook(GOGO_DRUID_FLIGHTFORM) then
				return "[swimming] "..GOGO_DRUID_AQUAFORM.."; [combat]"..GOGO_DRUID_TRAVELFORM.."; "..GOGO_DRUID_FLIGHTFORM
			else
				return "[swimming] "..GOGO_DRUID_AQUAFORM.."; "..GOGO_DRUID_TRAVELFORM
			end --if
		end --if
	end, --function
	["SHAMAN"] = GOGO_SHAMAN_GHOSTWOLF,
}

GOGO_BUGS = {
	"item:21176:", "item:21218:", "item:21321:", "item:21323:", "item:21324:", 
}

GOGO_ERRORS = {
	[SPELL_FAILED_NOT_MOUNTED] = true,
	[SPELL_FAILED_NOT_SHAPESHIFT] = true,
	[ERR_ATTACK_MOUNTED] = true,
}

GOGO_COMMANDS = {
	["spell"] = function()
		GoGo_Prefs.checkspells = not GoGo_Prefs.checkspells
		GoGo_Msg("spell")
	end, --function
	["auto"] = function()
		GoGo_Prefs.autodismount = not GoGo_Prefs.autodismount
		GoGo_Msg("auto")
		if GoGo_Prefs.autodismount then
			GoGoFrame:RegisterEvent("UI_ERROR_MESSAGE")
		else
			GoGoFrame:UnregisterEvent("UI_ERROR_MESSAGE")
		end --if
	end, --function
	["fly"] = function()
		if not GoGo_CanFly() then
			return
		else
			GoGo_Prefs.preferflight = not GoGo_Prefs.preferflight
			GoGo_Msg("fly")
		end --if
	end, --function
	["clear"] = function()
		GoGo_Prefs[GetRealZoneText()] = nil
		if not InCombatLockdown() then
			for i, button in ipairs({GoGoButton, GoGoButton2}) do
				GoGo_FillButton(button)
			end --for
		end --if
		GoGo_Msg("pref")
	end, --function
	["disableupdatenotice"] = function()
		GoGo_Prefs.DisableUpdateNotice = not GoGo_Prefs.DisableUpdateNotice
		GoGo_Msg("disableupdatenotice")
	end, --function
}

GOGO_MESSAGES = {
	["spell"] = function()
		if GoGo_Prefs.checkspells then
			return "Spells/forms included - </gogo spell> to toggle"
		else
			return "Spells/forms excluded - </gogo spell> to toggle"
		end --if
	end, --function
	["auto"] = function()
		if GoGo_Prefs.autodismount then
			return "Autodismount active - </gogo auto> to toggle"
		else
			return "Autodismount inactive - </gogo auto> to toggle"
		end --if
	end, --function
	["fly"] = function()
		if not GoGo_CanFly() then
			return
		elseif GoGo_Prefs.preferflight then
			return "Slow flying over fast running - </gogo fly> to toggle"
		else
			return "Fast running over slow flying - </gogo fly> to toggle"
		end --if
	end, --function
	["pref"] = function()
		local loc = GetRealZoneText()
		local list = ""
		if GoGo_Prefs[loc] then
			list = list..table.concat(GoGo_Prefs[loc], ", ")
			if GoGo_Prefs[loc][GOGO_CLASS] then
				if string.len(list) > 0 then
					list = list..", "
				end --if
				list = list..GoGo_Prefs[loc][GOGO_CLASS]
			end --if
			return loc..": "..list.." - </gogo clear> to clear"
		else
			return loc..": ?".." - </gogo ItemLink> or </gogo SpellName> to add"
		end --if
	end, --function
	["disableupdatenotice"] = function()
		if GoGo_Prefs.DisableUpdateNotice then
			return "Update notices from other players disabled - </gogo disableupdatenotice> to toggle"
		else
			return "Update notices from other players enabled - </gogo disableupdatenotice> to toggle"
		end --if
	end, --function
}