﻿-- Author      : Svartalve
-- Create Date : 8/2/2008 1:57:08 AM
SLASH_GNOMESAGE1 = "/gnomesage"
SlashCmdList["GNOMESAGE"] = function()
		GnomeSageFrame:Show()
end

local totalAns, yesAns, maybeAns, noAns = 15, 5, 5, 5

function GnomeSage_OnLoad(frame)
   frame:RegisterForDrag("LeftButton")
end

function GnomeSage_UpdateQuestion()
	local labelQuestion
	if GnomeSageFrame_Input:GetNumLetters() == 0 then
		labelQuestion = GnomeSageLocalization["ERROR"]
		GnomeSageFrame_Question:SetText(labelQuestion)
		GnomeSageFrame_Input:SetFocus()
		GnomeSageFrame_Answer:Hide()
		GnomeSageFrame:SetHeight(130)
		GnomeSageFrame_Input:SetPoint("TOPLEFT", GnomeSageFrame_Portrait, "BOTTOMLEFT", 5, -5)
	else
		labelQuestion = GnomeSageLocalization["QUESTION"]..GnomeSageFrame_Input:GetText().."\""
		GnomeSageFrame_Question:SetText(labelQuestion)
		GnomeSageFrame_Input:SetText("")
		GnomeSageFrame_Input:ClearFocus()
		GnomeSage_UpdateAnswer()
  end
end

-- Function that accepts two variables, answer type (Y,M,N) and a number value. Returns the value which corresponds to the given key in localization tables.
function answerKey(name, index)
   local key = name.."_"..index
   return GnomeSageLocalization[key]
end

function GnomeSage_UpdateAnswer()
	local dieCast = random(1, totalAns)
	local labelAnswer
	
	if dieCast <= yesAns then
		labelAnswer = answerKey("YES", dieCast)
	elseif dieCast <= (yesAns + maybeAns) then
		labelAnswer = answerKey("MAYBE", (dieCast - yesAns))
	else
		labelAnswer = answerKey("NO", (dieCast - (yesAns + maybeAns)))
	end
	GnomeSageFrame_Answer:SetText(labelAnswer)
  GnomeSageFrame_Answer:Show()
  GnomeSageFrame:SetHeight(195)
  GnomeSageFrame_Input:SetPoint("TOPLEFT", GnomeSageFrame_Answer, "BOTTOMLEFT", 5, -6)
end
