--[[

	Give Me Health: 
		copyright 2005 by Stephen Blaising
	Version: 1.10.00
	-----------------
	Version 1.12.2 to Current by Mileg

]]

GMH_ADDONNAME = "Give Me Health";
GMH_MACRONAME = "GMHealth";
GMH_MANAMACRONAME = "GMMana";
GMH_BANDAGEMACRONAME = "GMBandage";
GMH_FOODMACRONAME = "GMFood";
GMH_WATERMACRONAME = "GMWater";
GMH_HEALTHSTONENAME = "GMHStone";

local GMH_VERSION = "2.4.1";

-- Binding Variables
BINDING_HEADER_GMH_HEADER = "Give Me Health";
BINDING_NAME_GMH_TOGGLE = "Toggle";
BINDING_NAME_GMH_OPTIONS= "Show Options Frame";

local GiveMeHealth_Loaded = false;
local GiveMeHealth_Enabled = false;
local notInCombat = true;
local saveType;
GMH_Save = {};
local Realm;
local Player;

local playername;

local GMH_HPotions = {};
local GMH_MPotions = {};
local GMH_Bandages = {};
local GMH_Water = {};
local GMH_Food = {};
local GMH_PotionCnt = {};
local TempArray = {};
local GMH_LastItem = {};
local GMH_LastBackup = {};

local GHM_ZoneName = "";
local GHM_ZoneType = "";

-- Check the player name, return true if the player name is known, false otherwise
local function CheckPlayerName()
  if (gotPlayerName) then
    return true;
  end
  local pName = UnitName("player");
  if ((pName ~= nil) and (pname ~= UNKNOWNOBJECT) and (pname ~= UKNOWNBEING)) then
    gotPlayerName = true;
    return true;
  end
  return false;
end

function GiveMeHealth_OnLoad()
	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("PLAYER_REGEN_ENABLED");
	this:RegisterEvent("PLAYER_REGEN_DISABLED");
	this:RegisterEvent("UNIT_INVENTORY_CHANGED");
	this:RegisterEvent("BAG_UPDATE");
	this:RegisterEvent("PLAYER_ENTERING_WORLD");
	this:RegisterEvent("ZONE_CHANGED_NEW_AREA");
	
	SlashCmdList["GIMMEHEALTHCOMMAND"] = GiveMeHealth_SlashHandler;
     	SLASH_GIMMEHEALTHCOMMAND1 = "/givemehealth";
     	SLASH_GIMMEHEALTHCOMMAND1 = "/gmh";

	
end



function GiveMeHealth_OnEvent()
	if ( event == "PLAYER_ENTERING_WORLD" ) then
		
		if ( GetMacroIndexByName(GMH_MACRONAME) == 0 ) then
			CreateMacro(GMH_MACRONAME,7,"/gmh update=health\n/cast [modifier:ctrl] Alchemy",true);
		end
		
		if ( GetMacroIndexByName(GMH_MANAMACRONAME) == 0 ) then
			CreateMacro(GMH_MANAMACRONAME,282,"/gmh update=mana\n/cast [modifier:ctrl] Alchemy",true);
		end
		
		if ( GetMacroIndexByName(GMH_BANDAGEMACRONAME) == 0 ) then
			CreateMacro(GMH_BANDAGEMACRONAME,511,"/gmh update=bandage\n/cast [modifier:ctrl] First Aid",true);
		end
		
		if ( GetMacroIndexByName(GMH_FOODMACRONAME) == 0 ) then
			CreateMacro(GMH_FOODMACRONAME,545,"/gmh update=food\n/cast [modifier:ctrl] Cooking\n/cast [button:2] conjure food",true);
		end
		
		if ( GetMacroIndexByName(GMH_WATERMACRONAME) == 0 ) then
			CreateMacro(GMH_WATERMACRONAME,544,"/gmh update=water\n/cast [button:2] conjure water",true);
		end
		if ( GetMacroIndexByName(GMH_HEALTHSTONENAME) == 0 ) then
			CreateMacro(GMH_HEALTHSTONENAME,575,"/gmh update=stone\n/cast [button:2] Create Healthstone",true);
		end
		GiveMeHealth_GetZoneType()
		GMH_Go(GMH_MACRONAME);
		GMH_Go(GMH_MANAMACRONAME);
		GMH_Go(GMH_BANDAGEMACRONAME);
		GMH_Go(GMH_FOODMACRONAME);
		GMH_Go(GMH_WATERMACRONAME);
			
			
		return;
        elseif ( event == "VARIABLES_LOADED" ) then
        	GiveMeHealth_InitVars();
        	GiveMeHealth_Print(GMH_ADDONNAME.." v"..GMH_VERSION.." Loaded");
			GiveMeHealth_Print("Type /gmh help for instructions");
		return;
			
		elseif ( event == "PLAYER_REGEN_ENABLED" ) then
			notInCombat = true;
			GMH_Go(GMH_MACRONAME);
			GMH_Go(GMH_MANAMACRONAME);
			GMH_Go(GMH_BANDAGEMACRONAME);
			GMH_Go(GMH_FOODMACRONAME);
			GMH_Go(GMH_HEALTHSTONENAME);
			--GiveMeHealth_Print("Exiting Combat");
		return;
			
		elseif ( event == "PLAYER_REGEN_DISABLED" ) then
			notInCombat = false;
			--GiveMeHealth_Print("Entering Combat");
		return;
			
		elseif ((event == "UNIT_INVENTORY_CHANGED" or event == "BAG_UPDATE") and notInCombat ) then
			--GiveMeHealth_Print("Updating Macros");
			GMH_Go(GMH_MACRONAME);
			GMH_Go(GMH_MANAMACRONAME);
			GMH_Go(GMH_BANDAGEMACRONAME);
			GMH_Go(GMH_FOODMACRONAME);
			GMH_Go(GMH_WATERMACRONAME);
			GMH_Go(GMH_WATERMACRONAME);
			GMH_Go(GMH_HEALTHSTONENAME);
		elseif ( event == "ZONE_CHANGED_NEW_AREA" ) then
			GiveMeHealth_GetZoneType()
	end
end

function GiveMeHealth_GetZoneType()
	if ( GHM_ZoneName ~= GetRealZoneText() ) then
		GHM_ZoneName = GetRealZoneText();
		if ( GHM_ZoneName == "Warsong Gulch" or GHM_ZoneName == "Alterac Valley" or GHM_ZoneName == "Arathi Basin" or GHM_ZoneName == "Eye of the Storm") then
			GHM_ZoneType = "BG";
		elseif ( GHM_ZoneName == "The Botanica" or GHM_ZoneName == "Tempest Keep" or GHM_ZoneName == "The Mechanar" or GHM_ZoneName == "The Arcatraz") then
			GHM_ZoneType = "TK";
		else
			GHM_ZoneType = "ALL";
		end 
		--GMH_Go(GMH_MACRONAME);
		--GMH_Go(GMH_MANAMACRONAME);
		--GMH_Go(GMH_BANDAGEMACRONAME);
		--GMH_Go(GMH_FOODMACRONAME);
		--GMH_Go(GMH_WATERMACRONAME);
	end
end


function GiveMeHealth_SlashHandler(msg)

     if (msg) then
	  msg = string.lower(msg);
	end
	if (msg == "help") then
		GiveMeHealth_Print(GMH_ADDONNAME.." v"..GMH_VERSION.." ");
		GiveMeHealth_Print("Type /Macro to open macro list");
		GiveMeHealth_Print("Drag macros to your hot bar.");
		GiveMeHealth_Print("   GMHealth - Uses best Health potions. May need Prepping (see below)");
		GiveMeHealth_Print("   GMMana - Uses best Mana potions. May need Prepping.");
		GiveMeHealth_Print("   GMBandage - Uses best Bandages. May need Prepping");
		GiveMeHealth_Print("   GMFood - Eat best foods.");
		GiveMeHealth_Print("   GMWater - Drink best drinks");
		GiveMeHealth_Print("Prepping: If used in combat, the macro won't auto-update per 2.0 rules. To prep, just click on the macro");
		GiveMeHealth_Print("   To prep, just click on the macro outside of combat. The potion will NOT be used outside of combat. Cancel bandage use.");
		GiveMeHealth_Print("CTRL-Click on macros to open craft (if you have it) to make those items:");
		GiveMeHealth_Print("   GMFood - Cooking");
		GiveMeHealth_Print("   GMBandage - First Aid");
		GiveMeHealth_Print("   GMHealth or GMMana - Alchemy");
		GiveMeHealth_Print("ALT-Click on Potion macros to Use potion out of combat.");
		GiveMeHealth_Print("/gmh update will update all macros");
		GiveMeHealth_Print("/gmh update=[health|mana|bandage|food|water] will update specified macro (no spaces)");
		
	elseif (msg == "update") then
		notInCombat = true;
		GMH_Go(GMH_MACRONAME);
		GMH_Go(GMH_MANAMACRONAME);
		GMH_Go(GMH_BANDAGEMACRONAME);
		GMH_Go(GMH_FOODMACRONAME);
		GMH_Go(GMH_WATERMACRONAME);
		GMH_Go(GMH_HEALTHSTONENAME);		
	elseif (msg == "update=health") then
		GMH_Go(GMH_MACRONAME);
	elseif (msg == "update=mana") then
		GMH_Go(GMH_MANAMACRONAME);
	elseif (msg == "update=bandage") then
		GMH_Go(GMH_BANDAGEMACRONAME);
	elseif (msg == "update=food") then
		GMH_Go(GMH_FOODMACRONAME);
	elseif (msg == "update=water") then
		GMH_Go(GMH_WATERMACRONAME);
	elseif (msg == "update=stone") then
		GMH_Go(GMH_HEALTHSTONENAME);
		
	elseif (msg == "save") then
		GiveMeHealth_Print("Saving ".. saveType.. " to be eaten last");
	elseif (msg == "save=meat") then
		saveType = "meat";
		GMH_Save[Realm][Player].saveType = saveType;
		GiveMeHealth_Print("Saving ".. saveType.. " to be eaten last");
	elseif (msg == "save=fish") then
		saveType = "fish";
		GMH_Save[Realm][Player].saveType = saveType;
		GiveMeHealth_Print("Saving ".. saveType.. " to be eaten last");
	elseif (msg == "save=cheese") then
		saveType = "cheese";
		GMH_Save[Realm][Player].saveType = saveType;
		GiveMeHealth_Print("Saving ".. saveType.. " to be eaten last");
	elseif (msg == "save=bread") then
		saveType = "bread";
		GMH_Save[Realm][Player].saveType = saveType;
		GiveMeHealth_Print("Saving ".. saveType.. " to be eaten last");
	elseif (msg == "save=fungus") then
		saveType = "fungus";
		GMH_Save[Realm][Player].saveType = saveType;
		GiveMeHealth_Print("Saving ".. saveType.. " to be eaten last");
	elseif (msg == "save=fruit") then
		saveType = "fruit";
		GMH_Save[Realm][Player].saveType = saveType;
		GiveMeHealth_Print("Saving ".. saveType.. " to be eaten last");
	end
	
end


function GiveMeHealth_Print(msg) 
	if ( ( msg ) and ( strlen(msg) > 0 ) ) then
		if ( DEFAULT_CHAT_FRAME ) then
			DEFAULT_CHAT_FRAME:AddMessage(msg, 1, 1, 0);
		end
	end
end

function GiveMeHealth_InitVars()
	Player=UnitName("player");
	Realm=GetCVar("realmName");

	if GMH_Save[Realm] == nil then
		GMH_Save[Realm] = {}
	end

	if GMH_Save[Realm][Player] == nil then
		GMH_Save[Realm][Player] = {}
	end

	if (GMH_Save[Realm][Player].saveType  == nil) then
		GMH_Save[Realm][Player].saveType  = "meat";
		saveType = "meat";
	else
		saveType = GMH_Save[Realm][Player].saveType;
	end
	GiveMeHealth_MakeArray();
	
end

function GiveMeHealth_MakeArray()

	GMH_HPotions = { 
			[16] = { [1] = Healing_sp_1, [2] = 55, [3] = 0, [4] = "TK" },
			[15] = { [1] = MAJOR_HEALING_DRAUGHT, [2] = 45 , [3] = 0, [4] = "BG"}, 
			[14] = { [1] = SUPERIOR_HEALING_DRAUGHT, [2] = 35, [3] = 0, [4] = "BG" },
			-- Normal items:
-- **** To have Super potions before Injectors, change 10 to 9, and on next line 9 to 10.
			[13] = { [1] = Healing_eng, [2] = 55, [3] = 0, [4] = "ALL" },
			[12] = { [1] = Healing_11, [2] = 55, [3] = 0, [4] = "ALL" },
			[11] = { [1] = Healing_10, [2] = 55, [3] = 0, [4] = "ALL" },
			[10] = { [1] = Healing_9, [2] = 55, [3] = 0, [4] = "ALL" },
			[9] = { [1] = Healing_8, [2] = 61, [3] = 0, [4] = "ALL" },
			[8] = { [1] = Healing_7, [2] = 55, [3] = 0, [4] = "ALL" },
			[7] = { [1] = MAJOR_HEALING_POTION, [2] = 45 , [3] = 0, [4] = "ALL"}, 
			[6] = { [1] = COMBAT_HEALING_POTION, [2] = 45 , [3] = 0, [4] = "ALL"}, 
			[5] = { [1] = SUPERIOR_HEALING_POTION, [2] = 35, [3] = 0, [4] = "ALL" }, 
			[4] = { [1] = GREATER_HEALING_POTION,  [2] = 21, [3] = 0, [4] = "ALL" },
			[3] = { [1] = HEALING_POTION , [2] = 12, [3] = 0, [4] = "ALL" }, 
			[2] = { [1] = LESSER_HEALING_POTION, [2] = 3, [3] = 0, [4] = "ALL" },
			[1] = { [1] = MINOR_HEALING_POTION, [2] = 0, [3] = 0, [4] = "ALL" },
	};	
	
	GMH_MPotions = { 
			[16] = { [1] = Mana_sp_1, [2] = 55, [3] = 0, [4] = "TK" },
			[15] = { [1] = MAJOR_MANA_DRAUGHT, [2] = 45, [3] = 0, [4] = "BG" },
			[14] = { [1] = SUPERIOR_MANA_DRAUGHT, [2] = 35, [3] = 0 ,[4] = "BG"},
			--Normal items:
-- **** To have Super potions before Injectors, change 10 to 9, and on next line 9 to 10.
			[13] = { [1] = Mana_eng, [2] = 55, [3] = 0, [4] = "ALL" },
			[12] = { [1] = Mana_11, [2] = 55, [3] = 0, [4] = "ALL" },
			[11] = { [1] = Mana_10, [2] = 55, [3] = 0, [4] = "ALL" },
			[10] = { [1] = Mana_9, [2] = 55, [3] = 0, [4] = "ALL" },
			[9] = { [1] = Mana_8, [2] = 61, [3] = 0, [4] = "ALL" },
			[8] = { [1] = Mana_7, [2] = 55, [3] = 0, [4] = "ALL" },
			[7] = { [1] = MAJOR_MANA_POTION, [2] = 41, [3] = 0, [4] = "ALL" },
			[6] = { [1] = COMBAT_MANA_POTION, [2] = 35, [3] = 0 ,[4] = "ALL"},
			[5] = { [1] = SUPERIOR_MANA_POTION, [2] = 41, [3] = 0 ,[4] = "ALL"},
			[4] = { [1] = GREATER_MANA_POTION, [2] = 31, [3] = 0, [4] = "ALL" },
			[3] = { [1] = MANA_POTION, [2] = 22, [3] = 0, [4] = "ALL" },
			[2] = { [1] = LESSER_MANA_POTION, [2] = 14, [3] = 0, [4] = "ALL" },
			[1] = { [1] = MINOR_MANA_POTION, [2] = 5 , [3] = 0, [4] = "ALL"},
	};	
	
	GMH_Bandages = {
			[22] = { [1] = WSG_RUNECLOTH_BANDAGE, [2] = 45 , [3] = 0, [4] = "Warsong Gulch"},
			[21] = { [1] = WSG_MAGEWEAVE_BANDAGE, [2] = 35 , [3] = 0, [4] = "Warsong Gulch"},
			[20] = { [1] = WSG_SILK_BANDAGE, [2] = 25 , [3] = 0, [4] = "Warsong Gulch"},
			[19] = { [1] = ARATHI_RUNECLOTH_BANDAGEh, [2] = 45 , [3] = 0, [4] = "Arathi Basin"},
			[18] = { [1] = ARATHI_MAGEWEAVE_BANDAGEh, [2] = 35 , [3] = 0, [4] = "Arathi Basin"},
			[17] = { [1] = ARATHI_SILK_BANDAGEh, [2] = 25 , [3] = 0, [4] = "Arathi Basin"},
			[16] = { [1] = ARATHI_RUNECLOTH_BANDAGEa, [2] = 45 , [3] = 0, [4] = "Arathi Basin"},
			[15] = { [1] = ARATHI_MAGEWEAVE_BANDAGEa, [2] = 35 , [3] = 0, [4] = "Arathi Basin"},
			[14] = { [1] = ARATHI_SILK_BANDAGEa, [2] = 25 , [3] = 0, [4] = "Arathi Basin"},
			[13] = { [1] = ALTERAC_RUNECLOTH_BANDAGE, [2] = 0 , [3] = 0, [4] = "Alterac Valley"},
			--Normal items:
			[12] = { [1] = Bandage_12, [2] = 0 , [3] = 0, [4] = "ALL"},
			[11] = { [1] = Bandage_11, [2] = 0 , [3] = 0, [4] = "ALL"},
			[10] = { [1] = HEAVY_RUNECLOTH_BANDAGE, [2] = 0 , [3] = 0, [4] = "ALL"},
			[9] = { [1] = RUNECLOTH_BANDAGE, [2] = 0 , [3] = 0, [4] = "ALL"},
			[8] = { [1] = HEAVY_MAGEWEAVE_BANDAGE, [2] = 0 , [3] = 0, [4] = "ALL"},
			[7] = { [1] = MAGEWEAVE_BANDAGE, [2] = 0, [3] = 0 , [4] = "ALL"},
			[6] = { [1] = HEAVY_SILK_BANDAGE, [2] = 0 , [3] = 0, [4] = "ALL"},
			[5] = { [1] = SILK_BANDAGE, [2] = 0, [3] = 0 , [4] = "ALL"},
			[4] = { [1] = HEAVY_WOOL_BANDAGE, [2] = 0, [3] = 0 , [4] = "ALL"},
			[3] = { [1] = WOOL_BANDAGE, [2] = 0, [3] = 0, [4] = "ALL"},
			[2] = { [1] = HEAVY_LINEN_BANDAGE, [2] = 0 , [3] = 0, [4] = "ALL"},
			[1] = { [1] = LINEN_BANDAGE, [2] = 0, [3] = 0 , [4] = "ALL"},
	};
	
	GMH_Water = {
			-- Mage water
			[43] = { [1] = Mage_Biscuit_1, [2] = 65 , [3] = 0, [4] = "ALL"},
			[42] = { [1] = Mage_Water_9, [2] = 65 , [3] = 0, [4] = "ALL"},
			[41] = { [1] = Mage_Water_8, [2] = 60 , [3] = 0, [4] = "ALL"},
			[40] = { [1] = Mage_Water_7, [2] = 55 , [3] = 0, [4] = "ALL"},
			[39] = { [1] = Mage_Water_6, [2] = 45 , [3] = 0, [4] = "ALL"},
			[38] = { [1] = Mage_Water_5, [2] = 35 , [3] = 0, [4] = "ALL"},
			[37] = { [1] = Mage_Water_4, [2] = 25 , [3] = 0, [4] = "ALL"},
			[36] = { [1] = Mage_Water_3, [2] = 15 , [3] = 0, [4] = "ALL"},
			[35] = { [1] = Mage_Water_2, [2] = 5 , [3] = 0, [4] = "ALL"},
			[34] = { [1] = Mage_Water_1, [2] = 0 , [3] = 0, [4] = "ALL"},
			[33] = { [1] = PvP_Food_6a, [2] = 45 , [3] = 0, [4] = "Arathi Basin"},
			[32] = { [1] = PvP_Food_6h, [2] = 45 , [3] = 0, [4] = "Arathi Basin"},
			[31] = { [1] = PvP_Food_5, [2] = 45 , [3] = 0, [4] = "Warsong Gulch"},
			[30] = { [1] = PvP_Food_4, [2] = 35 , [3] = 0, [4] = "Arathi Basin"},
			[29] = { [1] = PvP_Food_4a, [2] = 35 , [3] = 0, [4] = "Arathi Basin"},
			[28] = { [1] = PvP_Food_4h, [2] = 35 , [3] = 0, [4] = "Arathi Basin"},
			[27] = { [1] = PvP_Food_3, [2] = 35 , [3] = 0, [4] = "Warsong Gulch"},
			[26] = { [1] = PvP_Food_2a, [2] = 25 , [3] = 0, [4] = "Arathi Basin"},
			[25] = { [1] = PvP_Food_2h, [2] = 25 , [3] = 0, [4] = "Arathi Basin"},
			[24] = { [1] = PvP_Food_1, [2] = 25 , [3] = 0, [4] = "Warsong Gulch"},
			-- Event water
			[23] = { [1] = Temp_Water_1, [2] = 0 , [3] = 0, [4] = "ALL"},
			[22] = { [1] = Temp_Water_2, [2] = 25 , [3] = 0, [4] = "ALL"},
			-- Vendor water
			[21] = { [1] = Vend_Biscuit_6_3, [2] = 65 , [3] = 0, [4] = "ALL"},
			[20] = { [1] = Cook_Biscuit_6_1, [2] = 65 , [3] = 0, [4] = "ALL"},
			[19] = { [1] = Vend_Water_14, [2] = 65 , [3] = 0, [4] = "ALL"},
			[18] = { [1] = Vend_Water_13, [2] = 65 , [3] = 0, [4] = "ALL"},
			[17] = { [1] = Vend_Water_12, [2] = 65 , [3] = 0, [4] = "ALL"},
			[16] = { [1] = Vend_Water_11, [2] = 65 , [3] = 0, [4] = "ALL"},
			[15] = { [1] = Vend_Water_10, [2] = 65 , [3] = 0, [4] = "ALL"},
			[14] = { [1] = Vend_Water_9, [2] = 60 , [3] = 0, [4] = "ALL"},
			[13] = { [1] = Vend_Water_8, [2] = 60 , [3] = 0, [4] = "ALL"},
			[12] = { [1] = Drop_Water_2, [2] = 55 , [3] = 0, [4] = "ALL"},
			[11] = { [1] = Other_Food_2, [2] = 55 , [3] = 0, [4] = "ALL"},
			[10] = { [1] = Vend_Water_7, [2] = 55 , [3] = 0, [4] = "ALL"},
			[9] = { [1] = Vend_Biscuit_6_2, [2] = 45 , [3] = 0, [4] = "ALL"},
			[8] = { [1] = Vend_Biscuit_6_1, [2] = 45 , [3] = 0, [4] = "ALL"},
			[7] = { [1] = Vend_Water_6, [2] = 45 , [3] = 0, [4] = "ALL"},
			[6] = { [1] = Vend_Water_5, [2] = 35 , [3] = 0, [4] = "ALL"},
			[5] = { [1] = Drop_Water_1, [2] = 25 , [3] = 0, [4] = "ALL"},
			[4] = { [1] = Vend_Water_4, [2] = 25 , [3] = 0, [4] = "ALL"},
			[3] = { [1] = Vend_Water_3, [2] = 15 , [3] = 0, [4] = "ALL"},
			[2] = { [1] = Vend_Water_2, [2] = 5 , [3] = 0, [4] = "ALL"},
			[1] = { [1] = Vend_Water_1, [2] = 0 , [3] = 0, [4] = "ALL"},
	};
		GMH_Food = {
			[117] = { [1] = Mage_Biscuit_1, [2] = 65 , [3] = 0, [4] = "ALL"},
			-- PvP Food
			[116] = { [1] = PvP_Food_6a, [2] = 45 , [3] = 0, [4] = "Arathi Basin"},
			[115] = { [1] = PvP_Food_6h, [2] = 45 , [3] = 0, [4] = "Arathi Basin"},
			[114] = { [1] = PvP_Food_5, [2] = 45 , [3] = 0, [4] = "Warsong Gulch"},
			[113] = { [1] = PvP_Food_4, [2] = 35 , [3] = 0, [4] = "Arathi Basin"},
			[112] = { [1] = PvP_Food_4a, [2] = 35 , [3] = 0, [4] = "Arathi Basin"},
			[111] = { [1] = PvP_Food_4h, [2] = 35 , [3] = 0, [4] = "Arathi Basin"},
			[110] = { [1] = PvP_Food_3, [2] = 35 , [3] = 0, [4] = "Warsong Gulch"},
			[109] = { [1] = PvP_Food_2a, [2] = 25 , [3] = 0, [4] = "Arathi Basin"},
			[108] = { [1] = PvP_Food_2h, [2] = 25 , [3] = 0, [4] = "Arathi Basin"},
			[107] = { [1] = PvP_Food_1, [2] = 25 , [3] = 0, [4] = "Warsong Gulch"},
			-- Mage Food
			[106] = { [1] = Mage_Food_8, [2] = 65 , [3] = 0, [4] = "ALL"},
			[105] = { [1] = Mage_Food_7, [2] = 55 , [3] = 0, [4] = "ALL"},
			[104] = { [1] = Mage_Food_6, [2] = 45 , [3] = 0, [4] = "ALL"},
			[103] = { [1] = Mage_Food_5, [2] = 35 , [3] = 0, [4] = "ALL"},
			[102] = { [1] = Mage_Food_4, [2] = 25 , [3] = 0, [4] = "ALL"},
			[101] = { [1] = Mage_Food_3, [2] = 15 , [3] = 0, [4] = "ALL"},
			[100] = { [1] = Mage_Food_2, [2] = 5 , [3] = 0, [4] = "ALL"},
			[99] = { [1] = Mage_Food_1, [2] = 0 , [3] = 0, [4] = "ALL"},
			--- Event Food
			
			[98] = { [1] = Temp_Food_1, [2] = 0 , [3] = 0, [4] = "ALL"},
			[97] = { [1] = Temp_Food_2, [2] = 0 , [3] = 0, [4] = "ALL"},
			[96] = { [1] = Temp_Food_3, [2] = 0 , [3] = 0, [4] = "ALL"},
			[95] = { [1] = Temp_Food_4, [2] = 0 , [3] = 0, [4] = "ALL"},
			[94] = { [1] = Temp_Food_5, [2] = 0 , [3] = 0, [4] = "ALL"},
			[93] = { [1] = Temp_Food_6, [2] = 0 , [3] = 0, [4] = "ALL"},
			[92] = { [1] = Temp_Food_7, [2] = 0 , [3] = 0, [4] = "ALL"},
			[91] = { [1] = Temp_Food_8, [2] = 40 , [3] = 0, [4] = "ALL"},
			[90] = { [1] = Temp_Food_9, [2] = 0 , [3] = 0, [4] = "ALL"},
			[89] = { [1] = Temp_Food_10, [2] = 0 , [3] = 0, [4] = "ALL"},
			--- Food (Level 65)
			[88] = { [1] = Vend_Biscuit_6_3, [2] = 65 , [3] = 0, [4] = "ALL"},
			[87] = { [1] = Cook_Biscuit_6_1, [2] = 65 , [3] = 0, [4] = "ALL"},
			[86] = { [1] = Cook_Food_62, [2] = 65 , [3] = 0, [4] = "ALL"},
			[85] = { [1] = Vend_Food_8_18, [2] = 65 , [3] = 0, [4] = "ALL"},
			[84] = { [1] = Vend_Food_8_19, [2] = 65 , [3] = 0, [4] = "ALL"},
			[83] = { [1] = Vend_Food_8_20, [2] = 65 , [3] = 0, [4] = "ALL"},
			[82] = { [1] = Vend_Food_8_21, [2] = 65 , [3] = 0, [4] = "ALL"},
			[81] = { [1] = Vend_Food_8_22, [2] = 65 , [3] = 0, [4] = "ALL"},
			[80] = { [1] = Vend_Food_8_23, [2] = 65 , [3] = 0, [4] = "ALL"},
			[79] = { [1] = Vend_Food_8_24, [2] = 65 , [3] = 0, [4] = "ALL"},
			-- Food 55
			[78] = { [1] = Other_Food_2, [2] = 55 , [3] = 0, [4] = "ALL"},
			[77] = { [1] = Other_Food_1, [2] = 55 , [3] = 0, [4] = "ALL"},
			[76] = { [1] = Cook_Food_61, [2] = 55 , [3] = 0, [4] = "ALL"},
			[75] = { [1] = Vend_Food_7_18, [2] = 55 , [3] = 0, [4] = "ALL"},
			[74] = { [1] = Vend_Food_7_19, [2] = 55 , [3] = 0, [4] = "ALL"},
			[73] = { [1] = Vend_Food_7_20, [2] = 55 , [3] = 0, [4] = "ALL"},
			[72] = { [1] = Vend_Food_7_21, [2] = 55 , [3] = 0, [4] = "ALL"},
			[71] = { [1] = Vend_Food_7_22, [2] = 55 , [3] = 0, [4] = "ALL"},
			[70] = { [1] = Vend_Food_7_23, [2] = 55 , [3] = 0, [4] = "ALL"},
			[69] = { [1] = Vend_Food_7_24, [2] = 55 , [3] = 0, [4] = "ALL"},
			--Vend Food 45
			[68] = { [1] = Cook_Food_52, [2] = 45 , [3] = 0, [4] = "ALL"},
			[67] = { [1] = Cook_Food_51, [2] = 45 , [3] = 0, [4] = "ALL"},
			[66] = { [1] = Vend_Biscuit_6_2, [2] = 45 , [3] = 0, [4] = "ALL"},
			[65] = { [1] = Vend_Biscuit_6_1, [2] = 45 , [3] = 0, [4] = "ALL"},
			[64] = { [1] = Vend_Food_6_20, [2] = 45 , [3] = 0, [4] = "ALL"},
			[63] = { [1] = Vend_Food_6_21, [2] = 45 , [3] = 0, [4] = "ALL"},
			[62] = { [1] = Vend_Food_6_22, [2] = 45 , [3] = 0, [4] = "ALL"},
			[61] = { [1] = Vend_Food_6_23, [2] = 45 , [3] = 0, [4] = "ALL"},
			[60] = { [1] = Vend_Food_6_24, [2] = 45 , [3] = 0, [4] = "ALL"},
			[59] = { [1] = Vend_Food_6_25, [2] = 45 , [3] = 0, [4] = "ALL"},
			[58] = { [1] = Vend_Food_6_26, [2] = 45 , [3] = 0, [4] = "ALL"},
			[57] = { [1] = Vend_Food_6_27, [2] = 45 , [3] = 0, [4] = "ALL"},
			[56] = { [1] = Vend_Food_6_28, [2] = 45 , [3] = 0, [4] = "ALL"},
			-- Level 35
			[55] = { [1] =  Cook_Food_43, [2] = 35 , [3] = 0, [4] = "ALL"},
			[54] = { [1] =  Cook_Food_42, [2] = 35 , [3] = 0, [4] = "ALL"},
			[53] = { [1] =  Cook_Food_41, [2] = 35 , [3] = 0, [4] = "ALL"},
			[52] = { [1] = Vend_Food_5_20, [2] = 35 , [3] = 0, [4] = "ALL"},
			[51] = { [1] = Vend_Food_5_21, [2] = 35 , [3] = 0, [4] = "ALL"},
			[50] = { [1] = Vend_Food_5_22, [2] = 35 , [3] = 0, [4] = "ALL"},
			[49] = { [1] = Vend_Food_5_23, [2] = 35 , [3] = 0, [4] = "ALL"},
			[48] = { [1] = Vend_Food_5_24, [2] = 35 , [3] = 0, [4] = "ALL"},
			[47] = { [1] = Vend_Food_5_25, [2] = 35 , [3] = 0, [4] = "ALL"},
			[46] = { [1] = Vend_Food_5_26, [2] = 35 , [3] = 0, [4] = "ALL"},
			[45] = { [1] = Vend_Food_5_27, [2] = 35 , [3] = 0, [4] = "ALL"},
			-- Level 25
			[44] = { [1] = Cook_Food_32, [2] = 25 , [3] = 0, [4] = "ALL"},
			[43] = { [1] = Cook_Food_31, [2] = 25 , [3] = 0, [4] = "ALL"},
			[42] = { [1] = Vend_Food_4_20, [2] = 25 , [3] = 0, [4] = "ALL"},
			[41] = { [1] = Vend_Food_4_21, [2] = 25 , [3] = 0, [4] = "ALL"},
			[40] = { [1] = Vend_Food_4_22, [2] = 25 , [3] = 0, [4] = "ALL"},
			[39] = { [1] = Vend_Food_4_23, [2] = 25 , [3] = 0, [4] = "ALL"},
			[38] = { [1] = Vend_Food_4_24, [2] = 25 , [3] = 0, [4] = "ALL"},
			[37] = { [1] = Vend_Food_4_25, [2] = 25 , [3] = 0, [4] = "ALL"},
			[36] = { [1] = Vend_Food_4_26, [2] = 25 , [3] = 0, [4] = "ALL"},
			-- Level 15
			[35] = { [1] = Vend_Food_3_20, [2] = 15 , [3] = 0, [4] = "ALL"},
			[34] = { [1] = Vend_Food_3_21, [2] = 15 , [3] = 0, [4] = "ALL"},
			[33] = { [1] = Vend_Food_3_22, [2] = 15 , [3] = 0, [4] = "ALL"},
			[32] = { [1] = Vend_Food_3_23, [2] = 15 , [3] = 0, [4] = "ALL"},
			[31] = { [1] = Vend_Food_3_24, [2] = 15 , [3] = 0, [4] = "ALL"},
			[30] = { [1] = Vend_Food_3_25, [2] = 15 , [3] = 0, [4] = "ALL"},
			[29] = { [1] = Vend_Food_3_26, [2] = 15 , [3] = 0, [4] = "ALL"},
			--Level 10:
			[28] = { [1] = Cook_Food_23, [2] = 10 , [3] = 0, [4] = "ALL"},
			[27] = { [1] = Cook_Food_22, [2] = 10 , [3] = 0, [4] = "ALL"},
			[26] = { [1] = Cook_Food_21, [2] = 10 , [3] = 0, [4] = "ALL"},
			-- Level 5
			[25] = { [1] = Cook_Food_14, [2] = 5 , [3] = 0, [4] = "ALL"},
			[24] = { [1] = Cook_Food_13, [2] = 5 , [3] = 0, [4] = "ALL"},
			[23] = { [1] = Cook_Food_12, [2] = 5 , [3] = 0, [4] = "ALL"},
			[22] = { [1] = Cook_Food_11, [2] = 5 , [3] = 0, [4] = "ALL"},
			[21] = { [1] = Vend_Food_2_20, [2] = 5 , [3] = 0, [4] = "ALL"},
			[20] = { [1] = Vend_Food_2_21, [2] = 5 , [3] = 0, [4] = "ALL"},
			[19] = { [1] = Vend_Food_2_22, [2] = 5 , [3] = 0, [4] = "ALL"},
			[18] = { [1] = Vend_Food_2_23, [2] = 5 , [3] = 0, [4] = "ALL"},
			[17] = { [1] = Vend_Food_2_24, [2] = 5 , [3] = 0, [4] = "ALL"},
			[16] = { [1] = Vend_Food_2_25, [2] = 5 , [3] = 0, [4] = "ALL"},
			[15] = { [1] = Vend_Food_2_26, [2] = 5 , [3] = 0, [4] = "ALL"},
			-- Level 0
			[14] = { [1] = Cook_Food_06, [2] = 0 , [3] = 0, [4] = "ALL"},
			[13] = { [1] = Cook_Food_05, [2] = 0 , [3] = 0, [4] = "ALL"},
			[12] = { [1] = Cook_Food_04, [2] = 0 , [3] = 0, [4] = "ALL"},
			[11] = { [1] = Cook_Food_03, [2] = 0 , [3] = 0, [4] = "ALL"},
			[10] = { [1] = Cook_Food_02, [2] = 0 , [3] = 0, [4] = "ALL"},
			[9] = { [1] = Cook_Food_01, [2] = 0 , [3] = 0, [4] = "ALL"},
			[8] = { [1] = Vend_Food_1_20, [2] = 0 , [3] = 0, [4] = "ALL"},
			[7] = { [1] = Vend_Food_1_21, [2] = 0 , [3] = 0, [4] = "ALL"},
			[6] = { [1] = Vend_Food_1_22, [2] = 0 , [3] = 0, [4] = "ALL"},
			[5] = { [1] = Vend_Food_1_23, [2] = 0 , [3] = 0, [4] = "ALL"},
			[4] = { [1] = Vend_Food_1_24, [2] = 0 , [3] = 0, [4] = "ALL"},
			[3] = { [1] = Vend_Food_1_25, [2] = 0 , [3] = 0, [4] = "ALL"},
			[2] = { [1] = Vend_Food_1_26, [2] = 0 , [3] = 0, [4] = "ALL"},
			[1] = { [1] = Vend_Food_1_27, [2] = 0 , [3] = 0, [4] = "ALL"},
	};
		GMH_Stones = {
			[6] = { [1] = Healthstone_60, [2] = 0 , [3] = 0, [4] = "ALL"},
			[5] = { [1] = Healthstone_48, [2] = 0 , [3] = 0, [4] = "ALL"},
			[4] = { [1] = Healthstone_36, [2] = 36 , [3] = 0, [4] = "ALL"},
			[3] = { [1] = Healthstone_24, [2] = 24 , [3] = 0, [4] = "ALL"},
			[2] = { [1] = Healthstone_12, [2] = 12 , [3] = 0, [4] = "ALL"},
			[1] = { [1] = Healthstone_0 , [2] = 0 , [3] = 0, [4] = "ALL"},
	};
	
end

function GMH_Go(macroName, dontuse)
	local fNum = 0;
	local fBagNum = 0;
	local fSlotNum = 0;
	local fName = "";
	local fIcon = "";
	local fBNum = 0;
	local fBackup = "";
	
	GiveMeHealth_GetZoneType()		
	if (macroName == GMH_MACRONAME) then
		fName = "No health potions";
		TempArray = GMH_HPotions;
	elseif (macroName == GMH_MANAMACRONAME) then
		fName = "No mana potions";
		TempArray = GMH_MPotions;
	elseif (macroName == GMH_BANDAGEMACRONAME) then
		fName = "No bandages";
		TempArray = GMH_Bandages;
	elseif (macroName == GMH_FOODMACRONAME) then
		fName = "No food";
		TempArray = GMH_Food;
	elseif (macroName == GMH_WATERMACRONAME) then
		fName = "No drinks";
		TempArray = GMH_Water;
	elseif (macroName == GMH_HEALTHSTONENAME) then
		fName = "No Stones";
		TempArray = GMH_Stones;
	end
	
	local tHCnt = 0;
	-- Loop through bags.
	for lttcnt = 1, table.getn(TempArray), 1 do
		TempArray[lttcnt][3] = 0;
	end
	for bagID = 0, 4, 1 do
		local cnt = GetContainerNumSlots(bagID);
		if ( cnt > 0 ) then
			-- Loop through slots.
			for slot = 1,cnt,1 do
				local link = GetContainerItemLink(bagID, slot);
	  			local name = GiveMeHealth_NameFromLink(link);
				--local name = GetItemInfo(GetContainerItemLink(bagID, slot))
				--GiveMeHealth_Print("Found ".. name);
				local cntitem,icnt = GetContainerItemInfo(bagID,slot);
				local canuse = false;
				if ( name ) then
					--GiveMeHealth_Print("Looking at ".. name);
					
					for lttcnt = 1, table.getn(TempArray), 1 do
						if ( TempArray[lttcnt][1] == name) then 
							if ( TempArray[lttcnt][2] <= UnitLevel("player") ) then
								
								
								if ( TempArray[lttcnt][4] == "ALL" ) then
									canuse = true;
								elseif ( TempArray[lttcnt][4] == GHM_ZoneType ) then
									canuse = true;
								elseif ( TempArray[lttcnt][4] == GHM_ZoneName ) then
									canuse = true;
								end 
								
								if ( canuse == true ) then
									TempArray[lttcnt][3] = TempArray[lttcnt][3] + 1;
									--GiveMeHealth_Print("lttcnt at ".. lttcnt);
									--GiveMeHealth_Print("fNum ".. fNum);

									if ( lttcnt > fNum ) then
										--GiveMeHealth_Print("Replacing ".. fBNum.." with ".. fNum);
										--GiveMeHealth_Print("Replacing ".. fBackup.." with ".. fName);
										fBNum = fNum;
										fNum = lttcnt;
										fBagNum = bagID;
										fSlotNum = slot;
										fBackup = fName;
										fName = name;
										fIcon = cntitem;
									elseif ( (lttcnt > fBNum)  and (lttcnt < fNum)) then
										--GiveMeHealth_Print("2Replacing ".. fBNum.." with ".. fNum);
										--GiveMeHealth_Print("2Replacing ".. fBackup.." with ".. fName);
										fBNum = lttcnt;
										fBackup = name;
										
									end
									tHCnt =  tHCnt + icnt;
								end
							end
							break;
						end	
						
					end			
					
				end
				
			end
		end
		
	end
	
	GMH_PotionCnt[macroName] = tHCnt;
		
	if ( dontuse == true ) then
		if ( fNum > 0 ) then
			return fName, fIcon;
		end 
		return fName, nil;
		
	elseif ( fNum > 0 ) then
		
		--UseContainerItem(fBagNum,fSlotNum);
		if (macroName == GMH_MACRONAME and notInCombat) then
			if (GMH_LastItem[GMH_MACRONAME] == nil or GMH_LastBackup[GMH_MACRONAME] ==nil) or (GMH_LastItem[GMH_MACRONAME] ~= fName or GMH_LastBackup[GMH_MACRONAME] ~= fBackup) then
				--GiveMeHealth_Print("Preping "..fName);
				EditMacro(GMH_MACRONAME,GMH_MACRONAME,1,"#showtooltip [nomodifier:shift]"..fName..";"..fBackup..";\n/gmh update=health\n/use [combat, nomodifier] "..fName..";[modifier:alt]"..fName..";[modifier:shift]"..fBackup..";\n/cast [modifier:ctrl] Alchemy",true);
				GMH_LastItem[GMH_MACRONAME] = fName;
				GMH_LastBackup[GMH_MACRONAME] = fBackup;
			end
		elseif (macroName == GMH_MANAMACRONAME and notInCombat) then
			if (GMH_LastItem[GMH_MANAMACRONAME] == nil or GMH_LastBackup[GMH_MANAMACRONAME] == nil) or (GMH_LastItem[GMH_MANAMACRONAME] ~= fName or GMH_LastBackup[GMH_MANAMACRONAME] ~= fBackup) then
				--GiveMeHealth_Print("Preping "..fName);
				EditMacro(GMH_MANAMACRONAME,GMH_MANAMACRONAME,1,"#showtooltip [nomodifier:shift]"..fName..";"..fBackup..";\n/gmh update=mana\n/use [combat, nomodifier] "..fName..";[modifier:alt]"..fName..";[modifier:shift]"..fBackup..";/cast [modifier:ctrl] Alchemy",true);
				GMH_LastItem[GMH_MANAMACRONAME] = fName;
				GMH_LastBackup[GMH_MANAMACRONAME] = fBackup;
			end
		elseif (macroName == GMH_BANDAGEMACRONAME and notInCombat) then
			if (GMH_LastItem[GMH_BANDAGEMACRONAME] == nil) or (GMH_LastItem[GMH_BANDAGEMACRONAME] ~= fName) then
				--GiveMeHealth_Print("Preping/Using "..fName);
				EditMacro(GMH_BANDAGEMACRONAME,GMH_BANDAGEMACRONAME,1,"#showtooltip\n/gmh update=bandage\n/use [nomodifier]"..fName.."\n/cast [modifier:ctrl] First Aid\n/use [modifier:alt, target=player] "..fName.." ",true);
				GMH_LastItem[GMH_BANDAGEMACRONAME] = fName;
				GMH_LastBackup[GMH_BANDAGEMACRONAME] = fBackup;
			end
		elseif (macroName == GMH_FOODMACRONAME and notInCombat) then
			if (GMH_LastItem[GMH_FOODMACRONAME] == nil or GMH_LastBackup[GMH_FOODMACRONAME] == nil) or (GMH_LastItem[GMH_FOODMACRONAME] ~= fName or GMH_LastBackup[GMH_FOODMACRONAME] ~= fBackup) then
				--GiveMeHealth_Print("Eating "..fName);
				EditMacro(GMH_FOODMACRONAME,GMH_FOODMACRONAME,1,"#showtooltip [nomodifier:shift]"..fName..";"..fBackup..";\n/gmh update=food\n/use [button:1, nomodifier] "..fName..";[modifier:shift]"..fBackup..";\n/cast [button:1, modifier:ctrl] Cooking\n/cast [button:2] conjure food",true);
				GMH_LastItem[GMH_FOODMACRONAME] = fName;
				GMH_LastBackup[GMH_FOODMACRONAME] = fBackup;
			end
		elseif (macroName == GMH_WATERMACRONAME and notInCombat) then
			if (GMH_LastItem[GMH_WATERMACRONAME] == nil or GMH_LastBackup[GMH_WATERMACRONAME] == nil) or (GMH_LastItem[GMH_WATERMACRONAME] ~= fName or GMH_LastBackup[GMH_WATERMACRONAME] ~= fBackup) then
				--GiveMeHealth_Print("Drinking "..fName.." or " ..fBackup);
				EditMacro(GMH_WATERMACRONAME,GMH_WATERMACRONAME,1,"#showtooltip [nomodifier:shift]"..fName..";"..fBackup..";\n/gmh update=water\n/use [button:1, nomodifier] "..fName..";[modifier:shift]"..fBackup..";\n/cast [button:2] conjure water",true);
				GMH_LastItem[GMH_WATERMACRONAME] = fName;
				GMH_LastBackup[GMH_WATERMACRONAME] = fBackup;
			end
		elseif (macroName == GMH_HEALTHSTONENAME and notInCombat) then
			if (GMH_LastItem[GMH_HEALTHSTONENAME] == nil) or (GMH_LastItem[GMH_HEALTHSTONENAME] ~= fName) then
				EditMacro(GMH_HEALTHSTONENAME,GMH_HEALTHSTONENAME,1,"#showtooltip\n/gmh update=stone\n/use [button:1] "..fName.."\n/cast [button:2]  Create Healthstone",true);
				GMH_LastItem[GMH_HEALTHSTONENAME] = fName;
				GMH_LastBackup[GMH_HEALTHSTONENAME] = fBackup;
			end
		end 
		
		return fName, fIcon;
	else
		if (macroName == GMH_MACRONAME and notInCombat) then
			--GiveMeHealth_Print("Out of Health Potions");
			EditMacro(GMH_MACRONAME,GMH_MACRONAME,7,"/gmh update=health\n/cast [modifier:ctrl] Alchemy",true);
			GMH_LastItem[GMH_MACRONAME] = nil;
			GMH_LastBackup[GMH_MACRONAME] = nil;
		elseif (macroName == GMH_MANAMACRONAME and notInCombat) then
			--GiveMeHealth_Print("Out of Mana Potions");
			EditMacro(GMH_MANAMACRONAME,GMH_MANAMACRONAME,282,"/gmh update=mana\n/cast [modifier:ctrl] Alchemy",true);
			GMH_LastItem[GMH_MANAMACRONAME] = nil;
			GMH_LastBackup[GMH_MANAMACRONAME] = nil;
		elseif (macroName == GMH_BANDAGEMACRONAME and notInCombat) then
			--GiveMeHealth_Print("Out of Bandages");
			EditMacro(GMH_BANDAGEMACRONAME,GMH_BANDAGEMACRONAME,511,"/gmh update=bandage\n/cast [modifier:ctrl] First Aid",true);
			GMH_LastItem[GMH_BANDAGEMACRONAME] = nil;
			GMH_LastBackup[GMH_BANDAGEMACRONAME] = nil;
		elseif (macroName == GMH_FOODMACRONAME and notInCombat) then
			--GiveMeHealth_Print("Out of Food");
			EditMacro(GMH_FOODMACRONAME,GMH_FOODMACRONAME,545,"/gmh update=food\n/cast [modifier:ctrl] Cooking\n/cast [button:2] conjure food",true);
			GMH_LastItem[GMH_FOODMACRONAME] = nil;
			GMH_LastBackup[GMH_FOODMACRONAME] = nil;
		elseif (macroName == GMH_WATERMACRONAME and notInCombat) then
			--GiveMeHealth_Print("Out of Drinks");
			EditMacro(GMH_WATERMACRONAME,GMH_WATERMACRONAME,544,"/gmh update=water\n/cast [button:2] conjure water",true);
			GMH_LastItem[GMH_WATERMACRONAME] = nil;
			GMH_LastBackup[GMH_WATERMACRONAME] = nil;
		elseif (macroName == GMH_HEALTHSTONENAME and notInCombat) then
			EditMacro(GMH_HEALTHSTONENAME,GMH_HEALTHSTONENAME,575,"/gmh update=stone\n/cast [button:2] Create Healthstone",true);
			GMH_LastItem[GMH_HEALTHSTONENAME] = nil;
			GMH_LastBackup[GMH_HEALTHSTONENAME] = nil;
		end 
		
		return fName, nil;
	end
		
end

function GiveMeHealth_NameFromLink(link)
	if( not link ) then
		return nil;
	end
	local _, _, name = strfind(link, "%[(.-)%]")
	
	return name;
end

