-- Not to be localized, just in here for general message purposes.
local GREEN="|cff20ff20"
local YELLOW="|cffffff40"
local RED="|cffff2020"
local WHITE="|cffffffff"
local MAGENTA="|cffff00ff"

local GEIST_PRETTYNAME = GREEN.."Geist"..WHITE

-- Chat Messages
GEIST_LOCAL_CHAT = {
	NAME = "Geist",
	VERSION = " v20300.1",
	SCALERESET = GEIST_PRETTYNAME..": Scale reset.",
	SCALESET = GEIST_PRETTYNAME..": Scale set to ",
	SCALEAT = GEIST_PRETTYNAME..": Scale is at ",
	BUTTON = GEIST_PRETTYNAME..": Button ",
	SETBUTTONID = " set to ID ",
	IDGUIDE = GEIST_PRETTYNAME..": Button ID guide is now ",
	NUMBUTTONSET = GEIST_PRETTYNAME..": Number of buttons now set to ",
	NUMBUTTONAT = GEIST_PRETTYNAME..": Number of buttons currently set to: ",
}

-- Chat Commands
GEIST_LOCAL_CMD = {
	SCALE = "scale",
	RESET = "reset",
	HELP = "help",
	ASSIGN = "assign",
	BIND = "bind",
	GUIDE = "guide",
	BUTTON = "buttons",
	ON = "on",
	OFF = "off",
	SLASH1 = "/geist",
	SLASH2 = "/gbm",
}

-- Keybindings
GEIST_LOCAL_KEYBIND = {
	FRAMEBINDSET = "Show Geist",
	BUTTONBINDSET = "Geist Button ",
}

local GEIST_PRETTYSLASH = YELLOW..GEIST_LOCAL_CMD["SLASH1"].." "

GEIST_CHATUSAGE = {
	GEIST_PRETTYNAME..": "..RED.."All changes require a UI reload to take effect.",
	GEIST_PRETTYNAME..GEIST_LOCAL_CHAT["VERSION"].." Usage:",
	GEIST_PRETTYSLASH..GEIST_LOCAL_CMD["BIND"]..WHITE..": Opens the keybinding panel. You will need to do this at least once.",
	GEIST_PRETTYSLASH..GEIST_LOCAL_CMD["BUTTON"]..WHITE..": Tells you the current number of buttons "..GEIST_LOCAL_CHAT["NAME"].." is set to use.",
	GEIST_PRETTYSLASH..GEIST_LOCAL_CMD["BUTTON"].." X"..WHITE..": Set the number of buttons for "..GEIST_LOCAL_CHAT["NAME"].." to use between 1 and 25.",
	GEIST_PRETTYSLASH..GEIST_LOCAL_CMD["SCALE"]..WHITE..": Tells you the current "..GEIST_LOCAL_CHAT["NAME"].." scale.",
	GEIST_PRETTYSLASH..GEIST_LOCAL_CMD["SCALE"].." X"..WHITE..": Set the scale of "..GEIST_LOCAL_CHAT["NAME"].." to between 0.5 and 1.5.",
	GEIST_PRETTYSLASH..GEIST_LOCAL_CMD["SCALE"].." "..GEIST_LOCAL_CMD["RESET"]..WHITE..": Reset "..GEIST_LOCAL_CHAT["NAME"].." to match your UI scale.",
	GEIST_PRETTYSLASH..GEIST_LOCAL_CMD["GUIDE"]..WHITE..": Enables or disables the button ID guide. When enabled, two numbers lay over your buttons. The top number is the "..GEIST_LOCAL_CHAT["NAME"].." button number. The bottom is the ID currently assigned to it.",
	GEIST_PRETTYSLASH..GEIST_LOCAL_CMD["ASSIGN"].."X"..WHITE..": Tells you what Button X's ID currently is.",
	GEIST_PRETTYSLASH..GEIST_LOCAL_CMD["ASSIGN"].."X Y"..WHITE..": Sets Button X to ID Y.",
	GEIST_PRETTYNAME..": "..RED.."All changes require a UI reload to take effect.",
}