function Geist_Create()
	-- Create the intial anchor.
	local anchor = CreateFrame("Button", "GeistAnchor", UIParent, "SecureAnchorUpDownTemplate")

	-- Set anchor to raise all events to it's children.
	anchor:SetAttribute("*childraise*", true)

	-- Tell it what value to set the statemap-anchor to one value for key down, one for key up. 
	-- In order to get a down and up, we need so specify the virtual buttons mapped to those states.
	anchor:SetAttribute("onmousedownbutton", "down")
	anchor:SetAttribute("onmouseupbutton", "up")

	-- Then the childstates.
	anchor:SetAttribute("childstate-down", "down")
	anchor:SetAttribute("childstate-up", "up")

	-- Now for the header.
	local hdr = CreateFrame("Frame", "GeistHeader", nil, "SecureStateHeaderTemplate")

	-- Show the buttons directly under the mouse.
	hdr:SetAttribute("headofsx", "1:0")
	hdr:SetAttribute("headofsy", "1:0")
	hdr:SetAttribute("headofsrelpoint", "cursor")

	-- Give it a statemap for the event sent from the anchor.
	hdr:SetAttribute("statemap-anchor-down", "1")
	hdr:SetAttribute("statemap-anchor-up", "0")

	-- And add it to the anchor
	anchor:SetAttribute("anchorchild", hdr)

	-- Now create the actual buttons.
	local buttons = {}

	for i = 1, Geist["Buttons"] do
		local btn = CreateFrame("CheckButton", "GeistButton"..i, nil, "SecureActionButtonTemplate, ActionBarButtonTemplate")

		buttons[i] = btn

		-- Needed for the buttons to work.
		btn:SetScript("OnAttributeChanged", ActionButton_UpdateAction)

		-- All sorts of fun placement stuff.
		if i == 1 then
			btn:SetAttribute("ofsx", "0")
			btn:SetAttribute("ofsx", "0")
		elseif i == 2 then
		btn:SetPoint("RIGHT", buttons[i-1], "LEFT", -2, 0)
		elseif i == 3 then
			btn:SetPoint("LEFT", buttons[i-2], "RIGHT", 2, 0)
		elseif i == 4 then
			btn:SetPoint("BOTTOM", buttons[i-3], "TOP", 0, 2)
		elseif i == 5 then
			btn:SetPoint("TOP", buttons[i-4], "BOTTOM", 0, -2)
		elseif i == 6 or i == 14 then
			btn:SetPoint("RIGHT", buttons[i-2], "LEFT", -2, 0)
		elseif i == 7 or i == 15 then
			btn:SetPoint("LEFT", buttons[i-3], "RIGHT", 2, 0)
		elseif i == 8 or i == 16 then
			btn:SetPoint("RIGHT", buttons[i-3], "LEFT", -2, 0)
		elseif i == 9 or i == 17 then
			btn:SetPoint("LEFT", buttons[i-4], "RIGHT", 2, 0)
		elseif i == 10 or i == 22 or i == 24 then
			btn:SetPoint("RIGHT", buttons[i-8], "LEFT", -2, 0)
		elseif i == 11 or i == 23 or i == 25 then
			btn:SetPoint("LEFT", buttons[i-8], "RIGHT", 2, 0)
		elseif i == 12 then
			btn:SetPoint("BOTTOM", buttons[i-8], "TOP", 0, 2)
		elseif i == 13 then
			btn:SetPoint("TOP", buttons[i-8], "BOTTOM", 0, -2)
		elseif i == 18 or i == 20 then
			btn:SetPoint("RIGHT", buttons[i-12], "LEFT", -2, 0)
		elseif i == 19 or i == 21 then
			btn:SetPoint("LEFT", buttons[i-12], "RIGHT", 2, 0)
		end

		-- Hide in state 0. Otherwise, be visible.
		btn:SetAttribute("hidestates", "0")

		-- Telling the buttons what to go do with themselves.
		btn:SetAttribute("*type*", "action")
		btn:SetAttribute("*action*", Geist["ButtonIDs"][i])

		-- Needed for the buttons to work.
		btn:SetScript("OnAttributeChanged", ActionButton_Update)

		-- Added to the header.
		hdr:SetAttribute("AddChild", btn)

		-- Setting the size.
		btn:SetAttribute("scale", Geist["Scale"])

		-- Create the binding entry for ClickBinder.
		table.insert(Geist_Bind, { GEIST_LOCAL_KEYBIND["BUTTONBINDSET"]..i, "CLICK "..btn:GetName()..":LeftButton" })

		-- Button numbers.
		if Geist["Guide"] then
			btn.title = btn:CreateFontString(nil, "OVERLAY")
			btn.title:SetFont(STANDARD_TEXT_FONT, 15, "OUTLINE")
			btn.title:SetTextColor(1, 1, 0)
			btn.title:SetAllPoints(btn)
			btn.title:SetText(i.."\n"..Geist["ButtonIDs"][i])
		end

	end

	-- The title box. I rather like this.
	local title = CreateFrame("Frame")
	title:SetAttribute("hidestates", "0")
	title:SetAttribute("scale", Geist["Scale"])
	hdr:SetAttribute("AddChild", title)
	title:SetFrameStrata("BACKGROUND")
	title:SetWidth(36)
	title:SetHeight(36)
	title:SetPoint("CENTER", 0, 0)

	local t = title:CreateTexture(nil,"BACKGROUND")
	t:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background")
	t:SetAllPoints(title)
	t:SetVertexColor(1, 1, 1, .5)
	title.texture = t

	title.title = title:CreateFontString(nil, "OVERLAY")
	title.title:SetFont(STANDARD_TEXT_FONT, 12, "OUTLINE")
	title.title:SetTextColor(1, 1, 0, .8)
	title.title:SetPoint("TOP", title, "TOP", 0, -1)
	title.title:SetText("Geist")

end
