﻿--[[
	Gatherable Nodes, type groupings definitions
	Gatherer Addon for World of Warcraft(tm).
	Version: 3.1.2 (<%codename%>)
	Revision: $Id: GatherCategories.lua 725 2008-04-08 19:23:48Z Esamynn $

	License:
		This program is free software; you can redistribute it and/or
		modify it under the terms of the GNU General Public License
		as published by the Free Software Foundation; either version 2
		of the License, or (at your option) any later version.

		This program is distributed in the hope that it will be useful,
		but WITHOUT ANY WARRANTY; without even the implied warranty of
		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
		GNU General Public License for more details.

		You should have received a copy of the GNU General Public License
		along with this program(see GPL.txt); if not, write to the Free Software
		Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	Note:
		This AddOn's source code is specifically designed to work with
		World of Warcraft's interpreted AddOn system.
		You have an implicit licence to use this AddOn with these facilities
		since that is it's designated purpose as per:
		http://www.fsf.org/licensing/licenses/gpl-faq.html#InterpreterIncompat

	Note 2:
		This file is automatically generated from data collected at
		http://wowwatcher.com/
		If you want to help contribute, please go there, get the client
		and upload your data.
]]

-- functions needed from the global environment
local pairs = pairs
local type = type
local Gatherer = Gatherer

-- redirect any other variable look ups to look for values
-- in the generated translations table
local Babylonian = LibStub("Babylonian")
assert(Babylonian, "Babylonian is not installed")
local babylonian = Babylonian(GathererLocalizations)
local metatable = { 
	__index = function( tbl, key )
		return babylonian:GetString(key, key)
	end
}
setmetatable( Gatherer.Categories, metatable )
setfenv(1, Gatherer.Categories)


-- Mapping of Object IDs to categories
ObjectCategories = {
	-- Ores
	[324] = "ORE_THORIUM", -- Small Thorium Vein
	[1610] = "ORE_INCENDICITE", -- Incendicite Mineral Vein
	[1731] = "ORE_COPPER", -- Copper Vein
	[1732] = "ORE_TIN", -- Tin Vein
	[1733] = "ORE_SILVER", -- Silver Vein
	[1734] = "ORE_GOLD", -- Gold Vein
	[1735] = "ORE_IRON", -- Iron Deposit
	[2040] = "ORE_MITHRIL", -- Mithril Deposit
	[2047] = "ORE_TRUESILVER", -- Truesilver Deposit
	[2653] = "ORE_BLOODSTONE", -- Lesser Bloodstone Deposit
	[19903] = "ORE_INDURIUM", -- Indurium Mineral Vein
	[73940] = "ORE_SILVER", -- Ooze Covered Silver Vein
	[73941] = "ORE_GOLD", -- Ooze Covered Gold Vein
	[123309] = "ORE_TRUESILVER", -- Ooze Covered Truesilver Deposit
	[123310] = "ORE_MITHRIL", -- Ooze Covered Mithril Deposit
	[123848] = "ORE_THORIUM", -- Ooze Covered Thorium Vein
	[165658] = "ORE_DARKIRON", -- Dark Iron Deposit
	[175404] = "ORE_RTHORIUM", -- Rich Thorium Vein
	[177388] = "ORE_RTHORIUM", -- Ooze Covered Rich Thorium Vein
	[180215] = "ORE_THORIUM", -- Hakkari Thorium Vein
	[181555] = "ORE_FELIRON", -- Fel Iron Deposit
	[181556] = "ORE_ADAMANTITE", -- Adamantite Deposit
	[181557] = "ORE_KHORIUM", -- Khorium Vein
	[181569] = "ORE_RADAMANTITE", -- Rich Adamantite Deposit
	[182197] = "", -- Arcane Container
	[185877] = "ORE_NETHERCITE", -- Nethercite Deposit

	-- Herbs
	[1617] = "HERB_SILVERLEAF", -- Silverleaf
	[1618] = "HERB_PEACEBLOOM", -- Peacebloom
	[1619] = "HERB_EARTHROOT", -- Earthroot
	[1620] = "HERB_MAGEROYAL", -- Mageroyal
	[1621] = "HERB_BRIARTHORN", -- Briarthorn
	[1622] = "HERB_BRUISEWEED", -- Bruiseweed
	[1623] = "HERB_WILDSTEELBLOOM", -- Wild Steelbloom
	[1624] = "HERB_KINGSBLOOD", -- Kingsblood
	[1628] = "HERB_GRAVEMOSS", -- Grave Moss
	[2041] = "HERB_LIFEROOT", -- Liferoot
	[2042] = "HERB_FADELEAF", -- Fadeleaf
	[2043] = "HERB_KHADGARSWHISKER", -- Khadgar's Whisker
	[2044] = "HERB_WINTERSBITE", -- Wintersbite
	[2045] = "HERB_STRANGLEKELP", -- Stranglekelp
	[2046] = "HERB_GOLDTHORN", -- Goldthorn
	[2866] = "HERB_FIREBLOOM", -- Firebloom
	[142140] = "HERB_PURPLELOTUS", -- Purple Lotus
	[142141] = "HERB_ARTHASTEAR", -- Arthas' Tears
	[142142] = "HERB_SUNGRASS", -- Sungrass
	[142143] = "HERB_BLINDWEED", -- Blindweed
	[142144] = "HERB_GHOSTMUSHROOM", -- Ghost Mushroom
	[142145] = "HERB_GROMSBLOOD", -- Gromsblood
	[176583] = "HERB_GOLDENSANSAM", -- Golden Sansam
	[176584] = "HERB_DREAMFOIL", -- Dreamfoil
	[176586] = "HERB_MOUNTAINSILVERSAGE", -- Mountain Silversage
	[176587] = "HERB_PLAGUEBLOOM", -- Plaguebloom
	[176588] = "HERB_ICECAP", -- Icecap
	[176589] = "HERB_BLACKLOTUS", -- Black Lotus
	[181166] = "HERB_BLOODTHISTLE", -- Bloodthistle
	[181270] = "HERB_FELWEED", -- Felweed
	[181271] = "HERB_DREAMINGGLORY", -- Dreaming Glory
	[181275] = "HERB_RAGVEIL", -- Ragveil
	[181276] = "HERB_FLAMECAP", -- Flame Cap
	[181277] = "HERB_TEROCONE", -- Terocone
	[181278] = "HERB_ANCIENTLICHEN", -- Ancient Lichen
	[181279] = "HERB_NETHERBLOOM", -- Netherbloom
	[181280] = "HERB_NIGHTMAREVINE", -- Nightmare Vine
	[181281] = "HERB_MANATHISTLE", -- Mana Thistle
	[185881] = "HERB_NETHERDUST", -- Netherdust Bush

	-- Treasure
	[2039] = "TREASURE_CHEST", -- Hidden Strongbox
	[2744] = "TREASURE_CLAM", -- Giant Clam
	[2843] = "TREASURE_CHEST", -- Battered Chest
	[2844] = "TREASURE_CHEST", -- Tattered Chest
	[2850] = "TREASURE_CHEST", -- Solid Chest
	[3658] = "TREASURE_BARREL", -- Water Barrel
	[3659] = "TREASURE_BARREL", -- Barrel of Melon Juice
	[3660] = "TREASURE_CRATE", -- Armor Crate
	[3661] = "TREASURE_CRATE", -- Weapon Crate
	[3662] = "TREASURE_CRATE", -- Food Crate
	[3705] = "TREASURE_BARREL", -- Barrel of Milk
	[3706] = "TREASURE_BARREL", -- Barrel of Sweet Nectar
	[3714] = "TREASURE_CHEST", -- Alliance Strongbox
	[19019] = "TREASURE_BOX", -- Box of Assorted Parts
	[28604] = "TREASURE_CRATE", -- Scattered Crate
	[74447] = "TREASURE_CHEST", -- Large Iron Bound Chest
	[74448] = "TREASURE_CHEST", -- Large Solid Chest
	[75293] = "TREASURE_CHEST", -- Large Battered Chest
	[123330] = "TREASURE_FOOTLOCKER", -- Buccaneer's Strongbox
	[131978] = "TREASURE_CHEST", -- Large Mithril Bound Chest
	[131979] = "TREASURE_CHEST", -- Large Darkwood Chest
	[142191] = "TREASURE_CRATE", -- Horde Supply Crate
	[157936] = "TREASURE_UNGOROSOIL", -- Un'Goro Dirt Pile
	[164658] = "TREASURE_POWERCRYST", -- Blue Power Crystal
	[164659] = "TREASURE_POWERCRYST", -- Green Power Crystal
	[164660] = "TREASURE_POWERCRYST", -- Red Power Crystal
	[164661] = "TREASURE_POWERCRYST", -- Yellow Power Crystal
	[164958] = "TREASURE_BLOODPETAL", -- Bloodpetal Sprout
	[176213] = "TREASURE_BLOODHERO", -- Blood of Heroes
	[176582] = "TREASURE_SHELLFISHTRAP", -- Shellfish Trap
	[178244] = "TREASURE_FOOTLOCKER", -- Practice Lockbox
	[179486] = "TREASURE_FOOTLOCKER", -- Battered Footlocker
	[179487] = "TREASURE_FOOTLOCKER", -- Waterlogged Footlocker
	[179492] = "TREASURE_FOOTLOCKER", -- Dented Footlocker
	[179493] = "TREASURE_FOOTLOCKER", -- Mossy Footlocker
	[179498] = "TREASURE_FOOTLOCKER", -- Scarlet Footlocker
	[181665] = "TREASURE_FOOTLOCKER", -- Burial Chest
	[181798] = "TREASURE_CHEST", -- Fel Iron Chest
	[181800] = "TREASURE_CHEST", -- Heavy Fel Iron Chest
	[181802] = "TREASURE_CHEST", -- Adamantite Bound Chest
	[181804] = "TREASURE_CHEST", -- Felsteel Chest
	[182053] = "TREASURE_GLOWCAP", -- Glowcap
	[184740] = "TREASURE_FOOTLOCKER", -- Wicker Chest
	[184793] = "TREASURE_FOOTLOCKER", -- Primitive Chest
	[184930] = "TREASURE_CHEST", -- Solid Fel Iron Chest
	[184931] = "TREASURE_CHEST", -- Bound Fel Iron Chest
	[184936] = "TREASURE_CHEST", -- Bound Adamantite Chest
	[184939] = "TREASURE_CHEST", -- Solid Adamantite Chest
	[185915] = "TREASURE_EGG", -- Netherwing Egg
	[164881] = "TREASURE_NIGHTDRAGON", -- Cleansed Night Dragon
	[164882] = "TREASURE_SONGFLOWER", -- Cleansed Songflower
	[164884] = "TREASURE_WINDBLOSSOM", -- Cleansed Windblossom
	[174622] = "TREASURE_WHIPPERROOT", -- Cleansed Whipper Root
}


-- This table defines the object name which will be used by the UI
-- to refer to all objects of a specific category
-- The values in this table are translated into locale specific name
-- strings when this file is loaded
CategoryNames = {
	-- Ores
	["ORE_COPPER"] = ORE_COPPER,
	["ORE_TIN"] = ORE_TIN,
	["ORE_SILVER"] = ORE_SILVER,
	["ORE_IRON"] = ORE_IRON,
	["ORE_GOLD"] = ORE_GOLD,
	["ORE_MITHRIL"] = ORE_MITHRIL,
	["ORE_TRUESILVER"] = ORE_TRUESILVER,
	["ORE_THORIUM"] = ORE_THORIUM,
	["ORE_RTHORIUM"] = ORE_RTHORIUM,
	["ORE_DARKIRON"] = ORE_DARKIRON,
	["ORE_OBSIDIAN"] = ORE_OBSIDIAN,
	["ORE_BLOODSTONE"] = ORE_BLOODSTONE,
	["ORE_INDURIUM"] = ORE_INDURIUM,
	["ORE_INCENDICITE"] = ORE_INCENDICITE,
	["ORE_FELIRON"] = ORE_FELIRON,
	["ORE_ADAMANTITE"] = ORE_ADAMANTITE,
	["ORE_RADAMANTITE"] = ORE_RADAMANTITE,
	["ORE_KHORIUM"] = ORE_KHORIUM,
	["ORE_NETHERCITE"] = ORE_NETHERCITE,

	-- Herbs
	["HERB_ARTHASTEAR"] = 142141, -- Arthas' Tears
	["HERB_BLACKLOTUS"] = 176589, -- Black Lotus
	["HERB_BLINDWEED"] = 142143, -- Blindweed
	["HERB_BRIARTHORN"] = 1621, -- Briarthorn
	["HERB_BRUISEWEED"] = 1622, -- Bruiseweed
	["HERB_DREAMFOIL"] = 176584, -- Dreamfoil
	["HERB_EARTHROOT"] = 1619, -- Earthroot
	["HERB_FADELEAF"] = 2042, -- Fadeleaf
	["HERB_FIREBLOOM"] = 2866, -- Firebloom
	["HERB_GHOSTMUSHROOM"] = 142144, -- Ghost Mushroom
	["HERB_GOLDENSANSAM"] = 176583, -- Golden Sansam
	["HERB_GOLDTHORN"] = 2046, -- Goldthorn
	["HERB_GRAVEMOSS"] = 1628, -- Grave Moss
	["HERB_GROMSBLOOD"] = 142145, -- Gromsblood
	["HERB_ICECAP"] = 176588, -- Icecap
	["HERB_KHADGARSWHISKER"] = 2043, -- Khadgar's Whisker
	["HERB_KINGSBLOOD"] = 1624, -- Kingsblood
	["HERB_LIFEROOT"] = 2041, -- Liferoot
	["HERB_MAGEROYAL"] = 1620, -- Mageroyal
	["HERB_MOUNTAINSILVERSAGE"] = 176586, -- Mountain Silversage
	["HERB_PEACEBLOOM"] = 1618, -- Peacebloom
	["HERB_PLAGUEBLOOM"] = 176587, -- Plaguebloom
	["HERB_PURPLELOTUS"] = 142140, -- Purple Lotus
	["HERB_SILVERLEAF"] = 1617, -- Silverleaf
	["HERB_STRANGLEKELP"] = 2045, -- Stranglekelp
	["HERB_SUNGRASS"] = 142142, -- Sungrass
	["HERB_WILDSTEELBLOOM"] = 1623, -- Wild Steelbloom
	["HERB_WINTERSBITE"] = 2044, -- Wintersbite
	["HERB_FELWEED"] = 181270, -- Felweed
	["HERB_DREAMINGGLORY"] = 181271, -- Dreaming Glory
	["HERB_BLOODTHISTLE"] = 181166, -- Bloodthistle
	["HERB_RAGVEIL"] = 181275, -- Ragveil
	["HERB_FLAMECAP"] = 181276, -- Flame Cap
	["HERB_TEROCONE"] = 181277, -- Terocone
	["HERB_ANCIENTLICHEN"] = 181278, -- Ancient Lichen
	["HERB_NETHERBLOOM"] = 181279, -- Netherbloom
	["HERB_NIGHTMAREVINE"] = 181280, -- Nightmare Vine
	["HERB_MANATHISTLE"] = 181281, -- Mana Thistle
	["HERB_NETHERDUST"] = HERB_NETHERDUST,

	-- Treasure
	["TREASURE_BOX"] = TREASURE_BOX,
	["TREASURE_CHEST"] = TREASURE_CHEST,
	["TREASURE_CLAM"] = TREASURE_CLAM,
	["TREASURE_CRATE"] = TREASURE_CRATE,
	["TREASURE_BARREL"] = TREASURE_BARREL,
	["TREASURE_CASK"] = TREASURE_CASK,
	["TREASURE_FOOTLOCKER"] = TREASURE_FOOTLOCKER,
	["TREASURE_UNGOROSOIL"] = TREASURE_UNGOROSOIL,
	["TREASURE_BLOODPETAL"] = TREASURE_BLOODPETAL,
	["TREASURE_POWERCRYST"] = TREASURE_POWERCRYST,
	["TREASURE_BLOODHERO"] = 176213, -- Blood of Heroes
	["TREASURE_SHELLFISHTRAP"] = TREASURE_SHELLFISHTRAP,
	["TREASURE_NIGHTDRAGON"] = TREASURE_NIGHTDRAGON,
	["TREASURE_WHIPPERROOT"] = TREASURE_WHIPPERROOT,
	["TREASURE_WINDBLOSSOM"] = TREASURE_WINDBLOSSOM,
	["TREASURE_SONGFLOWER"] = TREASURE_SONGFLOWER,
	["TREASURE_GLOWCAP"] = TREASURE_GLOWCAP,
	["TREASURE_EGG"] = TREASURE_EGG,
}

for category, id in pairs(CategoryNames) do
	if ( type(id) == "number" ) then
		for name, nodeId in pairs(Gatherer.Nodes.Names) do
			if ( id == nodeId ) then
				CategoryNames[category] = name
				break
			end
		end
	end
end
