-- nearby check yes/no? slowdown may be an isue if someone leaves the mod enabled and always replace node
local GatherMateData = LibStub("AceAddon-3.0"):NewAddon("GatherMate_Data")
local GatherMate = LibStub("AceAddon-3.0"):GetAddon("GatherMate")

local bcZones = {
	[15] = true,
	[18] = true,
	[21] = true,
	[22] = true,
	[40] = true,
	[47] = true,
	[56] = true,
	[58] = true,
	[61] = true,
}

function GatherMateData:PerformMerge(dbs,style, bcOnly)
	if not bcOnly then bcOnly = false end
	if dbs["Mines"]    then self:MergeMines(style ~= "Merge",bcOnly) end
	if dbs["Herbs"]    then self:MergeHerbs(style ~= "Merge",bcOnly) end
	if dbs["Gases"]    then self:MergeGases(style ~= "Merge",bcOnly) end
	if dbs["Fish"]     then self:MergeFish(style ~= "Merge",bcOnly) end
	if dbs["Treasure"] then self:MergeTreasure(style ~= "Merge",bcOnly) end
	self:CleanupImportData()
	GatherMate:SendMessage("GatherMateDataImport")
	--GatherMate:CleanupDB()
end
-- Insert mining data
function GatherMateData:MergeMines(clear,bcOnly)
	if clear then GatherMate:ClearDB("Mining") end
	for zoneID, node_table in pairs(GatherMateDataMineDB) do
		if bcOnly and bcZones[zoneID] or not bcOnly then
			for coord, nodeID in pairs(node_table) do
				GatherMate:InjectNode(zoneID,coord,"Mining", nodeID)
			end
		end
	end
end

-- herbs
function GatherMateData:MergeHerbs(clear,bcOnly)
	if clear then GatherMate:ClearDB("Herb Gathering") end
	for zoneID, node_table in pairs(GatherMateDataHerbDB) do
		if bcOnly and bcZones[zoneID] or not bcOnly then
			for coord, nodeID in pairs(node_table) do
				GatherMate:InjectNode(zoneID,coord,"Herb Gathering", nodeID)
			end
		end
	end
end

-- gases
function GatherMateData:MergeGases(clear,bcOnly)
	if clear then GatherMate:ClearDB("Extract Gas") end
	for zoneID, node_table in pairs(GatherMateDataGasDB) do
		if bcOnly and bcZones[zoneID] or not bcOnly then
			for coord, nodeID in pairs(node_table) do
				GatherMate:InjectNode(zoneID,coord,"Extract Gas", nodeID)
			end
		end
	end
end

-- fish
function GatherMateData:MergeFish(clear,bcOnly)
	if clear then GatherMate:ClearDB("Fishing") end
	for zoneID, node_table in pairs(GatherMateDataFishDB) do
		if bcOnly and bcZones[zoneID] or not bcOnly then
			for coord, nodeID in pairs(node_table) do
				GatherMate:InjectNode(zoneID,coord,"Fishing", nodeID)
			end
		end
	end
end
function GatherMateData:MergeTreasure(clear,bcOnly)
	if clear then GatherMate:ClearDB("Treasure") end
	for zoneID, node_table in pairs(GatherMateDataTreasureDB) do
		if bcOnly and bcZones[zoneID] or not bcOnly then
			for coord, nodeID in pairs(node_table) do
				GatherMate:InjectNode(zoneID,coord,"Treasure", nodeID)
			end
		end
	end
end


function GatherMateData:CleanupImportData()
	GatherMateDataHerbDB = nil
	GatherMateDataMineDB = nil
	GatherMateDataGasDB = nil
	GatherMateDataFishDB = nil
	GatherMateDataTreasureDB = nil
end
