function GankListButton_OnClick()
	GankList_ShowFrame();
end

function GankListButton_Init(event)
	if (event == "VARIABLES_LOADED") then
		if (GankListOptions.ButtonPosition == nil) then GankListOptions.ButtonPosition = 0; end
		GankListButtonFrame:Show();
	end
end

function GankListButton_UpdatePosition()
	GankListButtonFrame:SetPoint(
		"TOPLEFT",
		"Minimap",
		"TOPLEFT",
		54 - (78 * cos(GankListOptions.ButtonPosition)),
		(78 * sin(GankListOptions.ButtonPosition)) - 55
	);
	-- GankListOptions_Init();
end

-- Thanks to Yatlas for this code
function GankListButton_BeingDragged()
    -- Thanks to Gello for this code
    local xpos,ypos = GetCursorPosition() 
    local xmin,ymin = Minimap:GetLeft(), Minimap:GetBottom() 

    xpos = xmin-xpos/UIParent:GetScale()+70 
    ypos = ypos/UIParent:GetScale()-ymin-70 

    GankListButton_SetPosition(math.deg(math.atan2(ypos,xpos)));
end

function GankListButton_SetPosition(v)
    if(v < 0) then
        v = v + 360;
    end

    GankListOptions.ButtonPosition = v;
    GankListButton_UpdatePosition();
end

function GankListButton_OnEnter()
    GameTooltip:SetOwner(this, "ANCHOR_LEFT");
    GameTooltip:AddLine("|cFFFFFFFFGank List");
    GameTooltip:AddLine("Click to Show or Hide your Gank List");
    GameTooltip:Show();
end