GankListVersion = "1.9imp";

UIPanelWindows["GankListFrame"] = { area = "left", pushable = 0, whileDead = 1 };

StaticPopupDialogs["GANKLIST_ADD"] = {
	text = "Enter name of player to add:",
	button1 = TEXT(ACCEPT),
	button2 = TEXT(CANCEL),
	hasEditBox = 1,
	maxLetters = 12,
	OnAccept = function()
		local editBox = getglobal(this:GetParent():GetName().."EditBox");
		GankList_Add(editBox:GetText());
	end,
	OnShow = function()
		getglobal(this:GetName().."EditBox"):SetFocus();
	end,
	OnHide = function()
		if ( ChatFrameEditBox:IsVisible() ) then
			ChatFrameEditBox:SetFocus();
		end
		getglobal(this:GetName().."EditBox"):SetText("");
	end,
	EditBoxOnEnterPressed = function()
		local editBox = getglobal(this:GetParent():GetName().."EditBox");
		GankList_Add(editBox:GetText());
		this:GetParent():Hide();
	end,
	EditBoxOnEscapePressed = function()
		this:GetParent():Hide();
	end,
	timeout = 0,
	exclusive = 1,
	whileDead = 1,
	hideOnEscape = 1
};

StaticPopupDialogs["GANKLIST_KILLED"] = {
  text = "Add %s to your GankList?",
  button1 = "Yes",
  button2 = "No",
  -- sound = "igPlayerInvite",
  OnShow = function()
	GankListTmp.KILLER = GankListTmp.LASTHIT;
  end,
  OnAccept = function()
    GankList_Add(GankListTmp.KILLER);
  end,
  timeout = 0,
  whileDead = 1,
  hideOnEscape = 1
};

GankListTmp = {
	LASTHIT = nil;
}

GankListBattlegrounds = {
	["Alterac Valley"] = true;
	["Arathi Basin"] = true;
	["Warsong Gulch"] = true;
	["Eye of the Storm"] = true;
	["Nagrand Arena"] = true;
	["Blade's Edge Arena"] = true;
	["Blades Edge Arena"] = true;
	["Lordaeron Arena"] = true;
}

function GankList_Print(msg)
	DEFAULT_CHAT_FRAME:AddMessage("|cFF9E9EFF[GankList]|r " .. msg);
end
function GankList_Debug(msg)
	if (GankListOptions.Debug == true) then
		DEFAULT_CHAT_FRAME:AddMessage("|cFFE900E9[GankList]|r " .. msg);
	end
end

function GankList_OnLoad()
	SLASH_GANKLIST1 = "/ganklist";
	SlashCmdList["GANKLIST"] = GankList_ShowFrame;

	this:RegisterEvent("UPDATE_MOUSEOVER_UNIT");
	this:RegisterEvent("VARIABLES_LOADED");
	--this:RegisterEvent("CHAT_MSG_COMBAT_FRIENDLY_DEATH");
	--this:RegisterEvent("CHAT_MSG_COMBAT_HOSTILEPLAYER_HITS");
	--this:RegisterEvent("CHAT_MSG_SPELL_HOSTILEPLAYER_DAMAGE");
	this:RegisterEvent("PLAYER_DEAD");
	this:RegisterEvent("MINIMAP_ZONE_CHANGED");
	this:RegisterEvent("ZONE_CHANGED_NEW_AREA");
	this:RegisterEvent("CHAT_MSG_ADDON");
	
end

function GankList_OnEvent(event)
	if (event == "VARIABLES_LOADED") then
		if (GankList_DB == nil) then
			GankList_Print("Preparing for first use...");
			GankList_DB = {}
			GankList_Print("You Gank List has been initialised");
		else
			GankList_Print("Addon Loaded");
		end
		if(GankListOptions == nil or GankListOptions.Sync == nil) then
			GankListOptions = {
				Sync = true;
				AskOnKill = true;
				Debug = false;
			}
		else
			if(GankListOptions.Sync) then
				GankList_Sync();
			end
		end
		GankListGuildSyncCheckButton:SetChecked(GankListOptions.Sync);
		if(IsAddOnLoaded("TinyTip")) then
			tinyTip = true;
			db = TinyTip_GetDB();
			BGColor = db["BGColor"];
		end
	end
			
	if (event == "MINIMAP_ZONE_CHANGED" or event == "ZONE_CHANGED_NEW_AREA") then
		local askonkill = GankListOptions.AskOnKill;
		local zone = GetRealZoneText();
		GankList_Debug("Zone changed, checking to see if player entered BG?");
		if (GankListBattlegrounds[zone]) then
			GankList_Debug(zone .. " = BG Zone");
			GankListOptions.AskOnKill = false;
		else
			GankList_Debug(zone .. " fs != BG Zone");
			GankListOptions.AskOnKill = true;
		end
		if (askonkill ~= GankListOptions.AskOnKill) then
			if (GankListOptions.AskOnKill == true) then
				GankList_Print("Normal Mode");
			else
				GankList_Print("Battlegrounds Mode");
			end
		end
	end
	
	if (event == "UPDATE_MOUSEOVER_UNIT") then
		if(tinyTip) then 
			db["BGColor"] = BGColor;
		end
		if ((UnitIsPlayer("mouseover")) and (UnitIsEnemy("mouseover", "player"))) then
			onList = "no";
			local player = UnitName("mouseover");
			if (GankList_DB[player] and not(GankList_DB[player]["OnList"] == 0)) then
				if(tinyTip) then
					db["BGColor"] = 1;
				end
				if (GankList_DB[player]["OnList"] == 1) then
					GankList_ColorBG(1, 0, 0);
				else 
					if (GankList_DB[player]["OnList"] >= 2) then
						GankList_ColorBG(1, 0.5, 0.5);
					end
				end
			end
		end
	end
	
	if (event == "PLAYER_DEAD") then
		GankList_Debug(UnitName("player") .. " died");
		searchLog = true;
		i = 0;
		if(CombatLogGetNumEntries() > 0 and GankListOptions.AskOnKill == true) then
			while(searchLog and CombatLogGetNumEntries() + i > 0) do
				i = i - 1;
				CombatLogSetCurrentEntry(i);
				timestamp, event, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags = CombatLogGetCurrentEntry();
				if(not(dstGUID == nil) and not(srcFlags == nil) and (srcFlags == 0x0548 or srcFlags == 0x10548 or srcFlags == 0x20548) and dstGUID == UnitGUID("player")) then
					GankListTmp.LASTHIT = srcName;
					if(not(string.find(event, "DAMAGE") == nil) or not(string.find(event, "DRAIN") == nil) or not(string.find(event, "LEECH") == nil)) then
						local name = (GankListTmp.LASTHIT);
						if (not GankList_DB[name]) then
							StaticPopup_Show("GANKLIST_KILLED", GankListTmp.LASTHIT);
						else
							if (GankList_DB[name]["OnList"] >= 2) then
								StaticPopup_Show("GANKLIST_KILLED", GankListTmp.LASTHIT);
							end
						end
					end
					searchLog = false;
				end
			end
		end
	end
	
--	if (event == "CHAT_MSG_COMBAT_FRIENDLY_DEATH") then
--		if (arg1 == "You die.") then
--			GankList_Debug(UnitName("player") .. " died");
--			if (GankListTmp.LASTHIT) then
--				local name = (GankListTmp.LASTHIT);
--				if (GankListOptions.AskOnKill == true) then
--					if (not GankList_DB[name]) then
--						StaticPopup_Show("GANKLIST_KILLED", GankListTmp.LASTHIT);
--					else
--						if (GankList_DB[name]["OnList"] >= 2) then
--							StaticPopup_Show("GANKLIST_KILLED", GankListTmp.LASTHIT);
--						end
--					end
--				end
--			end
--		end
--	end
--	if (event == "CHAT_MSG_SPELL_HOSTILEPLAYER_DAMAGE") then
--		tmpstart, tmpend, name, spell, attacktype, dmg = string.find(arg1, "(.+)'s (.+) (.+) you for (.+).");
--		if (dmg) then GankListTmp.LASTHIT = name; end
--	end
--	if (event == "CHAT_MSG_COMBAT_HOSTILEPLAYER_HITS") then
--		tmpstart, tmpend, name, attacktype, dmg = string.find(arg1, "(.+) (.+) you for (.+)%.");
--		if (dmg) then GankListTmp.LASTHIT = name; end
--	end
	if (event == "CHAT_MSG_ADDON") then
		if(GankListOptions.Sync) then
			local playerName = UnitName("player");
			if (arg1 == "GankListGuild" and not(arg4 == playerName)) then
				GankList_GankerRec(arg2);
			end
			if (arg1 == "GankListGuildSync" and not(arg4 == playerName)) then
				GankList_AddSync(arg2, arg4);
			end
		end
	end
end

function GankList_ColorBG(bdR,bdG,bdB)
	GameTooltipTextLeft1:SetTextColor(1, 0.5, 0.5);
	GameTooltip:SetBackdropColor(bdR,bdG,bdB);
	GameTooltip:Show()
end

function GankList_ShowFrame()
    if (GankListFrame:IsVisible()) then
		HideUIPanel(GankListFrame);
	else
		ShowUIPanel(GankListFrame);
	end
end

function GankList_AddSync(gname, name)
	if((not GankList_DB[gname])) then
		if (GankList_DB[gname] == nil) then GankList_DB[gname] = {} end
		GankList_DB[gname]["OnList"] = 2;
		GankList_Print(gname .. " Added to GankList, Received from: " .. name);
	end
end

function GankList_Sync()
	for gname, name in pairs (GankList_DB) do
		if(GankList_DB[gname]["OnList"] > 0) then
			GankList_GuildSend("GankListGuildSync", gname);
		end
	end
end

function GankList_GuildSend(tag, msg)
	if(IsInGuild()) then
		SendAddonMessage(tag, msg, "GUILD" );
	end
end

function GankList_ApplySettings()
	if(GankListGuildSyncCheckButton:GetChecked()==1)then
		GankListOptions.Sync = true;
	else
		GankListOptions.Sync = false;
	end
end

function GankList_Add(msg)
	local a,b,c=strfind(msg, "(%S+)"); --contiguous string of non-space characters
	local basename = string.sub(c, a, b);
	local name = string.upper(string.sub(basename, 0, 1))
	name = name .. string.lower(string.sub(basename, 2))
	
	local numChar = string.len(name);
	if(string.find(name, "'s", numChar-2)) then
		name = string.sub(name, 1 , numChar-2);
	end
	
	if(GankList_DB[name]) then
		if(GankList_DB[name]["OnList"] >= 2) then
				GankList_DB[name]["OnList"] = 1;
				GankList_GuildSend("GankListGuild", name);
		else 
			if(GankList_DB[name]["OnList"] == 0)then
				GankList_DB[name]["OnList"] = 1;
			end
		end
		GankList_Print(name .. " added to your Gank List");
	else
		if (GankList_DB[name] == nil) then
			GankList_DB[name] = {};
		end
		GankList_DB[name]["OnList"] = 1;
		GankList_Print(name .. " added to your Gank List");
		GankList_GuildSend("GankListGuild", name);
	end

	if (GankListFrame:IsVisible()) then
		GankList_Update();
	end
end

function GankList_GankerRec(name)
	if(GankList_DB[name] and GankList_DB[name]["OnList"] >= 2) then
		GankList_DB[name]["OnList"] = GankList_DB[name]["OnList"] + 1;	
	else
		if((not GankList_DB[name])) then		
			GankList_DB[name] = {}
			GankList_DB[name]["OnList"] = 2;
		end
	end
	GankList_Print(arg2 .. " Added to GankList, Received from: " .. arg4);
	if (GankListFrame:IsVisible()) then
		GankList_Update();
	end
end

function GankList_Remove()
	local nameOffset = FauxScrollFrame_GetOffset(GankListNameScrollFrame);
	local nameIndex = GankListFrame.selectedName - nameOffset;
	local nameButton = getglobal("GankListNameButton".. nameIndex .."ButtonTextName");
	local name = nameButton:GetText();
	--GankList_DB[name] = nil;
	local startpos = string.find(name, "]")
	if(startpos) then
		name = string.sub(name, startpos+2);
		GankList_DB[name]["OnList"] = 0;
	else
		GankList_DB[name]["OnList"] = 0;
	end
	GankList_Print(name .. " removed from your Gank List");

	if (GankListFrame:IsVisible()) then
		GankList_Update();
	end
end

function GankList_Update()
	local names = {}
      local i = 0;
	for index, value in pairs (GankList_DB) do
		if (GankList_DB[index]["OnList"] == 1) then
			table.insert(names, index)
			i = i + 1;
		else 
			if (GankList_DB[index]["OnList"] >= 2) then	
				table.insert(names, "|cff888888" .. "[" .. GankList_DB[index]["OnList"] - 1 .. "] " .. index)
				i = i + 1;
			end
		end
	end

	table.sort(names);

	local numNames = i;
	local nameText;
	local name;
	local nameButton;
	if ( numNames > 0 ) then
		if (GankListFrame.selectedName == 0) then
			GankListFrame.selectedName = 1;
		end
		GankListRemovePlayerButton:Enable();
	else
		GankListRemovePlayerButton:Disable();
	end
	
	local currentMode = nil;
	if (GankListOptions.AskOnKill == true) then
		currentMode = "Normal";
	else
		currentMode = "Battlegrounds";
	end
	GankListTopText1:SetText(GetRealmName());
	GankListTopText2:SetText("There are " .. numNames .. " names on your Gank List");
	GankListTopText3:SetText("[" .. currentMode .. " Mode]");
	
	local nameOffset = FauxScrollFrame_GetOffset(GankListNameScrollFrame);
	local nameIndex;
	for i=1, 20, 1 do
		nameIndex = i + nameOffset;
		nameText = getglobal("GankListNameButton"..i.."ButtonTextName");
		nameText:SetText(names[nameIndex]);
		nameButton = getglobal("GankListNameButton"..i);
		nameButton:SetID(nameIndex);
		-- Update the highlight
		if ( nameIndex == GankListFrame.selectedName ) then
			nameButton:LockHighlight();
		else
			nameButton:UnlockHighlight();
		end
		
		if ( nameIndex > numNames ) then
			nameButton:Hide();
		else
			nameButton:Show();
		end
	end
	
	-- ScrollFrame stuff
	FauxScrollFrame_Update(GankListNameScrollFrame, numNames, 20, 16 );
	
	--Sync stuff
	GankList_ApplySettings();
	GankListGuildSyncCheckButton.tooltipText = "Check to sync with guild mates";
	GankListSyncText1:SetText("Sync");
	GankListGuildSyncCheckButton:SetChecked(GankListOptions.Sync);
end

function GankListNameButton_OnClick(button)
	if( IsShiftKeyDown() and ChatFrameEditBox:IsVisible() ) then
		local ButtonTextName = getglobal(this:GetName() .. "ButtonTextName");
		local name = ButtonTextName:GetText();
		local text = ChatFrameEditBox:GetText();
		ChatFrameEditBox:SetText(text .. name);
	end
	GankListFrame.selectedName = this:GetID();
	GankList_Update();
end