local options = { 
  type='group',
  args = {
    list = {
      type = 'execute',
      name = 'List',
      desc = "List all available Gag slash commands",
      func = "ListEmotes",
    },
    enable = {
      type = 'execute',
      name = 'Enable',
      desc = "Enables Gag emotes and sounds for your own character",
      func = "Enable",
    },
    disable = {
      type = 'execute',
      name = 'Disable',
      desc = "Disables Gag emotes and sounds for your own character",
      func = "Disable",
    },
    groupenable = {
      type = 'execute',
      name = 'Group Enable',
      desc = "Enables Gag emotes for the entire group if you are a party, raid, or battleground leader",
      func = "GroupEnable",
    },
    groupdisable = {
      type = 'execute',
      name = 'Group Disable',
      desc = "Disables Gag emotes for the entire group if you are a party, raid, or battleground leader.  Older versions of Gag do not obey this command.",
      func = "GroupDisable",
    },
    ping = {
      type = 'execute',
      name = 'Ping',
      desc = "Pings your group to see who has Gag installed.  Older versions of Gag will not be seen.",
      func = "Ping",
    },
  },
}


Gag = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0","AceComm-2.0", "FuBarPlugin-2.0")
Gag:RegisterChatCommand("/gag",options);

Gag.cannotDetachTooltip = true
local Dewdrop = AceLibrary("Dewdrop-2.0")

Gag.LastEmoteTime = time();
gag_data_sorted_keys = {};
Gag.GroupEnabled = true;
Gag.IsEnabled = true;
Gag:SetCommPrefix("Gag");

function Gag:OnInitialize()
  --Hook all chat frames
  for i=1, NUM_CHAT_WINDOWS do
    local cf = getglobal("ChatFrame"..i);
    cf.gag_Orig_AddMessage = cf.AddMessage;
    cf.AddMessage=gag_ChatFrame_AddMessage;
  end
end

function gag_ChatFrame_AddMessage(self, msg, ...)
  for key,value in pairs(gag_data) do
      if(string.find(msg,gag_data[key]["text"])) then return; end
  end

  return self:gag_Orig_AddMessage(msg, ...)
end

function Gag:OnEnable()

  self.IsEnabled = true;
  

  --Generate slash commands from gag_data
  if gag_data then
    for key,value in pairs(gag_data) do
      _G.SlashCmdList["GAG_"..key]=loadstring("Gag:SayGagKey(\""..key.."\");");
      _G["SLASH_GAG_"..key.."1"] = "/"..key;
    end
  end


  --Fill the array
  local i=0;
  for key,value in pairs(gag_data) do
    gag_data_sorted_keys[i]=key;
    i=i+1;
  end

  --Sort the array
  table.sort(gag_data_sorted_keys);

  --Receive messages sent by other players
  self:RegisterComm(self.commPrefix, "WHISPER")
  self:RegisterComm(self.commPrefix, "GROUP")

  --Register Events
  self:RegisterEvent("CHAT_MSG_SAY");
  self:RegisterEvent("PARTY_MEMBERS_CHANGED");
end

function Gag:OnDisable()
  self.IsEnabled=false;
end

function Gag:Enable()
  self:Print("Enabled");
  self.IsEnabled = true;
end

function Gag:Disable()
  self:Print("Disabled");
  self.IsEnabled = false;
end

function Gag:GroupEnable()
  if(IsPartyLeader() or IsRaidLeader() or IsRaidOfficer()) then
    self:SendMessage("GroupEnable");
    self.GroupEnabled = true;
    self:Print("Enabled for the entire group");
  else
    self:Print("You are not a group leader");
  end
end

function Gag:GroupDisable()
  if(IsPartyLeader() or IsRaidLeader() or IsRaidOfficer()) then
    self:SendMessage("GroupDisable");
    self.GroupEnabled = false;
    self:Print("Disabled for the entire group");
  else
    self:Print("You are not a group leader");
  end
end

function Gag:Ping()
  local s = self:SendMessage("PingSend");
  if(s) then
    self:Print("Players in your group with Gag installed:");
  end
  if(not s) then
    self:Print("Ping failed");
  end
end

function Gag:CHAT_MSG_SAY(var1)
  for key,value in pairs(gag_data) do
    if(string.find(var1,gag_data[key]["text"])) then Gag:DoEmote(key); end
  end
end

function Gag:PARTY_MEMBERS_CHANGED()
  local ge = self.GroupEnabled;
  self.GroupEnabled = true;
  if(IsPartyLeader() or IsRaidLeader() or IsRaidOfficer()) then
    if(ge) then
      self:SendMessage("GroupEnable");
    else
      self:SendMessage("GroupDisable");
    end
  end
end

function Gag:ListEmotes()
  DEFAULT_CHAT_FRAME:AddMessage("List of emotes:");
  local arrayOfEmotes={}; -- An array of strings; each string is one of the commands
  local i=1;              -- counter varaibles
  local k=1;

  --Fill the array
  for key,value in pairs(gag_data) do
    arrayOfEmotes[i]=key;
    i=i+1;
  end

  --Sort the array
  table.sort(arrayOfEmotes);

  --Output the array
  local line="";
  i=1;
  for key,value in pairs(arrayOfEmotes) do
    line=line..arrayOfEmotes[key].." ";
    if(i==6) then
      DEFAULT_CHAT_FRAME:AddMessage(line);
      i=0;
      line="";
    end
    i=i+1;
  end
end

function Gag:SayGagKey(key)
  if(self.IsEnabled) then
    if(self.GroupEnabled) then
      if(time() - Gag.LastEmoteTime>1) then
        local emote = gag_data[key];
        if (emote["text"]~=nil) then SendChatMessage(emote["text"], "SAY"); end
        if (emote["msg"]~=nil) then SendChatMessage(emote["msg"], "EMOTE"); end
      else
        self:Print("Emote blocked to prevent spam");
      end
    else
      self:Print("Disabled by your group leader");
    end
  else
    self:Print("Disabled.  Type \"/gag enable\" to enable this mod.");
  end
end

function Gag:DoEmote(key)
  if(self.IsEnabled) then
    if(self.GroupEnabled) then
      if(time() - Gag.LastEmoteTime>1) then
        local emote = gag_data[key]
        if (emote["emote"]~=nil) then DoEmote(emote["emote"]); end
        if (emote["file"]~=nil) then
          PlaySoundFile(emote["file"]);
        end
        Gag.LastEmoteTime = time();
      end
    else
      self:Print("Disabled by your group leader");
    end
  end
end

function Gag:SendMessage(arg1, ...)
  local groupSuccess = self:SendCommMessage("GROUP", arg1, ...);
  local whisperSuccess = self:SendCommMessage("WHISPER", UnitName("player"), arg1, ...);
  return (groupSuccess and whisperSuccess);
end

function Gag:OnCommReceive(prefix, sender, distribution, message, message2, message3)
  --DEFAULT_CHAT_FRAME:AddMessage("comm received!");
  --DEFAULT_CHAT_FRAME:AddMessage(sender.." sent "..message);
  if(string.find("GroupEnable",message)) then
    self.GroupEnabled = true;
  end
  if(string.find("GroupDisable",message)) then
    self.GroupEnabled = false;
  end
  if(string.find("PingSend",message)) then
    self:SendMessage("PingReply",sender)
  end
  if(string.find("PingReply",message) and message2==UnitName("player")) then
    self:Print(sender);
  end
end

function Gag:OnMenuRequest(level,value)
  if gag_data then
    local text="";
    local emote;
    if(level==1) then
      Dewdrop:AddLine('text', "Alpha", 'value', "Alpha", 'hasArrow', true)
      Dewdrop:AddLine('text', "");

      local i=1;
      local categories = {};
      categories[0]="Etc";
      for key, _ in pairs(gag_data) do
        emote=gag_data[key];
        if(emote["category"]~=nil) then c=emote["category"]; else c="Etc"; end
        local alreadyInCategories = false;
        for _, v in pairs(categories) do
          if(c==v) then alreadyInCategories = true; end
        end
        if(not alreadyInCategories) then
          categories[i]=c;
          i=i+1;
        end
      end

      for _, value in pairs(categories) do
        Dewdrop:AddLine('text', value, 'value', value, 'hasArrow', true);
      end

      Dewdrop:AddLine('text', "");

      Dewdrop:AddLine("text", "Enable", "func", function() Gag:Enable(key) end)
      Dewdrop:AddLine("text", "Disable", "func", function() Gag:Disable(key) end)
      Dewdrop:AddLine("text", "GroupEnable", "func", function() Gag:GroupEnable(key) end)
      Dewdrop:AddLine("text", "DroupDisable", "func", function() Gag:GroupDisable(key) end)

      Dewdrop:AddLine('text', "");
    end

    if(level==2) then
      if(value=="Alpha") then
        for i=65,90 do
          local c=string.char(i);
          Dewdrop:AddLine('text', c, 'value', c, 'hasArrow', true)
        end
      else
        --build the "subcategories" table
        local i=0;
        local subcategories = {};
        for k, v in pairs(gag_data) do
          emote=gag_data[k];
          if(emote["category"]==value and emote["subcategory"]~=nil) then
            local alreadyInSubcategories=false;
            for k2, v2 in pairs(subcategories) do
              if(v2==emote["subcategory"]) then alreadyInSubcategories = true; end
            end
            if(alreadyInSubcategories==false) then 
              subcategories[i]=emote["subcategory"];
              i=i+1;
            end
          end	
        end
        --output the subcategories table
        for k, v in pairs(subcategories) do
          Dewdrop:AddLine('text', v, 'value', v, 'hasArrow', true);
        end
        for _, v in pairs(gag_data_sorted_keys) do
          local key=gag_data_sorted_keys[_];
          emote=gag_data[key];
          if(emote["subcategory"]==nil) then
            local c;
            if(emote["category"]~=nil) then c=emote["category"]; else c="Etc"; end
            if(c==value) then
              text = "/"..key.." - |cFF999999"..emote["text"].."|r";
              Dewdrop:AddLine(
                "text", text,
                "func", function() Gag:SayGagKey(key) end
              )
            end
          end
        end
      end
    end

    if(level==3) then
      if(string.len(value)==1) then
        for _, v in pairs(gag_data_sorted_keys) do
          local key=gag_data_sorted_keys[_];
          emote=gag_data[key];
        
          if(string.sub(key,1,1)==string.lower(value)) then
            text = "/"..key.." - |cFF999999"..emote["text"].."|r";
            Dewdrop:AddLine(
              "text", text,
              "func", function() Gag:SayGagKey(key) end
            )
          end
        end
      else
        for k, v in pairs(gag_data_sorted_keys) do
          local key=gag_data_sorted_keys[k];
          emote=gag_data[key];
          if(emote["subcategory"]==value) then
            text = "/"..key.." - |cFF999999"..emote["text"].."|r";
            Dewdrop:AddLine(
              "text", text,
              "func", function() Gag:SayGagKey(key) end
            )
          end
        end
      end
    end
  end
end