

--| Lib import |--
local gp = LibStub('LibGuildPositions-1.0')


--| Roster |--
local guildroster = {}  -- Keep a roster of all guild members and their basic data.
local buttonroster = {}  -- Keep name->button dict.


--| Global access |--
GPS = { buttonroster = buttonroster }


--| Cache |--
local WorldMapTooltip = WorldMapTooltip  -- Local acces = fast. 
local MouseIsOver = MouseIsOver
local _G = _G
local UnitName = UnitName
local ipairs = ipairs
local CreateFrame = CreateFrame
local WorldMapButton = WorldMapButton
local RAID_CLASS_COLORS = RAID_CLASS_COLORS
local GetTime = GetTime
local GetMapInfo = GetMapInfo
local format = string.format
local pairs = pairs
local GetNumGuildMembers = GetNumGuildMembers
local GetGuildRosterInfo = GetGuildRosterInfo
local upper = string.upper
local gsub = string.gsub
local WorldMapPlayer = WorldMapPlayer
local WorldMapTooltipTextRight5 = WorldMapTooltipTextRight5


--| Locals |--
local bin = {}  -- Recycling bin for unused buttons. Being green is fun.
local white = { r = 1, g = 1, b = 1 }  -- Will we ever not be able to get guild info? In case, keep default 'white'.


--| Frame funcs |--
local over = {}
local OnEnter = function(self)  -- Seems big for an OnEnter function. Whatever.
	if self:GetCenter() > WorldMapButton:GetCenter() then  -- Should the tooltip be on the left or right? 
		WorldMapTooltip:SetOwner(self,'ANCHOR_LEFT')
	else
		WorldMapTooltip:SetOwner(self,'ANCHOR_RIGHT')
	end
	
	for k in ipairs(over) do  -- Use an upvalue table that's cleared to avoid garbage waste.
		over[k] = nil
	end
	
	-- Run through all the WorldMap blips to see if any are underneath 'self'. If so, we'll display multiple names in the tooltip. 
	if WorldMapPlayer:IsVisible() and MouseIsOver(WorldMapPlayer) then
		local color = RAID_CLASS_COLORS[upper(gsub(UnitClass('player'),' ',''))]
		over[#over+1] = format('Player: |cff%02x%02x%02x%s|r',color.r*255,color.g*255,color.b*255,UnitName('player'))
	end
	for name,btn in pairs(buttonroster) do  -- Guild.
		if btn ~= self and btn:IsVisible() and MouseIsOver(btn) then
			local color = btn.color
			over[#over+1] = format('|cff3fff3fGuild|r: |cff%02x%02x%02x%s|r',color.r*255,color.g*255,color.b*255,name)
		end
	end
	for i = 1,4 do  -- Party.
		local btn = _G['WorldMapParty'..i]
		if btn:IsVisible() and MouseIsOver(btn) then
			local color = RAID_CLASS_COLORS[upper(gsub(UnitClass(btn.unit),' ',''))]
			over[#over+1] = format('|cffaaaaffParty|r: |cff%02x%02x%02x%s|r',color.r*255,color.g*255,color.b*255,UnitName(btn.unit))
		end
	end
	for i = 1,40 do  -- Raid.
		local btn = _G['WorldMapRaid'..i]
		if btn:IsVisible() and MouseIsOver(btn) then
			local color = RAID_CLASS_COLORS[upper(gsub(UnitClass(btn.unit),' ',''))]
			over[#over+1] = format('|cffff7f00Raid|r: |cff%02x%02x%02x%s|r',color.r*255,color.g*255,color.b*255,UnitName(btn.unit))
		end
	end
	
	if #over > 0 then  -- We have more than one unit to display.
		local color = self.color
		WorldMapTooltip:AddLine(format('|cff3fff3fGuild|r: |cff%02x%02x%02x%s|r',color.r*255,color.g*255,color.b*255,self.name))  -- First add 'self'.
		for _,name in ipairs(over) do
			WorldMapTooltip:AddLine(name,1,1,1)  -- Then add the others. 
		end
	else  -- Just 'self'.
		local color = self.color
		WorldMapTooltip:AddLine(self.name,color.r or 1,color.g or 1,color.b or 1)
		local info = self.info
		WorldMapTooltip:AddDoubleLine('Class:',info.class,1,1,1,1,1,1)
		WorldMapTooltip:AddDoubleLine('Level:',info.level,1,1,1,1,1,1)
		WorldMapTooltip:AddDoubleLine('Rank:',format('%s (%d)',info.rank,info.rankI),1,1,1,1,1,1)
		WorldMapTooltip:AddDoubleLine('Position:',format('%.1f, %.1f',self.x,self.y),1,1,1,1,1,1)
	end
	WorldMapTooltip:Show()
end
local OnLeave = function(self)
	WorldMapTooltip:Hide()
end


--| Updating |--
local width,height = WorldMapButton:GetWidth(),WorldMapButton:GetHeight()

local function update()
	local now = GetTime()  -- We store the time of the last update on a button, so we can tell when we need to remove them.
	local zone = GetMapInfo()
	for name,x,y,z in gp:IterateGuildMembers() do
		if z == zone then  -- Only show players from current zone.
			local btn = buttonroster[name]
			if not btn then
				btn = bin[#bin]  -- Fetch an unused button.
				if btn then
					bin[#bin] = nil
				else
					btn = CreateFrame('Frame',nil,WorldMapButton)  -- Create a new one if the bin's empty.
					btn:SetHeight(16)
					btn:SetWidth(16)
					btn:EnableMouse(true)
					btn:SetFrameLevel(btn:GetFrameLevel()+1)
					local texture = btn:CreateTexture(nil,'OVERLAY')
					texture:SetTexture('Interface\\AddOns\\GPS\\btn.tga')
					texture:SetAllPoints()
					btn.texture = texture
					btn:SetScript('OnEnter',OnEnter)
					btn:SetScript('OnLeave',OnLeave)
				end
				btn.name = name
				btn.info = guildroster[name]
				local color = RAID_CLASS_COLORS[upper(gsub(guildroster[name].class,' ',''))] or white
				btn.color = color
				btn.texture:SetVertexColor(color.r,color.g,color.b,1)
				btn:Show()
				buttonroster[name] = btn
			end
			btn:ClearAllPoints()
			btn:SetPoint('TOPLEFT',width*x,-(height*y))
			btn.x,btn.y = x*100,y*100
			btn.lastupdate = now
		end
	end
	for name,btn in pairs(buttonroster) do
		if btn.lastupdate ~= now then
			btn.name = nil
			btn.info = nil
			btn.texture:SetVertexColor(1,1,1,1)
			btn:ClearAllPoints()
			btn:Hide()
			bin[#bin+1] = btn
			buttonroster[name] = nil
		end
	end
	-- Update the tooltip incase it's already anchored.
	local self = WorldMapTooltip:GetOwner()
	if self and self.info and self.color and self.x and self.y then  -- We have our button.
		local cur = WorldMapTooltipTextRight5:IsShown() and WorldMapTooltipTextRight5:GetText()
		if cur and match(cur,'^%d+%.%d+, %d+%.%d+$') then
			WorldMapTooltipTextRight5:SetText(format('%.1f, %.1f',self.x,self.y),1,1,1)
		end
	end
end


--| Events |--
local e = CreateFrame('Frame')

e:RegisterEvent('GUILD_ROSTER_UPDATE')
e:RegisterEvent('PLAYER_ENTERING_WORLD')
e:RegisterEvent('ZONE_CHANGED')
e:RegisterEvent('ZONE_CHANGED_NEW_AREA')
e:RegisterEvent('WORLD_MAP_UPDATE')

e:SetScript('OnEvent',function(self,event)
	if event == 'GUILD_ROSTER_UPDATE' then
		if not IsInGuild() then return end
		for k in pairs(guildroster) do
			guildroster[k] = nil  -- Yeah, it *is* wasteful. But this isn't called often enough for me to care. A proper recycling system would cost more. 
		end
		for i = 1,GetNumGuildMembers(true) do
			local name,rank,rankI,level,class = GetGuildRosterInfo(i)
			guildroster[name] = { class = class, level = level, rank = rank, rankI = rankI }
		end
	elseif event == 'PLAYER_ENTERING_WORLD' then
		if IsInGuild() then GuildRoster() end
	end
	update()  -- Done every event. 
end)

local t = 0
e:SetScript('OnUpdate',function(self,elapsed)
	t = t + elapsed
	if t >= 1 then
		update()  -- Done every 1 sec.
		t = 0
	end
end)
