GL_Data = {};
GL_DataInitialized=false;

function GL_DataInitialize()
	if GL_Data == nil then
		GL_Data={};
	end				
	if GL_Data.Info == nil then      GL_Data.Info = {};	end
	if GL_Data.NextTicket==nil then  GL_Data.NextTicket=0; end
	if GL_Data.StartGold==nil then   GL_Data.StartGold=0;	end
	if GL_Data.TicketSerie==nil then GL_Data.TicketSerie=1000;	end
	if GL_Data.MaxTickets==nil then  GL_Data.MaxTickets=20;	end
	if GL_Data.TicketPrice==nil then GL_Data.TicketPrice=10000;	end
	if GL_Data.LotteryDate==nil then GL_Data.LotteryDate=0;	end
	if GL_Data.SecondPrize==nil then GL_Data.SecondPrize=20; end
	GL_DataInitialized=true;
end

function GL_DataClear()
	if GL_DataCount()>0 then
		GL_Data.TicketSerie=GL_Data.TicketSerie+1000;
		if GL_Data.TicketSerie>9000 then 
			GL_Data.TicketSerie=1000;		
		end
	end
--	GL_Data.StartGold=0;
	GL_Data.NextTicket=GL_Data.TicketSerie;
	local i,amount;
	amount=GL_DataCount();
	for i=1,amount,1 do
		GL_DataRemove(1);
	end
end

function GL_DataValid( idx )
	if GL_DataInitialized==false then
		GL_DataInitialize();
	end
	if GL_Data and GL_Data.Info then
		if idx==nil then
			return true;
		else
			if GL_Data.Info[idx] then
				return true;
			end
		end 
	end
	return false;
end

function GL_DataGetUserIdx ( user )
	local i;
	for i=1, GL_DataCount(), 1 do
		if GL_Data.Info[i].User == user then
			return i;
		end
	end
	return 0;
end

function GL_DataGetTicketIdx ( ticketnumber )
	local i,j;
	for i=1, GL_DataCount(), 1 do
		local Tickets=GL_DataGetTickets(i);
		for j=1, GL_DataGetTicketCount(i), 1 do
			if Tickets[j]==ticketnumber then
				return i;
			end
		end
	end
	return 0;
end


function GL_DataGetUser( idx )
	if GL_DataValid(idx) then
		return GL_Data.Info[idx].User;
	end
	return "";
end

function GL_DataSetUser(idx, value)
	if GL_DataValid(idx) then
		GL_Data.Info[idx].User = value;
	end
end

function GL_DataGetTickets( idx )
	if GL_DataValid(idx) then
		return GL_Data.Info[idx].Tickets;
	end
	return nil;
end

function GL_DataGetTicketCount( idx )
	if GL_DataValid(idx) then
		return table.getn(GL_Data.Info[idx].Tickets);
	end
	return 0;
end

function GL_DataGetTotalTicketCount()
	local i,count;
	count=0;
	for i=1, GL_DataCount(), 1 do
		count=count+GL_DataGetTicketCount(i);
	end
	return count;
end

function GL_DataSetTickets( idx, value )
	if GL_DataValid(idx) then
		GL_Data.Info[idx].Tickets = value;
	end
end

function GL_DataAddTickets( idx, value )
	if GL_DataValid(idx) then
		local i=0;
		for i=1, table.getn(value), 1 do
			table.insert(GL_Data.Info[idx].Tickets,value[i]);
		end
	end
end

function GL_DataCount()
	if GL_DataValid() then
		return table.getn(GL_Data.Info);
	end
	return 0;
end

function GL_DataInsert( idx, info )
	if GL_DataValid() then
		if idx>=GL_DataCount()+1 then
			table.insert(GL_Data.Info, info);
		else
			table.insert(GL_Data.Info, idx, info);
		end
	end
end


function GL_DataRemove( idx )
	local i;
	if GL_DataValid(idx) then
		table.remove(GL_Data.Info, idx);
	end
end

