--  GLottery - By Voogue

--[[
 Schedule code - Taken from Chronos By Alexander Brazie
]]

-- GLSystem Data 
GLSystem_Data = {
	-- Initialize the startup time
	elaspedTime = 0;

	-- Last ID
	lastID = nil;
	
	-- Initialize the Timers
	timers = {};

	-- Intialize the anonymous todo list
	anonTodo = {};
};

function GLSystem_OnLoad()
  GLSystem_Data.elapsedTime = 0;
end

function GLSystem_startTimer(id)
  if ( not id ) then 
    id = this:GetName();
  end

  -- Create a table for this id's timers
  if ( not GLSystem_Data.timers[id] ) then
    GLSystem_Data.timers[id] = {};
  end

  -- Clear out an entry if the table is too big.
  if ( #GLSystem_Data.timers[id] >= 100) then
    tremove(GLSystem_Data.timers[id], 1 );
  end

  -- Add a new timer entry 
  tinsert(GLSystem_Data.timers[id], GetTime() );		
end

function GLSystem_endTimer(id) 
  if ( not id ) then 
    id = this:GetName();
  end
  
  -- Create a table for this id's timers
  if ( not GLSystem_Data.timers[id] ) then
    GLSystem_Data.timers[id] = {};
  end
  
  -- Check to see if there is any timers started
  if ( #GLSystem_Data.timers[id] == 0 ) then
    return 0, GetTime(), GetTime();
  end
  
  -- Grab the last timer called
  local startTime = tremove ( GLSystem_Data.timers[id] );
  local now = GetTime();
  
  return (now - startTime), startTime, now;
end


function GLSystem_OnUpdate(dt)
  if ( GLSystem_Data.elapsedTime ) then
    GLSystem_Data.elapsedTime = GLSystem_Data.elapsedTime + dt;
  else
    GLSystem_Data.elapsedTime = dt;
  end

  local timeThisUpdate = 0;
  local largest = 0;
  local largestName = nil;
  
  if ( not GLSystem_Data.anonTodo ) then 
    GLSystem_Data.anonTodo = {};
  end

  -- Handle Anonymous Scheduled Tasks
  for k,v in pairs(GLSystem_Data.anonTodo) do 
    GLSystem_Data.lastID = k;
    -- Call all handlers whose time has been exceeded
    while(v[1] and v[1].time <= GetTime()) do
      -- Lets start the timer
      GLSystem_startTimer();
    
      local todo = tremove(v,1);
      if(todo.args) then
        if ( todo.handler ) then 
          todo.handler(unpack(todo.args));
        end
      else
        if ( todo.handler ) then 
          todo.handler();
        end
      end
      -- End the timer
      local runTime = GLSystem_endTimer();
    
      -- Update the elapsed time
      timeThisUpdate = timeThisUpdate + runTime;
    
      -- Check if this was the biggest hog yet
      if ( runTime > largest ) then 
        largest = runTime;
        largestName = k;
      end
    
      -- Check if we've overrun our limit
      if ( timeThisUpdate > .3 ) then
        break;
      end
    end	
  
    -- Clean out the table
    if ( #v == 0 ) then 
      GLSystem_Data.anonTodo[k] = nil;
    end
  end
end

function GLSystem_PackArgs(...)
  local tab = {};
  local v;
  for i=1,select("#",...) do v = select(i,...); tinsert(tab,v); end
  return tab;
end

function GLSystem_Schedule(when,handler,...)
  -- Assign an id
  local id = "";
  if ( not this ) then 
    id = "Keybinding";
  else
    id = this:GetName();
  end
  if ( not id ) then 
    id = "_DEFAULT";
  end
  if ( not when ) then 
    return;
  end

  -- Ensure we're not looping GLSystemFrame
  if ( id == "GLSystemFrame" and GLSystem_Data.lastID ) then 
    id = GLSystem_Data.lastID;
  end

  -- Create the new task
  local todo = {};
  todo.time = when + GetTime();
  todo.handler = handler;
  todo.args = GLSystem_PackArgs(...);

  -- Create a new table if one does not exist
  if ( not GLSystem_Data.anonTodo[id] ) then
    GLSystem_Data.anonTodo[id] = {};
  end

  -- Find the correct index within the frame's table
  local i = 1;
  while(GLSystem_Data.anonTodo[id][i] and
    GLSystem_Data.anonTodo[id][i].time < todo.time) do
    i = i + 1;
  end

  -- Add the new task for the current frame
  tinsert(GLSystem_Data.anonTodo[id],i,todo);

  --
  -- Ensure we don't have too many events
  --	(For now, we just ignore it and pop a message)
  --	
  if ( #GLSystem_Data.anonTodo[id] > 100 and not GLSystem_Data.anonTodo[id].errorSent ) then
    GLSystem_Data.anonTodo[id].errorSent = true;
  end
end

