--[[
  Guild Event Manager by Kiki of European Cho'gall (Alliance)
    Calendar module - By Kiki
]]

--------------- Local variables ---------------
local GL_CALENDAR_CBFunc = nil;
local GL_CALENDAR_UserData = nil;

--------------- Internal functions ---------------

function GL_EventCalendar_DrawDays(parent,tim,ShowReset)
  local today = date("*t");

  -- Clear all days
  for i=1,6 do
    for j=1,7 do
      getglobal(parent:GetName().."Day"..i..j.."Text"):SetText("");
      getglobal(parent:GetName().."Day"..i..j.."Texture"):SetTexture("");
      getglobal(parent:GetName().."Day"..i..j):Hide();
    end
  end

  -- Compute starting month day
  local tab = date("*t",tim);
  local day = 1;
  local line = 1;
  local row = 1;
  local current_month = tab.month;
  tab.hour = 12;
  tab.min = 1;
  tab.sec = 1;
  tim = time(tab);
  local start_tim = tim - ((tab.day-1) * 60*60*24); -- Rewind (tab.day - 1) days
  tab = date("*t",start_tim);
  
  -- Display all valid days
  while tab.month == current_month
  do
    if(tab.wday < row) -- Changed line
    then
      line = line + 1;
    end
    row = tab.wday;
    getglobal(parent:GetName().."Day"..line..row.."Text"):SetText(day);
    getglobal(parent:GetName().."Day"..line..row):Show();
    getglobal(parent:GetName().."Day"..line..row).time = start_tim;
    if(today.year == tab.year and today.yday == tab.yday)
    then
      getglobal(parent:GetName().."Day"..line..row.."Text"):SetTextColor(0,1.0,0);
    else
      getglobal(parent:GetName().."Day"..line..row.."Text"):SetTextColor(0.4,0.8,1.0);
    end
    day = day + 1;
    start_tim = start_tim + 60*60*24; -- Increment day
    tab = date("*t",start_tim);
  end
end

local function GL_Calendar_DrawDays(tim)
  local today = date("*t");

  -- Clear all days
  for i=1,6 do
    for j=1,7 do
      getglobal("GLCalendarDay"..i..j):SetText("");
      getglobal("GLCalendarDay"..i..j):Hide();
    end
  end

  -- Compute starting month day
  local tab = date("*t",tim);
  local day = 1;
  local line = 1;
  local row = 1;
  local current_month = tab.month;
  tab.hour = 12;
  tab.min = 1;
  tab.sec = 1;
  tim = time(tab);
  local start_tim = tim - ((tab.day-1) * 60*60*24); -- Rewind (tab.day - 1) days
  tab = date("*t",start_tim);
  
  -- Display all valid days
  while tab.month == current_month
  do
    if(tab.wday < row) -- Changed line
    then
      line = line + 1;
    end
    row = tab.wday;
    getglobal("GLCalendarDay"..line..row):SetText(day);
    getglobal("GLCalendarDay"..line..row):Show();
    getglobal("GLCalendarDay"..line..row).time = start_tim;
    if(today.year == tab.year and today.yday == tab.yday)
    then
      getglobal("GLCalendarDay"..line..row.."Text"):SetTextColor(0.1,0.8,0.1);
    else
      getglobal("GLCalendarDay"..line..row.."Text"):SetTextColor(0.4,0.8,1.0);
    end
    day = day + 1;
    start_tim = start_tim + 60*60*24; -- Increment day
    tab = date("*t",start_tim);
  end
end


--------------- From XML functions ---------------


function GL_Calendar_OnClick()
  local tab = date("*t",this.time);
  tab.hour = getglobal("GLCalendarHourDropDown").hour;
  tab.min = getglobal("GLCalendarMinuteDropDown").min;
  tab.sec = 0;
  if(GL_CALENDAR_CBFunc)
  then
    GL_CALENDAR_CBFunc(time(tab),GL_CALENDAR_UserData);
  end
  GLCalendarFrame:Hide();
end

function GL_Calendar_OnShow()
  GL_Calendar_DrawDays(time());
end

function GL_CalendarMonthDropDown_OnShow()
  local tab = date("*t");
  getglobal("GLCalendarMonthDropDown").month = tab.month;
  UIDropDownMenu_Initialize(GLCalendarMonthDropDown, GL_CalendarMonthDropDown_Init);
  UIDropDownMenu_SetText(GLCalendar_Month[tab.month], GL_CalendarMonthDropDown);
  UIDropDownMenu_SetWidth(70, GLCalendarMonthDropDown);
end

function GL_CalendarMonthDropDown_OnClick()
  local tab = date("*t");
  getglobal("GLCalendarMonthDropDown").month = this.value;
  tab.day = 1;
  tab.month = getglobal("GLCalendarMonthDropDown").month;
  tab.year = getglobal("GLCalendarYearDropDown").year;
  GL_Calendar_DrawDays(time(tab));
  UIDropDownMenu_SetText(GLCalendar_Month[this.value], GLCalendarMonthDropDown);
end

function GL_CalendarMonthDropDown_Init()
  for i,month in pairs(GLCalendar_Month) do
    local info = { };
    info.text = month;
    info.value = i;
    info.func = GL_CalendarMonthDropDown_OnClick;
    UIDropDownMenu_AddButton(info);
  end
end
--
function GL_CalendarYearDropDown_OnShow()
  local tab = date("*t");
  getglobal("GLCalendarYearDropDown").year = tab.year;
  UIDropDownMenu_Initialize(GLCalendarYearDropDown, GL_CalendarYearDropDown_Init);
  UIDropDownMenu_SetText(tab.year, GLCalendarYearDropDown);
  UIDropDownMenu_SetWidth(58, GLCalendarYearDropDown);
end

function GL_CalendarYearDropDown_OnClick()
  local tab = date("*t");
  getglobal("GLCalendarYearDropDown").year = this.value;
  tab.day = 1;
  tab.month = getglobal("GLCalendarMonthDropDown").month;
  tab.year = getglobal("GLCalendarYearDropDown").year;
  GLCalendar_DrawDays(time(tab));
  UIDropDownMenu_SetText(this.value,GLCalendarYearDropDown);
end

function GL_CalendarYearDropDown_Init()
  for i=2005,2008 do
    local info = { };
    info.text = i;
    info.value = i;
    info.func = GL_CalendarYearDropDown_OnClick;
    UIDropDownMenu_AddButton(info);
  end
end
--
function GL_CalendarHourDropDown_OnShow()
  getglobal("GLCalendarHourDropDown").hour = 20;
  UIDropDownMenu_Initialize(GLCalendarHourDropDown, GL_CalendarHourDropDown_Init);
  UIDropDownMenu_SetText("20h", GLCalendarHourDropDown);
  UIDropDownMenu_SetWidth(48, GLCalendarHourDropDown);
end

function GL_CalendarHourDropDown_OnClick()
  getglobal("GLCalendarHourDropDown").hour = this.value;
  if(this.value < 10)
  then
    UIDropDownMenu_SetText("0"..this.value.."h",GLCalendarHourDropDown);
  else
    UIDropDownMenu_SetText(this.value.."h",GLCalendarHourDropDown);
  end
end

function GL_CalendarHourDropDown_Init()
  for i=0,23 do
    local info = { };
    if(i < 10)
    then
      info.text = "0"..i.."h";
    else
      info.text = i.."h";
    end
    info.value = i;
    info.func = GL_CalendarHourDropDown_OnClick;
    UIDropDownMenu_AddButton(info);
  end
end
--
function GL_CalendarMinuteDropDown_OnShow()
  getglobal("GLCalendarMinuteDropDown").min = 0;
  UIDropDownMenu_Initialize(GLCalendarMinuteDropDown, GL_CalendarMinuteDropDown_Init);
  UIDropDownMenu_SetText("00", GLCalendarMinuteDropDown);
  UIDropDownMenu_SetWidth(40, GLCalendarMinuteDropDown);
end

function GL_CalendarMinuteDropDown_OnClick()
  getglobal("GLCalendarMinuteDropDown").min = this.value;
  if(this.value < 10)
  then
    UIDropDownMenu_SetText("0"..this.value,GLCalendarMinuteDropDown);
  else
    UIDropDownMenu_SetText(this.value,GLCalendarMinuteDropDown);
  end
end

function GL_CalendarMinuteDropDown_Init()
  for i=0,45,15 do
    local info = { };
    if(i < 10)
    then
      info.text = "0"..i;
    else
      info.text = i;
    end
    info.value = i;
    info.func = GL_CalendarMinuteDropDown_OnClick;
    UIDropDownMenu_AddButton(info);
  end
end


--------------- GUI Exported functions ---------------

--[[
 function GLCalendar_PickupDate :
  Opens the calendar
   CBFunc    : Function -- The CB function : void (*func)(sel_date,user_data) -- Called with the selected date (hour/minute undefined)
   user_data : any      -- User data returned in the callback
  --
   Returns false if Calendar is already open, True otherwise
]]
function GL_Calendar_PickupDate(CBFunc,user_data)
  if(GLCalendarFrame:IsVisible())
  then
    return false;
  end
  GL_CALENDAR_CBFunc = CBFunc;
  GL_CALENDAR_UserData = user_data;
  GLCalendarFrame:Show();
  return true;
end

-- /script GLCalendar_PickupDate(nil)
