GL = {};
GL.Me = "";
GL.Command = "LOTTERY";
GL.WhisperHistory = {};
GL.WinningTicket=0;
GL.WinningPercentage=100;

GL_Settings = {};
GL_Settings.MinimapRadiusOffset = 80;
GL_Settings.MinimapArcOffset = 343;
GL_Settings.MinimapTexture = "Spell_Nature_RavenForm";
GL_Settings.MinimapTextureId = 1;
GL_Settings.Debuglevel = 0;


GL_GCHAT = "<<Guild Lottery>> "

GL_Icons = {
"Spell_Nature_RavenForm",
"Ability_Hunter_AspectOfTheMonkey",
"Ability_Mount_JungleTiger",
"Ability_Mount_WhiteTiger",
"Ability_Mount_PinkTiger",
"Spell_Nature_ProtectionformNature",
"Ability_Hunter_RunningShot",
"Ability_EyesOfTheOwl",
"Ability_Whirlwind",
"Shadow_RagingScream",
"Spell_Fire_FireArmor",
"Shadow_SacrificialShield",
"Shadow_DemonBreath",
"Shadow_EvilEye",
"Shadow_Twilight",
"Shadow_DetectLesserInvisibility",
"Shadow_PsychicScream",
"Shadow_AntiShadow",
"Shadow_ShadowPact",
"Shadow_DetectInvisibility",
"Shadow_GatherShadows",
"Shadow_DetectInvisibility",
"Shadow_Shadowform",
"Shadow_AntiShadow",
"Shadow_DeadofNight",
"Spell_Holy_WordFortitude",
"Spell_Holy_PrayerOfFortitude",
"Spell_Holy_PowerWordShield",
"Spell_Holy_Renew",
"Shadow_ShadowWordDominate",
"Spell_Holy_InnerFire",
"Spell_Frost_WindWalkOn",
"Shadow_Requiem",
"Spell_Magic_LesserInvisibility",
"Shadow_Raisedead",
"Shadow_UnsummonBuilding",
"Spell_Magic_LesserInvisibilty",
"Spell_Holy_PowerInfusion",
"Spell_Holy_GreaterHeal",
"Spell_Lightning_LightningBolt01",
"Spell_Holy_Excorcism",
"Spell_Holy_Restoration",
"Spell_Holy_HolyProtection",
"Spell_Holy_Heal",
"Spell_Holy_BlessingOfAgility",
"Spell_Holy_ArcaneIntellect",
"Spell_Holy_MagicalSentry",
"Spell_Frost_FrostArmor02",
"Shadow_DetectLesserInvisibility",
"Spell_Fire_FireArmor",
"Spell_Frost_Frost",
"Spell_Ice_Lament",
"Spell_Frost_FrostWard",
"Spell_MageArmor",
"Shadow_ManaBurn",
"Spell_Nature_EnchantArmor",
"Spell_Fire_SealOfFire",
"Spell_Arcane_TeleportOrgrimmar",
"Shadow_RagingScream",
"Shadow_SoulGem",
"Spell_Nature_AbolishMagic",
"Spell_Holy_FlashHeal",
"Spell_Nature_Regeneration",
"Spell_Nature_Rejuvenation",
"Spell_Nature_NaturesBlessing",
"Spell_Nature_Thorns",
"Spell_Nature_Ravenform",
"Spell_Nature_SpiritWolf",
"Spell_Nature_StoneSkinTotem",
"Spell_Nature_Swiftness",
"Spell_Nature_P",
"Spell_Nature_ResistNature",
"Spell_Nature_LightningShield",
"Racial_Troll_Berserk",
"Spell_Nature_LightningShield",
"Spell_Magic_MageArmor",
"Spell_MiscFood",
"Ability_Mount_BlackDireWolf",
"Ability_Mount_WhiteDireWolf",
"Ability_Mount_Kodo_01",
"Ability_Mount_Kodo_03",
"Ability_Mount_Raptor",
"Ability_Mount_Undeadhorse",
"Ability_Mount_Dreadsteed",
"Ability_Rogue_Sprint",
"Ability_Druid_CatForm",
"Ability_Ambush",
"Ability_Mount_JungleTiger",
"Ability_Druid_Dash",
"Ability_Warrior_DefensiveStance",
"Ability_TrueShot",
"Spell_INV_Jewelry_Talisman_07",
"Spell_INV_Potion_44",
"Spell_INV_Potion_58",
"Spell_INV_Potion_65",
"Spell_INV_Potion_92",
"Spell_INV_Potion_93",
"Spell_INV_Drink_07",
"Spell_INV_Drink_18",
"Spell_INV_Misc_Fork&Knive",
"Spell_Nature_TimeStop",
"Spell_Holy_DivineIntervention",
"Ability_Warrior_InnerRage",
"Spell_Holy_HealingAura",
"Spell_Holy_RighteousnessAura",
"Spell_Holy_HolySmite",
"Ability_ThunderBolt",
"Spell_Holy_SealOfWrath",
"Spell_Holy_FistOfJustice",
"Spell_Holy_SealOfWisdom",
"Spell_Holy_SealOfSalvation",
"Spell_Holy_PrayerOfHealing02",
"Spell_Holy_SealOfValor",
"Spell_Holy_SealOfProtection",
"Spell_Holy_GreaterBlessingofKings",
"Spell_Holy_GreaterBlessingofWisdom",
"Spell_Holy_GreaterBlessingofSalvation",
"Spell_Holy_GreaterBlessingofLight",
"Ability_Warrior_BattleShout",
"Shadow_Teleport",
"Ability_Hunter_BeastTraining",
"Ability_Hunter_MendPet",
"Ability_Druid_Dash",
"Ability_Druid_SupriseAttack",
"Shadow_ImpPhaseShift",
"Shadow_LifeDrain",
"Shadow_AntiShadow",
"Spell_Magic_LesserInvisibility",
"Shadow_GatherShadows",
"Spell_Holy_DevotionAura",
"Spell_Holy_AuraOfLight",
"Spell_Holy_MindSooth",
"Shadow_SealOfKings",
"Spell_Holy_MindVision",
"Spell_Frost_WizardMark",
"Spell_Fire_SealOfFire",
"Shadow_BloodBoil",
"Shadow_AuraOfDarkness",
"Spell_Frost_Stun",
"Ability_Hunter_SniperShot",
"Ability_Rogue_Trip",
"Ability_Hunter_Quickshot",
"Ability_Hunter_CriticalShot",
"Ability_Hunter_AimedShot",
"Ability_GolemStormBolt",
"Ability_GolemStormBolt",
"Spell_Frost_ChainsOfIce",
"Spell_Frost_FreezingBreath",
"Spell_Fire_FlameShock",
"Spell_Fire_SelfDestruct",
"Spell_Holy_Dizzy",
"Spell_Nature_Polymorph",
"Spell_Frost_FrostBolt02",
"Spell_Frost_FrostNova",
"Spell_Frost_FrostArmor",
"Spell_Fire_SoulBurn",
"Shadow_AbominationExplosion",
"Spell_Fire_Immolation",
"Shadow_Requiem",
"Shadow_LifeDrain02",
"Shadow_Haunting",
"Shadow_SiphonMana",
"Shadow_CurseOfSargeras",
"Shadow_CurseOfMannoroth",
"Shadow_CurseOfAchimonde",
"Shadow_ChillTouch",
"Shadow_AuraOfDarkness",
"Shadow_CurseOfTounges",
"Shadow_UnholyStrength",
"Shadow_GrimWard",
"Shadow_ShadowBolt",
"Shadow_Possession",
"Shadow_EnslaveDemon",
"Shadow_MindSteal *",
"Shadow_LifeDrain",
"Shadow_MindRot",
"Shadow_DeathScream",
"Shadow_DeathCoil",
"Ability_Gouge",
"Spell_Nature_ThunderClap",
"Shadow_DeathScream",
"Ability_ShockWave",
"Spell_Frost_Stun",
"Spell_Frost_Stun",
"Spell_Frost_Stun",
"Ability_Warrior_WarCry",
"Ability_GolemThunderClap",
"Ability_Warrior_Sunder",
"Spell_Holy_AshesToAshes",
"Shadow_PsychicScream",
"Spell_Nature_Slow",
"Ability_Druid_Disembowel",
"Spell_Nature_StarFall",
"Spell_Nature_FaerieFire",
"Spell_Nature_Sleep",
"Spell_Nature_InsectSwarm",
"Ability_Gouge",
"Ability_Rogue_Garrote",
"Shadow_MindSteal *",
"Ability_Rogue_Rupture",
"Ability_CheapShot",
"Ability_Sap",
"Ability_Warrior_Riposte",
"Shadow_LifeDrain",
"Ability_Rogue_KidneyShot",
"Spell_Frost_FrostShock",
"Shadow_DeathScream",
"Shadow_ShadowWordPain",
"Shadow_BlackPlague",
"Shadow_AbonimationExplosion",
"Shadow_CurseOfSargeras",
"Fire_FlameBolt",
"Fire_Fireball02",
"Frost_Stun",
"Frost_ChainsOfIce",
"Nature_StrangleVines",
"Nature_Starfall",
"Spell_Holy_SearingLight",
"Ability_BackStab",
"Ability_ShockWave",
"Ability_Vanish",
"Ability_Warrior_SavageBlow",
"Misc_Bandage_08"
};


-- MenuItem related
GL_MENUBUTTONSIZEY = 16;
g_MenuItemSelected = 0;
--

local GL_ANSWER_YES = "Yes";
local GL_ANSWER_NO = "No";

local Orig_ChatFrame_OnEvent=nil;

VERSION_TEXT = "0.3 Beta"

local RED     = "|cffff0000";
local GREEN   = "|cff00ff00";
local BLUE    = "|cff0000ff";
local MAGENTA = "|cffff00ff";
local YELLOW  = "|cffffff00";
local CYAN    = "|cff00ffff";
local WHITE   = "|cffffffff";	

function GL_Color( color, text )
	if color==nil then color=WHITE; end
	local coloredtext=color..text.."|r"
	return coloredtext;
end

function GL_SlashHandler(msg)
	local argv = {};
	for arg in string.gmatch(string.lower(msg), '[%a%d%-%.]+') do
		table.insert(argv, arg);
	end

	if argv[1] == "toggle" then
		GL_Toggle(0);
	else
		if argv[1]==nil then
			GL_Help();
		else
			GL_printf(GL_Color(GREEN,"GuildLottery:")..GL_Color(RED,"Unknown command."));
		end
	end
end

function GL_Help()
    GL_printf("GLottery Commands");
    GL_printf("----------------------------------");
    GL_printf("/glot toggle - Open/Close the GLottery screen");
end


local GL_EventDelta=0;
function GL_OnGlobalUpdate(delta)
end

function GL_OnGlobalEvent(event, arguments)
  local channel = nil;
  if(arg9)
  then
    channel = strlower(arg9);
  end
  
	if event == "CHAT_MSG_WHISPER" or event == "CHAT_MSG_GUILD" then
		GL_debug("GLottery: event "..event);
		local text=strupper(arguments[1]);
		if string.find(text,"^"..GL.Command.."$") then
				GL_SendInfo(arguments[2]);
		end
		if string.find(text,"^"..GL.Command.." %d+$") then
				local ticketno=string.gsub(text,"^"..GL.Command.." (%d+)$","%1");
				GL_SendTicketOwnerOf(arguments[2],ticketno);			
		end
		if string.find(text,"^"..GL.Command.." HELP$") then
			GL_SendHelp(arguments[2]);
		end
	elseif event == "VARIABLES_LOADED" then
		GL_Init();
	end
end

Orig_ChatFrame_OnEvent = ChatFrame_OnEvent;
function GL_ChatFrame_OnEvent(event)
	if event=="CHAT_MSG_WHISPER_INFORM" then
		if GL_IsGLWhisper(arg1,arg2) then
			return;
		end
	end	
	if event=="CHAT_MSG_WHISPER" then
		local whisp=string.upper(arg1);
		if string.find(whisp,"^"..GL.Command.." %w+$") or string.find(whisp,"^"..GL.Command.."$") then
			return;
		end
	end	
	Orig_ChatFrame_OnEvent(event) 
end
ChatFrame_OnEvent = GL_ChatFrame_OnEvent;

function GL_OptionsOnShow()
    GLRadiusSliderButtonPos:SetValue(GL_Settings.MinimapRadiusOffset);
    GLArcSliderButtonPos:SetValue(GL_Settings.MinimapArcOffset);
    GLIconSliderButtonPos:SetValue(GL_Settings.MinimapTextureId);
end

function GL_IsGLWhisper( text, to )
	if #GL.WhisperHistory > 0 then
		for n=#GL.WhisperHistory, 1, -1 do
			hist = GL.WhisperHistory[n];
			if (GetTime() - hist.time > 10) then
				table.remove(GL.WhisperHistory,n);
			end
		end
	end
	if #GL.WhisperHistory > 0 then
		for n=1, #GL.WhisperHistory, 1 do
			hist = GL.WhisperHistory[n];
			if hist.to==to and hist.text==text then
				return true; 
			end
		end
	end  
end

function GL_OptionsToggle()
  if (GLOptionsWindow:IsVisible()) then
    GLOptionsWindow:Hide();
  else
    GLOptionsWindow:Show();
  end
end

function GL_Init()
  SlashCmdList["GLOTTERY"] = GL_SlashHandler
  SLASH_GLOTTERY1 = "/glottery"
  SLASH_GLOTTERY2 = "/glot"
  
	GL_MinimapButton_Update();	
	GL_DataInitialize();

	if GL_Settings.Debuglevel == nil then
		GL_Settings.Debuglevel=0;
	end
	GL_UpdateScreen();
	GL_UpdateUserButtons();
	
	GLControlFrameVersion:SetText(VERSION_TEXT);
	
	MoneyInputFrame_SetOnvalueChangedFunc(GLStartGoldFrame,GL_OnMoneyChanged);
	MoneyInputFrame_SetOnvalueChangedFunc(GLTicketPriceFrame,GL_OnMoneyChanged);
	
	GLJackPotFrameGold:SetTextColor(0.5,0.5,0.5);
	GLJackPotFrameSilver:SetTextColor(0.5,0.5,0.5);
	GLJackPotFrameGold:EnableMouse(0);
	GLJackPotFrameSilver:EnableMouse(0);
	
end

function GL_OnMoneyChanged()
	local somethingchanged=false;
	value = MoneyInputFrame_GetCopper(GLStartGoldFrame);
	if value ~= GL_Data.StartGold then 
		GL_Data.StartGold = value;
		somethingchanged=true; 
	end
	
	value = MoneyInputFrame_GetCopper(GLTicketPriceFrame);
	if value ~= GL_Data.TicketPrice then
		GL_Data.TicketPrice = value
		somethingchanged=true; 
	end
		
	if somethingchanged then
		GL_UpdateScreen();
	end	
end

function GL_OnGlobalLoad()
	GL.Me = UnitName("player");
	GL.Command = strupper(GL.Command);
	this:RegisterEvent("CHAT_MSG_GUILD");
	this:RegisterEvent("CHAT_MSG_WHISPER");
	this:RegisterEvent("VARIABLES_LOADED");
	
  GL_printf("GLottery "..VERSION_TEXT.." loaded");

-- minimap button
	GL_MinimapButton_Update();
	GLMinimapButton:Show();
	GLMinimapButtonText:SetText("");
	GLMinimapButtonText:SetTextColor(1.0,0.1,0.1);
	if ButtonHole then
		ButtonHole.application.RegisterMod({id="GLOTTERY", name="Guild Lottery",tooltip="Easy Lottery util", buttonFrame="GLMinimapButton", updateFunction="GL_MinimapButton_Update"});
	end
-- end minimap 
  tinsert(UISpecialFrames, "GLControlFrame");
end


function GL_Toggle(page)
 	GL_MinimapButton_Update();
 	GL_UpdateUserButtons();
  if (GLControlFrame:IsVisible()) then
    GLControlFrame:Hide();
  else
    GLControlFrame:Show();
  end
end

function GL_User_OnLoad()
	this:RegisterForClicks("LeftButtonDown", "RightButtonDown");
end

function GL_User_OnClick(button)
	local id = this:GetID();
	local offset = FauxScrollFrame_GetOffset(GLUsersScrollFrame);
	local idx = id+offset;
	HideDropDownMenu(1);
	
	GLTicketsEditBox:ClearFocus();
	
	g_MenuItemSelected = idx;		
	if button=="RightButton" then
		ToggleDropDownMenu(1,nil,GLUserCmdList,"cursor");
	end
	GL_UpdateScreen();
	GL_UpdateUserButtons();
end

function GL_UserCmdList_OnLoad()
  HideDropDownMenu(1);
  GLUserCmdList.initialize = GL_UserCmdList_Initialize;
  GLUserCmdList.displayMode = "MENU";
  GLUserCmdList.name = "Titre";
end

function GL_UserCmdList_Initialize()
	local IsUser=false;
	if GL_DataValid(g_MenuItemSelected) then
		IsUser=true;
	end

  info = { };
  info.text = "LOTTERY COMMANDS";
  info.isTitle = true;
  info.notCheckable = 1;
  UIDropDownMenu_AddButton(info,1);

	if (IsUser) then
	  info = { };
	  info.text =  "Add Tickets";
	  info.notCheckable = 1;
	  info.value = selectAdminItem;
	  info.func = GL_UserCmdList_AddTickets_OnClick;
	  UIDropDownMenu_AddButton(info,1);			
	end

  info = { };
  info.text =  "Add Player";
  info.notCheckable = 1;
  info.value = selectAdminItem;
  info.func = GL_UserCmdList_AddUser_OnClick;
  UIDropDownMenu_AddButton(info,1);
  
  info = { };
  info.text = "Cancel";
  info.notCheckable = 1;
  info.func = GL_UserCmdList_Cancel_OnClick;
  UIDropDownMenu_AddButton(info,1);  
end

function GL_UserCmdList_AddTickets_OnClick()
	GLNewUserTicketsEditBox:SetText("1");
	GLNewUserNameEditBox:SetText(GL_DataGetUser(g_MenuItemSelected));
	GLNewUserFrame:Show();	
	GLNewUserTicketsEditBox:SetFocus();
	GLNewUserTicketsEditBox:HighlightText();
end

function GL_UserCmdList_AddUser_OnClick()
	GLNewUserTicketsEditBox:SetText("1");
	GLNewUserNameEditBox:SetText("");
	GLNewUserFrame:Show();	
	GLNewUserNameEditBox:SetFocus();
end

function GL_UserCmdList_Cancel_OnClick()
  HideDropDownMenu(1);
end

function GL_FormatPrice ( price )
	if price==nil then price =0 end
	local c= price % 100;
	local s= (math.floor(price/100)) % 100;
	local g= math.floor(price/10000);
	local text=g.."g";
	if s>0 then text=text.." "..s.."s"; end
	if c>0 then text=text.." "..c.."c"; end
	return text;
end

function GL_FormatTicket( tickets )
	if tickets==nil then 
		return;
	end
	local i,count;
	local text="";
	count=0;
	for i=1, table.getn(tickets), 1 do
		text=text..tickets[i];
		count=count+1;
		if count==5 then
			text=text.."\n";
			count=0;
		else
			text=text.." ";
		end
	end
	return text;		
end

function GL_FormatDate( datestamp )
	local text=date(GL_DATE_FORMAT,datestamp);
	--GL_printf("date="..text);
	return text;
end

function GL_CalculateJackpot()
	return GL_Data.StartGold+GL_DataGetTotalTicketCount()*GL_Data.TicketPrice;
end
	
function GL_UpdateScreen()
	local IsUser=false;
	local idx=g_MenuItemSelected;
	if (GL_DataValid(idx)) then
		IsUser=true;
	end

	if (GL_Data.LotteryDate and GL_Data.LotteryDate~=0) then
		GLLotteryDateEditBox:SetText(GL_FormatDate(GL_Data.LotteryDate))
	end
	GLLotteryDateEditBox:SetTextColor(0.5,0.5,0.5);
	MoneyInputFrame_ResetMoney(GLJackPotFrame);
	MoneyInputFrame_SetCopper(GLJackPotFrame,GL_CalculateJackpot());
	MoneyInputFrame_ResetMoney(GLStartGoldFrame);
	MoneyInputFrame_SetCopper(GLStartGoldFrame,GL_Data.StartGold);
	GLTicketMaxTicketsEditBox:SetText(GL_Data.MaxTickets);
	GLSecondPrizeEditBox:SetText(GL_Data.SecondPrize);	
	MoneyInputFrame_ResetMoney(GLTicketPriceFrame);
	MoneyInputFrame_SetCopper(GLTicketPriceFrame, GL_Data.TicketPrice);

	GLTicketsEditBox:SetTextColor(1,1,1);
	GLTicketsEditBox:EnableMouse(0);
	
	if (GL_DataGetTotalTicketCount()>0) then
		GLStartRollButton:Enable();
	else
		GLStartRollButton:Disable();
	end
	
	if ( IsUser ) then
		local TicketText=GL_FormatTicket(GL_DataGetTickets(idx));
		GLTicketsEditBox:SetText(TicketText);
	else		
		GLTicketsEditBox:SetText("");
	end
end


function GL_UpdateUserButtons()
	GL_debug("GL_UpdateUserButtons");
	local size=GL_DataCount();
	FauxScrollFrame_Update(GLUsersScrollFrame, size, 10, GL_MENUBUTTONSIZEY);
	local offset=FauxScrollFrame_GetOffset(GLUsersScrollFrame);
	local i = 1;
	local button, normaltext, highlight;

	for i=1, 10, 1 do
		button = getglobal("GLUserButton"..i);
--		normaltext = getglobal("GLUserButton"..i.."NormalText");
		--highlight = getglobal("GLUserButton"..i.."Highlight");		
		idx = i+offset;
		if (GL_DataValid(idx)) then
			button:SetText(GL_DataGetUser(idx).." ("..GL_DataGetTicketCount(idx)..")");
			button:SetTextColor(0.6,0.8,1.0)
			if ( g_MenuItemSelected and g_MenuItemSelected == idx ) then
				button:LockHighlight();
			else
				button:UnlockHighlight();
			end
			button:Show();
		else
			button:Show();
			button:UnlockHighlight();
--			button:SetNormalTexture("");
			button:SetText("");
--			highlight:SetTexture("");
		end
	end
end

-------- Minimap button ------

function GL_MinimapButton_Update()
  if(GL.Me)
  then
    local radius = GL_Settings.MinimapRadiusOffset;
    local arc = GL_Settings.MinimapArcOffset;
    GLMinimapButton:SetPoint( "TOPLEFT", "Minimap", "TOPLEFT",55 - ( ( radius ) * cos( arc ) ),( ( radius ) * sin( arc ) ) - 55);
    GL_Settings.MinimapTexture = GL_Icons[GL_Settings.MinimapTextureId];
    if (GL_Settings.MinimapTexture==nil) then
    	GL_Settings.MinimapTexture=GL_Icons[1];
    end
    GLMinimapButtonTexture:SetTexture("Interface\\Icons\\"..GL_Settings.MinimapTexture);
    GLMinimapButtonTexture:SetAlpha(1.0);
  end
end

function GL_QuestionYes_Click()
	if GL_Question_Callback~=nil then
		GL_Question_Callback(GL_ANSWER_YES);
	end
	GL_Question_Callback=nil;
	GLQuestionFrame:Hide();
end

function GL_QuestionNo_Click()
	if GL_Question_Callback~=nil then
		GL_Question_Callback(GL_ANSWER_NO);
	end
	GL_Question_Callback=nil;
	GLQuestionFrame:Hide();
end

function GL_AskQuestion(text,callback)
	GL_Question_Callback=callback;
	GLQuestionEditBox:SetText(text);
	GLQuestionFrame:Show();
end	

function GL_BuyTickets( amount )
	local i,ticket;
	local newTickets={};
	if GL_Data.NextTicket==0 then
		GL_Data.NextTicket=GL_Data.TicketSerie;
	end	
	for i=1, amount, 1 do
		ticket=GL_Data.NextTicket;
		table.insert(newTickets,ticket);
		GL_Data.NextTicket=ticket+2;
	end
	return newTickets;		
end


-- NewUserFrame Button Clicks -----
function GL_NewUserCancel_Click()
	GLNewUserFrame:Hide();
end


function GL_NewUserOK_Click()
	local User=GLNewUserNameEditBox:GetText();
	local numtickets = tonumber(GLNewUserTicketsEditBox:GetText());
	
	local alreadysold = 0;
	if GL_DataGetUserIdx(User)>0 then
		alreadysold = GL_DataGetTicketCount(GL_DataGetUserIdx(User));
	end
	if (numtickets+alreadysold>GL_Data.MaxTickets) then
		GL_printf( GL_Color(GREEN,"GuildLottery: ")..GL_Color(RED,"Exceeding Maximum tickets, you can only sell "..GL_Data.MaxTickets-alreadysold.." tickets to:")..GL_Color(CYAN,User));
		return;
	end
	local Tickets=GL_BuyTickets(numtickets);
	local idx=GL_DataGetUserIdx(User);
	if (idx and idx>0) then
		GL_DataAddTickets(idx, Tickets);
		GL_SendInfo(User);
	else
		Info={};
		Info.User=User;
		Info.Tickets=Tickets;
		GL_InsertData( Info );
		GL_SendInfo(User);
		GL_SendWhisperLine(User, "Whisper: Lottery to "..GL.Me.." or type in guildchat to see Lottery status.");
	end
	GLNewUserFrame:Hide();
	GL_UpdateScreen();
	GL_UpdateUserButtons();
end

function GL_NewUserNameAutocomplete()
	local text = this:GetText();
	local textlen = strlen(text);
	local numFriends, name;


	-- No match, check your guild list
	numFriends = GetNumGuildMembers(true);	-- true to include offline members
	if ( numFriends > 0 ) then
		for i=1, numFriends do
			name = GetGuildRosterInfo(i);
			if ( strfind(strupper(name), strupper(text), 1, 1) == 1 ) then
				this:SetText(name);
				this:HighlightText(textlen, -1);
				return;
			end
		end
	end
end

function GL_NewUserOnEscapePressed()
	GL_NewUserCancel_Click();
end

function GL_NewUserOnEnterPressed()
	if GLNewUserNameEditBox:GetText() ~= "" then
		GL_NewUserOK_Click();
	end
end

function GL_InsertData( info)
	local Position;
	
	if (info~=nil and info.User ~= nil) then
		Position=GL_DataCount()+1;
		GL_DataInsert(Position,info);	
		g_MenuItemSelected = Position;
		GL_UpdateScreen();
		GL_UpdateUserButtons();	
	end
end

-- ControlFrame Button Clicks -----

function GL_NewLotteryClick()
	if GL_DataGetTotalTicketCount() > 0 then
		GL_AskQuestion( "\n\n  Starting a new lottery will remove\n  all ticket numbers which are\n  already sold.\n\n  "..GL_Color(YELLOW,"Do you want to start a new Lottery?"),GL_NewLotteryAnswerCallback)
	else
		GL_Calendar_PickupDate(GL_NewLotteryCallback);
	end 
end


function GL_NewLotteryAnswerCallback( answer )
	if answer==GL_ANSWER_YES then
		GL_Calendar_PickupDate(GL_NewLotteryCallback);
	end
end

function GL_NewLotteryCallback(datetime)
	GL_Data.LotteryDate=datetime;
	GL_DataClear();
	GL_UpdateUserButtons();	
	GL_UpdateScreen();
end

local GLRollState=0;
function GL_StartRollClick()
	GLRollState=1;
	GL_GuildChat("Will start in 20 seconds");
	GLSystem_Schedule(10,GL_Rolling);
end

local GLWinAmount=0;
function GL_Rolling()
	if GLRollState==1 then
		GL_GuildChat("10 seconds");
		GLRollState=2;
		GLSystem_Schedule(10,GL_Rolling);
	elseif GLRollState==2 then
		GL_GuildChat("Rolling for the Jackpot "..GL_FormatPrice(GL_CalculateJackpot()));
		GL_GuildChat(GL_DataGetTotalTicketCount().." tickets sold ranging from: "..GL_Data.TicketSerie.." to "..GL_Data.NextTicket-2);
		GLRollState=3;
		GLSystem_Schedule(5,GL_Rolling);
	elseif GLRollState==3 then
		GL.WinningTicket=math.random(GL_Data.TicketSerie,GL_Data.NextTicket-2);
		GL_GuildChat("The winning ticket number is: "..GL.WinningTicket);
		local idx=GL_DataGetTicketIdx(GL.WinningTicket);
		if (idx==0) then
			GL_GuildChat("This ticket number is not sold, there is no winner. :(");
			-- No winner
			if GL_Data.SecondPrize>0 then
				GLRollState=4
			else
				GL.WinningTicket=0;
				GLRollState=10;
			end
		else
			GL_GuildChat("This ticket number is sold, we have a winner!!");
			GL.WinningPercentage=100;
			GLRollState=10;
		end
		GLSystem_Schedule(5,GL_Rolling);
	elseif GLRollState==4 then
		-- Rolling for SecondPrize
		GL.WinningTicket=math.random(GL_Data.TicketSerie,GL_Data.NextTicket-2);
		GL_GuildChat("The second prize ticket number is: "..GL.WinningTicket);
		local idx=GL_DataGetTicketIdx(GL.WinningTicket);
		if (idx==0) then
			GL_GuildChat("This ticket number is not sold, there is no winner. :(");
			-- No winner
--			if GL_Data.ThirdPrize>0 then
--				GLRollState=5
--			else
				GL.WinningTicket=0;
				GLRollState=10;
--			end
		else
			GL_GuildChat("This ticket number is sold, we have a winner!!");
			GL.WinningPercentage=GL_Data.SecondPrize;
			GLRollState=10;
		end
		GLSystem_Schedule(5,GL_Rolling);
		
	elseif GLRollState==5 then
		
	elseif GLRollState==10 then
		GLWinAmount=0;
		if GL.WinningTicket>0 then
			GLWinAmount = (GL.WinningPercentage * GL_CalculateJackpot()) / 100;
			GL_GuildChat("The winner is: "..GL_GetUserByTicket(GL.WinningTicket).." and wins "..GL.WinningPercentage.."% of the Jackpot");
			GL_GuildChat("The winning amount is: "..GL_FormatPrice( GLWinAmount ));
			GL_printf(GL_Color(GREEN,"GuildLottery:")..GL_Color(WHITE," You have to pay out: ")..GL_Color(YELLOW,GL_FormatPrice(GLWinAmount))..GL_Color(WHITE," to: ")..GL_Color(CYAN,GL_GetUserByTicket(GL.WinningTicket)));
		end
		GLRollState=11;
		GLSystem_Schedule(5,GL_Rolling);
	elseif GLRollState==11 then
		local newstartgold = GL_CalculateJackpot()-GLWinAmount;
		if newstartgold>0 then
			GL_GuildChat("Next Lottery will start with: "..GL_FormatPrice(newstartgold));
		end
		GL_Data.StartGold = newstartgold;
		GL_printf(GL_Color(GREEN,"GuildLottery:")..GL_Color(WHITE," Choose the date for the next lottery"));
		GL_DataClear();
		GL_NewLotteryClick();
	end	
end

function GL_TicketMaxTicketsOnEscapePressed()
	GLTicketMaxTicketsEditBox:SetText(GL_Data.TicketMaxTickets);
	GL_UpdateScreen();
end

function GL_TicketMaxTicketsOnEnterPressed()
	GL_Data.MaxTickets=GLTicketMaxTicketsEditBox:GetNumber();
	GL_UpdateScreen();
end

function GL_SecondPrizesOnEscapePressed()
	GLSecondPrizeEditBox:SetText(GL_Data.SecondPrize);
	GL_UpdateScreen();
end

function GL_SecondPrizeOnEnterPressed()
	GL_Data.SecondPrize=GLSecondPrizeEditBox:GetNumber();
	GL_UpdateScreen();
end


function GL_TicketPriceOnEscapePressed()
	GL_UpdateScreen();
end

function GL_TicketPriceOnEnterPressed()
	GL_Data.TicketPrice = GLTicketPriceEditBox:GetNumber();
	GL_UpdateScreen();
end

function GL_StartGoldOnEscapePressed()
	GL_UpdateScreen();
end

function GL_StartGoldOnEnterPressed()
	local value=GLStartGoldEditBox:GetNumber();
	if value then
		GL_Data.StartGold=value;
	else
		GL_Data.StartGold=0;
	end
	GL_UpdateScreen();
end

function GL_printf(text)
   if DEFAULT_CHAT_FRAME then
      DEFAULT_CHAT_FRAME:AddMessage(text);
   else
      message(text);
   end
end

function GL_debug(text)
	if 	GL_Settings.Debuglevel>0 then
		GL_printf(text);
  end
end


function GL_SendWhisperLine(to, text )
	table.insert(GL.WhisperHistory, { to=to, text=text, time=GetTime() });
	if to == GL.Me then
		GL_printf( GL_Color(GREEN,text));
	else
		SendChatMessage( text, "WHISPER", nil, to );		
	end	
end

function GL_GetUserByTicket( ticketno )
	local idx=GL_DataGetTicketIdx(tonumber(ticketno));
	local Name=GL_DataGetUser(idx);
	return Name;
end

function GL_SendTicketOwnerOf( user, ticketno )
	local Name=GL_GetUserByTicket( ticketno);
	GL_SendWhisperLine(user, "GuildLottery:");
	if Name==nil or Name=="" then
		GL_SendWhisperLine(user, "Ticket number "..ticketno.." is not sold.");
	else
		GL_SendWhisperLine(user, "Ticket number "..ticketno.." is sold to: "..Name);
	end
end

function GL_UseSecondPrize()
	if GL_Data.SecondPrize > 0 then
		return true;
	end
	return false;
end

function GL_SendHelp( user )
	GL_printf(GL_Color(GREEN,"GuildLottery ")..GL_Color(WHITE,"sending lottery help to: ")..GL_Color(CYAN,user));
	GL_SendWhisperLine(user, "GuildLottery works like this:");
	GL_SendWhisperLine(user, "- The lottery owner puts StartGold of his own in the Jackpot:"..GL_FormatPrice(GL_Data.StartGold));
	GL_SendWhisperLine(user, "- He/She decides what the ticket price is: "..GL_FormatPrice(GL_Data.TicketPrice));
	GL_SendWhisperLine(user, "- And how many tickets can be bought: "..GL_Data.MaxTickets.." per person");
	GL_SendWhisperLine(user, "- Jackpot is calculated as: StartGold + (Sold Tickets x Ticket Price)");
	GL_SendWhisperLine(user, "- At a given date: "..GL_FormatDate(GL_Data.LotteryDate).." the rolling will start.");
	GL_SendWhisperLine(user, "- In the guildchat, the winning ticket number will be written, and who have won the Jackpot"); 
	GL_SendWhisperLine(user, "- Only EVEN ticket numbers are sold, and if rolled an ODD number, nobody wins"); 
	if GL_UseSecondPrize() then
		GL_SendWhisperLine(user, "- if nobody wins, another roll will be done for second prize: "..GL_Data.SecondPrize.."% of Jackpot");
		GL_SendWhisperLine(user, "  the remaining gold will go to the next lottery, as StartGold.");
		GL_SendWhisperLine(user, "- If still nobody wins, the whole Jackpot will go to the next lottery.");
	else
		GL_SendWhisperLine(user, "- If nobody wins, the whole Jackpot will go to the next lottery, as StartGold.");
	end
end

GL_WIM_API_Filter_orig = WIM_API_Filter;
function GL_WIM_API_Filter(theMsg, theUser)		
	if GL_IsGLWhisper( theMsg, theUser ) then
		return 2; -- WIM  1=igonre 2=block
	end
  return GL_WIM_API_Filter_orig(theMsg, theUser);
end
WIM_API_Filter = GL_WIM_API_Filter;


function GL_SendInfo( user )
	GL_printf(GL_Color(GREEN,"GuildLottery ")..GL_Color(WHITE,"sending lottery info to: ")..GL_Color(CYAN,user));
	GL_SendWhisperLine(user,"Guild Lottery @ "..GL_FormatDate(GL_Data.LotteryDate));
	GL_SendWhisperLine(user,"Current Jackpot Status: "..GL_FormatPrice(GL_CalculateJackpot())..".");
	
	local idx=GL_DataGetUserIdx( user );
	if (idx and idx>0) then
		-- show tickets
		GL_SendWhisperLine(user,"---------------------------");
		
		GL_SendWhisperLine(user,"Your Lottery Ticket Numbers are:");
		local tickets=GL_DataGetTickets(idx);
		local i,count;
		local text="";
		count=0;
		for i=1, GL_DataGetTicketCount(idx), 1 do
			text=text..tickets[i].." ";
			count=count+1;
			if count==5 then
				GL_SendWhisperLine(user,text);
				count=0;
				text="";
			end
		end
		if text~="" then
			GL_SendWhisperLine(user,text);
		end
  	GL_SendWhisperLine(user,"---------------------------");
  	local availcount = GL_Data.MaxTickets - GL_DataGetTicketCount(idx);
  	if availcount > 0 then
			GL_SendWhisperLine(user,"You could buy "..GL_Data.MaxTickets - GL_DataGetTicketCount(idx).." more tickets ("..GL_FormatPrice(GL_Data.TicketPrice).." per ticket)");
		end
		GL_SendWhisperLine(user,"Good Luck!");	
	else
		GL_SendWhisperLine(user,"You could buy "..GL_Data.MaxTickets.." tickets ("..GL_FormatPrice(GL_Data.TicketPrice).." per ticket)");
	end

end

function GL_SpamGuildClick()
	local Jackpot=GL_FormatPrice(GL_CalculateJackpot());
	local text="Jackpot="..Jackpot..". > Time to buy tickets until: "..GL_FormatDate(GL_Data.LotteryDate).." > Send "..GL_FormatPrice(GL_Data.TicketPrice).." per ticket you want to "..GL.Me.." (max "..GL_Data.MaxTickets..")";
	GL_GuildChat( text);
end

function GL_GuildChat(text)
	SendChatMessage( GL_GCHAT..text, "GUILD", nil, nil );
end


function GL_RollOptionsClick()
	if (GLRollOptionsFrame:IsVisible()) then
		GLRollOptionsFrame:Hide();
	else
		GLRollOptionsFrame:Show();
	end
end