--[[
 ULM = Utility Library of Mergan
 UCM = Utilitly Class of Mergan
 
 This file provides some usefull class and functions. 
 
 functions :
	* math.round(value)
 
 class :
	* UCMScreen
	* UCMList
	* UCMStack 
	
--]]

----------------------------------------------------------------------------------------------------------------------
-- math.round
--		rounds up the incomming value if it's greater-euqal then x.5 or, rounds down if it's lower then x.5
--		exp : 2.5->3 , 2.4->2
function math.round(value)
 local floor=math.floor(value);
 
 if (value>=floor+0.5) then
	return floor+1;
 else
	return floor;
 end;
end;
----------------------------------------------------------------------------------------------------------------------
-- tonumberdef
--		returns the value if it's a valid number, otherwise returns def
function tonumberdef(value,def)
 if (value==null or tonumber(value)==null) then
	return tonumber(def);
	else
	return tonumber(value);
 end;
end;
----------------------------------------------------------------------------------------------------------------------
-- forces the value to act as boolean
function forceboolean(value)
 if (value==null or type(value)~="boolean") then
	return (value=="true" or value=="1" or value==1);
	else
	return value;
 end;
end;
----------------------------------------------------------------------------------------------------------------------
if (UCMTools==null or (UCMTools.version~=null and UCMTools.version<1.00)) then
	UCMTools = {};
	UCMTools.version = 1.00;
	
	function UCMTools.boolToString(b)
		if (b==true) then
			return "true";
		else
			return "false";
		end;
	end;
end;
----------------------------------------------------------------------------------------------------------------------
-- UCMScreen class
--
--	 PROPERTIES
--		* debug (bool)
--			indicates that it's debug mode or not
-- 	 METHODS
-- 		* Print(text,r,g,b)
--			Writes the text to the default channel. You do not have to pass r,g,b value. Default color is white (1,1,1)
--		* Debug(text,r,g,b)
--			Writes the text to the default channel if debug mode enabled. You do not have to pass r,g,b value. Default color is white (1,1,1)
----------------------------------------------------------------------------------------------------------------------
if (UCMScreen==null or (UCMScreen.version~=null and UCMScreen.version<1.00)) then
	UCMScreen = {};
	UCMScreen.version = 1.00;
   
	function UCMScreen:New()
		local o={}   -- create object
		o.debug=false;
		
		setmetatable(o,self);
		self.__index=self;
		return o;
	end

	-- Print()
	--		Writes the text to the default channel. You do not have to pass r,g,b value. Default color is white (1,1,1)
	function UCMScreen:Print(text,r,g,b)
		local rv,gv,bv;
	
		if (r==null) then
			rv=1;
		else
			rv=r;
		end;

		if (g==null) then
			gv=1;
		else
			gv=g;
		end;

		if (b==null) then
			bv=1;
		else
			bv=b;
		end;
		
		if (DEFAULT_CHAT_FRAME) then
			DEFAULT_CHAT_FRAME:AddMessage(text,rv,gv,bv);
		end;
	end;
	
	-- Debug(()
	--		Writes the text to the default channel if debug mode enabled. You do not have to pass r,g,b value. Default color is white (1,1,1)
	function UCMScreen:Debug(text,r,g,b)
		if (self.debug) then
			self:Print(text,r,g,b);
		end;
	end;
	
	function UCMScreen:Control(text,var,r,g,b)
		if (self.debug) then
			if (var==null) then
				self:Print(text.." null",r,g,b);
			else
				if (type(var)=="boolean") then
					var=UCMTools.boolToString(var);
				end;
				
				self:Print(text.." "..var,r,g,b);
			end;
		end;
	end;
	
end;
----------------------------------------------------------------------------------------------------------------------
-- UCMList class
--
--	 PROPERTIES
--		* count (int)
--		* items (list)
-- 	 METHODS
-- 		* GetCount()
-- 		* IndexOf(item)
--		* Add(item)
--		* Remove(index)		(index is [1..count])
--		* RemoveItem(item)		
--		* GetItem(index)	(index is [1..count])
--		* Clear()
----------------------------------------------------------------------------------------------------------------------
if (UCMList==null or (UCMList.version~=null and UCMList.version<1.00)) then
	UCMList = {};
	UCMList.version = 1.00;
   
	function UCMList:New()
		local o={}   -- create object
		o.count=0;
		o.items={};
		
		setmetatable(o,self);
		self.__index=self;
		return o;
	end;

	function UCMList:GetCount()
		return self.count;
	end;

	function UCMList:IndexOf(item)
		for i=1,self.count,1 do 
			if (self.items[i]==item) then
				return i;
			end;
		end;
		
		return 0;
	end;
	
	function UCMList:Add(item)
		self.count=self.count+1;
		self.items[self.count]=item;
		return count;
	end;
	
	function UCMList:Remove(index)
		if (index>0 and index<=self.count) then
			-- shift the list
			for i=index+1,self.count,1 do 
				self.items[i-1]=self.items[i];
			end;
			self.items[self.count]=null;
			self.count=self.count-1;
		end;
	end;

	function UCMList:RemoveItem(item)
		self:Remove(self:IndexOf(item));
	end;
	
	function UCMList:GetItem(index)
		if (index>0 and index<=self.count) then
			return self.items[index];
		else
			return null;
		end;
	end;

	function UCMList:Clear()
		self.count=0;
		self.items={};
	end;
end;
----------------------------------------------------------------------------------------------------------------------
-- UCMStack class
--
--	 PROPERTIES
--		* count (int)
--		* items (list)
-- 	 METHODS
-- 		* Size()			-- returns count
-- 		* GetCount()		-- returns count
-- 		* IndexOf(item)		-- returns index of item
--		* Push(item)		-- push the item to the end
--		* Pop()				-- pops the item from end and returns it
--		* Clear()			-- clears the stack
----------------------------------------------------------------------------------------------------------------------
if (UCMStack==null or (UCMStack.version~=null and UCMStack.version<1.00)) then
	UCMStack = {};
	UCMStack.version = 1.00;
   
	function UCMStack:New()
		local o={}   -- create object
		o.count=0;
		o.items={};
		
		setmetatable(o,self);
		self.__index=self;
		return o;
	end;

	function UCMStack:GetCount()
		return self.count;
	end;

	function UCMStack:Size()
		return self.count;
	end;

	function UCMStack:IndexOf(item)
		for i=1,self.count,1 do 
			if (self.items[i]==item) then
				return i;
			end;
		end;
		
		return 0;
	end;
	
	function UCMStack:Push(item)
		self.count=self.count+1;
		self.items[self.count]=item;
		return count;
	end;
		
	function UCMStack:Pop()
		if (self.count>0) then
			local result=self.items[self.count];
			self.items[self.count]=null;
			self.count=self.count-1;
			
			return result;
		else
			return null;
		end;
	end;

	function UCMStack:Clear()
		self.count=0;
		self.items={};
	end;
end;
----------------------------------------------------------------------------------------------------------------------
