
----------------------------------------------------------------------------------------------------------------------
-- marks for that screen update started
function objG15.BeginScreenUpdate()
 objG15.ScreenUpdateStack:Push(objG15.ScreenUpdateMode);
 objG15.ScreenUpdateMode=true;
end;
----------------------------------------------------------------------------------------------------------------------
-- unmarks screen update
function objG15.EndScreenUpdate()
 objG15.ScreenUpdateMode=objG15.ScreenUpdateStack:Pop();
end;
----------------------------------------------------------------------------------------------------------------------
-- show options form
function objG15.ShowOptions()
	if (G15Buttons_OptionsForm:IsVisible()) then
		G15Buttons_OptionsForm:Hide();
	else
		objG15.BeginScreenUpdate();
		G15Buttons_OptionsForm:Show();
		objG15.EndScreenUpdate();
	end;
end
----------------------------------------------------------------------------------------------------------------------
-- refresh screen from group data
function objG15.RefreshScreenFromGroup(group)
 local Activated=getglobal(objG15.UIOptionsFrameName.."_chkActivated");
 local LockMovement=getglobal(objG15.UIOptionsFrameName.."_chkLockMovement");
 local WriteText=getglobal(objG15.UIOptionsFrameName.."_chkWriteText");
 local ButtonCount=getglobal(objG15.UIOptionsFrameName.."_sliderButtonCount");
 local RowCount=getglobal(objG15.UIOptionsFrameName.."_sliderRowCount");
 local StartingButtonId=getglobal(objG15.UIOptionsFrameName.."_sliderStartingButtonId");
 local Scale=getglobal(objG15.UIOptionsFrameName.."_sliderScale");
 local AlwaysShowButtons=getglobal(objG15.UIOptionsFrameName.."_chkAlwaysShowButtons");
 local SpacePerRow=getglobal(objG15.UIOptionsFrameName.."_edtSpacePerRow");
 local SpaceOnEveryRow=getglobal(objG15.UIOptionsFrameName.."_sliderSpaceOnEveryRow");
 local SpacePerColumn=getglobal(objG15.UIOptionsFrameName.."_edtSpacePerColumn");
 local SpaceOnEveryColumn=getglobal(objG15.UIOptionsFrameName.."_sliderSpaceOnEveryColumn");
 
 objG15.LoadFrom(group);

 objG15.BeginScreenUpdate();
 
 Activated:SetChecked(group.activated);
 LockMovement:SetChecked(group.lockMovement);
 WriteText:SetChecked(group.writeButtonId);
 ButtonCount:SetValue(group.buttonCount);
 RowCount:SetValue(group.rowCount);
 StartingButtonId:SetValue(group.startingButtonID);
 Scale:SetValue(group.scale);
 AlwaysShowButtons:SetChecked(group.alwaysShowButtons);
 SpacePerRow:SetText(group.spacePerRow);
 SpaceOnEveryRow:SetValue(group.spaceAfterEveryXRow);
 SpacePerColumn:SetText(group.spacePerColumn);
 SpaceOnEveryColumn:SetValue(group.spaceAfterEveryXColumn);

 objG15.EndScreenUpdate();
end;
----------------------------------------------------------------------------------------------------------------------
-- applies screen to group data
function objG15.ApplyScreenToGroup(group)
 local Activated=getglobal(objG15.UIOptionsFrameName.."_chkActivated");
 local LockMovement=getglobal(objG15.UIOptionsFrameName.."_chkLockMovement");
 local WriteText=getglobal(objG15.UIOptionsFrameName.."_chkWriteText");
 local ButtonCount=getglobal(objG15.UIOptionsFrameName.."_sliderButtonCount");
 local RowCount=getglobal(objG15.UIOptionsFrameName.."_sliderRowCount");
 local StartingButtonId=getglobal(objG15.UIOptionsFrameName.."_sliderStartingButtonId");
 local Scale=getglobal(objG15.UIOptionsFrameName.."_sliderScale");
 local AlwaysShowButtons=getglobal(objG15.UIOptionsFrameName.."_chkAlwaysShowButtons");
 local SpacePerRow=getglobal(objG15.UIOptionsFrameName.."_edtSpacePerRow");
 local SpaceOnEveryRow=getglobal(objG15.UIOptionsFrameName.."_sliderSpaceOnEveryRow");
 local SpacePerColumn=getglobal(objG15.UIOptionsFrameName.."_edtSpacePerColumn");
 local SpaceOnEveryColumn=getglobal(objG15.UIOptionsFrameName.."_sliderSpaceOnEveryColumn");
 
 group.activated=(Activated:GetChecked()==1);
 group.lockMovement=(LockMovement:GetChecked()==1);
 group.writeButtonId=(WriteText:GetChecked()==1);
 group.buttonCount=tonumberdef(ButtonCount:GetValue(),1);
 group.rowCount=tonumberdef(RowCount:GetValue(),1);
 group.startingButtonID=tonumberdef(StartingButtonId:GetValue(),73);
 group.scale=tonumberdef(Scale:GetValue(),1);
 group.alwaysShowButtons=(AlwaysShowButtons:GetChecked()==1);
 group.spacePerRow=tonumberdef(SpacePerRow:GetText(),1);
 group.spaceAfterEveryXRow=tonumberdef(SpaceOnEveryRow:GetValue(),0);
 group.spacePerColumn=tonumberdef(SpacePerColumn:GetText(),1);
 group.spaceAfterEveryXColumn=tonumberdef(SpaceOnEveryColumn:GetValue(),0);
 
 objG15.SaveGroup(group);
end;
----------------------------------------------------------------------------------------------------------------------
-- on group listbox show
function objG15.OnShowLBGroups(sender)
	UIDropDownMenu_Initialize(sender,objG15.InitializeGroupListBox);
end;
----------------------------------------------------------------------------------------------------------------------
-- selects group listbox item
function objG15.SelectLBGroupsItem(objDropDown,index)
 UIDropDownMenu_SetSelectedID(objDropDown,index);	
 -- refresh information
 objG15.RefreshScreenFromGroup(objG15.ButtonGroups[index]);
end;
----------------------------------------------------------------------------------------------------------------------
function objG15.OnChangeLBGroups()
 -- anladigim kadari ile this=seilen item'in (DropDownMenu'nn degil) kendisi
 -- dolayisiyla this.value kullanilabilir
 objG15.SelectLBGroupsItem(this.owner,this:GetID());
 UIDropDownMenu_SetSelectedValue(this);
end
----------------------------------------------------------------------------------------------------------------------
-- fills combo box with items
function objG15.InitializeGroupListBox()
 local info;
 local dropdown=getglobal("G15Buttons_OptionsForm_LBGroups");
  
 for i=1,objG15.ButtonGroups.count,1 do
	info =	{
		    text=objG15.ButtonGroups[i].caption;
		    func=objG15.OnChangeLBGroups;
		    owner=dropdown;
		    value={text=objG15.ButtonGroups[i].caption;id=objG15.ButtonGroups[i].id;};
			};
	UIDropDownMenu_AddButton(info);
 end; -- for
end;
----------------------------------------------------------------------------------------------------------------------
-- apply form data
function objG15.ApplyOptionsForm()
 local dropdown=getglobal("G15Buttons_OptionsForm_LBGroups");
 local selectedIndex=UIDropDownMenu_GetSelectedID(dropdown);

 if (objG15.ScreenUpdateMode==false and selectedIndex~=null and selectedIndex>=1 and selectedIndex<=objG15.ButtonGroups.count) then
	objG15.ApplyScreenToGroup(objG15.ButtonGroups[selectedIndex]);
	objG15.CreateButtonGroup(objG15.ButtonGroups[selectedIndex]);
 end;
end;
----------------------------------------------------------------------------------------------------------------------
-- on any visible option on form changed (related to group)
function objG15.onOptionChanged(sender)
 objG15.ApplyOptionsForm();
end;
----------------------------------------------------------------------------------------------------------------------
function objG15.onFormShow()
 local dropdown=getglobal("G15Buttons_OptionsForm_LBGroups");
 
 objG15.BeginScreenUpdate();
 objG15.SelectLBGroupsItem(dropdown,1);
 objG15.EndScreenUpdate();
end;
----------------------------------------------------------------------------------------------------------------------
-- caption : string
-- strings = {"a","b","c"} : string array
function objG15.ShowHint(caption,strings)
	GameTooltip_SetDefaultAnchor(GameTooltip,UIParent);
	GameTooltip:SetText(objG15.COLOR_WHITE..caption);
	for id,value in pairs(strings) do
		GameTooltip:AddLine(objG15.COLOR_GOLD..value);
	end;
	GameTooltip:Show();
end;
----------------------------------------------------------------------------------------------------------------------
function objG15.ResetPositionOfCurrentGroup()
 local dropdown=getglobal("G15Buttons_OptionsForm_LBGroups");
 local selectedIndex=UIDropDownMenu_GetSelectedID(dropdown);
 
 if (selectedIndex~=null and selectedIndex>=1 and selectedIndex<=objG15.ButtonGroups.count) then
	objG15.ResetPositionOfGroup(objG15.ButtonGroups[selectedIndex]);
	objG15.RefreshScreenFromGroup(objG15.ButtonGroups[selectedIndex]);
	end;
end;
----------------------------------------------------------------------------------------------------------------------
