--[[
	Logitech G-15 Buttons Addon - Eyyub Volkan ektimur (eyyubvolkan@yahoo.com)
	
	This add-on provides groups of action buttons. In actual, there are 3 groups of buttons you can create. To use this add-on you DO NOT need 
	logitech G-15 keyboard or any other special stuff. 
	
	So why the name is G15 Buttons ? Because of, the idea has come related to my new G-15 keyboard :) And button groups are optimized for the keyboard. 
	But also you can change all the settings via options form. 
	
	You can create upto 24 buttons per group and can change starting id of buttons. You can also change the row count, offset, scale and someother options. 
	You can create a group of buttons and move it where ever you want. You can change all the parameters with options dialog (/g15).
	
	Also you can bind keys (any key, even normal keyboard keys :) via 'Key Bindings' in-game menu.

	for options;
	/g15 
	
todo list;
----------------------
* code revamp
* localization support
* new binding interface
* more button groups (6)
* tabbed frame to view more than 1 group in the same place
* mode/group change binding - related to previous todo item- will change visible mode/group
* visibility of groups
* "restore to default layout" button
* more screenshots
* options form - more explanation and much ease for "starting button id" field

key bindings examples
	read "on Key Down-Up.txt" and "onKeyDown , onKeyUp, onMouseDown, onMouseUp, onMouseWheel.txt"

known bugs;
------------------------


Change Log
---------------

1.07 (15.05.2008)
	* (fixed) drag & drop bug fixed
	* (fixed) redraw bug of hidden buttons (if "always show buttons" is disabled)
 
1.06 (27.03.2008)
	* (update) .toc update for WoW 2.4.0

1.05 (01.12.2007)
	* (fixed) nil value error when moving bar while options dialog is open

1.04 (19.11.2007)
	* (fixed) wrong size of mover bar after switching bars in options dialog
	* (update) .toc update for WoW 2.3.0

1.03 (08.10.2007)

	* (fixed) locked frames are no longer jumping around or out of screen
	* (fixed) key bindings now for 3 x 24 keys 

1.02n1 (28.09.2007)

	* (fixed) Tooltip error (Xinda)
	* (fixed) symbol redraw bug (Xinda)
	* (update) .toc update for WoW 2.2.0 (Xinda)

------------------------

1.02

	* only .toc update

1.01
	* button group defaults have been fixed
	* (fixed) version bug
	* (fixed) some minor bugs
	* tring to fix disappearing of groups. Added "Reset Position" button onto options form.
	* added xOffset & yOffset edit box onto options form, for editing movement of selected group
1.00 
	* first release
0.70b
	* minor bug fixes
	* (fixed) button grid show errors still exist. "Always show buttons" code revamp.
	* (fixed) width overflow on shortcut hints
	* (fixed) edit box changes does not trigger apply
0.60b
	* (fixed) keybinding changed does not effect while you relog or recreate buttons.
	* (fixed) what if created button's id passes 120 ?
	* (new) show button ids on buttons
	* (new) hints for every visible object on options window
	* (fixed) key-binding hint text overflows
	* (fixed) Always show buttons option does not work correctly
	* (fixed) time to time, buttons background textures becomes more darker then normal.
	* (new) more localization support
0.50b
	* alwaysShowButtons fixed
	* 3 groups of buttons
	* options form added
	* save/load support added
	* the first beta of addon
0.10b
	* code start
--]]
	
-- objG15 and other variables are defined at Definitions.lua ---------------------------------------------------------
-- objG15 and other variables are defined at Definitions.lua ---------------------------------------------------------
-- objG15 and other variables are defined at Definitions.lua ---------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------
-- load group data from saved data
function objG15.LoadFrom(group)
 local loadFrom=objG15SavedDatas.ButtonGroups[group.id];
 
 if (loadFrom~=null) then
	group.buttonCount=tonumberdef(loadFrom.buttonCount,1);
	group.rowCount=tonumberdef(loadFrom.rowCount,1);
	group.startingButtonID=tonumberdef(loadFrom.startingButtonID,73);
	group.scale=tonumberdef(loadFrom.scale,1);
	group.alwaysShowButtons=forceboolean(loadFrom.alwaysShowButtons);
	group.spacePerRow=tonumberdef(loadFrom.spacePerRow,1);
	group.spaceAfterEveryXRow=tonumberdef(loadFrom.spaceAfterEveryXRow,0);
	group.spacePerColumn=tonumberdef(loadFrom.spacePerColumn,1);
	group.spaceAfterEveryXColumn=tonumberdef(loadFrom.spaceAfterEveryXColumn,0);
	group.activated=forceboolean(loadFrom.activated);
	group.lockMovement=forceboolean(loadFrom.lockMovement);
	group.writeButtonId=forceboolean(loadFrom.writeButtonId);
	
	if (loadFrom.framePosition~=null) then
		group.framePosition.point=loadFrom.framePosition.point;
		group.framePosition.relativePoint=loadFrom.framePosition.relativePoint;
		group.framePosition.xOfs=tonumberdef(loadFrom.framePosition.xOfs,300);
		group.framePosition.yOfs=tonumberdef(loadFrom.framePosition.yOfs,-300);	
		end;
	end;
end;
----------------------------------------------------------------------------------------------------------------------
-- save group data to save data
function objG15.SaveGroup(group)
 if (objG15SavedDatas.ButtonGroups[group.id]==null) then
	objG15SavedDatas.ButtonGroups[group.id]={};
 end;
 
 local saveTo=objG15SavedDatas.ButtonGroups[group.id];
 
 saveTo.buttonCount=group.buttonCount;
 saveTo.rowCount=group.rowCount;
 saveTo.startingButtonID=group.startingButtonID;
 saveTo.scale=group.scale;
 saveTo.alwaysShowButtons=group.alwaysShowButtons;
 saveTo.spacePerRow=group.spacePerRow;
 saveTo.spaceAfterEveryXRow=group.spaceAfterEveryXRow;
 saveTo.spacePerColumn=group.spacePerColumn;
 saveTo.spaceAfterEveryXColumn=group.spaceAfterEveryXColumn;
 saveTo.activated=group.activated;
 saveTo.lockMovement=group.lockMovement;
 saveTo.writeButtonId=group.writeButtonId;
 
 saveTo.framePosition={};
 saveTo.framePosition.point=group.framePosition.point;
 saveTo.framePosition.relativePoint=group.framePosition.relativePoint;
 saveTo.framePosition.xOfs=group.framePosition.xOfs;
 saveTo.framePosition.yOfs=group.framePosition.yOfs;
end;
----------------------------------------------------------------------------------------------------------------------
function objG15.onLoaded()
 objG15.Screen:Debug("Addon Load");
 
 objG15.Screen.debug=objG15.DEBUGMODE;
 objG15.Screen:Print(string.format(G15BUTTONS_ST_WELCOMETEXT,UnitName("player").."@"..GetCVar("realmName")),0.5,0.5,0.8);
 
 objG15.Screen:Debug("Debug Mode...");
 objG15.doLocalization() ;	-- function defined at definitions.lua
 
 -- Register Slash Commands
 SlashCmdList["G15BUTTONS"]=objG15.OnSlashCommand;
	SLASH_G15BUTTONS1="/g15"; 
end;
----------------------------------------------------------------------------------------------------------------------
function objG15.convertLoadGroupDataFromVersion_1(group)
 local loadFrom=objG15SavedDatas.ButtonGroups[group.id];
 local ver=0;
 
 if (objG15SavedDatas.Version~=null) then
	ver=objG15SavedDatas.Version;
	end;
	
 objG15.Screen:Print("Converting G15Data["..group.id.."] from version "..ver);
		
 if (loadFrom~=null) then
	if (type(loadFrom.activated)~="boolean") then
		group.activated=(loadFrom.activated==1);
		end;
	if (type(loadFrom.lockMovement)~="boolean") then
		group.lockMovement=(loadFrom.lockMovement==1);
		end;
	if (type(loadFrom.writeButtonId)~="boolean") then
		group.writeButtonId=(loadFrom.writeButtonId==1);
		end;
	if (type(loadFrom.alwaysShowButtons)~="boolean") then
		group.alwaysShowButtons=(loadFrom.alwaysShowButtons==1);
		end;
 end;
end;
----------------------------------------------------------------------------------------------------------------------
function objG15.VariablesLoaded()
 objG15.Screen:Debug("Variables Load");

 for i=1,objG15.ButtonGroups.count,1 do
	objG15.LoadFrom(objG15.ButtonGroups[i])
	
	if (type(objG15SavedDatas.Version)=="table") then
		objG15SavedDatas.Version=1;
	end;

	-- convert version 1 data to 2 --------------------------
	if (objG15SavedDatas.Version==null or objG15SavedDatas.Version<2) then
		objG15.convertLoadGroupDataFromVersion_1(objG15.ButtonGroups[i]);
		end;
 end;  
 
 -- after load
 objG15SavedDatas.Version=objG15.CURRENTSAVEVERSION; 
end;
----------------------------------------------------------------------------------------------------------------------
function objG15.PlayerLogin()
 objG15.Screen:Debug("Login");
 -- create buttons because of key-binding functions does not work onLoad
 for i=1,objG15.ButtonGroups.count,1 do
	objG15.CreateButtonGroup(objG15.ButtonGroups[i]);
 end; 
end;
----------------------------------------------------------------------------------------------------------------------
function objG15.UpdateButtonBinding(sender)
 local group=objG15.GroupFromButton(sender);
 local btnIndex=sender.index;
 local KeyBound=GetBindingKey("G15BUTTONS_BINDINGS_"..group.id.."_"..btnIndex);
 
 if (KeyBound~=null) then
	SetOverrideBinding(UIParent,false,KeyBound);
 end;
 
 if (KeyBound~=null and group.activated) then
	SetOverrideBindingClick(UIParent,false,KeyBound,sender:GetName());
 end;
end;
----------------------------------------------------------------------------------------------------------------------
-- returns group from frame
function objG15.GroupFromFrame(bar)
 local index=bar.groupId;
 
 if (index~=null) then
	return objG15.ButtonGroups[index];
 else
	return null;
 end;
end;
----------------------------------------------------------------------------------------------------------------------
-- returns group from button
function objG15.GroupFromButton(btn)
 local index=btn.groupId;
 
 if (index~=null) then
	return objG15.ButtonGroups[index];
 else
	return null;
 end;
end;
----------------------------------------------------------------------------------------------------------------------
function objG15.onButtonEvent(btn)
 if (event=="UPDATE_BINDINGS") then
	ActionButton_OnEvent(event);
	objG15.UpdateButtonBinding(this);
 elseif (event=="ACTIONBAR_SHOWGRID") then
	ActionButton_ShowGrid(btn);
	btn:SetAttribute("showgrid",1);			-- set for "showed once"
 elseif (event=="ACTIONBAR_HIDEGRID") then
	local group=objG15.GroupFromButton(btn);
	if (group==null or group.alwaysShowButtons==null or group.alwaysShowButtons==false) then
		btn:SetAttribute("showgrid",1);		-- set for "showed once before, ActionButton_HideGrid() will decrease the number"
		ActionButton_HideGrid(btn);

		objG15.CreateButtonGroup(group);
	end;
 elseif (event == "PLAYER_ENTERING_WORLD") then
	local group=objG15.GroupFromButton(btn);
	if (group==null or group.alwaysShowButtons==null or group.alwaysShowButtons==false) then
		objG15.CreateButtonGroup(group);
	end;
 else
	ActionButton_OnEvent(event);
 end;
end;
----------------------------------------------------------------------------------------------------------------------
function objG15.onButtonHint(btn)
 local group=objG15.GroupFromButton(btn);

 ActionButton_SetTooltip(btn);
 if (group~=null) then
	local keybind=GetBindingKey("G15BUTTONS_BINDINGS_"..group.id.."_"..btn.index);
	if (keybind~=null) then
		GameTooltip:AddLine("|cffffcc00");
		GameTooltip:AddLine("|cff44ff44 "..keybind);
		GameTooltip:SetHeight(GameTooltip:GetHeight()+27);
		GameTooltip:SetWidth(math.max(GameTooltip:GetWidth(),string.len(keybind)*9));
	end;
 end;
end;
----------------------------------------------------------------------------------------------------------------------
-- deletes/pools the created frames/buttons
function objG15.DeleteButtonGroup(group)
 objG15.ClearBindings(group);
 
 if (group.createdBar~=null) then
	objG15.pooledObjects.frames:Add(group.createdBar);
	group.createdBar:SetParent(UIParent);
--	group.createdBar:SetPoint("TOPLEFT",UIParent,"TOPRIGHT",-1000,-1000);
	group.createdBar:ClearAllPoints();
	group.createdBar:Hide();
	group.createdBar.groupId=null;
	group.createdBar=null;
 end;
 
 for i=1,group.createdButtons:GetCount(),1 do
	local btn=group.createdButtons:GetItem(i);
	objG15.pooledObjects.buttons:Add(btn);
	btn:SetParent(UIParent);
	btn:SetAttribute("*action*",0);
	btn:SetPoint("TOPLEFT",UIParent,"TOPLEFT",-1000,1000);
	btn:Disable();
	btn:Hide();
	btn.groupId=null;
 end;
 group.createdButtons:Clear();
end;
----------------------------------------------------------------------------------------------------------------------
-- if an empty frame found in the pool then returns it, otherwise creates a new frame and returns it
function objG15.CreateFrame()
 if (objG15.pooledObjects.frames:GetCount()>0) then
	local result=objG15.pooledObjects.frames:GetItem(objG15.pooledObjects.frames:GetCount());
	objG15.pooledObjects.frames:Remove(objG15.pooledObjects.frames:GetCount());
	return result;
	else
	objG15.LastGiveId=objG15.LastGiveId+1;
	return CreateFrame("Frame",objG15.UIObjectPrefix..objG15.UIBarPrefix..objG15.LastGiveId,UIParent,"G15Buttons_BarTemplate");	
	end;
end;
----------------------------------------------------------------------------------------------------------------------
-- if an empty button found in the pool then returns it, otherwise creates a new button and returns it
function objG15.CreateButton(parent)
 if (objG15.pooledObjects.buttons:GetCount()>0) then
	local result=objG15.pooledObjects.buttons:GetItem(objG15.pooledObjects.buttons:GetCount());
	objG15.pooledObjects.buttons:Remove(objG15.pooledObjects.buttons:GetCount());
	return result;
	else
	objG15.LastGiveId=objG15.LastGiveId+1;
	return CreateFrame("CheckButton",objG15.UIObjectPrefix..objG15.UIButtonPrefix..objG15.LastGiveId,parent,"G15Buttons_ButtonTemplate");			
	end;
end;
----------------------------------------------------------------------------------------------------------------------
-- clears group bindings
function objG15.ClearBindings(group)
 for i=1,24,1 do
	local KeyBound=GetBindingKey("G15BUTTONS_BINDINGS_"..group.id.."_"..i);
	if (KeyBound~=null) then
		SetOverrideBinding(UIParent,false,KeyBound);
		end;
 end;
end;
----------------------------------------------------------------------------------------------------------------------
function objG15.UpdateKeyBindingsOfGroup(group)
 objG15.ClearBindings(group); 
 
 if (group.activated) then
	for i=1,group.createdButtons.count do
		local KeyBound=GetBindingKey("G15BUTTONS_BINDINGS_"..group.id.."_"..group.createdButtons.items[i].index);
		if (KeyBound~=null) then
			SetOverrideBindingClick(UIParent,false,KeyBound,group.createdButtons.items[i]:GetName());
		end;
	end;
 end;
end;
----------------------------------------------------------------------------------------------------------------------
function objG15.ResetPositionOfGroup(group)
if (group~=null) then
	group.framePosition.point="TOPLEFT";
	group.framePosition.relativePoint="TOPLEFT";
	group.framePosition.xOfs=300;
	group.framePosition.yOfs=-300;
	
	group.createdBar:SetPoint(group.framePosition.point,UIParent,group.framePosition.relativePoint,group.framePosition.xOfs,group.framePosition.yOfs);
	objG15.SaveGroup(group);
 end;
end;
----------------------------------------------------------------------------------------------------------------------
-- re-create/create all group
function objG15.CreateButtonGroup(group)

 local backup_valid	= false;
 local backup_point	= "TOPLEFT";
 local backup_rpoint	= "TOPRIGHT";
 local backup_xOfs	= 0;
 local backup_yOfs	= 0;

 if (group.activated) then 

	backup_point	= group.framePosition.point;
	backup_rpoint	= group.framePosition.relativePoint;
	backup_xOfs	= group.framePosition.xOfs;
	backup_yOfs	= group.framePosition.yOfs;
	backup_valid	= true;

--	objG15.Screen:Debug(string.format("point: %s  rpoint: %s",backup_point,backup_rpoint));
-- 	objG15.Screen:Debug(string.format("xOfs: %.2f  yOfs: %.2f",backup_xOfs,backup_yOfs));

 end;

 objG15.DeleteButtonGroup(group);

 
 if (group.activated and group.buttonCount>0 and group.rowCount>0) then
	local buttonPerRow=math.round(group.buttonCount/group.rowCount);
	local moveBar=null;
	local createdButtonCount=0;
	local buttonID=group.startingButtonID;
	local Anchor="TOPLEFT";
	local AnchorTo="TOPRIGHT";
	local AnchorToObject=null;
	local RowsFirstButton=null;
	local offsetX=0;
	local offsetY=0;

	moveBar=objG15.CreateFrame();


	group.createdBar=moveBar;



	moveBar.groupId=group.id;
	if (group.framePosition.yOfs>moveBar:GetHeight()) then
		group.framePosition.yOfs=0;
	end;
	if (group.framePosition.xOfs<-(moveBar:GetWidth()*2)) then
		group.framePosition.xOfs=0;
	end;

	if (backup_valid) then
		group.framePosition.point		= backup_point;
		group.framePosition.relativePoint 	= backup_rpoint;
		group.framePosition.xOfs		= backup_xOfs;
		group.framePosition.yOfs		= backup_yOfs;
	end;




--	moveBar:SetPoint(group.framePosition.point,UIParent,group.framePosition.relativePoint,group.framePosition.xOfs,group.framePosition.yOfs);
	group.createdBar:SetPoint(group.framePosition.point,UIParent,group.framePosition.relativePoint,group.framePosition.xOfs,group.framePosition.yOfs);
							
	if (tonumber(group.spacePerColumn)==null) then
		group.spacePerColumn=0;
		end;
	if (tonumber(group.spacePerRow)==null) then
		group.spacePerRow=0;
		end;	
		
	AnchorToObject=moveBar;
	for row=1,group.rowCount,1 do 
		for column=1,buttonPerRow,1 do
			-- if you give moveBar for parent and if the move bar is invisible at the begining (loading) , buttons do not appears on screen, don't know why ?
			local btn=objG15.CreateButton(UIParent);
			createdButtonCount=createdButtonCount+1;

			btn:Enable();
			-- if a button is a created one, an update message will sent to it (<onLoad> ActionButton_Update() </onLoad>), and there is a code inside
			-- that shows/hides the button according to "showgrid". if it's 1 it will show the button, otherwise it will hide.
			if (group.alwaysShowButtons==true) then
				ActionButton_ShowGrid(btn);
				btn:SetAttribute("showgrid",1);
			else
				btn:SetAttribute("showgrid",1);
				ActionButton_HideGrid(btn);
			end;
				
			btn:SetPoint(Anchor,AnchorToObject,AnchorTo,offsetX,offsetY);
			btn:SetAttribute("*action*",buttonID);
			btn:SetScale(group.scale);
			btn.groupId=group.id;
			btn.index=createdButtonCount;
			btn.buttonId=buttonID;
			group.createdButtons:Add(btn);

			if (group.writeButtonId) then
				btn:SetText(buttonID);
				btn:SetTextColor(1,1,1);
				btn:SetTextFontObject("GameFontNormalLarge");
				else
				btn:SetText("");
				end;
			
			if (column==1) then
				RowsFirstButton=btn;
			end;
			
			AnchorToObject=btn;
			Anchor="TOPLEFT";
			AnchorTo="TOPRIGHT";
			offsetX=objG15.btnOffsetX;
			offsetY=0;
		
			if (group.spaceAfterEveryXColumn>0 and (column%group.spaceAfterEveryXColumn)==0) then
				offsetX=offsetX+group.spacePerColumn;
			end;
		
			buttonID=buttonID+1;
			
			if (createdButtonCount>=group.buttonCount or buttonID>120) then
				break;
				end;
		end; -- for
		
		AnchorToObject=RowsFirstButton;
		Anchor="TOPLEFT";
		AnchorTo="BOTTOMLEFT";
		offsetX=0;
		offsetY=-objG15.btnOffsetY;
		if (group.spaceAfterEveryXRow>0 and (row%group.spaceAfterEveryXRow)==0) then
			offsetY=offsetY-group.spacePerRow;
		end;
	end; -- for
		
	objG15.UpdateKeyBindingsOfGroup(group);

--	objG15.LoadFrom(group);
--	group.createdBar:SetPoint(group.framePosition.point,UIParent,group.framePosition.relativePoint,group.framePosition.xOfs,group.framePosition.yOfs);
	
	if (group.lockMovement) then
		moveBar:Hide();
		else
		moveBar:Show();
		end;
	end; -- if
end;
----------------------------------------------------------------------------------------------------------------------
-- slash commands
function objG15.OnSlashCommand(msg)
 if (objG15.DEBUGMODE and msg=="1") then
	objG15.CreateButtonGroup(objG15.ButtonGroups[1]);
 elseif (objG15.DEBUGMODE and msg=="2") then
	objG15.DeleteButtonGroup(objG15.ButtonGroups[1]);
 else
	objG15.ShowOptions();	-- function defined at OptionsForm.lua
 end;
end
----------------------------------------------------------------------------------------------------------------------
-- happens when the anchor frame moved
function objG15.onFrameMoved(sender)
 local group=objG15.GroupFromFrame(sender);

 if (group~=null) then		
	group.framePosition.point,_,group.framePosition.relativePoint,group.framePosition.xOfs,group.framePosition.yOfs=group.createdBar:GetPoint();
	objG15.SaveGroup(group);
 end;
end;
----------------------------------------------------------------------------------------------------------------------