local Tablet = AceLibrary("Tablet-2.0")
local L = Rock("LibRockLocale-1.0"):GetTranslationNamespace("FuBar_AtlasFu2")

AtlasFu2 = Rock:NewAddon("AtlasFu2", "LibRockConfig-1.0", "LibRockDB-1.0", "LibFuBarPlugin-3.0")

AtlasFu2:SetDatabase("AtlasFu2DB")
AtlasFu2:SetDatabaseDefaults("profile", {})

AtlasFu2:SetFuBarOption("iconPath", "Interface\\AddOns\\Fubar_AtlasFu2\\Images\\Icon")
AtlasFu2:SetFuBarOption("defaultPosition", "RIGHT")
AtlasFu2:SetFuBarOption("tooltipType", "Tablet-2.0")

function AtlasFu2:OnInitialize()
	local optionsTable = {
		name = "FuBar_AtlasFu2",
		desc = L["A FuBar button to load Atlas."],
		handler = AtlasFu2,
		type = "group",
		args = {}
	}

	AtlasFu2:SetConfigTable(optionsTable)
	AtlasFu2.OnMenuRequest = optionsTable
end

function AtlasFu2:OnUpdateFuBarText()
	if (self:IsFuBarTextShown()) then
		self:ShowFuBarText()
		self:SetFuBarText("|cffffffff"..L["Atlas"].."|r")
	else
		self:HideFuBarText()
	end
end

function AtlasFu2:OnUpdateFuBarTooltip()
	Tablet:SetHint(L["Click to show Atlas."])
end

function AtlasFu2:OnFuBarClick(button)
	Atlas_Toggle()
end
