local Tablet = AceLibrary("Tablet-2.0")
local BC = AceLibrary("Babble-Class-2.2")
local L = AceLibrary("AceLocale-2.2"):new("uGuild")

uGuild = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "FuBarPlugin-2.0", "AceDB-2.0")
uGuild.hasIcon = true
uGuild.clickableTooltip = true


function uGuild:OnEnable()
	self:RegisterDB("uGuildDB")
	self:RegisterDefaults('profile', {
		showMOTD = false,
		showNotes = false,
	})

	self:RegisterEvent("GUILD_ROSTER_UPDATE", "UpdateData")
	self:RegisterEvent("PLAYER_GUILD_UPDATE", "UpdateData")
	self:RegisterEvent("PLAYER_ENTERING_WORLD", "UpdateData")
	self:RegisterEvent("CHAT_MSG_SYSTEM")

	-- Quick hack to prevent being spammed with "You are not in a guild" every 5 minutes
	if IsInGuild() then
		self:ScheduleRepeatingEvent(self.name, GuildRoster, 300)
	end

	self.OnMenuRequest = {
		type = "group",
		handler = self,
		args = {
			motd = {
				type = "toggle",
				name = L["Toggle MotD"],
				desc = L["Toggle display of the Guild Message of the Day"],
				get  = function() return self.db.profile.showMOTD end,
				set  = function(v)
					self.db.profile.showMOTD = v
					self:UpdateTooltip()
				end,
			},
			notes = {
				type = "toggle",
				name = L["Toggle Player Notes"],
				desc = L["Toggle display of the Player Notes"],
				get  = function() return self.db.profile.showNotes end,
				set  = function(v)
					self.db.profile.showNotes = v
					self:UpdateTooltip()
				end,
			},
		},
	}

	self:RegisterChatCommand({"/uguild", "/ug"}, self.OnMenuRequest)
	self:UpdateData()
end

function uGuild:OnDisable()
	self:UnregisterAllEvents()
	self:CancelAllScheduledEvents()
end

function uGuild:CHAT_MSG_SYSTEM()
	if string.find(arg1, L["has come online"] or string.find(arg1, L["has gone offline"])) then
		self:UpdateData()
	end
end

function uGuild:OnDataUpdate()
	if IsInGuild() then
		GuildRoster()

		if not self:IsEventScheduled(self.name) then
			self:ScheduleRepeatingEvent(self.name, GuildRoster, 300)
		end

		self.guildSize = GetNumGuildMembers(true) or 0
		self.guildName = GetGuildInfo("player") or "Lonely Soul"
		self.guildMOTD = GetGuildRosterMOTD()
		self.guildOnline = 0

		for i = 1, self.guildSize do
			local _, _, _, _, _, _, _, _, connected = GetGuildRosterInfo(i)
			if connected then
				self.guildOnline = self.guildOnline + 1
			end
		end

		self:UpdateText()
	end
end

function uGuild:OnClick()
	if FriendsFrame:IsVisible() then
		HideUIPanel(FriendsFrame)
	else
		ToggleFriendsFrame(3)
		FriendsFrame_Update()
	end
end


function uGuild:OnTextUpdate()
	if IsInGuild() then
		self:SetText(string.format("%d/%d", self.guildOnline, self.guildSize))
	else
		self:SetText(L["No Guild"])
	end
end


function uGuild:OnTooltipUpdate()
	if IsInGuild() then
		Tablet:SetTitle(self.guildName)

		local cat

		if self.db.profile.showMOTD then
			cat = Tablet:AddCategory("columns", 1)
			cat:AddLine("text", self.guildMOTD, "wrap", true)
		end

		local nCats = (self.db.profile.showNotes and 4) or 3

		cat = Tablet:AddCategory("columns", nCats)

		if self.guildSize > 0 then
			if nCats == 3 then
				cat:AddCategory(
					"text", L["Name"],
					"text2", L["Level"],
					"text3", L["Area"]
				)
			else
				cat:AddCategory(
					"text", L["Name"],
					"text2", L["Level"],
					"text3", L["Note"],
					"text4", L["Area"]
				)
			end
		end

		for i=1, self.guildSize do
			local name, rank, rankIndex, level, class, area, note, officernote, connected, status = GetGuildRosterInfo(i)
			if connected then
				if nCats == 4 then
					cat:AddLine(
						"text", string.format("|cff%s%s|r", BC:GetHexColor(class) or "000000", name),
						"justify", "LEFT",
						"text2", level or "",
						"justify2", "RIGHT",
						"text3", string.format("%s %s", note or "", officernote or ""),
						"text4", area or "",
						"func", "WhisperPlayer",
						"arg1", self,
						"arg2", name
					)
				else
					cat:AddLine(
						"text", string.format("|cff%s%s|r", BC:GetHexColor(class) or "000000", name),
						"justify", "LEFT",
						"text2", level or "",
						"justify2", "RIGHT",
						"text3", area or "",
						"func", "WhisperPlayer",
						"arg1", self,
						"arg2", name
					)
				end
			end
		end

		Tablet:SetHint(L["Click a name to start whispering to them"])
	else
		Tablet:AddCategory():AddLine("text", L["Not in guild"])
	end
end

function uGuild:WhisperPlayer(name)
	if name then
		SetItemRef(string.format("player:%s", name), string.format("|Hplayer:%s|h[%s|h", name, name), "LeftButton")
	end
end
