local dewdrop = AceLibrary("Dewdrop-2.0")
local tablet = AceLibrary("Tablet-2.0")
local BC = AceLibrary("Babble-Class-2.2")

local L = AceLibrary("AceLocale-2.2"):new("uFriends")

uFriends = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "FuBarPlugin-2.0", "AceDB-2.0")
uFriends.hasIcon = true
uFriends.clickableTooltip = true
uFriends:RegisterDB("uFriendsDB")

function uFriends:OnEnable()
	self:RegisterEvent("FRIENDLIST_UPDATE", "UpdateData")
	self:RegisterEvent("PLAYER_ENTERING_WORLD", "UpdateData")
	self:RegisterEvent("CHAT_MSG_SYSTEM")

	self:ScheduleRepeatingEvent(self.name, ShowFriends, 300)

	self:UpdateData()
end

function uFriends:OnDisable()
	self:UnregisterAllEvents()
	self:CancelAllScheduledEvents()
end

function uFriends:CHAT_MSG_SYSTEM()
	if (string.find(arg1, L["has come online"]) or string.find(arg1, L["has gone offline"])) then
		self:OnDataUpdate()
	end
end

function uFriends:OnDataUpdate()
	self.total = GetNumFriends() or 0
	self.online = 0

	if not self.friends then self.friends = {} end

	for i = 1, self.total do
		local name, level, class, area, connected = GetFriendInfo(i)

		if name then
			if connected then
				self.friends[name] = {}

				local t = self.friends[name]
				t.level = level
				t.class = class
				t.area  = area
				self.online = self.online + 1

			elseif self.friends[name] then
				self.friends[name] = nil
			end
		end
	end

	self:UpdateText()
end

function uFriends:OnClick()
	if FriendsFrame:IsVisible() then
		HideUIPanel(FriendsFrame)
	else
		ToggleFriendsFrame(1)
		FriendsFrame_Update()
	end
end


function uFriends:OnTextUpdate()
	if self.online > 0 then
		self:SetText(string.format("%d/%d", self.online, self.total))
	elseif self.total > 0 then
		self:SetText(string.format("0/%d", self.total))
	else
		self:SetText(L["No Friends"])
	end
end


function uFriends:OnTooltipUpdate()
	if self.total > 0 then
		tablet:SetTitle("Friends")
		local cat = tablet:AddCategory("columns", 3)

		cat:AddCategory(
			"text", L["Name"],
			"text2", L["Level"],
			"text3", L["Area"]
		)

		for name, data in pairs(self.friends) do
			cat:AddLine(
				"text", string.format("|cff%s%s|r", BC:GetHexColor(data.class) or "000000", name),
				"justify", "LEFT",
				"text2", data.level or "",
				"justify2", "RIGHT",
				"text3", data.area or "",
				"func", "WhisperPlayer",
				"arg1", self,
				"arg2", name
			)
		end

		tablet:SetHint(L["Click a name to start whispering to them"])
	else
		tablet:AddCategory():AddLine("text", L["No Friends Online"])
	end
end

function uFriends:WhisperPlayer(name)
	if (name) then
		SetItemRef(string.format("player:%s", name), string.format("|Hplayer:%s|h[%s|h", name, name), "LeftButton")
	end
end
