local Tablet = AceLibrary("Tablet-2.0")
local Dewdrop = AceLibrary("Dewdrop-2.0")
local L = AceLibrary("AceLocale-2.2"):new("FuBar_tTracker")

local optionsTable = {
	type = 'group',
	args = {
		showMinimap = {
			order = 10,
			type = 'toggle',
			name = L["TRACKER_SHOW_MINIMAP"],
			desc = L["TRACKER_SHOW_MINIMAP"],
			set = "ToggleShowMiniMap",
			get = "IsShowingMiniMap",
		},		
	}	
}

FuBar_tTracker = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0", "FuBarPlugin-2.0", "AceHook-2.1")

FuBar_tTracker.hasIcon = "Interface\\Icons\\Ability_Tracking"
FuBar_tTracker.OnMenuRequest = optionsTable
FuBar_tTracker:RegisterChatCommand({"/ttracker"}, optionsTable)

FuBar_tTracker:RegisterDB("FuBar_tTrackerDB", "FuBar_tTrackerCharDB")
FuBar_tTracker:RegisterDefaults('profile', {
	showMiniMap = false,
})

function FuBar_tTracker:Tracker_FindTracking(theTexture)
	--DEFAULT_CHAT_FRAME:AddMessage(theTexture)
	if ( theTexture == L["TRACKER_ICON_FIND_HERBS"] ) then		
		return L["TRACKER_SPELL_FIND_HERBS"]
	elseif ( theTexture == L["TRACKER_ICON_FIND_MINERALS"] ) then
		return L["TRACKER_SPELL_FIND_MINERALS"]
	elseif ( theTexture == L["TRACKER_ICON_FIND_TREASURE"] ) then
		return L["TRACKER_SPELL_FIND_TREASURE"]
	elseif ( theTexture == L["TRACKER_ICON_TRACK_BEASTS"] ) then
		local playerClass, englishClass = UnitClass("player")
		if ( englishClass == "DRUID" ) then
			return L["TRACKER_SPELL_TRACK_HUMANOIDS"]
		else
			return L["TRACKER_SPELL_TRACK_BEASTS"]
		end
	elseif ( theTexture == L["TRACKER_ICON_TRACK_HUMANOIDS"] ) then
		return L["TRACKER_SPELL_TRACK_HUMANOIDS"]
	elseif ( theTexture == L["TRACKER_ICON_TRACK_HIDDEN"] ) then
		return L["TRACKER_SPELL_TRACK_HIDDEN"]
	elseif ( theTexture == L["TRACKER_ICON_TRACK_ELEMENTALS"] ) then
		return L["TRACKER_SPELL_TRACK_ELEMENTALS"]
	elseif ( theTexture == L["TRACKER_ICON_TRACK_UNDEAD"] ) then
		return L["TRACKER_SPELL_TRACK_UNDEAD"]
	elseif ( theTexture == L["TRACKER_ICON_TRACK_DEMONS"] ) then
		return L["TRACKER_SPELL_TRACK_DEMONS"]
	elseif ( theTexture == L["TRACKER_ICON_TRACK_GIANTS"] ) then
		return L["TRACKER_SPELL_TRACK_GIANTS"]
	elseif ( theTexture == L["TRACKER_ICON_TRACK_DRAGONKIN"] ) then 
		return L["TRACKER_SPELL_TRACK_DRAGONKIN"]
	elseif ( theTexture == L["TRACKER_ICON_SENSE_UNDEAD"] ) then
		return L["TRACKER_SPELL_SENSE_UNDEAD"]
	elseif ( theTexture == L["TRACKER_ICON_SENSE_DEMONS"] ) then
		return L["TRACKER_SPELL_SENSE_DEMONS"]
	else
		return L["TRACKER_STOP_TRACKING"]
	end
end

function FuBar_tTracker:IsShowingMiniMap()
	return self.db.profile.showMiniMap
end
	
function FuBar_tTracker:ToggleShowMiniMap()
	self.db.profile.showMiniMap = not self.db.profile.showMiniMap
	if (self.db.profile.showMiniMap) then
		MiniMapTracking:Show()
	else
		MiniMapTracking:Hide()
	end
	return self.db.profile.showMiniMap
end

function FuBar_tTracker:OnDataUpdate()
	if (self.db.profile.showMiniMap) then
		MiniMapTracking:Show()
	else
		MiniMapTracking:Hide()
	end
	
	self.db.profile.currTexture = GetTrackingTexture()
end

function FuBar_tTracker:OnTextUpdate()
	if (self.db.profile.currTexture ~= nil) then
		self:SetIcon(self.db.profile.currTexture)
        self:SetText(self:Tracker_FindTracking(self.db.profile.currTexture))
	else
		self:SetIcon(L["DEFAULT_ICON"])
		self:SetText(L["TRACKER_OFF_TEXT"])
	end

	if (self.db.profile.showMiniMap) then
		MiniMapTracking:Show()
	else
		MiniMapTracking:Hide()
	end	
end

function FuBar_tTracker:OnTooltipUpdate()
    Tablet:SetTitle(L["TABLET_TITLE"])
    local cat = Tablet:AddCategory('id',"Tracking",'columns',1)

    if (self.db.profile.currTexture) then
        local currTracking = self:Tracker_FindTracking(self.db.profile.currTexture)
        local text = "|cff00ff00"..L["HINT_STOP"].." "..currTracking.."|r"

        cat:AddLine('text',"|cffffffff"..currTracking,'justify',"CENTER")
        cat:AddLine('text',text,'justify',"CENTER")
	else
		local currTracking = L["TRACKER_OFF_TEXT"]
		cat:AddLine('text',"|cffaaaaaa"..currTracking,'justify',"CENTER")
	end
	
end

function FuBar_tTracker:Initialize()
	self.db.profile.currTexture = GetTrackingTexture()
end

function FuBar_tTracker:OnEnable()
	self:RegisterEvent("SPELLS_CHANGED")
	self:RegisterEvent("PLAYER_AURAS_CHANGED")
end

function FuBar_tTracker:OnClick()
    CancelTrackingBuff()
end

function FuBar_tTracker:SPELLS_CHANGED()
	self.db.profile.currTexture = GetTrackingTexture()	
	self:Update()
end

function FuBar_tTracker:PLAYER_AURAS_CHANGED()
	self.db.profile.currTexture = GetTrackingTexture()
	self:Update()
end	
