﻿--[[ FuBar_switcherFu
	original code called ScreenSwitchFu by avngr
	adapted and expanded for FuBar 2.0 / Ace2 by arJUna ]]--
switcherFu = AceLibrary("AceAddon-2.0"):new("AceDB-2.0", "FuBarPlugin-2.0")
local T = AceLibrary("Tablet-2.0")
local L = AceLibrary("AceLocale-2.2"):new("switcherFu")
L:RegisterTranslations("enUS", function() return({
	["Left click to toggle screen mode"] = true,
	["Fullscreen"] = true,
	["Windowed"] = true,
	["switch resolution"] = true,
	["switch resolutions when changing to windowed mode"] = true,
	["resolution"] = true,
	["resolution to use in windowed mode"] = true
}) end)
L:RegisterTranslations("koKR", function() return({
	["Left click to toggle screen mode"] = "화면 모드를 변경하실려면 왼쪽 버튼을 클릭하세요.",
	["Fullscreen"] = "전체 화면",
	["Windowed"] = "창 모드",
	["switch resolution"] = "해상도 전환",
	["switch resolutions when changing to windowed mode"] = "창 모드로 변경시 해상도를 변경합니다." ,
	["resolution"] = "해상도",
	["resolution to use in windowed mode"] = "창 모드 사용시 사용할 해상도를 설정합니다.",
}) end)
--
switcherFu.hasIcon = "Interface\\Icons\\Spell_Arcane_TeleportThunderBluff"
switcherFu.cannotDetachTooltip = true
switcherFu.hasNoColor = true
--
function switcherFu:OnInitialize()
	self.defaults = { changeRes=false, windowRes=1, fullscreenRes=nil }
	self.options = {
		type = 'group',
		args = {
			switch={
				type="toggle", order=1,
				name=L["switch resolution"], desc=L["switch resolutions when changing to windowed mode"],
				get=function() return(switcherFu.db.profile.changeRes) end,
				set=function(x) switcherFu.db.profile.changeRes=x end
			},
			resolution={
				type="group", order=2,
				name=L["resolution"], desc=L["resolution to use in windowed mode"],
				args={}
			}
		}
	}
	for i, mode in pairs({GetScreenResolutions()}) do
		self.options.args.resolution.args[tostring(i)] = {
			type="toggle", order=i, name=mode, desc=mode,
			get=function() return(self.db.profile.windowRes==i) end,
			set=function() self.db.profile.windowRes=i end
		}
	end
	self:RegisterDB("switcherFuDB")
	self:RegisterDefaults("profile", self.defaults)
	self.OnMenuRequest = self.options
end
--
function switcherFu:OnTextUpdate()
	if(GetCVar("gxWindow") =="0") then
		self:SetText(L["Fullscreen"])
	else
		self:SetText(L["Windowed"])
	end
end
--
function switcherFu:OnTooltipUpdate()
	T:SetHint(L["Left click to toggle screen mode"])
end
--
function switcherFu:OnClick()
	local screenMode = 1 - GetCVar("gxWindow")
	SetCVar("gxWindow", screenMode)
	if(self.db.profile.changeRes) then
		if(screenMode == 0) then
			if(self.db.profile.fullscreenRes) then SetScreenResolution(self.db.profile.fullscreenRes) end
		else
			self.db.profile.fullscreenRes = GetCurrentResolution()
			SetScreenResolution(self.db.profile.windowRes)
		end
	end
	RestartGx()
	self:Update()
end