local L = AceLibrary("AceLocale-2.2"):new("FuBar_XPerlFu")
local Tablet = AceLibrary("Tablet-2.0");


XPerlFu = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0", "FuBarPlugin-2.0", "AceHook-2.1")
XPerlFu.hasIcon = "Interface\\Icons\\INV_Misc_Gem_Pearl_02"
XPerlFu.defaultPosition = "LEFT"
XPerlFu.defaultMinimapPosition = 180
XPerlFu.cannotDetachTooltip = true
XPerlFu.hasNoColor = true
XPerlFu:RegisterDB("XPerlFuDB")



function XPerlFu:OnInitialize()
    self.hasIcon = true
    self:SetIcon(true)
end

function XPerlFu:OnEnable()
end

function XPerlFu:OnClick(button)
      XPerl_Toggle();
end

function XPerlFu:OnTooltipUpdate()
	Tablet:SetHint(L["|c00FFFFFFLeft click|r for Options (and to |c0000FF00unlock frames|r)"])
end

function XPerlFu:OnTextUpdate()
    if self:IsTextShown() then
        self:SetText("XPerlFu")
    end
    if not self:IsIconShown() then
        self:HideIcon()
    end
end



XPerlFu.OnMenuRequest = {
	type = 'group',
	args = {
		optionframe = {
            	type = 'execute',
            	name = L["Open Options"],
            	desc = L["Open XPerl Options Frame"],
            	func  = function() XPerl_Toggle() end
		}
	}
}