WorldPVPFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceHook-2.1")--, "AceDB-2.0")

local L = AceLibrary("AceLocale-2.2"):new("FuBar_WorldPVPFu")
local tablet = AceLibrary("Tablet-2.0")
--local moveTab
--local defaultXofs, defaultYofs

function WorldPVPFu:GetObjectivesMode()
	return WORLD_PVP_OBJECTIVES_DISPLAY
end

function WorldPVPFu:SetObjectivesMode(mode)
	WORLD_PVP_OBJECTIVES_DISPLAY = mode
	WorldStateAlwaysUpFrame_Update()
end

function WorldPVPFu:GetIconPath()
	local iconDir = "Interface\\AddOns\\FuBar_WorldPVPFu\\icons\\"
	if self:GetObjectivesMode() == "1" then
		return iconDir .. "HordeTower"
	elseif self:GetObjectivesMode() == "2" then
		return iconDir .. "NeutralTower"
	else
		return iconDir .. "AllianceTower"
	end
end

WorldPVPFu.hasIcon = WorldPVPFu:GetIconPath()
WorldPVPFu.hasNoText = true
WorldPVPFu.cannotDetachTooltip = true

WorldPVPFu.OnMenuRequest = {
    type = 'group',
    args = {
        mode = {
            type = "text",
            name = L["Display mode"],
            desc = L["Change the way World PVP Objectives frame is displayed"],
            get = "GetObjectivesMode",
            set = "SetObjectivesMode",
			validate = {
				["1"] = L["always"],
				["2"] = L["dynamic"],
				["3"] = L["never"],
			},
			validateDesc = {
				["1"] = L["Always show World PVP Objectives"],
				["2"] = L["Only show World PVP Objectives when near points of interest"],
				["3"] = L["Never show World PVP Objectives"],
			},
			order = 10,
        },
		--[[
		moveObj = {
			type = "toggle",
            name = L["Unlock frame"],
            desc = L["Unlock World PVP Objectives frame so it can be moved"],
            get = function() if moveTab then return moveTab:IsVisible() else return false end end,
            set = "LockFrame",
			order = 20,
		},
		restDefaults = {
			type = "execute",
			name = L["Restore default position"],
			desc = L["Restore default position of the World PVP Objectives frame"],
			func = "RestoreDefaultPos",
			order = 30,
		},--]]
    },
	handler = WorldPVPFu,
}

function WorldPVPFu:OnClick()
	self:ToggleObjectives()
end

function WorldPVPFu:ToggleObjectives()
	if self:GetObjectivesMode() == "1" then
		self:SetObjectivesMode("3")
	else
		self:SetObjectivesMode("1")
	end
end

function WorldPVPFu:OnTextUpdate()
	self:SetIcon(self:GetIconPath())
end

function WorldPVPFu:OnTooltipUpdate()
	tablet:SetHint(L["Click to show/hide PVP Objectives"])
end

function WorldPVPFu:OnEnable()
	--[[
	_, _, _, defaultXofs, defaultYofs = WorldStateAlwaysUpFrame:GetPoint(1)
	
	WorldPVPFu:RegisterDB("WorldPVPFuDB","WorldPVPFuDBPC")

	WorldPVPFu:RegisterDefaults("char",{
		frameOffs = {},
		unlocked = false
	})
	
	if self.db.char.frameOffs.x then
		WorldStateAlwaysUpFrame:SetPoint("TOPLEFT","UIParent","TOPLEFT",self.db.char.frameOffs.x,self.db.char.frameOffs.y)
	end
	--]]
	self:SecureHook("WorldStateAlwaysUpFrame_Update","UpdateText")
end

--[[
function WorldPVPFu:LockFrame(unlock)
	if unlock then
		if not moveTab then
			moveTab = self:CreateMoveTab(WorldStateAlwaysUpFrame,"TOP","WorldStateAlwaysUpFrame","TOP",0,-10,self.SaveLastCoords)
		end
		moveTab:Show()
	else
		moveTab:Hide()
	end
end

function WorldPVPFu:SaveLastCoords(...)
	self.db.char.frameOffs.x = select(4,...)
	self.db.char.frameOffs.y = select(5,...)
end

function WorldPVPFu:RestoreDefaultPos()
	WorldStateAlwaysUpFrame:SetPoint("TOPLEFT","UIParent","TOPLEFT",defaultXofs,defaultYofs)
	self.db.char.frameOffs.x = defaultXofs
	self.db.char.frameOffs.y = defaultYofs
end

function WorldPVPFu:CreateMoveTab(dragTarget, point, relativeFrame, relativePoint, xOfs, yOfs, saveFunction)
	if type(dragTarget) ~= "table" then
		return
	end
	
	point = point or "CENTER"
	relativeFrame = relativeFrame or dragTarget
	relativePoint = relativePoint or "CENTER"
	xOfs = xOfs or 0
	yOfs = yOfs or 0
	if type(saveFunction) ~= "function" then
		saveFunction = function(...) end
	end
	
	local tab = CreateFrame("Frame")
	tab:SetPoint(point,relativeFrame,relativePoint,xOfs,yOfs)
	tab:SetWidth(10)
	tab:SetHeight(10)
	
	local t = tab:CreateTexture("OVERLAY")
	t:SetTexture("Interface\Minimap\MiniMap-TrackingBorder")
	t:SetAllPoints(tab)
	tab.texture = t
	
	tab:RegisterForDrag("LeftButton")
	
	tab.OnDragStart = function()
			tab.wasTargetMovable = dragTarget:IsMovable()
			dragTarget:SetMovable(true)
			dragTarget:StartMoving()
		end
		
	tab.OnDragStop = function()
			dragTarget:StopMovingOrSizing()
			dragTarget:SetMovable(tab.wasTargetMovable)
			saveFunction(dragTarget:GetPoint(1))
		end
	
	return tab
end
--]]