local L = AceLibrary("AceLocale-2.2"):new("FuBar_WindFuryFu")
local T = AceLibrary("Tablet-2.0")
local BS = AceLibrary("Babble-Spell-2.2")
local BC = AceLibrary("Babble-Class-2.2")
local G = AceLibrary("Gratuity-2.0")
local D = AceLibrary("Deformat-2.0")

WindFuryFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceDB-2.0", "AceEvent-2.0", "AceConsole-2.0")
WindFuryFu.version = "2.0"
WindFuryFu.revision  = tonumber(string.sub("$Rev: 40551 $", 12, -3))
WindFuryFu.date = "$LastChangedDate: 2007-06-18 15:07:57 -0400 (Mon, 18 Jun 2007) $"
WindFuryFu.hasIcon = true
WindFuryFu.canHideText = true
WindFuryFu.independentProfile = true
--WindFuryFu.clickableTooltip = true
WindFuryFu:RegisterDB("WindFuryFuDB")
WindFuryFu:RegisterDefaults('profile', {
	debugEnabled = false,
	showLabel = true,
	displayLast = true,
	displayBest = true,
	displayChat = true,
	tooltipVictims = true,
	tooltipLastFive = true,
	tooltipShowHint = true,
	tooltipShowDPS = true,
	sctEnabled = true,
	sctShowDodge = true,
	sctShowMiss = true,
	sctShowParry = true,
	sctShowBlock = true,
	sctShowEvade = true,
	sctShowAbsorb = true,
	fontSize = 26,
	fontFace = "Default",
	fontColor = {r=1,g=1,b=0},
	countFirstHit = true,
})
WindFuryFu:RegisterDefaults('char', {
	session = {},
	lifetime = {}
})
WindFuryFu.options = {
	handler = WindFuryFu,
	type = 'group',
	args = {
		display = {
			type = 'group',
			name = L["Display Options"],
			desc = L["Set the Display Properties"],
			args = {
				debugEnabled = {
					type = 'toggle',
					name = L["Show Debug Messages"],
					desc = L["Toggle showing of debug messages in chat frame"],
					get = function() return WindFuryFu.db.profile.debugEnabled end,
					set = function(t) WindFuryFu.db.profile.debugEnabled = t end,
				},
				label = {
					type = 'toggle',
					name = L["Show Label Text"],
					desc = L["Toggle text labels on FuBar"],
					get = function() return WindFuryFu.db.profile.showLabel end,
					set = function(t)
						WindFuryFu.db.profile.showLabel = t
						WindFuryFu:UpdateText()
					end,
				},
				last = {
					type = 'toggle',
					name = L["Show Last WF Hit"],
					desc = L["Toggle showing your last Windfury hit"],
					get = function() return WindFuryFu.db.profile.displayLast end,
					set = function(t)
						WindFuryFu.db.profile.displayLast = t
						WindFuryFu:UpdateText()
					end,
				},
				best = {
					type = 'toggle',
					name = L["Show Best WF Hit"],
					desc = L["Toggle showing your best Windfury hit"],
					get = function() return WindFuryFu.db.profile.displayBest end,
					set = function(t)
						WindFuryFu.db.profile.displayBest = t
						WindFuryFu:UpdateText()
					end,
				},
				chat = {
					type = 'toggle',
					name = L["Display Total Damage in Chat Frame"],
					desc = L["Toggle displaying total damage chat frame"],
					get = function() return WindFuryFu.db.profile.displayChat end,
					set = function(t) WindFuryFu.db.profile.displayChat = t end,
				},	
			},
		},
		tooltip = {
			type = 'group',
			name = L["Tooltip Options"],
			desc = L["Set the Tooltip Properties"],
			args = {
				lastfive = {
					type = 'toggle',
					name = L["Show Five Last WF Hits"],
					desc = L["Toggle showing the last five Windfury hits in the tooltip"],
					get = function() return WindFuryFu.db.profile.tooltipLastFive end,
					set = function(t)
						WindFuryFu.db.profile.tooltipLastFive = t
						WindFuryFu:UpdateTooltip()
					end,
				},
				dps = {
					type = 'toggle',
					name = L["Show DPS"],
					desc = L["Toggle showing damage per second in the tooltip"],
					get = function() return WindFuryFu.db.profile.tooltipShowDPS end,
					set = function(t)
						WindFuryFu.db.profile.tooltipShowDPS = t
						WindFuryFu:UpdateTooltip()
					end,
				},
				victims = {
					type = 'toggle',
					name = L["Show Victims"],
					desc = L["Toggle showing victims for each attack in the tooltip"],
					get = function() return WindFuryFu.db.profile.tooltipVictims end,
					set = function(t)
						WindFuryFu.db.profile.tooltipVictims = t
						WindFuryFu:UpdateTooltip()
					end,
				},
				hint = {
					type = 'toggle',
					name = L["Show Hint"],
					desc = L["Toggle showing the hint in the tooltip"],
					get = function() return WindFuryFu.db.profile.tooltipShowHint end,
					set = function(t)
						WindFuryFu.db.profile.tooltipShowHint = t
						WindFuryFu:UpdateTooltip()
					end,
				},

			},
		},
		stats = {
			type = 'group',
			name = L["Statistic Options"],
			desc = L["Configure how statistics should be monitored and saved"],
			args = {
				countfirsthit = {
					type = 'toggle',
					name = L["Count First Hit"],
					desc = L["Count the hit that triggered the Windfury attack and add it to total damage"],
					get = function() return WindFuryFu.db.profile.countFirstHit end,
					set = function(t) WindFuryFu.db.profile.countFirstHit = t end,
				},
				reset = {
					type = 'group',
					name = L["Reset Statistics"],
					desc = L["Reset your Windfury statistics"],
					args = {
						session = {
							type = 'execute',
							name = L["Session"],
							desc = L["Reset your Windfury statistics for this session"],
							func = function()
								WindFuryFu:ResetStats("session")
							end
						},
						lifetime = {
							type = 'execute',
							name = L["Lifetime"],
							desc = L["Reset your lifetime Windfury statistics"],
							func = function()
								WindFuryFu:ResetStats("lifetime")
							end
						},
					},
				},
			},
		},
		scrollingtext = {
			type = 'group',
			name = L["SCT/MSBT Options"],
			desc = L["Set the Display Properties for SCT/MSBT"],
			args = {
				toggle = {
					type = 'toggle',
					name = L["Enable Notification"],
					desc = L["Toggle showing total windfury damage notification in SCT or MSBT"],
					get = function() return WindFuryFu.db.profile.sctEnabled end,
					set = function(t) WindFuryFu.db.profile.sctEnabled = t end,
				},
				fontsize = {
					type = 'range',
					name = L["Font Size"],
					desc = L["Set the font size to use when displaying messages in SCT/MSBT"],
					step = 1,
					min = 8,
					max = 32,
					get = function() return WindFuryFu.db.profile.fontSize end,
					set = function(v) WindFuryFu.db.profile.fontSize = v end,
				},
				fontface = {
					type = 'text',
					name = L["Font Face"],
					desc = L["Set the font face to use when displaying messages in SCT/MSBT"],
					usage = "Default",
					get = function() return WindFuryFu.db.profile.fontFace end,
					set = function(t) WindFuryFu.db.profile.fontFace = t end,
				},
				fontcolor = {
					type = 'color',
					name = L["Font Color"],
					desc = L["Set the font color to use when displaying messages in SCT/MSBT"],
					get = function() return WindFuryFu.db.profile.fontColor.r,WindFuryFu.db.profile.fontColor.g, WindFuryFu.db.profile.fontColor.b end,
					set = function(r,g,b)
						WindFuryFu.db.profile.fontColor.r = r
						WindFuryFu.db.profile.fontColor.g = g
						WindFuryFu.db.profile.fontColor.b = b
					end,
					hasAlpha = false,
				},
				show = {
					type = 'group',
					name = L["Extra Notifications"],
					desc = L["Set which Windfury Attack events to show in SCT/MSBT"],
					args = {
						miss = {
							type = 'toggle',
							name = L["Miss"],
							desc = "Show Miss event",
							get = function() return WindFuryFu.db.profile.sctShowMiss end,
							set = function(t) WindFuryFu.db.profile.sctShowMiss = t end,
						},
						dodge = {
							type = 'toggle',
							name = L["Dodge"],
							desc = "Show Dodge event",
							get = function() return WindFuryFu.db.profile.sctShowDodge end,
							set = function(t) WindFuryFu.db.profile.sctShowDodge = t end,
						},
						block = {
							type = 'toggle',
							name = L["Block"],
							desc = "Show Block event",
							get = function() return WindFuryFu.db.profile.sctShowBlock end,
							set = function(t) WindFuryFu.db.profile.sctShowBlock = t end,
						},
						parry = {
							type = 'toggle',
							name = L["Parry"],
							desc = "Show Parry event",
							get = function() return WindFuryFu.db.profile.sctShowParry end,
							set = function(t) WindFuryFu.db.profile.sctShowParry = t end,
						},
						evade = {
							type = 'toggle',
							name = L["Evade"],
							desc = "Show Evade event",
							get = function() return WindFuryFu.db.profile.sctShowEvade end,
							set = function(t) WindFuryFu.db.profile.sctShowEvade = t end,
						},
						absorb = {
							type = 'toggle',
							name = L["Absorb"],
							desc = "Show Absorb event",
							get = function() return WindFuryFu.db.profile.sctShowAbsorb end,
							set = function(t) WindFuryFu.db.profile.sctShowAbsorb = t end,
						},
					},
				},
			},
		},
	},
}
WindFuryFu:RegisterChatCommand(L["AceConsole-options"], WindFuryFu.options)
WindFuryFu.OnMenuRequest = WindFuryFu.options

function WindFuryFu:OnEnable()
	self:RegisterEvent("UNIT_INVENTORY_CHANGED", "InventoryChanged")
	self:RegisterEvent("CHAT_MSG_SPELL_SELF_DAMAGE", "SpellSelfDamage")
	self:RegisterEvent("CHAT_MSG_COMBAT_SELF_HITS", "CombatSelfHit")
	self:RegisterEvent("CHAT_MSG_COMBAT_HOSTILE_DEATH", "CombatHostileDeath")
	self:RegisterEvent("PLAYER_TARGET_CHANGED", "TargetChanged")
	self:RegisterEvent("PLAYER_ENTER_COMBAT", "EnterCombat")
	self:RegisterEvent("PLAYER_REGEN_DISABLED", "EnterCombat")
	self:RegisterEvent("PLAYER_REGEN_ENABLED", "LeaveCombat")

	self.activeWeapon= "none"
	self.mainHand = {
		name = "",
		enchanted = false,
		rank = 0,
		speed = 0
	}
	self.offHand = {
		name = "",
		enchanted = false,
		rank = 0,
		speed = 0
	}
	self.status = false
	self.dualHit = false
	self.dualWield = false
	self.lastHit = 0
	self.lastHitIsCrit = false
	self.hitCount = 0
	self.critCount = 0
	self.swingsLeft = 0
	self.totalDamage = 0
	self.combatStart = 0
	
	self.victim = {
		name = "",
		class = "",
		level = 0,
		dead = false
	}
	
	self.windfuryAP = {46,119,249,333,445}
	self.ewAP = {13,27,40}
	
	self:WeaponCheck()
	self:ResetStats("session")
end

function WindFuryFu:OnClick()
	if (IsShiftKeyDown() and ChatFrameEditBox:IsVisible()) then
		-- Needs to be localized
		message = self.mainHand.name.." Stats - Best WF: "..self.db.char.lifetime[self.mainHand.name].bestWindfury .." - Average WF dmg: "..self.allAverage.." - Best hit during WF: "..self.db.char.lifetime[self.mainHand.name].bestSingleHit
		ChatFrameEditBox:Insert(message)
	end
end

function WindFuryFu:Round(val, decimal)
	if (val ~= nil) then
		if (decimal) then
			return floor( (val * 10^decimal) + 0.5) / (10^decimal)
		else
			return floor(val+0.5)
		end
	end
	return val
end

function WindFuryFu:OnDataUpdate()
	if (self.db.char.session[self.mainHand.name].totalDamage == 0) then
		self.average = "0"
	else
		self.average = self:Round(self.db.char.session[self.mainHand.name].totalDamage / self.db.char.session[self.mainHand.name].procCount)
	end

	if (self.db.char.lifetime[self.mainHand.name].totalDamage == 0) then
		self.allAverage = "0"
	else
		self.allAverage = self:Round(self.db.char.lifetime[self.mainHand.name].totalDamage / self.db.char.lifetime[self.mainHand.name].procCount)
	end

	if (self.db.char.session[self.mainHand.name].critCount == 0) then
		self.critPercent = "0"
	else
		self.critPercent = self:Round((self.db.char.session[self.mainHand.name].critCount / (self.db.char.session[self.mainHand.name].procCount*3))*100)
	end

	if (self.db.char.session[self.mainHand.name].procCount == 0) then
		self.outProcProcent = "0"
	else
		self.outProcProcent = self:Round((self.db.char.session[self.mainHand.name].procCount / self.db.char.session[self.mainHand.name].hitCount)*100)
	end

	if (self.db.char.lifetime[self.mainHand.name].procCount == 0) then
		self.allOutProcProcent = "0"
	else
		self.allOutProcProcent = self:Round((self.db.char.lifetime[self.mainHand.name].procCount / self.db.char.lifetime[self.mainHand.name].hitCount)*100)
	end

	if (self.db.char.lifetime[self.mainHand.name].critCount == 0) then
		self.allCritPercent = "0"
	else
		self.allCritPercent = self:Round((self.db.char.lifetime[self.mainHand.name].critCount / (self.db.char.lifetime[self.mainHand.name].procCount*3))*100)
	end
end

function WindFuryFu:OnTextUpdate()
	local str = ""

	if (self.db.profile.showLabel) then
		if (self.db.profile.displayLast) then
			str = str .. L["Last"] ..": |c00FFFFFF" .. self.db.char.session[self.mainHand.name].lastWindfury[1] .. "|r"
		end
		if (self.db.profile.displayBest) then
			if (strlen(str) > 4) then
				str = str .. "  "
			end
			if (self.db.char.lifetime[self.mainHand.name].bestWindfury < self.db.char.session[self.mainHand.name].bestHit) then
				str = str .. L["Best"] ..": |c00FFFFFF" .. self.db.char.session[self.mainHand.name].bestHit .. "|r"
			else
				str = str .. L["Best"] ..": |c00FFFFFF" .. self.db.char.lifetime[self.mainHand.name].bestWindfury .. "|r"
			end
		end
		if (self.status) then
			str = str .. " " .. L["Status"] .. ": |cff20ff20ON|r"
		else
			str = str .. " " .. L["Status"] .. ": |cffff2020OFF|r"
		end
	else
		if (self.db.profile.displayLast) then
			str = str .. "|c00FFFFFF" .. self.db.char.session[self.mainHand.name].lastWindfury[1] .. "|r/"
		end
		if (self.db.profile.displayBest) then
			if (self.db.char.lifetime[self.mainHand.name].bestWindfury < self.db.char.session[self.mainHand.name].bestHit) then
				str = str .. "|c00FFFFFF" .. self.db.char.session[self.mainHand.name].bestHit .. "|r/"
			else
				str = str .. "|c00FFFFFF" .. self.db.char.lifetime[self.mainHand.name].bestWindfury .. "|r/"
			end
		end
		if (self.status) then
			str = str .. "|cff20ff20ON|r"
		else
			str = str .. "|cffff2020OFF|r"
		end
	end
	self:SetText(str)
end

function WindFuryFu:OnTooltipUpdate()
	-- Get links for main- and offhand weapon
	local mainHandLink = GetInventoryItemLink("player", GetInventorySlotInfo("MainHandSlot"))
	local offHandLink = GetInventoryItemLink("player", GetInventorySlotInfo("SecondaryHandSlot"))

	local mainSpeed, offSpeed = UnitAttackSpeed("player");
	
	local cat = nil
	
	local level = nil

	if (self.dualWield) then
		cat = T:AddCategory(
			'columns', 1,
			'text', L["Weapons (Dual-wield)"]
		)
	else
		cat = T:AddCategory(
			'columns', 1,
			'text', L["Weapon"]
		)
	end
	
	if (mainHandLink == nil) and (offHandLink == nil) then
		cat:AddLine(
			'text', L["No Weapon Equipped"]
		)
	else
		if ((self.mainHand.name ~= "") and (mainHandLink ~= nil)) then
			cat:AddLine(
				'text', mainHandLink
			)
		end
		if ((self.offHand.name ~= "") and (offHandLink ~= nil))  then
			cat:AddLine(
				'text', offHandLink
			)
		end
	end
	
	if (self.db.profile.tooltipVictims) then
		cat = T:AddCategory(
			'columns', 3,
			'text', L["This Session"],
			'child_textR', 1,
			'child_textG', 1,
			'child_textB', 0,
			'child_text2R', 1,
			'child_text2G', 1,
			'child_text2B', 1,
			'child_text3R', 1,
			'child_text3G', 1,
			'child_text3B', 1
		)
	
		local victim = self.db.char.session[self.mainHand.name].lastWindfury_Victim[1]
		if (victim.level < 0) then level = "??" else level = victim.level end
		local r3, g3, b3 = BC:GetColor(victim.class)
		cat:AddLine(
			'text', L["Last"]..":",
			'text2', "("..self.db.char.session[self.mainHand.name].lastCrit[1] .. ") "..self.db.char.session[self.mainHand.name].lastWindfury[1],
			'text3', victim.name ..  " [|cffffffff" .. level .. "|r]",
			'text3R', r3,
			'text3G', g3,
			'text4B', b3
		)
		
		if (self.db.profile.tooltipLastFive) then
			victim = self.db.char.session[self.mainHand.name].lastWindfury_Victim[2]
			if (victim.level < 0) then level = "??" else level = victim.level end
			r3, g3, b3 = BC:GetColor(victim.class)
			cat:AddLine(
				'text', L["2nd Last"]..":",
				'text2', "("..self.db.char.session[self.mainHand.name].lastCrit[2]..") "..self.db.char.session[self.mainHand.name].lastWindfury[2],
				'text3', victim.name ..  " [|cffffffff" .. level .. "|r]",
				'text3R', r3,
				'text3G', g3,
				'text4B', b3
			)
			victim = self.db.char.session[self.mainHand.name].lastWindfury_Victim[3]
			if (victim.level < 0) then level = "??" else level = victim.level end
			r3, g3, b3 = BC:GetColor(victim.class)
			cat:AddLine(
				'text', L["3rd Last"]..":",
				'text2', "("..self.db.char.session[self.mainHand.name].lastCrit[3]..") "..self.db.char.session[self.mainHand.name].lastWindfury[3],
				'text3', victim.name ..  " [|cffffffff" .. level .. "|r]",
				'text3R', r3,
				'text3G', g3,
				'text4B', b3
			)
			victim = self.db.char.session[self.mainHand.name].lastWindfury_Victim[4]
			if (victim.level < 0) then level = "??" else level = victim.level end
			r3, g3, b3 = BC:GetColor(victim.class)
			cat:AddLine(
				'text', L["4th Last"]..":",
				'text2', "("..self.db.char.session[self.mainHand.name].lastCrit[4]..") "..self.db.char.session[self.mainHand.name].lastWindfury[4],
				'text3', victim.name ..  " [|cffffffff" .. level .. "|r]",
				'text3R', r3,
				'text3G', g3,
				'text4B', b3
			)
			victim = self.db.char.session[self.mainHand.name].lastWindfury_Victim[5]
			if (victim.level < 0) then level = "??" else level = victim.level end
			r3, g3, b3 = BC:GetColor(victim.class)
			cat:AddLine(
				'text', L["5th Last"]..":",
				'text2', "("..self.db.char.session[self.mainHand.name].lastCrit[5]..") "..self.db.char.session[self.mainHand.name].lastWindfury[5],
				'text3', victim.name ..  " [|cffffffff" .. level .. "|r]",
				'text3R', r3,
				'text3G', g3,
				'text4B', b3
			)
		end

		victim = self.db.char.session[self.mainHand.name].bestSingleHit_Victim
		if (victim.level < 0) then level = "??" else level = victim.level end
		r3, g3, b3 = BC:GetColor(victim.class)
		cat:AddLine(
			'text', L["Best Single Hit"]..":",
			'text2', self.db.char.session[self.mainHand.name].bestSingleHit,
			'text3', victim.name ..  " [|cffffffff" .. level .. "|r]",
			'text3R', r3,
			'text3G', g3,
			'text4B', b3
		)
		victim = self.db.char.session[self.mainHand.name].bestHit_Victim
		if (victim.level < 0) then level = "??" else level = victim.level end
		r3, g3, b3 = BC:GetColor(victim.class)
		cat:AddLine(
			'text', L["Best"]..":",
			'text2', self.db.char.session[self.mainHand.name].bestHit,
			'text3', victim.name ..  " [|cffffffff" .. level .. "|r]",
			'text3R', r3,
			'text3G', g3,
			'text4B', b3
		)
	else
		cat = T:AddCategory(
			'columns', 2,
			'text', L["This Session"],
			'child_textR', 1,
			'child_textG', 1,
			'child_textB', 0,
			'child_text2R', 1,
			'child_text2G', 1,
			'child_text2B', 1
		)

		cat:AddLine(
			'text', L["Last"]..":",
			'text2', "("..self.db.char.session[self.mainHand.name].lastCrit[1] .. ") "..self.db.char.session[self.mainHand.name].lastWindfury[1]
		)
		
		if (self.db.profile.tooltipLastFive) then
			cat:AddLine(
				'text', L["2nd Last"]..":",
				'text2', "("..self.db.char.session[self.mainHand.name].lastCrit[2]..") "..self.db.char.session[self.mainHand.name].lastWindfury[2]
			)
			cat:AddLine(
				'text', L["3rd Last"]..":",
				'text2', "("..self.db.char.session[self.mainHand.name].lastCrit[3]..") "..self.db.char.session[self.mainHand.name].lastWindfury[3]
			)
			cat:AddLine(
				'text', L["4th Last"]..":",
				'text2', "("..self.db.char.session[self.mainHand.name].lastCrit[4]..") "..self.db.char.session[self.mainHand.name].lastWindfury[4]
			)
			cat:AddLine(
				'text', L["5th Last"]..":",
				'text2', "("..self.db.char.session[self.mainHand.name].lastCrit[5]..") "..self.db.char.session[self.mainHand.name].lastWindfury[5]
			)
		end
		cat:AddLine(
			'text', L["Best Single Hit"]..":",
			'text2', self.db.char.session[self.mainHand.name].bestSingleHit
		)
		cat:AddLine(
			'text', L["Best"]..":",
			'text2', self.db.char.session[self.mainHand.name].bestHit
		)
	end
	cat:AddLine(
		'text', L["Procs"]..":",
		'text2', "("..self.db.char.session[self.mainHand.name].procCount.."/"..self.db.char.session[self.mainHand.name].hitCount..") "..self.outProcProcent.."%"
	)
	cat:AddLine(
		'text', L["Crits"]..":",
		'text2', "("..self.db.char.session[self.mainHand.name].critCount.."/"..(self.db.char.session[self.mainHand.name].procCount*3)..") "..self.critPercent.."%"
	)
	cat:AddLine(
		'text', L["Average"]..":",
		'text2', self.average
	)
	cat:AddLine(
		'text', L["Total WF Damage"]..":",
		'text2', self.db.char.session[self.mainHand.name].totalDamage
	)
	--cat:AddLine(
	--	'text', "Time in Combat:",
	--	'text2', self.db.char.session[self.mainHand.name].combatTime.. " sec."
	--)
	if (self.db.profile.tooltipShowDPS) then
		local actualDPS = 0
		if ((mainSpeed ~= nil) and (self.db.char.session[self.mainHand.name].combatTime > 0)) then
			actualDPS = self:Round((self.db.char.session[self.mainHand.name].totalDamage/self.db.char.session[self.mainHand.name].combatTime),1)
		end
		cat:AddLine(
			'text', L["Actual DPS"]..":",
			'text2', actualDPS
		)
	end

	if (self.db.profile.tooltipVictims) then
		cat = T:AddCategory(
			'columns', 3,
			'text', L["Lifetime"],
			'child_textR', 1,
			'child_textG', 1,
			'child_textB', 0,
			'child_text2R', 1,
			'child_text2G', 1,
			'child_text2B', 1,
			'child_text3R', 1,
			'child_text3G', 1,
			'child_text3B', 1
		)
	 
		victim = self.db.char.lifetime[self.mainHand.name].bestSingleHit_Victim
		if (victim.level < 0) then level = "??" else level = victim.level end
		r3, g3, b3 = BC:GetColor(victim.class)
		cat:AddLine(
			'text', L["Best Single Hit"]..":",
			'text2', self.db.char.lifetime[self.mainHand.name].bestSingleHit,
			'text3', victim.name ..  " [|cffffffff" .. level .. "|r]",
			'text3R', r3,
			'text3G', g3,
			'text4B', b3
		)
		
		victim = self.db.char.lifetime[self.mainHand.name].bestWindfury_Victim
		if (victim.level < 0) then level = "??" else level = victim.level end
		r3, g3, b3 = BC:GetColor(victim.class)
		cat:AddLine(
			'text', L["Best"]..":",
			'text2', self.db.char.lifetime[self.mainHand.name].bestWindfury,
			'text3', victim.name ..  " [|cffffffff" .. level .. "|r]",
			'text3R', r3,
			'text3G', g3,
			'text4B', b3
		)
	else
		cat = T:AddCategory(
			'columns', 2,
			'text', L["Lifetime"],
			'child_textR', 1,
			'child_textG', 1,
			'child_textB', 0,
			'child_text2R', 1,
			'child_text2G', 1,
			'child_text2B', 1
		)
	 
		cat:AddLine(
			'text', L["Best Single Hit"]..":",
			'text2', self.db.char.lifetime[self.mainHand.name].bestSingleHit
		)
		cat:AddLine(
			'text', L["Best"]..":",
			'text2', self.db.char.lifetime[self.mainHand.name].bestWindfury
		)
	end
	cat:AddLine(
		'text', L["Procs"]..":",
		'text2', "("..self.db.char.lifetime[self.mainHand.name].procCount.."/"..self.db.char.lifetime[self.mainHand.name].hitCount..") "..self.allOutProcProcent.."%"
	)
	cat:AddLine(
		'text', L["Crits"]..":",
		'text2', "("..self.db.char.lifetime[self.mainHand.name].critCount.."/"..(self.db.char.lifetime[self.mainHand.name].procCount*3)..") "..self.allCritPercent.."%"
	)
	cat:AddLine(
		'text', L["Average"]..":",
		'text2', self.allAverage
	)
	cat:AddLine(
		'text', L["Total WF Damage"]..":",
		'text2', self.db.char.lifetime[self.mainHand.name].totalDamage
	)
	--cat:AddLine(
	--	'text', "Time in Combat:",
	--	'text2', self.db.char.lifetime[self.mainHand.name].combatTime.. " sec."
	--)
	if (self.db.profile.tooltipShowDPS) then
	
		if (self.status) then
			local theoDPS = 0
			-- Get damage for main- and offhand weapons
			local mainHandDmgMin, mainHandDmgMax, offHandDmgMin, offHandDmgMax = UnitDamage("player")
			local mainHandDmgAvg,offHandDmgAvg,mainHandCritAvg,offHandCritAvg = 0,0,0,0
		
			if not (mainHandDmgMin) then
				mainHandDmgMin = 0
				mainHandDmgMax = 0
			end
			if not (offHandDmgMin) then
				offHandDmgMin = 0
				offHandDmgMax = 0
			end
			
			self:PrintDebug("Weapon Damage: " .. mainHandDmgMin .. " - " .. mainHandDmgMax)
			if (mainHandDmgMin > 0) then
				mainHandDmgAvg = (mainHandDmgMin+mainHandDmgMax)/2
				mainHandCritAvg = mainHandDmgAvg*2
			end
			if (offHandDmgMax > 0) then
				offHandDmgAvg = (offHandDmgMin+offHandDmgMax)/2
				offHandCritAvg = offHandDmgAvg*2
			end
			
			-- Get crit chance
			local critChance = GetCritChance()
			
			-- Get elemental weapons rank
			local _,_,_,_,ewRank = GetTalentInfo(2,14)
			
			-- Set initial DPS to zero
			local mainHandTheoDPS, offHandTheoDPS = 0,0
		
			-- Calculate theoretical DPS for main-hand
			if ((self.mainHand.name ~= "") and (self.mainHand.enchanted)) then
				-- If Elemental Weapons is over rank 0 it will add damage bonus
				self:PrintDebug("Average Weapon Damage: " .. mainHandDmgAvg)
				self:PrintDebug("Crit Chance: " .. critChance)
				self:PrintDebug("Windfury Weapon Rank " .. self.mainHand.rank)
				self:PrintDebug("Windfury Weapon Added AP: " .. self.windfuryAP[self.mainHand.rank])
				self:PrintDebug("Elemental Weapons Rank " .. ewRank)
				if (ewRank == 0) then
					self:PrintDebug("No Elemental Weapons AP added. No Talent point spent!")
				else
					self:PrintDebug("Elemental Weapons Added AP: " .. floor(self.windfuryAP[self.mainHand.rank]*((self.ewAP[ewRank])/100)))
				end
				local ewAddedAP = 0
				if (ewRank > 0) then
					local ewAddedAP = self.windfuryAP[self.mainHand.rank]*((self.ewAP[ewRank])/100)
				end
				local mainHandAddedDPS = floor((self.windfuryAP[self.mainHand.rank]+ewAddedAP)/14)
				
				self:PrintDebug("Windfury Added DPS: " .. mainHandAddedDPS)
				
				-- Calculate the dps of the weapon
				local mainHandAvgDPS = (mainHandDmgAvg+(mainHandCritAvg*(critChance/100)))/self.mainHand.speed
				
				-- Calculate the dps by adding two attacks and then the 20% chance for the attack to proc
				mainHandTheoDPS = self:Round(((mainHandAvgDPS+mainHandAddedDPS)*2)*0.20,1)
				
				self:PrintDebug("Windfury Theoretical DPS: " .. mainHandTheoDPS)
			else
				mainHandTheoDPS = 0
			end
			
			-- Calculate theoretical DPS for off-hand
			if ((self.offHand.name ~= "") and (self.offHand.enchanted)) then
				-- If Elemental Weapons is over rank 0 it will add damage bonus
				self:PrintDebug("Average Weapon Damage: " .. offHandDmgAvg)
				self:PrintDebug("Crit Chance: " .. critChance)
				self:PrintDebug("Windfury Weapon Rank " .. self.offHand.rank)
				self:PrintDebug("Windfury Weapon Added AP: " .. self.windfuryAP[self.offHand.rank])
				self:PrintDebug("Elemental Weapons Rank " .. ewRank)
				self:PrintDebug("Elemental Weapons Added AP: " .. floor(self.windfuryAP[self.offHand.rank]*((self.ewAP[ewRank])/100)))

				ewAddedAP = 0
				if (ewRank > 0) then
					ewAddedAP = self.windfuryAP[self.offHand.rank]*((self.ewAP[ewRank])/100)
				end
				local offHandAddedDPS = floor((self.windfuryAP[self.offHand.rank]+ewAddedAP)/14)
				
				self:PrintDebug("Windfury Added DPS: " .. offHandAddedDPS)

				-- Calculate the dps of the weapon
				local offHandAvgDPS = (offHandDmgAvg+(offHandCritAvg*(critChance/100)))/self.offHand.speed
				
				-- Calculate the dps by adding two attacks and then the 20% chance for the attack to proc
				offHandTheoDPS = self:Round(((offHandAvgDPS+offHandAddedDPS)*2)*0.20,1)
				
				self:PrintDebug("Windfury Theoretical DPS: " .. offHandTheoDPS)
			else
				offHandTheoDPS = 0
			end
			
			-- Calculate total theoretical DPS for both weapons
			theoDPS = mainHandTheoDPS + offHandTheoDPS
			
			cat:AddLine(
				'text', L["Theoretical DPS"]..":",
				'text2', "~" .. theoDPS
			)
		end
		
		actualDPS = 0
		if ((mainSpeed ~= nil) and (self.db.char.lifetime[self.mainHand.name].combatTime > 0)) then
			actualDPS = self:Round((self.db.char.lifetime[self.mainHand.name].totalDamage/self.db.char.lifetime[self.mainHand.name].combatTime),1)
		end
		
		cat:AddLine(
			'text', L["Actual DPS"]..":",
			'text2', actualDPS
		)
	end

	if (self.db.profile.tooltipShowHint) then
		T:SetHint(L["Shift-Click to insert your stats into a chat message."])
	end
end

function WindFuryFu:InventoryChanged()
	if (arg1 == "player") then
		self:WeaponCheck()
	end
end

function WindFuryFu:SpellSelfDamage()
	if (self.status) then
		-- Trigger for Windfury Attack
		if (string.find(arg1, L["Windfury"])) then
			
			--if (self.dualHit) then
			--	self.swingsLeft = self.swingsLeft + 2
			if (self.swingsLeft == 0) then
				self.swingsLeft = 2
				self.totalDamage = 0
				self.hitCount = 0
				self:AddValue("hitCount", 1, "session")
				self:AddValue("hitCount", 1, "lifetime")
				self:AddValue("procCount", 1, "session")
				self:AddValue("procCount", 1, "lifetime")
			end
			
			local _,creatureName,tdamage
			
			-- Normal Windfury Attack (SPELLLOGSELFOTHER)
			_,creatureName,tdamage = D(arg1, SPELLLOGSELFOTHER)
			if not (creatureName) then
				-- Normal Windfury Attack Partially Blocked (Added BLOCK_TRAILER)
				_,creatureName,tdamage = D(arg1, SPELLLOGSELFOTHER .. BLOCK_TRAILER)
			end
			if not (creatureName) then
				-- Normal Windfury Attack Partially Resisted (Added RESIST_TRAILER)
				_,creatureName,tdamage = D(arg1, SPELLLOGSELFOTHER .. RESIST_TRAILER)
			end
			if not (creatureName) then
				-- Normal Windfury Attack Partially Absorbed (Added ABSORB_TRAILER)
				_,creatureName,tdamage = D(arg1, SPELLLOGSELFOTHER .. ABSORB_TRAILER)
			end
			if (creatureName ~= nil) then
				self.totalDamage = self.totalDamage + tdamage
				self.hitCount = tonumber(tdamage)
				self:AddValue("totalDamage", tdamage, "lifetime")
				self:AddValue("totalDamage", tdamage, "session")		
			else
			
				-- Critical Windfury Attack (SPELLLOGCRITSELFOTHER)
				_,creatureName,tdamage = D(arg1, SPELLLOGCRITSELFOTHER)
				if not (creatureName) then
					-- Critical Windfury Attack Partially Blocked (Added BLOCK_TRAILER)
					_,creatureName,tdamage = D(arg1, SPELLLOGCRITSELFOTHER .. BLOCK_TRAILER)
				end
				if not (creatureName) then
					-- Critical Windfury Attack Partially Resisted (Added RESIST_TRAILER)
					_,creatureName,tdamage = D(arg1, SPELLLOGCRITSELFOTHER .. RESIST_TRAILER)
				end
				if not (creatureName) then
					-- Critical Windfury Attack Partially Absorbed (Added ABSORB_TRAILER)
					_,creatureName,tdamage = D(arg1, SPELLLOGCRITSELFOTHER .. ABSORB_TRAILER)
				end
				if (creatureName ~= nil) then
					self.totalDamage = self.totalDamage + tdamage
					self.hitCount = tonumber(tdamage)
					self.critCount = self.critCount + 1
					self:AddValue("totalDamage", tdamage, "lifetime")
					self:AddValue("totalDamage", tdamage, "session")
					self:AddValue("critCount", 1, "session")
					self:AddValue("critCount", 1, "lifetime")
				else				
					-- Dodged Windfury Attack (SPELLDODGEDSELFOTHER)
					_,creatureName = D(arg1, SPELLDODGEDSELFOTHER)
					if (creatureName ~= nil) then
						if (self.db.profile.sctShowDodge) then
							self:PrintTotal(L["Windfury"] ..": |cffff0000" ..L["DODGED!"])
						end
					else
					
						-- Blocked Windfury Attack (SPELLBLOCKEDSELFOTHER)
						_,creatureName = D(arg1, SPELLBLOCKEDSELFOTHER)
						if (creatureName ~= nil) then
							if (self.db.profile.sctShowBlock) then
								self:PrintTotal(L["Windfury"] ..": |cffff0000" ..L["BLOCKED!"])
							end
						else
						
							-- Missed Windfury Attack (SPELLMISSSELFOTHER)
							_,creatureName = D(arg1, SPELLMISSSELFOTHER)
							if (creatureName ~= nil) then
								if (self.db.profile.sctShowMiss) then
									self:PrintTotal(L["Windfury"] ..": |cffff0000" ..L["MISSED!"])
								end
							else
							
								-- Parried Windfury Attack (SPELLPARRIEDSELFOTHER)
								_,creatureName = D(arg1, SPELLPARRIEDSELFOTHER)
								if (creatureName ~= nil) then
									if (self.db.profile.sctShowParry) then
										self:PrintTotal(L["Windfury"] ..": |cffff0000" ..L["PARRIED!"])
									end
								else
								
									-- Evaded Windfury Attack (SPELLPARRIEDSELFOTHER)
									_,creatureName = D(arg1, SPELLEVADEDSELFOTHER)
									if (creatureName ~= nil) then
										if (self.db.profile.sctShowEvade) then
											self:PrintTotal(L["Windfury"] ..": |cffff0000" ..L["EVADED!"])
										end
									else
									
										-- Absorbed Windfury Attack (SPELLLOGABSORBSELFOTHER)
										_,creatureName = D(arg1, SPELLLOGABSORBSELFOTHER)
										if (creatureName ~= nil) then
											if (self.db.profile.sctShowAbsorb) then
												self:PrintTotal(L["Windfury"] ..": |cffff0000" ..L["ABSORBED!"])
											end
										else
											self:PrintDebug("Action '" .. arg1 .. "' is unhandled.")
											return
										end
									end
								end
							end
						end
					end
				end
			end

			self:TriggerWindfury()

			if (self.dualHit) then
				windfuryType = L["Dual Windfury"]
			else
				windfuryType = L["Windfury"]
			end

			if (self.victim.dead == true) then
				self:PrintTotal(windfuryType .." (single death): |cffff0000" .. self.totalDamage)
				self.victim.dead = false
			elseif (self.swingsLeft < 1) then
				self:PrintTotal(windfuryType ..": |cffff0000" .. self.totalDamage)
			end
		-- Trigger for Stormstrike
		elseif (string.find(arg1, BS["Stormstrike"])) then
			local _,creatureName,tdamage
			local isCrit = false
			-- Normal Stormstrike Attack (SPELLLOGSELFOTHER)
			_,creatureName,tdamage = D(arg1, SPELLLOGSELFOTHER)
			if not (creatureName) then
				_,creatureName,tdamage = D(arg1, SPELLLOGSELFOTHER .. BLOCK_TRAILER)
			end
			if not (creatureName) then
				_,creatureName,tdamage = D(arg1, SPELLLOGSELFOTHER .. RESIST_TRAILER)
			end
			if not (creatureName) then
				_,creatureName,tdamage = D(arg1, SPELLLOGSELFOTHER .. ABSORB_TRAILER)
			end
			if not (creatureName) then
				_,creatureName,tdamage = D(arg1, SPELLLOGSELFOTHER .. GLANCING_TRAILER)
			end
			if (creatureName ~= nil) then
				self.lastHitIsCrit = false			
			else
				-- Critical Stormstrike Attack (SPELLLOGCRITELFOTHER)
				_,creatureName,tdamage = D(arg1, SPELLLOGCRITSELFOTHER)
				if not (creatureName) then
					_,creatureName,tdamage = D(arg1, SPELLLOGCRITSELFOTHER .. BLOCK_TRAILER)
				end
				if not (creatureName) then
					_,creatureName,tdamage = D(arg1, SPELLLOGCRITSELFOTHER .. RESIST_TRAILER)
				end
				if not (creatureName) then
					_,creatureName,tdamage = D(arg1, SPELLLOGCRITSELFOTHER .. ABSORB_TRAILER)
				end
				if not (creatureName) then
					_,creatureName,tdamage = D(arg1, SPELLLOGCRITSELFOTHER .. GLANCING_TRAILER)
				end
				if (creatureName ~= nil) then
					self.lastHitIsCrit = true
				end
			end
			
			if (tdamage ~= nil) then
				if ((self.dualWield) and (self.swingsLeft > 0)) then
					self.dualHit = true
				end
				self.lastHit = tdamage
				self:AddValue("hitCount", 1, "session")
				self:AddValue("hitCount", 1, "lifetime")
				self:Update()
			else
				self.lastHit = 0
			end
		end
	end
end

function WindFuryFu:PrintDebug(text)
		if (self.db.profile.debugEnabled) then
			self:Print("Debug: " .. text)
		end
end

function WindFuryFu:PrintTotal(text)
	if (self.db.profile.displayChat) then
		self:Print(text)
	end
	if (self.db.profile.sctEnabled) then
		local color = self.db.profile.fontColor
		if (IsAddOnLoaded("MikScrollingBattleText")) then
			MikSBT.DisplayMessage(
				text,
				MikSBT.DISPLAYTYPE_OUTGOING, 
				true, 
				self.db.profile.fontColor.r*255, 
				self.db.profile.fontColor.g*255, 
				self.db.profile.fontColor.b*255, 
				self.db.profile.fontSize, 
				self.db.profile.fontFace
			);
		elseif (IsAddOnLoaded("sct")) then
			SCT:DisplayMessage(
				text,
				self.db.profile.fontColor
			);
		end
	end
end

function WindFuryFu:SetVictimInfo()
	local name = UnitName("target")
	if (name ~= nil) then
		local level = UnitLevel("target")
		local _,class = UnitClass("target")
		self.victim.name = name
		self.victim.class = class
		self.victim.level = level
		self.victim.dead = false
	end
end

function WindFuryFu:TargetChanged()
		if (UnitAffectingCombat("player") and (self.status)) then
			self:SetVictimInfo()
		end
end

function WindFuryFu:EnterCombat()
	if (self.status) then
		self:SetVictimInfo()
		self.combatStart = GetTime()
	end
end

function WindFuryFu:LeaveCombat()
	if (self.status and self.CombatStart) then
		local addTime = GetTime()-self.combatStart
		self.db.char.session[self.mainHand.name].combatTime = self.db.char.session[self.mainHand.name].combatTime + addTime
		self.db.char.lifetime[self.mainHand.name].combatTime = self.db.char.lifetime[self.mainHand.name].combatTime + addTime
		self.combatStart = nil
		self:Update()
	end
end

function WindFuryFu:CombatSelfHit()
	if (self.status) then
		local target, tdamage, isCrit

		isCrit = false
		target, tdamage, _ = D(arg1, COMBATHITSELFOTHER)
		if not target then
			target, tdamage, _ = D(arg1, COMBATHITSELFOTHER .. GLANCING_TRAILER)
			if not target then
				target, tdamage, _ = D(arg1, COMBATHITSELFOTHER .. BLOCK_TRAILER)
				if not target then
					target, tdamage, _ = D(arg1, COMBATHITSELFOTHER .. RESIST_TRAILER)
					if not target then
						target, tdamage, _ = D(arg1, COMBATHITSELFOTHER .. ABSORB_TRAILER)
						if not target then
							isCrit = true
							target, tdamage = D(arg1, COMBATHITCRITSELFOTHER)
							if not target then
								target, tdamage = D(arg1, COMBATHITCRITSELFOTHER .. GLANCING_TRAILER)
								if not target then
									target, tdamage = D(arg1, COMBATHITCRITSELFOTHER .. BLOCK_TRAILER)
									if not target then
										target, tdamage = D(arg1, COMBATHITCRITSELFOTHER .. RESIST_TRAILER)
										if not target then
											target, tdamage = D(arg1, COMBATHITCRITSELFOTHER .. ABSORB_TRAILER)
											if not target then
												isCrit = false
											end
										end
									end
								end
							end
						end
					end
				end
			end
		end
		
		if not target then
			isCrit = false
			target, tdamage = D(arg1, COMBATHITSCHOOLSELFOTHER)
			if not target then
				target, tdamage = D(arg1, COMBATHITSCHOOLSELFOTHER .. GLANCING_TRAILER)
				if not target then
					target, tdamage = D(arg1, COMBATHITSCHOOLSELFOTHER .. BLOCK_TRAILER)
					if not target then
						target, tdamage = D(arg1, COMBATHITSCHOOLSELFOTHER .. RESIST_TRAILER)
						if not target then
							target, tdamage = D(arg1, COMBATHITSCHOOLSELFOTHER .. ABSORB_TRAILER)
							if not target then
								isCrit = true
								target, tdamage = D(arg1, COMBATHITCRITSCHOOLSELFOTHER)
								if not target then
									target, tdamage = D(arg1, COMBATHITCRITSCHOOLSELFOTHER .. GLANCING_TRAILER)
									if not target then
										target, tdamage = D(arg1, COMBATHITCRITSCHOOLSELFOTHER .. BLOCK_TRAILER)
										if not target then
											target, tdamage = D(arg1, COMBATHITCRITSCHOOLSELFOTHER .. RESIST_TRAILER)
											if not target then
												target, tdamage = D(arg1, COMBATHITCRITSCHOOLSELFOTHER .. ABSORB_TRAILER)
												if not target then
													isCrit = false
												end
											end
										end
									end
								end
							end
						end
					end
				end
			end
		end
		
		if not target then
			isCrit = false
			target, tdamage = D(arg1, COMBATHITSELFOTHER .. CRUSHING_TRAILER)
			if not target then
				target, tdamage = D(arg1, COMBATHITSCHOOLSELFOTHER .. CRUSHING_TRAILER)
				if not target then
					isCrit = true
					target, tdamage = D(arg1, COMBATHITCRITSELFOTHER .. CRUSHING_TRAILER)
					if not target then
						target, tdamage = D(arg1, COMBATHITCRITSCHOOLSELFOTHER .. CRUSHING_TRAILER)
						if not target then
							isCrit = false
						end
					end
				end
			end
		end
		
		if ((self.dualWield) and (self.swingsLeft > 0)) then
			self.dualHit = true
		end

		if (tdamage ~= nil) then
			self.lastHit = tdamage
		else
			self.lastHit = 0
		end
		
		if (isCrit) and (tdamage ~= nil) then
			self.lastHitIsCrit = true
		else
			self.lastHitIsCrit = false
		end
		
		self:AddValue("hitCount", 1, "session")
		self:AddValue("hitCount", 1, "lifetime")
		self:Update()
	end
end

function WindFuryFu:TriggerWindfury()
	local victim = self.victim
	self.swingsLeft = self.swingsLeft - 1
	
	if ( self.hitCount > self.db.char.session[self.mainHand.name].bestSingleHit ) then
		self.db.char.session[self.mainHand.name].bestSingleHit = self.hitCount
		self.db.char.session[self.mainHand.name].bestSingleHit_Victim = {
			name = victim.name,
			class = victim.class,
			level = victim.level
		}
	end
	if ( self.hitCount > self.db.char.lifetime[self.mainHand.name].bestSingleHit ) then
		self.db.char.lifetime[self.mainHand.name].bestSingleHit = self.hitCount
		self.db.char.lifetime[self.mainHand.name].bestSingleHit_Victim = {
			name = victim.name,
			class = victim.class,
			level = victim.level
		}
	end
	
	if ((self.swingsLeft < 1) or (self.victim.dead)) then
		-- If endabled, will add the first hit to the windfury attack total damage
		if (self.db.profile.countFirstHit) then
			self.totalDamage = self.totalDamage + self.lastHit
			if (self.lastHitIsCrit) then
				self:AddValue("critCount", 1, "session")
			end
		end

		if (self.totalDamage > self.db.char.session[self.mainHand.name].bestHit) then
			self.db.char.session[self.mainHand.name].bestHit = self.totalDamage
			self.db.char.session[self.mainHand.name].bestHit_Victim = {
				name = victim.name,
				class = victim.class,
				level = victim.level
			}
		end
		if (self.totalDamage > self.db.char.lifetime[self.mainHand.name].bestWindfury) then
			self.db.char.lifetime[self.mainHand.name].bestWindfury = self.totalDamage
			self.db.char.lifetime[self.mainHand.name].bestWindfury_Victim = {
				name = victim.name,
				class = victim.class,
				level = victim.level
			}
		end
		
		if ((self.dualHit) and(self.activeWeapon== "both")) then
			self:UpdateStats(self.mainHand.name, true)
			self:UpdateStats(self.offHand.name, true)
		else
			if (self.activeWeapon== "mainhand") then
				self:UpdateStats(self.mainHand.name, false)
			elseif  (self.activeWeapon== "offhand") then
				self:UpdateStats(self.offHand.name, false)
			elseif (self.activeWeapon== "both") then
				self:UpdateStats(self.mainHand.name, false)
				self:UpdateStats(self.offHand.name, false)
			end
		end

		self.lastHit = 0
		self.lastHitIsCrit = false
		self.critCount = 0
		self.swingsLeft = 0
		self.dualHit = false
	end
	self:Update()
end

function WindFuryFu:UpdateStats(weapon, dualHit)
	self.db.char.session[weapon].lastCrit[5] = self.db.char.session[weapon].lastCrit[4]
	self.db.char.session[weapon].lastCrit[4] = self.db.char.session[weapon].lastCrit[3]
	self.db.char.session[weapon].lastCrit[3] = self.db.char.session[weapon].lastCrit[2]
	self.db.char.session[weapon].lastCrit[2] = self.db.char.session[weapon].lastCrit[1]

	self.db.char.session[weapon].lastWindfury[5] = self.db.char.session[weapon].lastWindfury[4]
	self.db.char.session[weapon].lastWindfury[4] = self.db.char.session[weapon].lastWindfury[3]
	self.db.char.session[weapon].lastWindfury[3] = self.db.char.session[weapon].lastWindfury[2]
	self.db.char.session[weapon].lastWindfury[2] = self.db.char.session[weapon].lastWindfury[1]
	
	if (dualHit) then
		self.db.char.session[weapon].lastCrit[1] = ceil(self.critCount/2)
		self.db.char.session[weapon].lastWindfury[1] = ceil(self.totalDamage/2)
	else
		self.db.char.session[weapon].lastCrit[1] = self.critCount
		self.db.char.session[weapon].lastWindfury[1] = self.totalDamage
	end

	self.db.char.session[weapon].lastWindfury_Victim[5] = {
		name = self.db.char.session[weapon].lastWindfury_Victim[4].name,
		class = self.db.char.session[weapon].lastWindfury_Victim[4].class,
		level = self.db.char.session[weapon].lastWindfury_Victim[4].level
	}
	
	self.db.char.session[weapon].lastWindfury_Victim[4] = {
		name = self.db.char.session[weapon].lastWindfury_Victim[3].name,
		class = self.db.char.session[weapon].lastWindfury_Victim[3].class,
		level = self.db.char.session[weapon].lastWindfury_Victim[3].level
	}
	
	self.db.char.session[weapon].lastWindfury_Victim[3] = {
		name = self.db.char.session[weapon].lastWindfury_Victim[2].name,
		class = self.db.char.session[weapon].lastWindfury_Victim[2].class,
		level = self.db.char.session[weapon].lastWindfury_Victim[2].level
	}
	
	self.db.char.session[weapon].lastWindfury_Victim[2] = {
		name = self.db.char.session[weapon].lastWindfury_Victim[1].name,
		class = self.db.char.session[weapon].lastWindfury_Victim[1].class,
		level = self.db.char.session[weapon].lastWindfury_Victim[1].level
	}
	
	self.db.char.session[weapon].lastWindfury_Victim[1] = {
		name = self.victim.name,
		class = self.victim.class,
		level = self.victim.level
	}
end

function WindFuryFu:CombatHostileDeath()
	if (self.status) then
		-- SELFKILLOTHER = You have slain %s!
		local name = D(arg1, SELFKILLOTHER)
		if (name == self.victim.name) then
			self.victim.dead = true
		end
	end
end

function WindFuryFu:ResetStats(type)
	if (type == "session") then
		self:SetupWeapon(self.mainHand.name, "session")
	elseif (type == "lifetime") then
		self:SetupWeapon(self.mainHand.name, "lifetime")
	end
	self:Update()
end

function WindFuryFu:WeaponCheck()
	self.status = self:WeaponsBuffed()
	self.dualWield = false
	local mainHandLink = GetInventoryItemLink("player", GetInventorySlotInfo("MainHandSlot"))
	local mainSpeed, offSpeed = UnitAttackSpeed("player");
	local offHandLink = nil
	local mainHandName = ""
	local offHandName = ""
	local activeWeapon = ""
	
	if (mainHandLink ~= nil) then
		local _,_,_,_,_,_,weaponType = GetItemInfo(mainHandLink);
		if ((OffhandHasWeapon() == 1) and (string.find(weaponType, "Two-Handed") == nil)) then
			offHandLink = GetInventoryItemLink("player", GetInventorySlotInfo("SecondaryHandSlot"))
		end
	end

	if ((mainHandLink == nil) and (offHandLink == nil)) then
		mainHandName = L["No Weapon Equipped"]
		activeWeapon = "none"
	elseif ((mainHandLink == nil) and (offHandLink ~= nil)) then
		local _, _,itemCode = strfind(offHandLink, "(%d+):")
		offHandName = GetItemInfo(itemCode)
		activeWeapon = "offhand"
	elseif ((mainHandLink ~= nil) and (offHandLink ~= nil)) then
		self.dualWield = true
		local _, _, itemCode1 = strfind(mainHandLink, "(%d+):")
		local _, _, itemCode2 = strfind(offHandLink, "(%d+):")
		mainHandName = GetItemInfo(itemCode1)
		offHandName = GetItemInfo(itemCode2)
		activeWeapon = "both"
	else
		local _, _, itemCode = strfind(mainHandLink, "(%d+):")
		mainHandName = GetItemInfo(itemCode)
		activeWeapon = "mainhand"
	end
	
	self.activeWeapon = activeWeapon
	
	self.mainHand.name = mainHandName
	self.mainHand.speed = mainSpeed

	self.offHand.name = offHandName
	self.offHand.speed = offSpeed

	if (self.mainHand.name ~= "") then
		if (self.db.char.lifetime[self.mainHand.name] == nil) then
			self:SetupWeapon(self.mainHand.name, "lifetime")
		end
		if (self.db.char.session[self.mainHand.name] == nil) then
			self:SetupWeapon(self.mainHand.name, "session")
		end
		-- Added this check for compatibility with 2.0b1
		if (self.db.char.lifetime[self.mainHand.name].bestSingleHit_Victim == nil) then
			self:SetupWeapon(self.mainHand.name, "lifetime")
			self:SetupWeapon(self.mainHand.name, "session")
		end
	end
	
	if (self.offHand.name ~= "") then
		if (self.db.char.lifetime[self.offHand.name] == nil) then
			self:SetupWeapon(self.offHand.name, "lifetime")
		end
		if (self.db.char.session[self.offHand.name] == nil) then
			self:SetupWeapon(self.offHand.name, "session")
		end
		-- Added this check for compatibility with 2.0b1
		if (self.db.char.lifetime[self.offHand.name].bestSingleHit_Victim == nil) then
			self:SetupWeapon(self.offHand.name, "lifetime")
			self:SetupWeapon(self.offHand.name, "session")
		end
	end
	self:Update()
end

function WindFuryFu:WeaponsBuffed()
	self.mainHand.enchanted = false
	self.mainHand.rank = 0
	self.offHand.enchanted = false
	self.offHand.rank = 0
	
	local chMHE,_,_chOHE = GetWeaponEnchantInfo()
	if ((chMHE) or (chOHE)) then
		local windfuryBuff = L["Windfury"]
		-- Fix for the german version
		if (GetLocale() == "deDE") then
			windfuryBuff = L["WindfuryBuff"]
		end
	
		local mainHand = G:SetInventoryItem("player", GetInventorySlotInfo("MainHandSlot"))
		if (mainHand) then
			self:PrintDebug("Looking for " .. windfuryBuff .. "-buff on main-hand.")
			if (G:Find(windfuryBuff) and not G:Find(BS["Windfury Totem"])) then
				self.mainHand.enchanted = true
				self.mainHand.rank = tonumber(select(3,G:Find(windfuryBuff .. " (%d)")))
				self:PrintDebug("Found " .. windfuryBuff .. " " .. self.mainHand.rank .. ".")
			end
		end
		
		local offHand = G:SetInventoryItem("player", GetInventorySlotInfo("SecondaryHandSlot"))
		if (offHand) then
			self:PrintDebug("Looking for " .. windfuryBuff .. "-buff on off-hand.")
			if (G:Find(windfuryBuff) and not G:Find(BS["Windfury Totem"])) then
				self.offHand.enchanted = true
				self.offHand.rank = tonumber(select(3,G:Find(windfuryBuff .. " (%d)")))
				self:PrintDebug("Found " .. windfuryBuff .. " " .. self.offHand.rank .. ".")
			end
		end
		
		if ((self.mainHand.enchanted) or (self.offHand.enchanted)) then
			return true
		end
	end
	return false
end

function WindFuryFu:AddValue(var, val, type)
	if ( type == "lifetime" ) then
		self.db.char.lifetime[self.mainHand.name][var] = self.db.char.lifetime[self.mainHand.name][var] + val
	elseif ( type == "session" ) then
		self.db.char.session[self.mainHand.name][var] = self.db.char.session[self.mainHand.name][var] + val
	end
end

function WindFuryFu:SetupWeapon(weapon, type)
	if ( weapon ~= nil ) then
	self:PrintDebug("Setting up weapon '" ..weapon.."' for " ..type..".")
	end	
	if ( type == "lifetime" ) then
		self.db.char.lifetime[weapon] = {}
		self.db.char.lifetime[weapon].totalDamage = 0
		self.db.char.lifetime[weapon].procCount = 0
		self.db.char.lifetime[weapon].hitCount = 0
		self.db.char.lifetime[weapon].critCount = 0
		self.db.char.lifetime[weapon].combatTime = 0
		
		self.db.char.lifetime[weapon].bestSingleHit = 0
		self.db.char.lifetime[weapon].bestSingleHit_Victim = {
			name = "-",
			class = "",
			level = 0
		}
		
		self.db.char.lifetime[weapon].bestWindfury = 0
		self.db.char.lifetime[weapon].bestWindfury_Victim = {
			name = "-",
			class = "",
			level = 0
		}
	elseif ( type == "session" ) then
		self.db.char.session[weapon] = {}

		self.db.char.session[weapon].combatTime = 0
		self.db.char.session[weapon].bestSingleHit = 0
		self.db.char.session[weapon].bestSingleHit_Victim = {
			name = "-",
			class = "",
			level = 0
		}
		
		self.db.char.session[weapon].bestHit = 0
		self.db.char.session[weapon].bestHit_Victim = {
			name = "-",
			class = "",
			level = 0
		}
		
		self.db.char.session[weapon].lastWindfury = { 0,0,0,0,0 }
		self.db.char.session[weapon].lastWindfury_Victim = {1,2,3,4,5}
		
		self.db.char.session[weapon].lastWindfury_Victim[1] = {
			name = "-",
			class = "",
			level = 0
		}
		self.db.char.session[weapon].lastWindfury_Victim[2] = {
			name = "-",
			class = "",
			level = 0
		}
		self.db.char.session[weapon].lastWindfury_Victim[3] = {
			name = "-",
			class = "",
			level = 0
		}
		self.db.char.session[weapon].lastWindfury_Victim[4] = {
			name = "-",
			class = "",
			level = 0
		}
		self.db.char.session[weapon].lastWindfury_Victim[5] = {
			name = "-",
			class = "",
			level = 0
		}
		
		self.db.char.session[weapon].lastCrit = { 0,0,0,0,0 }
		self.db.char.session[weapon].hitCount = 0
		self.db.char.session[weapon].critCount = 0
		self.db.char.session[weapon].procCount = 0
		self.db.char.session[weapon].totalDamage = 0
	end
end
