WhoLibFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0")

WhoLibFu.hasIcon = true
WhoLibFu.cannotDetachTooltip = true
WhoLibFu.canHideText = true
WhoLibFu.defaultPosition = "CENTER"

local Tablet = AceLibrary("Tablet-2.0")

local options = {
	type = "group",
	disabled = function() return not WhoLibByALeX end,
	args = {
		debug = {
			type = "toggle",
			name = 'WhoLib Debugging',
			desc = 'means: ton\'s on chat log lines',
			get = function()
				return WhoLibByALeX.Debug
			end,
			set = function()
				WhoLibByALeX.Debug = not WhoLibByALeX.Debug
			end,
			order = 1,
		},
		snake = {
			type = "toggle",
			name = 'Snake icon',
			desc = 'Yes, the german word "Schlange" means snake and queue...',
			get = function()
				return true
			end,
			set = function()
			end,
			order = 2,
		},
	},
}
WhoLibFu.OnMenuRequest = options

function WhoLibFu:OnEnable()
end

function WhoLibFu:OnTextUpdate()
	if WhoLibByALeX then
		local text = #WhoLibByALeX.Queue[1] .. '/' .. #WhoLibByALeX.Queue[2] .. '/' .. #WhoLibByALeX.Queue[3]
		self:SetText(text)
	end
end

function WhoLibFu:OnTooltipUpdate()
	if WhoLibByALeX then
	    local cat = Tablet:AddCategory(
	        'columns', 1,
	        'child_textR', 1,
	        'child_textG', 1,
	        'child_textB', 1
	    )
	    
		cat:AddLine(
			'text', '|cff00ff00WhoLib Queues:|r'
		)
	
	    for num,name in ipairs({
	    	'USER',
	    	'QUIET',
	    	'SCANNING',
	    }) do
			cat:AddLine(
				'text', '|cffffff00'..name..'|r'
			)
			if(#WhoLibByALeX.Queue[num] == 0)then
					cat:AddLine(
						'text', '|cff888888empty\r'
					)
			else
				for _,v in ipairs(WhoLibByALeX.Queue[num]) do
					local text
					if(v.info)then
						text = 'UserInfo: ' .. v.info
					elseif(v.gui)then
						text = 'WhoFrame: ' .. v.query
					elseif(num == 1)then
						text = 'Console: ' .. v.query
					else
						text = 'Who: ' .. v.query
					end
					cat:AddLine(
						'text', text
					)
				end
			end
		end
	end
end

function WhoLibFu:OnClick(button)
end
