--[[
	WarriorAlertFu 2.0.0 by LordRhys
	
	Check out readme.txt for more info
]]

local dewdrop = AceLibrary("Dewdrop-2.0")
local tablet = AceLibrary("Tablet-2.0")
local crayon = AceLibrary("Crayon-2.0")

WarriorAlertFu = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0", "FuBarPlugin-2.0")

WarriorAlertFu.version       = "2.0.0." .. string.sub("$Revision: 36382 $", 12, -3)
WarriorAlertFu.releaseDate   = string.sub("$Date: 2007-05-22 08:00:38 -0500 (Tue, 22 May 2007) $", 8, 17)
WarriorAlertFu.hasIcon = true
WarriorAlertFu.defaultPosition = 'LEFT'
WarriorAlertFu.canHideText = true
WarriorAlertFu.clickableTooltip = true



local optionsList = WarriorAlert.optionsTable
						
WarriorAlertFu:RegisterChatCommand({"/wafu","/walert"},optionsList)
-- WarriorAlertFu.OnMenuRequest = optionsList										
											
--------------------------------------------------------------------------------
-- functions --------------------------------------------------------------
--------------------------------------------------------------------------------										
										
function WarriorAlertFu:OnInitialize()
	self.db = WarriorAlert:AcquireDBNamespace("fubar")

	WarriorAlert.optionsTable.args.options.fubarSpacer = {
		order = 160,
		type = "header",
	}
	WarriorAlert.optionsTable.args.options.fubar = {
		order = 161,
		type = "group",
		name = "FuBarPlugin Config", -- L["FuBarPlugin Config"],
		desc = "Configure the FuBar Plugin", -- L["Configure the FuBar Plugin"],
		args = {},
	}
	AceLibrary("AceConsole-2.0"):InjectAceOptionsTable(self, WarriorAlert.optionsTable.args.fubar)
	self.OnMenuRequest = WarriorAlert.optionsTable
end


--------------------------------------------------------------------------------
-- FuBar functions ---------------------------------------------------------
--------------------------------------------------------------------------------

-- function WarriorAlertFu:OnTextUpdate()
  	-- self:SetText("WarriorAlertFu Enabled: "..self.db.char.WAFuEnabled)
-- end

function WarriorAlertFu:OnTooltipUpdate()
	tablet:SetHint(crayon:White("MessageFrame is: ")..crayon:Purple(WarriorAlert.db.char.MessageFramePos)..crayon:White(" Click to Lock or Unlock it."))
	-- as a rule, if you have an OnClick or OnDoubleClick or OnMouseUp or OnMouseDown, you should set a hint.
end

function WarriorAlertFu:OnClick()
  WarriorAlert.db.char.locked = not WarriorAlert.db.char.locked
  if (WarriorAlert.db.char.locked) then
  	WarriorAlert.db.char.MessageFramePos = "Locked"
  	WarriorAlert.frame:Hide()
  else
  	WarriorAlert.db.char.MessageFramePos = "UnLocked"
  	WarriorAlert.frame:Show()
  end
  WarriorAlertFu:UpdateDisplay()
end

function WarriorAlertFu:Test()
	WarriorAlert:Display("TEST Message!")
end
