--[[
	WarriorAlert 2.0.0 by LordRhys
	includes WarriorAlertFu
	Check out readme.txt for more info
]]

local dewdrop = AceLibrary("Dewdrop-2.0")
local tablet = AceLibrary("Tablet-2.0")
local crayon = AceLibrary("Crayon-2.0")
-- local parser = AceLibrary("Parser-3.0")

WarriorAlert = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0")
local WarriorAlert = WarriorAlert

WarriorAlert.version       = "2.0.0." .. string.sub("$Revision: 36382 $", 12, -3)
WarriorAlert.releaseDate   = string.sub("$Date: 2007-05-22 08:00:38 -0500 (Tue, 22 May 2007) $", 8, 17)

WarriorAlert_spellName = {
	"Execute","Overpower","Mortal Strike","Revenge","Bloodthirst",
	}
								
OverpowerMsg = {"You attack.(.+) dodges.","Your (.+) was dodged by (.+)."}
RevengeMsg = {"(.+) attacks. You dodge.","(.+) attacks. You parry.","(.+) attacks. You block."}
											
--------------------------------------------------------------------------------
-- functions --------------------------------------------------------------
--------------------------------------------------------------------------------										
										
function WarriorAlert:OnInitialize()
	local i;
	local _, class = UnitClass("player");
	if(class == "WARRIOR") then
		DEFAULT_CHAT_FRAME:AddMessage("LordRhys's WarriorAlert "..self.version.." loaded.")
		self.db.char.WAFuEnabled = true
		for i=1, 120 do
			self:GetSlots(i);
		end
		WarriorAlert:RegisterDB("WarriorAlertDB")
		WarriorAlert_timeSinceLastUpdate = 0
		WarriorAlert_LookupDone = 0
 		self:InitializeDefaults()   -- create DB defaults 
		self:CreateOptions()				-- setup Options
		self:CreateFrames()
		self:SetFont()

  	if (MikSBT) then
  		table.insert(self.optionsTable.args.options.args.display.validate, "MSBT")
  	end
  
  	if (SCT_Display) or (SCT and SCT.DisplayText) then
  		table.insert(self.optionsTable.args.options.args.display.validate, "SCT")
  		table.insert(self.optionsTable.args.options.args.display.validate, "SCT Message")
  	end

		-- parser:RegisterEvent("RampageReminder", "CHAT_MSG_COMBAT_SELF_HITS", function(event, info) self:EventHandler(event, info) end)

	else
		self.db.char.WAFuEnabled = false
		DisableAddOn("WarriorAlert")
	end
end

function WarriorAlert:OnEnable()
	
		self:RegisterEvent("UNIT_HEALTH","DoExecute")
		self:RegisterEvent("UNIT_RAGE","RageChecks")
		self:RegisterEvent("PLAYER_TARGET_CHANGED","TargetChanged")
		self:RegisterEvent("CHAT_MSG_COMBAT_SELF_MISSES","DoOverpower")
		self:RegisterEvent("CHAT_MSG_COMBAT_CREATURE_VS_SELF_MISSES","DoRevenge")
		self:RegisterEvent("ACTIONBAR_UPDATE_COOLDOWN","DoMortalStrike")
		self:RegisterEvent("SPELL_UPDATE_COOLDOWN","Instant")
		self:RegisterEvent("ACTIONBAR_SLOT_CHANGED","GetSlots")
		self:RegisterEvent("PLAYER_REGEN_DISABLED","LookUpActions")
		self:RegisterEvent("CHAT_MSG_SPELL_SELF_DAMAGE","DoOverpower")
		self:RegisterEvent("LEARNED_SPELL_IN_TAB","CheckSpells")	
end

function AutoBar:InitializeDefaults()
	self.defaults = {
		WarriorAlerts = {
  		["Overpower"] = {
  			["Message"] = true,
  			["Sound"] = true,
  			["Battle Stance"] = true,
  			["Defensive Stance"] = true,
  			["Berserker Stance"] = true,
  		},
  		["Mortal Strike"] = {       
  			["Message"] = true,
  			["Sound"] = true,
  			["Battle Stance"] = true,
  			["Defensive Stance"] = true,
  			["Berserker Stance"] = true,
  		},
  		["Execute"] = {
  			["Message"] = true,
  			["Sound"] = true,
  			["Battle Stance"] = true,
  			["Defensive Stance"] = true,
  			["Berserker Stance"] = true,
  		},
  		["Revenge"] = {
  			["Message"] = true,
  			["Sound"] = true,
  			["Battle Stance"] = false,
  			["Defensive Stance"] = true,
  			["Berserker Stance"] = false,
  		},
  		["Bloodthirst"] = {
  			["Message"] = true,
  			["Sound"] = true,
  			["Battle Stance"] = true,
  			["Defensive Stance"] = true,
  			["Berserker Stance"] = true,
  		},
  	},
  	WarriorAlertSpellPos = { 
  		["Execute"] = {
  			["spellPos"] = -1,
  			["inCooldown"] = 0,
  			["sekCooldown"] = 0,
  			["startTime"] = 0,
  			["tab"] = 2,
  			["messageShown"] = 0,
  			["slot"] = 0,
  			["canCast"] = 0,
  		},
  		["Mortal Strike"] = {
  			["spellPos"] = -1,
  			["inCooldown"] = 0,
  			["sekCooldown"] = 0,
  			["startTime"] = 0,
  			["tab"] = 4,
  			["messageShown"] = 0,
  			["slot"] = 0,
  			["canCast"] = 0,
  		},
  		["Bloodthirst"] = {
  			["spellPos"] = -1,
  			["inCooldown"] = 0,
  			["sekCooldown"] = 0,
  			["startTime"] = 0,
  			["tab"] = 2,
  			["messageShown"] = 0,
  			["slot"] = 0,
  			["canCast"] = 0,
  		},
  		["Overpower"] = {
  			["spellPos"] = -1,
  			["inCooldown"] = 0,
  			["sekCooldown"] = 0,
  			["startTime"] = 0,
  			["tab"] = 4,
  			["messageShown"] = 0,
  			["slot"] = 0,
  			["canCast"] = 0,
  		},
  		["Revenge"] = {
  			["spellPos"] = -1,
  			["inCooldown"] = 0,
  			["sekCooldown"] = 0,
  			["startTime"] = 0,
  			["tab"] = 3,
  			["messageShown"] = 0,
  			["slot"] = 0,
  			["canCast"] = 0,
  		},
  	},
  	MessageFramePos = "Locked",
    frame = 2,
    chat = true,
    chatColor = { r = 1, g = 1, b = 0 },
    msg = true,
    msgColor = { r = 1, g = 0, b = 0 },
    display = "Default",
    font = "huge",
    anchor = false,
    locked = true,
	}
	self:RegisterDefaults('char', self.defaults)
end

function WarriorAlert:CreateOptions()
	local name = "WarriorAlert" --L["AutoBar"]
	if (not self.optionsTable) then
		self.optionsTable = {
			type = "group",
    	order = 1,
    	name = name,
    	desc = name,
      args = { 
       	Alerts = { 
          name = "Alerts", 
          type = 'group',
          desc = "Options for Warrior Ability Alerts",
          args = {
           	Overpower = {
             	name = "Overpower",type = 'group',
              desc = "Options for Warrior Ability Overpower",
    					args = {
    						["Message"] = {
                  name = "Message",type = 'toggle',
                  desc = "toggles Message",
                  usage = "Alerts Overpower Message",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Overpower"].Message
                  end,
                  set = function(v)
                    WarriorAlert.db.char.WarriorAlerts["Overpower"].Message = not WarriorAlert.db.char.WarriorAlerts["Overpower"].Message
                  end,
                },
    						["Sound"] = {
                  name = "Sound",type = 'toggle',
                  desc = "toggles Sound",
                  usage = "Alerts Overpower Sound",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Overpower"].Sound
                  end,
                  set = function(v)
                    WarriorAlert.db.char.WarriorAlerts["Overpower"].Sound = not WarriorAlert.db.char.WarriorAlerts["Overpower"].Sound
                  end,
                },
    						["BattleStance"] = {
                  name = "Battle Stance",type = 'toggle',
                  desc = "toggles Battle Stance",
                  usage = "Alerts Overpower BattleStance",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Overpower"]["Battle Stance"]
                  end,
                  set = "SetOverPowerBattleStance",
                },
    						["DefensiveStance"] = {
                  name = "Defensive Stance",type = 'toggle',
                  desc = "toggles Defensive Stance",
                  usage = "Alerts Overpower DefensiveStance",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Overpower"]["Defensive Stance"]
                  end,
                  set = "SetOverPowerDefStance",
                },
    						["BerserkerStance"] = {
                  name = "Berserker Stance",type = 'toggle',
                  desc = "toggles Berserker Stance",
                  usage = "Alerts Overpower BerserkerStance",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Overpower"]["Berserker Stance"]
                  end,
                  set = "SetOverPowerBeserkStance",
                },
    					},
    				},
    				Execute = {
             	name = "Execute",type = 'group',
              desc = "Options for Warrior Ability Execute",
    					args = {
    						["Message"] = {
                  name = "Message",type = 'toggle',
                  desc = "toggles Message",
                  usage = "Alerts Execute Message",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Execute"].Message
                  end,
                  set = function(v)
                    WarriorAlert.db.char.WarriorAlerts["Execute"].Message = not WarriorAlert.db.char.WarriorAlerts["Execute"].Message
                  end,
                },
    						["Sound"] = {
                  name = "Sound",type = 'toggle',
                  desc = "toggles Sound",
                  usage = "Alerts Execute Sound",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Execute"].Sound
                  end,
                  set = function(v)
                    WarriorAlert.db.char.WarriorAlerts["Execute"].Sound = not WarriorAlert.db.char.WarriorAlerts["Execute"].Sound
                  end,
                },
    						["BattleStance"] = {
                  name = "Battle Stance",type = 'toggle',
                  desc = "toggles Battle Stance",
                  usage = "Alerts Execute BattleStance",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Execute"]["Battle Stance"]
                  end,
                  set = "SetExecuteBattleStance",
                },
    						["DefensiveStance"] = {
                  name = "Defensive Stance",type = 'toggle',
                  desc = "toggles Defensive Stance",
                  usage = "Alerts Execute DefensiveStance",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Execute"]["Defensive Stance"]
                  end,
                  set = "SetExecuteDefStance",
                },
    						["BerserkerStance"] = {
                  name = "Berserker Stance",type = 'toggle',
                  desc = "toggles Berserker Stance",
                  usage = "Alerts Execute BerserkerStance",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Execute"]["Berserker Stance"]
                  end,
                  set = "SetExecuteBeserkStance",
                },
    					},
    				},
    				MortalStrike = {
             	name = "Mortal Strike",type = 'group',
              desc = "Options for Warrior Ability Mortal Strike",
    					args = {
    						["Message"] = {
                  name = "Message",type = 'toggle',
                  desc = "toggles Message",
                  usage = "Alerts MortalStrike Message",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Mortal Strike"].Message
                  end,
                  set = function(v)
                    WarriorAlert.db.char.WarriorAlerts["Mortal Strike"].Message = not WarriorAlert.db.char.WarriorAlerts["Mortal Strike"].Message
                  end,
                },
    						["Sound"] = {
                  name = "Sound",type = 'toggle',
                  desc = "toggles Sound",
                  usage = "Alerts MortalStrike Sound",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Mortal Strike"].Sound
                  end,
                  set = function(v)
                    WarriorAlert.db.char.WarriorAlerts["Mortal Strike"].Sound = not WarriorAlert.db.char.WarriorAlerts["Mortal Strike"].Sound
                  end,
                },
    						["BattleStance"] = {
                  name = "Battle Stance",type = 'toggle',
                  desc = "toggles Battle Stance",
                  usage = "Alerts MortalStrike BattleStance",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Mortal Strike"]["Battle Stance"]
                  end,
                  set = "SetMortStrBattleStance",
                },
    						["DefensiveStance"] = {
                  name = "Defensive Stance",type = 'toggle',
                  desc = "toggles Defensive Stance",
                  usage = "Alerts MortalStrike DefensiveStance",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Mortal Strike"]["Defensive Stance"]
                  end,
                  set = "SetMortStrDefStance",
                },
    						["BerserkerStance"] = {
                  name = "Berserker Stance",type = 'toggle',
                  desc = "toggles Berserker Stance",
                  usage = "Alerts MortalStrike BerserkerStance",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Mortal Strike"]["Berserker Stance"]
                  end,
                  set = "SetMortStrBeserkStance",
                },
    					},
    				},
    				Revenge = {
             	name = "Revenge",type = 'group',
              desc = "Options for Warrior Ability Revenge",
    					args = {
    						["Message"] = {
                  name = "Message",type = 'toggle',
                  desc = "toggles Message",
                  usage = "Alerts Revenge Message",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Revenge"].Message
                  end,
                  set = function(v)
                    WarriorAlert.db.char.WarriorAlerts["Revenge"].Message = not WarriorAlert.db.char.WarriorAlerts["Revenge"].Message
                  end,
                },
    						["Sound"] = {
                  name = "Sound",type = 'toggle',
                  desc = "toggles Sound",
                  usage = "Alerts Revenge Sound",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Revenge"].Sound
                  end,
                  set = function(v)
                    WarriorAlert.db.char.WarriorAlerts["Revenge"].Sound = not WarriorAlert.db.char.WarriorAlerts["Revenge"].Sound
                  end,
                },
    						["BattleStance"] = {
                  name = "Battle Stance",type = 'toggle',
                  desc = "toggles Battle Stance",
                  usage = "Alerts Revenge BattleStance",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Revenge"]["Battle Stance"]
                  end,
                  set = "SetRevengeBattleStance",
                },
    						["DefensiveStance"] = {
                  name = "Defensive Stance",type = 'toggle',
                  desc = "toggles Defensive Stance",
                  usage = "Alerts Revenge DefensiveStance",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Revenge"]["Defensive Stance"]
                  end,
                  set = "SetRevengeDefStance",
                },
    						["BerserkerStance"] = {
                  name = "Berserker Stance",type = 'toggle',
                  desc = "toggles Berserker Stance",
                  usage = "Alerts Revenge BerserkerStance",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Revenge"]["Berserker Stance"]
                  end,
                  set = "SetRevengeBeserkStance",
                },
    					},
    				},
    				Bloodthirst = {
             	name = "Bloodthirst",type = 'group',
              desc = "Options for Warrior Ability Bloodthirst",
    					args = {
    						["Message"] = {
                  name = "Message",type = 'toggle',
                  desc = "toggles Message",
                  usage = "Alerts Bloodthirst Message",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Bloodthirst"].Message
                  end,
                  set = function(v)
                    WarriorAlert.db.char.WarriorAlerts["Bloodthirst"].Message = not WarriorAlert.db.char.WarriorAlerts["Bloodthirst"].Message
                  end,
                },
    						["Sound"] = {
                  name = "Sound",type = 'toggle',
                  desc = "toggles Sound",
                  usage = "Alerts Bloodthirst Sound",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Bloodthirst"].Sound
                  end,
                  set = function(v)
                    WarriorAlert.db.char.WarriorAlerts["Bloodthirst"].Sound = not WarriorAlert.db.char.WarriorAlerts["Bloodthirst"].Sound
                  end,
                },
    						["BattleStance"] = {
                  name = "Battle Stance",type = 'toggle',
                  desc = "toggles Battle Stance",
                  usage = "Alerts Bloodthirst BattleStance",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Bloodthirst"]["Battle Stance"]
                  end,
                  set = "SetBloodBattleStance",
                },
    						["DefensiveStance"] = {
                  name = "Defensive Stance",type = 'toggle',
                  desc = "toggles Defensive Stance",
                  usage = "Alerts Bloodthirst DefensiveStance",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Bloodthirst"]["Defensive Stance"]
                  end,
                  set = "SetBloodDefStance",
                },
    						["BerserkerStance"] = {
                  name = "Berserker Stance",type = 'toggle',
                  desc = "toggles Berserker Stance",
                  usage = "Alerts Bloodthirst BerserkerStance",
                  get = function()
                    return WarriorAlert.db.char.WarriorAlerts["Bloodthirst"]["Berserker Stance"]
                  end,
                  set = "SetBloodBeserkStance",
                },
    					},
    				},		
    			},
    		},
    		options = { 
      		name = "Options", 
          type = 'group',
          desc = "Options for Display",
          args = {
      			color = {
      				type = 'color',
      				name = "Message color",
      				desc = "Set the color of the message",
      				get = function() return WarriorAlert.db.char.msgColor.r, WarriorAlert.db.char.msgColor.g, WarriorAlert.db.char.msgColor.b end,
      				set = function(r, g, b) WarriorAlert.db.char.msgColor = { r = r, g = g, b = b } end,
      			},
      			display = {
      				type = 'text',
      				name = "Display mode",
      				desc = "Select behavior for display of messages",
      				validate = {"Default","SCT"},
      				get = function() return WarriorAlert.db.char.display end,
      				set = function(v) WarriorAlert.db.char.display = v end,
      			},
      			font = {
      				type = 'text',
      				name = "Font size",
      				desc = "Set the font size for the RampageReminder message frame",
      				validate = {"small", "normal", "large", "huge"},
      				get = function() return WarriorAlert.db.char.font end,
      				set = function(v)
      					WarriorAlert.db.char.font = v
      					WarriorAlert:SetFont()
      				end,
      				disabled = function() return not (WarriorAlert.db.char.display == "Default") end,
      			},
      			lock = {
      				type = 'toggle',
      				name = "Lock",
      				desc = "Lock the frame",
      				get = function() return WarriorAlert.db.char.locked end,
      				set = function(v)
      					WarriorAlert.db.char.locked = v
      					if (v) then
      						WarriorAlert.frame:Hide()
      					else
      						WarriorAlert.frame:Show()
      					end
      				end,
      				disabled = function() return not (WarriorAlert.db.char.display == "Default") end,
      			},
      			test = {
      				type = 'execute',
      				name = "Test",
      				desc = "Run test script",
      				func = 'Test',
      			},
      		},
      	},
      },
    }
    -------------------------------- 
  end
	self:RegisterChatCommand({"/wafu","/walert"},optionsTable)
	
end

function WarriorAlert:RageChecks()
	self:DoExecute()
	self:DoMortalStrike()
	self:DoBloodthirst()
	
end

function WarriorAlert:GetSlots(slot)
	
	WarriorAlertTooltip:SetOwner(UIParent, "ANCHOR_NONE")
	WarriorAlertTooltip:SetAction(slot)
	local n = WarriorAlertTooltipTextLeft1:GetText()
	local j = WarriorAlertTooltipTextRight3:GetText()
	if (j == nil) then
		j = "0"
	end
	for s,_ in pairs(WarriorAlert_spellName) do
		if(n == WarriorAlert_spellName[s]) then
			self.db.char.WarriorAlertSpellPos[ WarriorAlert_spellName[s] ]["slot"] = slot
			self.db.char.WarriorAlertSpellPos[ WarriorAlert_spellName[s] ]["sekCooldown"] = string.gmatch(j, "%d")() + 0

			if(self.db.char.WarriorAlertSpellPos[ WarriorAlert_spellName[s] ]["sekCooldown"] < 1.5) then
				self.db.char.WarriorAlertSpellPos[ WarriorAlert_spellName[s] ]["sekCooldown"] = 1.5;
			end
			self:CheckSpells();
		end
	end
end

function WarriorAlert:CheckSpells()
	local pos = 1
	local spellCount = 0

	for spellBookTabs = 1, GetNumSpellTabs() do
		_, _, _, numSpells = GetSpellTabInfo(spellBookTabs)
		spellCount = spellCount + numSpells
	end
-- DEFAULT_CHAT_FRAME:AddMessage("SpellCount = "..spellCount)
	for s = 1, 5 do
		for spellNum = 1, spellCount do
			if(string.find(GetSpellName(spellNum, BOOKTYPE_SPELL), WarriorAlert_spellName[s])) then
				self.db.char.WarriorAlertSpellPos[WarriorAlert_spellName[s]].spellPos = spellNum
				break
			else
				self.db.char.WarriorAlertSpellPos[WarriorAlert_spellName[s]].spellPos = 0
			end
		end
	end
end


function WarriorAlert:CurrentStance()
	for x=1, GetNumShapeshiftForms() do
		_, stanceName, active = GetShapeshiftFormInfo(x)
		
		if(active == 1) then
			-- return x
			return stanceName
		end
	end
	
	-- return 0;
end

function WarriorAlert:SetRevengeBattleStance()
  self.db.char.WarriorAlerts["Revenge"]["Battle Stance"] = not self.db.char.WarriorAlerts["Revenge"]["Battle Stance"]
end

function WarriorAlert:SetRevengeDefStance()
  self.db.char.WarriorAlerts["Revenge"]["Defensive Stance"] = not self.db.char.WarriorAlerts["Revenge"]["Defensive Stance"]
end

function WarriorAlert:SetRevengeBeserkStance()
  self.db.char.WarriorAlerts["Revenge"]["Beserker Stance"] = not self.db.char.WarriorAlerts["Revenge"]["Beserker Stance"]
end

function WarriorAlert:SetOverPowerBattleStance()
  self.db.char.WarriorAlerts["Overpower"]["Battle Stance"] = not self.db.char.WarriorAlerts["Overpower"]["Battle Stance"]
end

function WarriorAlert:SetOverPowerDefStance()
  self.db.char.WarriorAlerts["Overpower"]["Defensive Stance"] = not self.db.char.WarriorAlerts["Overpower"]["Defensive Stance"]
end

function WarriorAlert:SetOverPowerBeserkStance()
  self.db.char.WarriorAlerts["Overpower"]["Beserker Stance"] = not self.db.char.WarriorAlerts["Overpower"]["Beserker Stance"]
end

function WarriorAlert:SetExecuteBattleStance()
  self.db.char.WarriorAlerts["Execute"]["Battle Stance"] = not self.db.char.WarriorAlerts["Execute"]["Battle Stance"]
end

function WarriorAlert:SetExecuteDefStance()
  self.db.char.WarriorAlerts["Execute"]["Defensive Stance"] = not self.db.char.WarriorAlerts["Execute"]["Defensive Stance"]
end

function WarriorAlert:SetExecuteBeserkStance()
  self.db.char.WarriorAlerts["Execute"]["Beserker Stance"] = not self.db.char.WarriorAlerts["Execute"]["Beserker Stance"]
end

function WarriorAlert:SetBloodBattleStance()
  self.db.char.WarriorAlerts["Bloodthirst"]["Battle Stance"] = not self.db.char.WarriorAlerts["Bloodthirst"]["Battle Stance"]
end

function WarriorAlert:SetBloodDefStance()
  self.db.char.WarriorAlerts["Bloodthirst"]["Defensive Stance"] = not self.db.char.WarriorAlerts["Bloodthirst"]["Defensive Stance"]
end

function WarriorAlert:SetBloodBeserkStance()
  self.db.char.WarriorAlerts["Bloodthirst"]["Beserker Stance"] = not self.db.char.WarriorAlerts["Bloodthirst"]["Beserker Stance"]
end

function WarriorAlert:SetMortStrBattleStance()
  self.db.char.WarriorAlerts["Mortal Strike"]["Battle Stance"] = not self.db.char.WarriorAlerts["Mortal Strike"]["Battle Stance"]
end

function WarriorAlert:SetMortStrDefStance()
  self.db.char.WarriorAlerts["Mortal Strike"]["Defensive Stance"] = not self.db.char.WarriorAlerts["Mortal Strike"]["Defensive Stance"]
end

function WarriorAlert:SetMortStrBeserkStance()
  self.db.char.WarriorAlerts["Mortal Strike"]["Beserker Stance"] = not self.db.char.WarriorAlerts["Mortal Strike"]["Beserker Stance"]
end

function WarriorAlert:Instant()
	for s=1, 5 do
		if(self.db.char.WarriorAlertSpellPos[ WarriorAlert_spellName[s] ].spellPos > 0 and self.db.char.WarriorAlertSpellPos[ WarriorAlert_spellName[s] ]["inCooldown"] == 0) then
			local start, duration, flag = GetSpellCooldown(self.db.char.WarriorAlertSpellPos[ WarriorAlert_spellName[s] ].spellPos, BOOKTYPE_SPELL)
		
			if(self.db.char.WarriorAlertSpellPos[ WarriorAlert_spellName[s] ]["sekCooldown"] == duration and start > 0) then
				self.db.char.WarriorAlertSpellPos[ WarriorAlert_spellName[s] ]["startTime"] = start
				self.db.char.WarriorAlertSpellPos[ WarriorAlert_spellName[s] ]["inCooldown"] = 1
				self.db.char.WarriorAlertSpellPos[ WarriorAlert_spellName[s] ]["canCast"] = 0
				-- self.db.char.WarriorAlertSpellPos[ WarriorAlert_spellName[s] ]["messageShown"] = 0
			end
		end
	end
end


function WarriorAlert:CheckCooldowns(elapsed)
	local updateInterval = 0.25
	
	WarriorAlert_timeSinceLastUpdate = WarriorAlert_timeSinceLastUpdate + elapsed 	
	
	if (WarriorAlert_timeSinceLastUpdate > updateInterval) then
		WarriorAlert_timeSinceLastUpdate = 0
		
		for s=1, 5 do
			if(self.db.char.WarriorAlertSpellPos[ WarriorAlert_spellName[s] ]["inCooldown"] == 1) then
				if((self.db.char.WarriorAlertSpellPos[ WarriorAlert_spellName[s] ]["sekCooldown"] - (GetTime() - self.db.char.WarriorAlertSpellPos[ WarriorAlert_spellName[s] ]["startTime"])) <= 0) then
					self.db.char.WarriorAlertSpellPos[ WarriorAlert_spellName[s] ]["inCooldown"] = 0
					-- self.db.char.WarriorAlertSpellPos[ WarriorAlert_spellName[s] ]["messageShown"] = 0
				end
			end
		end
		
		self:DoOverpower("")
		self:DoExecute()
		self:DoRevenge("")
		self:DoMortalStrike()
		
	end
end

function WarriorAlert:TargetChanged(unit)
	for s=1, 5 do
		-- self.db.char.WarriorAlertSpellPos[ WarriorAlert_spellName[s] ]["messageShown"] = 0
		self.db.char.WarriorAlertSpellPos[ WarriorAlert_spellName[s] ]["canCast"] = 0
	end

	self:DoExecute()
end

function WarriorAlert:LookUpActions()
	if(WarriorAlert_LookupDone == 1) then
		return
	end
	
	WarriorAlert_LookupDone = 1
	
	for i=1, 120 do
		self:GetSlots(i)
	end
end

--------------------------------------------------------------------------------
-- Execute functions -----------------------------------------------------------
--------------------------------------------------------------------------------
function WarriorAlert:DoExecute()
	local stance = self:CurrentStance()
	if(self.db.char.WarriorAlerts["Execute"][stance] == false) then
		return
	end
	
	if(self.db.char.WarriorAlertSpellPos["Execute"].spellPos == 0 or
		-- self.db.char.WarriorAlertSpellPos["Execute"]["inCooldown"] == 1 or
		-- self.db.char.WarriorAlertSpellPos["Execute"]["messageShown"] == 1 or
		IsActionInRange(self.db.char.WarriorAlertSpellPos["Execute"]["slot"]) ~= 1 or
		UnitCanAttack("player", "target") == false) then
		return
	end

	if(UnitHealth("target") > 0 and UnitHealth("target") < 20 and UnitMana("player") >= 15) then
		-- self.db.char.WarriorAlertSpellPos["Execute"]["messageShown"] = 1
		
		if(self.db.char.WarriorAlerts["Execute"]["Message"] == true) then
			-- WarriorAlertMessageFrame:AddMessage("|cFFFF0000EXECUTE|r NOW!", 1.0, 1.0, 1.0, 1.0, 1)
			self.Display("EXECUTE NOW!")
		end

		if(self.db.char.WarriorAlerts["Execute"]["Sound"] == true) then
			PlaySound("igQuestCancel") -- ("igQuestLogAbandonQuest")
		end
	end
end



--------------------------------------------------------------------------------
-- Mortal Strike functions -----------------------------------------------------
--------------------------------------------------------------------------------
function WarriorAlert:DoMortalStrike()
	local stance = self:CurrentStance()
	if(self.db.char.WarriorAlerts["Mortal Strike"][stance] == false) then
		return
	end

	-- if(UnitMana("player") < 30 and self.db.char.WarriorAlertSpellPos["Mortal Strike"]["inCooldown"] == 0) then
		-- self.db.char.WarriorAlertSpellPos["Mortal Strike"]["messageShown"] = 0;
	-- end
	
	if(self.db.char.WarriorAlertSpellPos["Mortal Strike"].spellPos == 0 or
		self.db.char.WarriorAlertSpellPos["Mortal Strike"]["inCooldown"] == 1 or
		-- self.db.char.WarriorAlertSpellPos["Mortal Strike"]["messageShown"] == 1 or
		IsActionInRange(self.db.char.WarriorAlertSpellPos["Mortal Strike"]["slot"]) ~= 1 or
		UnitCanAttack("player", "target") == false) then
		return
	end
	
	if(UnitHealth("target") > 0 and UnitMana("player") >= 30) then
		-- self.db.char.WarriorAlertSpellPos["Mortal Strike"]["messageShown"] = 1
		
		if(self.db.char.WarriorAlerts["Mortal Strike"]["Message"] == true) then
			-- WarriorAlertMessageFrame:AddMessage("|cFFFF0000MORTAL STRIKE|r NOW!", 1.0, 1.0, 1.0, 1.0, 1)
			self.Display("MORTAL STRIKE NOW!")
		end  

		if(self.db.char.WarriorAlerts["Mortal Strike"]["Sound"] == true) then
			PlaySound("igQuestCancel") -- ("igQuestLogAbandonQuest")
		end
	end

end



--------------------------------------------------------------------------------
-- Bloodthirst functions -------------------------------------------------------
--------------------------------------------------------------------------------
function WarriorAlert:DoBloodthirst()
	local stance = self:CurrentStance()
	if(self.db.char.WarriorAlerts["Bloodthirst"][stance] == false) then
		return;
	end
	
	if(self.db.char.WarriorAlertSpellPos["Bloodthirst"].spellPos == 0 or
		self.db.char.WarriorAlertSpellPos["Bloodthirst"]["inCooldown"] == 1 or
		-- self.db.char.WarriorAlertSpellPos["Bloodthirst"]["messageShown"] == 1 or
		IsActionInRange(self.db.char.WarriorAlertSpellPos["Bloodthirst"]["slot"]) ~= 1 or
		UnitCanAttack("player", "target") == false) then
		return;
	end
	
	if(UnitHealth("target") > 0 and UnitMana("player") >= 30) then
		-- self.db.char.WarriorAlertSpellPos["Bloodthirst"]["messageShown"] = 1;
		
		if(self.db.char.WarriorAlerts["Bloodthirst"]["Message"] == true) then
			-- WarriorAlertMessageFrame:AddMessage("|cFFFF0000BLOODTHIRST|r NOW!", 1.0, 1.0, 1.0, 1.0, 1);
			self.Display("BLOODTHIRST NOW!")
		end
		
		if(self.db.char.WarriorAlerts["Bloodthirst"]["Sound"] == true) then
			PlaySound("igQuestCancel") -- ("igQuestLogAbandonQuest")
		end
	end
end



--------------------------------------------------------------------------------
-- Overpower functions ---------------------------------------------------------
--------------------------------------------------------------------------------
function WarriorAlert:DoOverpower(msg)
	local stance = self:CurrentStance()
	if(self.db.char.WarriorAlerts["Overpower"][stance] == false) then
		return
	end
	
	for s,g in ipairs(OverpowerMsg) do
		if(string.find(msg, OverpowerMsg[s])) then
			self.db.char.WarriorAlertSpellPos["Overpower"]["canCast"] = 1;
		end
	end
	
	if(self.db.char.WarriorAlertSpellPos["Overpower"].spellPos == 0 or
		self.db.char.WarriorAlertSpellPos["Overpower"]["inCooldown"] == 1 or
		-- self.db.char.WarriorAlertSpellPos["Overpower"]["messageShown"] == 1 or
		IsActionInRange(self.db.char.WarriorAlertSpellPos["Overpower"]["slot"]) ~= 1) then
		return
	end

	if(UnitMana("player") >= 5 and self.db.char.WarriorAlertSpellPos["Overpower"]["canCast"] == 1) then
		-- self.db.char.WarriorAlertSpellPos["Overpower"]["messageShown"] = 1
		
		if(self.db.char.WarriorAlerts["Overpower"]["Message"] == true) then
			-- WarriorAlertMessageFrame:AddMessage("|cFFFF0000OVERPOWER|r NOW!", 1.0, 1.0, 1.0, 1.0, 1)
			self.Display("OVERPOWER NOW!")
		end

		if(self.db.char.WarriorAlerts["Overpower"]["Sound"] == true) then
			PlaySound("igQuestCancel") -- ("igQuestLogAbandonQuest")
		end
	end
end



--------------------------------------------------------------------------------
-- Revenge functions -----------------------------------------------------------
--------------------------------------------------------------------------------
function WarriorAlert:DoRevenge(msg)
	if(self.db.char.WarriorAlerts["Revenge"][ self:CurrentStance() ] == false) then
		return
	end
	
	for s,g in ipairs(RevengeMsg) do
		if(string.find(msg, RevengeMsg[s])) then
			self.db.char.WarriorAlertSpellPos["Revenge"]["canCast"] = 1
		end
	end
	
	if(self.db.char.WarriorAlertSpellPos["Revenge"].spellPos == 0 or
		-- self.db.char.WarriorAlertSpellPos["Revenge"]["messageShown"] == 1 or
		self.db.char.WarriorAlertSpellPos["Revenge"]["inCooldown"] == 1 or
		IsActionInRange(self.db.char.WarriorAlertSpellPos["Revenge"]["slot"]) ~= 1 or
		UnitCanAttack("player", "target") == false) then
		return
	end

	if(UnitHealth("target") > 0 and UnitMana("player") >= 5 and self.db.char.WarriorAlertSpellPos["Revenge"]["canCast"] == 1) then
		-- self.db.char.WarriorAlertSpellPos["Revenge"]["messageShown"] = 1
		
		if(self.db.char.WarriorAlerts["Revenge"]["Message"] == true) then
			-- WarriorAlertMessageFrame:AddMessage("|cFFFF0000REVENGE|r NOW!", 1.0, 1.0, 1.0, 1.0, 1)
			self.Display("REVENGE NOW!")
		end

		if(self.db.char.WarriorAlerts["Revenge"]["Sound"] == true) then
			PlaySound("igQuestCancel") -- ("igQuestLogAbandonQuest")
		end
	end
end

--------------------------------------------------------------------------------
-- Frame functions ---------------------------------------------------------
--------------------------------------------------------------------------------

function WarriorAlert:CreateFrames()
	self.frame = CreateFrame("Frame", "WarriorAlertAnchorFrame", UIParent)
	self.frame:EnableMouse(true)
	self.frame:SetMovable(true)
	self.frame:SetClampedToScreen(true)
	self.frame:SetWidth(600)
	self.frame:SetHeight(100)
	self.frame:SetPoint("BOTTOMLEFT", UIParent, "CENTER", 0, -30)
	self.frame:SetFrameStrata("LOW")

	self.frame.title = self.frame:CreateFontString(nil, "ARTWORK", "TextStatusBarText")
	self.frame.title:SetText("WarriorAlert")
	self.frame.title:SetPoint("TOP", 0, 0)
	
	self.frame:SetBackdrop({ 
		bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", 
		edgeFile = nil, tile = true, tileSize = 16, edgeSize = 16, 
		insets = { left = 5, right = 5, top = 5, bottom = 5 }
	})
	self.frame:SetBackdropColor(0, 0, 0, 0.6)

	self.frame:SetScript("OnMouseDown", function()
		if (arg1 == "LeftButton") then
			this:StartMoving()
		-- elseif (arg1 == "RightButton") then
		-- 	Dewdrop:Register(self.frame, 'children', function() Dewdrop:FeedAceOptionsTable(self.options) end, 'point', "TOPRIGHT", 'relativePoint', "BOTTOMLEFT", 'cursorX', true, 'cursorY', true)
		end
	end)
	self.frame:SetScript("OnMouseUp", function()
		if (arg1 == "LeftButton") then
			this:StopMovingOrSizing()
			self:SavePosition()
		end
	end)

	 if (self.db.char.locked) then self.frame:Hide() end
	
	self:LoadPosition()

	self.msgframe = CreateFrame("MessageFrame", "WarriorAlertMessageFrame")
	self.msgframe:SetMovable(true)
	self.msgframe:SetWidth(1024)
	self.msgframe:SetHeight(180)
	self.msgframe:SetFadeDuration(1.5)
	self.msgframe:SetTimeVisible(1.5)
	self.msgframe:ClearAllPoints()
	self.msgframe:SetPoint("TOP", "WarriorAlertAnchorFrame", "TOP", -20, -20)
	self.msgframe:SetInsertMode("TOP")
	self.msgframe:SetFrameStrata("HIGH")
	self.msgframe:CreateFontString(nil, nil, "NumberFontNormalHuge")
end

function WarriorAlert:LoadPosition()
	if (self.db.char.framePos) then
		local x = self.db.char.framePos.x
		local y = self.db.char.framePos.y

		self.frame:ClearAllPoints()
		self.frame:SetPoint("TOPLEFT", UIParent, "TOPLEFT", x, y)
	else
		self.frame:ClearAllPoints()
		self.frame:SetPoint("BOTTOMLEFT", UIParent, "CENTER")
	end
end

function WarriorAlert:SavePosition()
	local x, y = self.frame:GetLeft(), self.frame:GetTop() - UIParent:GetTop()

	if (not self.db.char.framePos) then 
		self.db.char.framePos = {}
	end

	self.db.char.framePos.x = x
	self.db.char.framePos.y = y
end

function WarriorAlert:SetFont()
	if (self.db.char.font == "small") then
		WarriorAlertMessageFrame:SetFontObject(NumberFontNormalSmall)
	elseif (self.db.char.font == "large") then
		WarriorAlertMessageFrame:SetFontObject(NumberFontNormalLarge)
	elseif (self.db.char.font == "huge") then
		WarriorAlertMessageFrame:SetFontObject(NumberFontNormalHuge)
	else
		WarriorAlertMessageFrame:SetFontObject(NumberFontNormal)
	end
end
function WarriorAlert:Display(msg)
	local color = self.db.char.msgColor
	local display = self.db.char.display
	
	if (MikSBT) and (display == "MSBT") then
		MikSBT.DisplayMessage(msg, MikSBT.DISPLAYTYPE_NOTIFICATION, false, color.r * 255, color.g * 255, color.b * 255)
		return
	elseif (SCT_Display or (SCT and SCT.DisplayText)) and (display == "SCT") then
		if (SCT_Display) then
			SCT_Display(msg, color)
		else 
			SCT:DisplayText(msg, color)
		end
		return
	elseif (SCT_Display or (SCT and SCT.DisplayText)) and (display == "SCT Message") then
		if (SCT_Display) then
			SCT_Display_Message(msg, color)
		else
			SCT:DisplayMessage(msg, color)
		end
		return
	elseif (display == "Default") then
		WarriorAlertMessageFrame:AddMessage(msg, color.r, color.g, color.b, 1, 0.5)
	end
end

function WarriorAlert:Test()
	self:Display("TEST Message!")
end
