--[[
Title: VoiceFu
Author: Triam of Baelgun (US Alliance)
Major Version: 1.0
Minor Version: $Revision: 00001 $
Date: $Date: 2007-01-23 17:42:17 -0800 (Tue, 23 Dec 2007) $
]]

local L = AceLibrary("AceLocale-2.2"):new("VoiceFu");
VoiceFu = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceComm-2.0", "AceDebug-2.0", "AceDB-2.0", "FuBarPlugin-2.0");

local crayon = AceLibrary("Crayon-2.0");
local tablet = AceLibrary("Tablet-2.0");

-- Saved Variables
VoiceFu:RegisterDB("VoiceFuDB");
VoiceFu:RegisterDefaults("profile", {
    channel = "GUILD",
    idleAlpha = 1,
    activeAlpha = 1,
    bindKeyLocked = false
    }
)

-- local Variables
local defaultText = crayon:White("VoiceFu");
local whoIsTalking = {};
local howManyPeopleAreTalking = 0;
local amITalking = false;
local displayText = defaultText;
local whoAmI, whatAmI;

-- Binding Key Stuff
BINDING_HEADER_VOICEFUHEADER = "VoiceFu";
BINDING_NAME_VOICEFUMONITOR = L["Your Program's Press to Talk Button"];


-- Options (menu)
local options = {
    handler = VoiceFu,
    type = "group",
    args =  {
        
        hintText =  {
            type = "header",
            order = 1.1,
            name = L["Double Click the Icon to Reset"]
        },
        
        spacer1 =   {
            type = "header",
            order = 1.2,
        },
        
        noKeyBound = {
            type = "header",
            order = 1.3,
            name = L["Please bind a key for push to talk"],
            hidden = "IsKeyBound"
        },
        
        lockBindKey = {
            type = "toggle",
            order = 1.35,
            name = L["Lock Press to Talk Key"],
            desc = L["Lock or Unlock the Press to Talk key Menu Item"],
            set = "ToggleBindKeyLocked",
            get = "IsBindKeyLocked"
        },
        
        bindKey = {
            type = "text",
            order = 1.4,
            name = L["Press to Talk Key"],
            desc = L["Your Voice Chat Program's Press to Talk key"],
            usage = L["eg: MOUSEBUTTON4, CTRL-`, SHIFT-G"],
            get = "GetBoundKey",
            set = "SetBoundKey",
            hidden = "IsBindKeyLocked"
        },

        spacer2 = {
            type = "header",
            order = 1.5
        },
        
        channelChoice = {
            type = "text",
            order = 1.6,
            name = L["Channel"],
            desc = L["Channel to send and receive transmit signals from."],
            get = "GetCurrentChannel",
            set = "SetCurrentChannel",
            validate = {
                ["GROUP"] = L["Group"],
                ["PARTY"] = L["Party"],
                ["RAID"] = L["Raid"],
                ["GUILD"] = L["Guild"],
                ["BATTLEGROUND"] = L["Battleground"]
            }
        },
        
        spacer3 = {
            type = "header",
            order = 1.7
        },
        
        idleAlpha = {
            type = "range",
            order = 1.8,
            name = L["Idle Transparency"],
            desc = L["The transparency of the tooltip when no one is talking."],
            min = 0,
            max = 1,
            isPercent = true,
            get = "GetIdleAlpha",
            set = "SetIdleAlpha"
            },
        
        activeAlpha = {
            type = "range",
            order = 1.9,
            name = L["Active Transparency"],
            desc = L["The transparency of the tooltip when someone is talking."],
            min = 0,
            max = 1,
            isPercent = true,
            get = "GetActiveAlpha",
            set = "SetActiveAlpha"
        }

    }
};


-- FuBar Setup
VoiceFu.hasIcon = "Interface\\Icons\\Ability_Warrior_BattleShout"
VoiceFu.independentProfile = true;
VoiceFu.tooltipHiddenWhenEmpty = false;
VoiceFu.debugFrame = ChatFrame1;
VoiceFu.OnMenuRequest = options;
VoiceFu.version = "2.0."..string.sub("$Revision: 00001 $", 12, -3);
VoiceFu.date = string.sub("$Date: 2007-01-23 17:42:17 -0800 (Tue, 23 Dec 2007) $", 8, 17);



-- AceComm Prefix setup
VoiceFu:SetCommPrefix("VoiceFu");


function VoiceFu:OnEnable()
    whoAmI = UnitName("player");
    _, whatAmI = UnitClass("player");

--    VoiceFu:RegisterMemoizations( {whoAmI, whatAmI, "START", "STOP"} );
    self:RegisterComm(self.commPrefix, self.db.profile.channel, "OnCommReceive");
    self:SetDefaultCommPriority("ALERT");
end


-- Menu Controllers
function VoiceFu:OnDoubleClick(button)
    whoIsTalking = {};
    howManyPeopleAreTalking = 0;
    self:CheckWhoIsTalking();
    self:UpdateDisplay();
end

function VoiceFu:IsKeyBound()
    local key1, key2 = GetBindingKey("VOICEFUMONITOR");
    if key1 or key2 then
        return true
    else
        return false
    end
end

function VoiceFu:GetBoundKey()
    local key1 = GetBindingKey("VOICEFUMONITOR");
    return key1;
end

function VoiceFu:SetBoundKey(key)
    if not SetBinding(key, "VOICEFUMONITOR") then
        VoiceFu:Print("Key Bind failed.  Please use the following rules.");
        VoiceFu:Print("Single Keys are OK. Modifyer keys should be added in CAPS with a hyphen. (eg: SHIFT-`, ALT-G)");
        VoiceFu:Print("Mouse buttons should be all one word and CAPITALIZED. (eg: MOUSEBUTTON1)");
    else
        SaveBindings(1);
    end
end

function VoiceFu:GetCurrentChannel()
    return self.db.profile.channel;
end

function VoiceFu:SetCurrentChannel(channelName)
    self:UnregisterComm(self.commPrefix, self.db.profile.channel);
    self.db.profile.channel = channelName;
    self:RegisterComm(self.commPrefix, self.db.profile.channel, "OnCommReceive")
end

function VoiceFu:GetIdleAlpha()
    return self.db.profile.idleAlpha;
end

function VoiceFu:SetIdleAlpha(val)
    self.db.profile.idleAlpha = val;
    self:CheckWhoIsTalking();
    self:UpdateDisplay();
end

function VoiceFu:GetActiveAlpha()
    return self.db.profile.activeAlpha;
end

function VoiceFu:SetActiveAlpha(val)
    self.db.profile.activeAlpha = val;
    self:CheckWhoIsTalking();
    self:UpdateDisplay();
end

function VoiceFu:ToggleBindKeyLocked()
    if self.db.profile.bindKeyLocked then
        self.db.profile.bindKeyLocked = false
    else
        self.db.profile.bindKeyLocked = true
    end
end

function VoiceFu:IsBindKeyLocked()
    return self.db.profile.bindKeyLocked
end


-- What to do when we get a message
function VoiceFu:OnCommReceive(prefix, sender, distribution, startOrStop, whoIsIt, whatAreThey, whatLevelAreThey)
    DEFAULT_CHAT_FRAME:AddMessage("Received Message: " .. prefix .. sender .. distribution .. startOrStop .. whoIsIt .. whatAreThey .. whatLevelAreThey);
    if startOrStop == "START" then
        whoIsTalking[whoIsIt] = { ["name"] = whoIsIt, ["class"] = whatAreThey, ["lvl"] = whatLevelAreThey};
        howManyPeopleAreTalking = howManyPeopleAreTalking + 1;
    else
        whoIsTalking[whoIsIt] = nil;
        howManyPeopleAreTalking = howManyPeopleAreTalking - 1;
        if howManyPeopleAreTalking < 0 then howManyPeopleAreTalking = 0 end;
    end
    self:CheckWhoIsTalking();
    self:UpdateDisplay();
end

-- 3 functions to send messages
function VoiceFu:ToggleButton(keystate)
    if keystate == "down" then
        self:KeyDown()
    else
        self:KeyUp()
    end
    self:CheckWhoIsTalking();
    self:UpdateDisplay();
end

function VoiceFu:KeyDown()
    amITalking = true;
    self:SendCommMessage(self.db.profile.channel, "START", whoAmI, whatAmI, UnitLevel("player"));

end

function VoiceFu:KeyUp()
    amITalking = false;
    self:SendCommMessage(self.db.profile.channel, "STOP", whoAmI, whatAmI, UnitLevel("player"));
--    self:OnCommReceive(self.commPrefix, UnitName("player"), self.db.profile.channel, "STOP", whoAmI, whatAmI, UnitLevel("player"));
end


-- Getting between messages and display information
function VoiceFu:CheckWhoIsTalking()
    if (not amITalking) and (howManyPeopleAreTalking == 0) then
        -- No one is talking, set text and tooltip to default
        displayText = defaultText;
        tablet:SetTransparency(FuBarPluginVoiceFuFrame, self.db.profile.idleAlpha);
    elseif amITalking and howManyPeopleAreTalking == 0 then
        -- Only player is talking, set text to "Transmitting" in green color
        displayText = crayon:Green(L["Transmitting"]);
        tablet:SetTransparency(FuBarPluginVoiceFuFrame, self.db.profile.activeAlpha);
    elseif amITalking and howManyPeopleAreTalking > 0 then
        -- Player is talking over others, set text to "Transmitting" in red color
        displayText = crayon:Red(L["Transmitting"]);
        tablet:SetTransparency(FuBarPluginVoiceFuFrame, self.db.profile.activeAlpha);
    elseif howManyPeopleAreTalking == 1 then
        -- One other person is talking, set text to identify them
        for thisGuy, allAboutThisGuy in pairs(whoIsTalking) do
            local myClassColor = RAID_CLASS_COLORS[allAboutThisGuy.class];
            myClassColor = string.format("%02x%02x%02x", myClassColor.r * 255, myClassColor.g * 255, myClassColor.b * 255);
            displayText = crayon:Colorize( myClassColor, allAboutThisGuy.lvl .. ": " .. allAboutThisGuy.name);
        end
        tablet:SetTransparency(FuBarPluginVoiceFuFrame, self.db.profile.activeAlpha);
    else
        -- Multiple people are talking, set text to "Multiple" in red color
        displayText = crayon:Red(L["Multiple"]);
        tablet:SetTransparency(FuBarPluginVoiceFuFrame, self.db.profile.activeAlpha);
    end
end

-- Displaying information
function VoiceFu:OnTextUpdate()
    self:SetText(displayText);
end

function VoiceFu:OnTooltipUpdate()
    local cat = tablet:AddCategory('columns', 1);
    if displayText == crayon:Red(L["Multiple"]) or displayText == crayon:Red(L["Transmitting"]) or displayText == crayon:Green(L["Transmitting"]) then
        cat:AddLine('text', displayText, 'noinherit', false);
--        line:SetTransparency(self.db.profile.activeAlpha);
    else
        cat:AddLine('text', crayon:White("VoiceFu"), 'textTransparency', self.db.profile.idleAlpha);
--        line:SetTransparency(self.db.profile.idleAlpha);
    end
    for thisGuy, allAboutThisGuy in pairs(whoIsTalking) do
        local myClassColor = RAID_CLASS_COLORS[allAboutThisGuy.class];
        cat:AddLine(
            'text', allAboutThisGuy.lvl .. ": " .. allAboutThisGuy.name,
            'textR', myClassColor.r,
            'textG', myClassColor.g,
            'textB', myClassColor.b,
            'noinherit', false
        )
--        line:SetTransparency(self.db.profile.activeAlpha);
    end
    
end

