--[[

Name: FuBar_VampwatchFu
Revision: $Revision: 81496 $
Date: $Date: 2008-09-07 18:53:41 -0400 (Sun, 07 Sep 2008) $
Author(s): jayrox (jayrox@gmail.com)
Description: Stats for Vampiric Touch, Vampiric Embrace and Shadowfied for Priests.
Dependencies: Ace2
Translations: deDE - bawi, tayedaen

]]--

VampwatchFu = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceDB-2.0", "FuBarPlugin-2.0", "AceEvent-2.0", "CandyBar-2.0") --, "AceDebug-2.0")
local tablet = AceLibrary("Tablet-2.0")
local L = AceLibrary("AceLocale-2.2"):new("FuBar_VampwatchFu")
local crayon = AceLibrary("Crayon-2.0")
local sm = AceLibrary("SharedMedia-1.0");

StaticPopupDialogs["VampwatchFUCONFIRM"] = { }

VampwatchFu:RegisterDB("VampwatchFuDB")
VampwatchFu:RegisterDefaults('char', {
	useConfirm = true,
	useTimer = true,
	useVT = true,
	useVE = true,
	useSF = true,
	useML = true,
    useMP5 = true,
	useLast = true,
	useTotal = false,
	monitorOverheal = false,
	SpamOnClick = true,
	useTitle = true,
	channel = L["say"],
	barposition = {},

	totalfights = 0,
	
	vtTotal = 0,
	vtLast = 0,
	vtTicks = 0,
	vtAvg = 0,
	vtHigh = 0,
	vtTTotal = 0,
	enableVT = true,
	
	veTotal = 0,
	veLast = 0,
	veTicks = 0,
	veAvg = 0,
	veHigh = 0,
	veTTotal = 0,
	veTotalE = 0,
	veLastE = 0,
	enableVE = true,

	sfTotal = 0,
	sfLast = 0,
	sfTicks = 0,
	sfAvg = 0,
	sfHigh = 0,
	sfTTotal = 0,
	enableSF = true,
})

VampwatchFu.hasIcon = "Interface\\Icons\\Spell_Shadow_ImprovedVampiricEmbrace"
VampwatchFu.hideMenuTitle = false
VampwatchFu.hasNoColor = false
VampwatchFu.hasNoText = false
VampwatchFu.clickableTooltip = true
VampwatchFu.defaultPosition = "CENTER"
VampwatchFu.Debugging = false
VampwatchFu.DebugLevel = 1
local shadowFiendSpell
local vampTouchSpell
local vampEmbraceSpell
local manaLeech
--- ========================================================= ---
--- Revision
--- ========================================================= ---
local Revision = tonumber(string.sub("$Revision: 81496 $", 12, -3))
VampwatchFu.Version = "1.2"
if Revision then
	VampwatchFu.Version = VampwatchFu.Version .. " Rev." .. Revision
end

VampwatchFu.events = {
	['CHAT_MSG_SPELL_PET_BUFF'] = true,
	['CHAT_MSG_SPELL_SELF_BUFF'] = true,
}

VampwatchFu.menuOptions = {
	type = 'group',
	args = {
		header = {
			type = "header",
			name = L["addonname"] .. " V." .. VampwatchFu.Version,
			icon = VampwatchFu.hasIcon,
			iconHeight = 16,
			iconWidth = 16,
			order = 100
		},
		headerspacer101 = {
			type = "header",
			name = " ",
			order = 101
		},
		ve_options = {
			type = "group",
			name = L["ve_opt"],
			desc = L["ve_opt"],
			args = { 
				ve_enabled = {
					type = "toggle",
					name = L["enabled"],
					desc = L["ve_enabled"],
					get = function() return VampwatchFu.db.char.enableVE end,
					set = function()
						VampwatchFu.db.char.enableVE = not VampwatchFu.db.char.enableVE
						VampwatchFu:UpdateText()
					end,
					order = 1
				},
				headerspacerVE1 = {
					type = "header",
					name = " ",
					order = 2
				},
				ve = {
					type = "toggle",
					name = L["vamp_embrace"],
					desc = L["vamp_embrace_desc"],
					get = function() return VampwatchFu.db.char.useVE end,
					set = function()
						VampwatchFu.db.char.useVE = not VampwatchFu.db.char.useVE
						VampwatchFu:UpdateText()
					end,
					order = 3
				},
				monitoroverheal = {
					type = "toggle",
					name = L["monitoroverheal"],
					desc = L["monitoroverheal_desc"],
					get = function() return VampwatchFu.db.char.monitorOverheal end,
					set = function() VampwatchFu.db.char.monitorOverheal = not VampwatchFu.db.char.monitorOverheal VampwatchFu:UpdateText() VampwatchFu:UpdateTooltip() end,
					order = 4
				},
			},
			order = 201,
		},
		vt_options = {
			type = "group",
			name = L["vt_opt"],
			desc = L["vt_opt"],
			args = { 
				vt_enabled = {
					type = "toggle",
					name = L["enabled"],
					desc = L["vt_enabled"],
					get = function() return VampwatchFu.db.char.enableVT end,
					set = function() VampwatchFu.db.char.enableVT = not VampwatchFu.db.char.enableVT VampwatchFu:UpdateText() end,
					order = 1
				},
				headerspacerVT1 = {
					type = "header",
					name = " ",
					order = 2
				},
				vt = {
					type = "toggle",
					name = L["vamp_touch"],
					desc = L["vamp_touch_desc"],
					get = function() return VampwatchFu.db.char.useVT end,
					set = function() VampwatchFu.db.char.useVT = not VampwatchFu.db.char.useVT VampwatchFu:UpdateText() end,
					order = 3
				},
				vtmp5 = {
					type = "toggle",
					name = L["vamp_touch_mp5"],
					desc = L["vamp_touch_mp5_desc"],
					get = function() return VampwatchFu.db.char.useMP5 end,
					set = function() VampwatchFu.db.char.useMP5 = not VampwatchFu.db.char.useMP5 VampwatchFu:UpdateText() end,
					order = 4
				},
			},
			order = 202,
		},
		sf_options = {
			type = "group",
			name = L["sf_opt"],
			desc = L["sf_opt"],
			args = { 
				sf_enabled = {
					type = "toggle",
					name = L["enabled"],
					desc = L["sf_enabled"],
					get = function() return VampwatchFu.db.char.enableSF end,
					set = function() VampwatchFu.db.char.enableSF = not VampwatchFu.db.char.enableSF VampwatchFu:UpdateText() end,
					order = 1
				},
				headerspacerSF1 = {
					type = "header",
					name = " ",
					order = 2
				},
				sftoggle = {
					type = "toggle",
					name = L["sf_toggle"],
					desc = L["sf_toggle_desc"],
					get = function() return VampwatchFu.db.char.useSF end,
					set = function() VampwatchFu.db.char.useSF = not VampwatchFu.db.char.useSF VampwatchFu:UpdateText() end,
					order = 3
				},
				headerspacerSF2 = {
					type = "header",
					name = " ",
					order = 4
				},
				shadowfiendtimer = {
					type = "toggle",
					name = L["sf_timer"],
					desc = L["sf_timer_desc"],
					get = function() return VampwatchFu.db.char.useTimer end,
					set = function() VampwatchFu.db.char.useTimer = not VampwatchFu.db.char.useTimer VampwatchFu:UpdateText() end,
					order = 5
				},
				anchor = {
					name = L["Show Anchor"],
					desc = L["Shows the dragable anchor."],
					type = "execute",
					func = function() VampwatchFu:ToggleAnchor() end,
					order = 6
				},
			},
			order = 203
		},
		titletext = {
			type = "group",
			name = L["title_text"],
			desc = L["title_text_desc"],
			--disabled = function() return not FuBar end,
			args = {
				showtitle = {
					type = "toggle",
					name = L["show_title"],
					desc = L["show_title_desc"],
					get = function() return VampwatchFu.db.char.useTitle end,
					set = function() 
						VampwatchFu.db.char.useTitle = not VampwatchFu.db.char.useTitle
						VampwatchFu:UpdateText()
						end,
					order = 1
				},
				headerspacerTitle1 = {
					type = "header",
					name = " ",
					order = 2
				},
				titlelast = {
					type = "toggle",
					name = L["title_last"],
					desc = L["title_last"],
					get = function() return VampwatchFu.db.char.useLast end,
					set = function(v)
						VampwatchFu.db.char.useLast = true
						VampwatchFu.db.char.useTotal = false
 						VampwatchFu:UpdateText()
					end,
					order = 3,
				},
				titletotal = {
					type = "toggle",
					name = L["title_total"],
					desc = L["title_total"],
					get = function() return VampwatchFu.db.char.useTotal end,
					set = function(v)
						VampwatchFu.db.char.useLast = false
						VampwatchFu.db.char.useTotal = true
 						VampwatchFu:UpdateText()
					end,
					order = 4,
				},
			},
			order = 204,
		},
		headerspacer300 = {
			type = "header",
			name = " ",
			order = 300
		},
		spamoptions = {
			type = "group",
			name = L["spam_opt"],
			desc = L["spam_opt_desc"],
			args = {
				multiline = {
					type = "toggle",
					name = L["multiline"],
					desc = L["multiline"],
					get = function() return VampwatchFu.db.char.useML end,
					set = function() VampwatchFu.db.char.useML = not VampwatchFu.db.char.useML VampwatchFu:UpdateText() end,
					order = 1
				},
				spamonclick = {
					type = "toggle",
					name = L["spam_on_click"],
					desc = L["spam_on_click_desc"],
					get = function() return VampwatchFu.db.char.SpamOnClick end,
					set = function() VampwatchFu.db.char.SpamOnClick = not VampwatchFu.db.char.SpamOnClick VampwatchFu:UpdateText() end,
					order = 2
				},
				sendto = {
					type = 'text',
					name = L["broadcast_opt"],
					desc = L["broadcast_opt"],
					usage = '<'.. L["broadcast_opt"].. '>',
					get = function()
						return VampwatchFu.db.char.channel
					end,
					set = function(v)
						VampwatchFu.db.char.channel = v;
					end,
					validate = {L["say"],L["party"],L["raid"],L["guild"],L["editbox"]},
					order = 3
				},
			},
			order = 301
		},
		headerspacer600 = {
			type = "header",
			name = " ",
			order = 600
		},
		resetoptions = {
			type = "group",
			name = L["reset_opt"],
			desc = L["reset_opt_desc"],
			args = {
				resettotals = {
					type = "execute",
					name = L["reset_totals"],
					desc = L["reset_totals_desc"],
					func = function() 
						VampwatchFu:Confirm(L["Reset_confirm_totals"], function() VampwatchFu:ResetTStats() VampwatchFu:UpdateText() end)
					end,
					order = 1
				},
				resetall = {
					type = "execute",
					name = L["reset_all"],
					desc = L["reset_all_desc"],
					func = function() 
						VampwatchFu:Confirm(L["Reset_confirm"], function() VampwatchFu:ResetStats() VampwatchFu:UpdateText() end)
					end,
					order = 2
				},
				headerspacerReset600 = {
					type = "header",
					name = " ",
					order = 3
				},
				confreset = {
					type = "toggle",
					name = L["reset_conf"],
					desc = L["reset_conf_desc"],
					get = function() return VampwatchFu.db.char.useConfirm end,
					set = function(v)
						VampwatchFu.db.char.useConfirm = not VampwatchFu.db.char.useConfirm
					end,
					order = 4
				},
			},
			order = 601
		},
	},
}

function VampwatchFu:ResetStats()
	VampwatchFu.db.char.vtLast = 0 
	VampwatchFu.db.char.vtHigh = 0 
	VampwatchFu.db.char.vtAvg = 0 
	VampwatchFu.db.char.vtTicks = 0 
	VampwatchFu.db.char.vtTotal = 0
	VampwatchFu.db.char.vtTTotal = 0
	
	VampwatchFu.db.char.veTotal = 0
	VampwatchFu.db.char.veTicks = 0
	VampwatchFu.db.char.veAvg = 0
	VampwatchFu.db.char.veHigh = 0
	VampwatchFu.db.char.veLast = 0
	VampwatchFu.db.char.veTTotal = 0
	VampwatchFu.db.char.veLastE = 0
	VampwatchFu.db.char.veTotalE = 0
	
	VampwatchFu.db.char.sfTicks = 0
	VampwatchFu.db.char.sfAvg = 0
	VampwatchFu.db.char.sfHigh = 0
	VampwatchFu.db.char.sfTotal = 0
	VampwatchFu.db.char.sfLast = 0
	VampwatchFu.db.char.sfTTotal = 0
	
	VampwatchFu.db.char.vtPerFight = 0
	VampwatchFu.db.char.vePerFight = 0
	VampwatchFu.db.char.sfPerFight = 0
	VampwatchFu.db.char.totalfights = 0
end

function VampwatchFu:ResetTStats()
	VampwatchFu.db.char.vtTotal = 0 
	VampwatchFu.db.char.vtLast = 0 

	VampwatchFu.db.char.sfTotal = 0
	VampwatchFu.db.char.sfLast = 0

	VampwatchFu.db.char.veTotal = 0
	VampwatchFu.db.char.veLast = 0
	VampwatchFu.db.char.veTotalE = 0
	VampwatchFu.db.char.veLastE = 0

	VampwatchFu.db.char.vtPerFight = 0
	VampwatchFu.db.char.vePerFight = 0
	VampwatchFu.db.char.sfPerFight = 0
	VampwatchFu.db.char.totalfights = 0
end

function VampwatchFu:OnTextUpdate()
	updateCounter = updateCounter + 1
    if(updateCounter < 6 and updateCounter > 1) then 
        return 
    else
        updateCounter = 1
    end
    local msg = "";
	if(VampwatchFu.db.char.useTitle ~=nil and VampwatchFu.db.char.useTitle == true) then
		msg = msg .. crayon:Red(L["VampwatchFu"]);
	end
	if(VampwatchFu.db.char.useLast == true) then
		tvt = VampwatchFu.db.char.vtLast
		tve = VampwatchFu.db.char.veLast
		tsf = VampwatchFu.db.char.sfLast
	elseif(VampwatchFu.db.char.useTotal == true) then
		tvt = VampwatchFu.db.char.vtTotal
		tve = VampwatchFu.db.char.veTotal
		tsf = VampwatchFu.db.char.sfTotal
	end
	if(VampwatchFu.db.char.monitorOverheal == true and VampwatchFu.db.char.useLast == true) then
		tve = VampwatchFu.db.char.veLastE
	elseif(VampwatchFu.db.char.monitorOverheal == true and VampwatchFu.db.char.useTotal == true) then
		tve = VampwatchFu.db.char.veTotalE
	end
	if(VampwatchFu.db.char.useVT ~= nil and VampwatchFu.db.char.useVT == true and VampwatchFu.db.char.enableVT == true) then
		msg = msg .. crayon:Purple(L["vt_title"]) .. crayon:Red(tvt);
	end
	if(VampwatchFu.db.char.useVE ~= nil and VampwatchFu.db.char.useVE == true and VampwatchFu.db.char.enableVE == true) then
		msg = msg .. crayon:Purple(L["ve_title"]) .. crayon:Red(tve);
	end
	if(VampwatchFu.db.char.useSF ~= nil and VampwatchFu.db.char.useSF == true and VampwatchFu.db.char.enableSF == true) then
		msg = msg .. crayon:Purple(L["sf_title"]) .. crayon:Red(tsf);
	end
	if(VampwatchFu.db.char.useMP5 ~= nil and VampwatchFu.db.char.useMP5 == true) then
		fightTimeTotal = fightEndTime - fightStartTime
        if(fightTimeTotal ~= 0) then
            tmp5 = VampwatchFu.db.char.vtLast / fightTimeTotal * 5
            tmp5 = string.sub(tmp5,1,6);
        else
            tmp5 = 0
        end
        if(tmp5 == -0) then tmp5 = 0 end
        msg = msg .. crayon:Purple(L["mp5_title"]) .. crayon:Red(tmp5);
	end
	self:SetText(msg)
end

function VampwatchFu:PLAYER_REGEN_ENABLED()		
    fightEndTime = GetTime()
end

function VampwatchFu:PLAYER_REGEN_DISABLED()		
	VampwatchFu.db.char.veLast = 0
	VampwatchFu.db.char.vtLast = 0
	VampwatchFu.db.char.sfLast = 0
	VampwatchFu.db.char.veLastE = 0
	VampwatchFu.db.char.totalfights = VampwatchFu.db.char.totalfights + 1
    fightStartTime = GetTime()
end

function VampwatchFu:UNIT_SPELLCAST_SENT(player, spell, rank, target)
	if (spell == shadowFiendSpell and VampwatchFu.db.char.useTimer == true) then
		self:StartCandyBar("VampwatchFuSF", false)
	end
end

local playerGUID
function VampwatchFu:OnInitialize()
	shadowFiendSpell = (GetSpellInfo(34433))
	vampTouchSpell= (GetSpellInfo(34914))
	vampEmbraceSpell = (GetSpellInfo(15286))
	manaLeech = (GetSpellInfo(28305))
	if(VampwatchFu.db.char.useMP5 == nil) then
        VampwatchFu.db.char.useMP5 = true
    end
    fightStartTime = 0
    fightEndTime = 0
    updateCounter = 0
    self:RegisterChatCommand(L["consolecommands"], self.OnMenuRequest)
	self:RegisterEvent("PLAYER_REGEN_DISABLED");
	self:RegisterEvent("PLAYER_REGEN_ENABLED");
	self:RegisterEvent("UNIT_SPELLCAST_SENT");
	sm:Register("statusbar", "BantoBar", "Interface\\Addons\\FuBar_VampwatchFu\\Texture\\banto.tga");
	--for event in pairs(self.events) do
	--	if not parser:IsEventRegistered("VampwatchFu", event) then
	--		parser:RegisterEvent("VampwatchFu", event, function(event, info) self:OnCombatEvent(event, info) end)
	--	end
	--end
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	self.anchor = self:CreateAnchor(L["VampwatchFu"], 0.3,0.5,0.8)
	self:RegisterCandyBarGroup("VampwatchFu")
	self:SetCandyBarGroupPoint("VampwatchFu", "TOP", self.anchor, "BOTTOM", 0, 0)	
	self:SetCandyBarGroupGrowth("VampwatchFu", false)
	self:RegisterCandyBar("VampwatchFuSF", 15, shadowFiendSepll, "Interface\\Icons\\Spell_Shadow_Shadowfiend", "green", "yellow", "red")
	self:RegisterCandyBarWithGroup("VampwatchFuSF", "VampwatchFu")
	self:SetCandyBarTexture("VampwatchFuSF", sm:Fetch("statusbar", "BantoBar"));
	self.OnMenuRequest = VampwatchFu.menuOptions
	playerGUID = UnitGUID("player")
	
end

-- GetOverheal Function from SCT by Grayhoof
function VampwatchFu:GetOverheal(target, damage)
	local unit = self:GetTargetUnit(target) or "player";
	local healamt = damage;
	local dmg = damage;
	local overheal = 0;
	local lost = 0;
	if unit then
		local lost = UnitHealthMax(unit)-UnitHealth(unit);
		local overheal = dmg - lost;
		if (overheal > 0) then
			dmg = lost.." {"..overheal.."}";
			healamt = lost;
		end
	end
	return dmg, healamt;
end

--Return the unit if for a given target from SCT by Grayhoof
function VampwatchFu:GetTargetUnit(target)
	local unit;
	if (target == "player") then
		return "player";
	end
	if (target == UnitName('pet'))then
	  return "pet";
	end
	for i = 1, GetNumRaidMembers(), 1 do
		if ( UnitName("raid" .. i) and UnitName("raid" .. i) == target ) then
			return "raid"..i;
		end
	end
	for i = 1, GetNumPartyMembers(), 1 do
		if ( UnitName("party" .. i) and UnitName("party" .. i) == target ) then
			return "party"..i;
		end
	end
end

function VampwatchFu:COMBAT_LOG_EVENT_UNFILTERED(timestamp, event, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags, spellID, spellName, spellSchool, detail1, detail2, detail3)
	if(playerGUID == nil) then
        playerGUID = UnitGUID("player")
    end
    if(srcGUID == playerGUID and event == "SPELL_PERIODIC_HEAL" and spellName == vampEmbraceSpell and VampwatchFu.db.char.enableVE == true)then -- VE heals
		VampwatchFu.db.char.veTicks = VampwatchFu.db.char.veTicks + 1;
		VampwatchFu.db.char.veTTotal = VampwatchFu.db.char.veTTotal + detail1;
		VampwatchFu.db.char.veAvg = VampwatchFu.db.char.veTTotal / VampwatchFu.db.char.veTicks;
		VampwatchFu.db.char.veAvg = string.sub(VampwatchFu.db.char.veAvg,1,6);
		VampwatchFu.db.char.veLast = VampwatchFu.db.char.veLast + detail1;
		VampwatchFu.db.char.veTotal = VampwatchFu.db.char.veTotal + detail1;
		VampwatchFu.db.char.vePerFight = VampwatchFu.db.char.veTotal / VampwatchFu.db.char.totalfights;
		VampwatchFu.db.char.vePerFight = string.sub(VampwatchFu.db.char.vePerFight,1,6);
		if(tonumber(VampwatchFu.db.char.veHigh) < tonumber(detail1)) then
			VampwatchFu.db.char.veHigh = tonumber(detail1);
		end
		if(VampwatchFu.db.char.monitorOverheal == true) then 
			_, healamt = self:GetOverheal(dstName, detail1);
			VampwatchFu.db.char.veLastE = VampwatchFu.db.char.veLastE + healamt;
			VampwatchFu.db.char.veTotalE = VampwatchFu.db.char.veTotalE + healamt;
		end
	end
	if(srcName == shadowFiendSpell and dstGUID == playerGUID and event == "SPELL_ENERGIZE" and spellName == manaLeech and VampwatchFu.db.char.enableSF == true) then -- shadow fiend
		VampwatchFu.db.char.sfTotal = VampwatchFu.db.char.sfTotal + detail1;
		VampwatchFu.db.char.sfPerFight = VampwatchFu.db.char.sfTotal / VampwatchFu.db.char.totalfights;
		VampwatchFu.db.char.sfPerFight = string.sub(VampwatchFu.db.char.sfPerFight,1,6);
		VampwatchFu.db.char.sfTTotal = VampwatchFu.db.char.sfTTotal + detail1;
		VampwatchFu.db.char.sfLast = VampwatchFu.db.char.sfLast + detail1;
		VampwatchFu.db.char.sfTicks = VampwatchFu.db.char.sfTicks + 1;
		VampwatchFu.db.char.sfAvg = VampwatchFu.db.char.sfTTotal / VampwatchFu.db.char.sfTicks;
		VampwatchFu.db.char.sfAvg = string.sub(VampwatchFu.db.char.sfAvg,1,6);
		if(tonumber(VampwatchFu.db.char.sfHigh) < tonumber(detail1)) then
			VampwatchFu.db.char.sfHigh = tonumber(detail1);
		end
	end
	if(srcGUID == playerGUID and event == "SPELL_PERIODIC_ENERGIZE" and spellName == vampTouchSpell and VampwatchFu.db.char.enableVT == true) then -- VT
		VampwatchFu.db.char.vtTotal = VampwatchFu.db.char.vtTotal + detail1;
		VampwatchFu.db.char.vtPerFight = VampwatchFu.db.char.vtTotal / VampwatchFu.db.char.totalfights;
		VampwatchFu.db.char.vtPerFight = string.sub(VampwatchFu.db.char.vtPerFight,1,6);
		VampwatchFu.db.char.vtTTotal = VampwatchFu.db.char.vtTTotal + detail1;
		VampwatchFu.db.char.vtLast = VampwatchFu.db.char.vtLast + detail1;
		VampwatchFu.db.char.vtTicks = VampwatchFu.db.char.vtTicks + 1;
		VampwatchFu.db.char.vtAvg = VampwatchFu.db.char.vtTTotal / VampwatchFu.db.char.vtTicks;
		VampwatchFu.db.char.vtAvg = string.sub(VampwatchFu.db.char.vtAvg,1,6);
		if(tonumber(VampwatchFu.db.char.vtHigh) < tonumber(detail1)) then
			VampwatchFu.db.char.vtHigh = tonumber(detail1);
		end
        fightEndTime = GetTime()
	end
	self:UpdateTooltip()
	self:UpdateText()
end

function VampwatchFu:OnEnable()
	if AceDebug then
		self:SetDebugging(VampwatchFu.Debugging)
		self:SetDebugLevel(VampwatchFu.DebugLevel)
	end
end

function VampwatchFu:ToggleAnchor()
	if self.anchor:IsVisible() then
		self.anchor:Hide()
	else
		self.anchor:Show()
	end
end

-- Creates the anchor frames
function VampwatchFu:CreateAnchor(text, cRed, cGreen, cBlue)
	local f = CreateFrame("Button", nil, UIParent)
	f:SetWidth(200)
	f:SetHeight(25)

	f.owner = self

	if VampwatchFu.db.char.barposition.x and VampwatchFu.db.char.barposition.y  and VampwatchFu.db.char.barposition.point and VampwatchFu.db.char.barposition.anchor then
		f:ClearAllPoints()
		f:SetPoint(VampwatchFu.db.char.barposition.point, UIParent, VampwatchFu.db.char.barposition.anchor, VampwatchFu.db.char.barposition.x, VampwatchFu.db.char.barposition.y)
	else
		f:SetPoint("CENTER", UIParent, "CENTER", 0, 50)
	end

	f:SetScript("OnDragStart", function() this:StartMoving() end )
	f:SetScript("OnDragStop",
		function()
			this:StopMovingOrSizing()
			local point, _, anchor, x, y = this:GetPoint()
			VampwatchFu.db.char.barposition.x = math.floor(x)
			VampwatchFu.db.char.barposition.y = math.floor(y)
			VampwatchFu.db.char.barposition.anchor = anchor
 			VampwatchFu.db.char.barposition.point = point
		end)

	f:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background",
					edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
                    tile = false, tileSize = 16, edgeSize = 16,
					insets = { left = 5, right =5, top = 5, bottom = 5 }})
	f:SetBackdropColor(cRed,cGreen,cBlue,.6)
	f:SetMovable(true)
	f:RegisterForDrag("LeftButton")

	f.Text = f:CreateFontString(nil, "OVERLAY")
	f.Text:SetFontObject(GameFontNormalSmall)
	f.Text:ClearAllPoints()
	f.Text:SetTextColor(1, 1, 1, 1)
	f.Text:SetWidth(200)
	f.Text:SetHeight(25)
	f.Text:SetPoint("TOPLEFT", f, "TOPLEFT")
	f.Text:SetJustifyH("CENTER")
	f.Text:SetJustifyV("MIDDLE")
	f.Text:SetText(text)

	f:Hide()

	return f
end

function VampwatchFu:Confirm(text, onAccept, timeout, whileDead)
	--VampwatchFu:Close(1)
	if (VampwatchFu.db.char.useConfirm) then
		if (not timeout) then timeout = 0 end
		if (not whileDead) then whileDead = 1 end
		StaticPopupDialogs["VampwatchFUCONFIRM"].text = text
		StaticPopupDialogs["VampwatchFUCONFIRM"].button1 = L["Yes"]
		StaticPopupDialogs["VampwatchFUCONFIRM"].button2 = L["No"]
		StaticPopupDialogs["VampwatchFUCONFIRM"].timeout = timeout
		StaticPopupDialogs["VampwatchFUCONFIRM"].whileDead = whileDead
		StaticPopupDialogs["VampwatchFUCONFIRM"].OnAccept = onAccept
		StaticPopup_Show("VampwatchFUCONFIRM")
	else
		pcall(onAccept) -- Just execute the damn function
	end
end

function VampwatchFu:OnClick()
	if IsAltKeyDown() then
		VampwatchFu:Confirm(L["Reset_confirm_totals"], function() VampwatchFu:ResetTStats() VampwatchFu:UpdateText() end)
		return
	elseif IsControlKeyDown() then
		VampwatchFu:Confirm(L["Reset_confirm"], function() VampwatchFu:ResetStats() VampwatchFu:UpdateText() end)
		return
	end
	if(not VampwatchFu.db.char.SpamOnClick or VampwatchFu.db.char.SpamOnClick == false) then return end
	if(VampwatchFu.db.char.useML) then
		VampWatchMessage1 = L[" ## VampwatchFu Stats:"];
		VampWatchMessage2 = L[" ## Vampiric Touch - Last Fight: "] .. VampwatchFu.db.char.vtLast .. " " .. L["mana"] .. ".";
		VampWatchMessage3 = L[" ## Vampiric Touch - All Fights: "] .. VampwatchFu.db.char.vtTotal .. " " .. L["mana"] .. ".";
		VampWatchMessage4 = L[" ## Vampiric Embrace - Last Fight: "] .. VampwatchFu.db.char.veLast .. " " .. L["health"] .. ".";
		VampWatchMessage5 = L[" ## Vampiric Embrace - All Fights: "] .. VampwatchFu.db.char.veTotal .. " " .. L["health"] .. ".";
		VampwatchFu:VWSpam(VampWatchMessage1)
		VampwatchFu:VWSpam(VampWatchMessage2)
		VampwatchFu:VWSpam(VampWatchMessage3)
		VampwatchFu:VWSpam(VampWatchMessage4)
		VampwatchFu:VWSpam(VampWatchMessage5)
	elseif(not VampwatchFu.db.char.useML) then
		VampwatchFu:VWSpam(L["vwFu:: Vampiric Touch Total: "] .. VampwatchFu.db.char.vtTotal .. L[" Vampiric Embrace Total: "] .. VampwatchFu.db.char.veTotal)
	end
end

function VampwatchFu:VWSpam(stat)
	local vw_spammsg = "";
	local vw_channel = VampwatchFu.db.char.channel;
	if(vw_channel == L["say"]) then
		vw_chat_channel = "SAY"
	elseif(vw_channel == L["party"]) then
		vw_chat_channel = "PARTY"
	elseif(vw_channel == L["raid"]) then
		vw_chat_channel = "RAID"
	elseif(vw_channel == L["guild"]) then
		vw_chat_channel = "GUILD"
	elseif(vw_channel == L["editbox"]) then
		vw_chat_channel = "EDITBOX"
	end
	if(stat == "ve_tick") then
		vw_spammsg = L["vwFu: Vampiric Embrace Ticks: "] .. VampwatchFu.db.char.veTicks .. L[" Average Tick: "] .. VampwatchFu.db.char.veAvg .. L[" Highest Tick: "] .. VampwatchFu.db.char.veHigh;
	elseif(stat == "ve_last") then
		vw_spammsg = L["vwFu: Vampiric Embrace Last: "] .. VampwatchFu.db.char.veLast .. " " .. L["health"];
	elseif(stat == "ve_total") then
		vw_spammsg = L["vwFu: Vampiric Embrace Total: "] .. VampwatchFu.db.char.veTotal .. " " .. L["health"];
	elseif(stat == "ve_laste") then
		vw_spammsg = L["vwFu: Vampiric Embrace Last: "] .. VampwatchFu.db.char.veLastE .. " " .. L["effective health"];
	elseif(stat == "ve_totale") then
		vw_spammsg = L["vwFu: Vampiric Embrace Total: "] .. VampwatchFu.db.char.veTotalE .. " " .. L["effective health"];
	elseif(stat == "vt_tick") then
		vw_spammsg = L["vwFu: Vampiric Touch Ticks: "] .. VampwatchFu.db.char.vtTicks .. L[" Average Tick: "] .. VampwatchFu.db.char.vtAvg .. L[" Highest Tick: "] .. VampwatchFu.db.char.vtHigh;
	elseif(stat == "vt_total") then
		vw_spammsg = L["vwFu: Vampiric Touch Total: "] .. VampwatchFu.db.char.vtTotal .. " " .. L["mana"];
	elseif(stat == "vt_last") then
		vw_spammsg = L["vwFu: Vampiric Touch Last: "] .. VampwatchFu.db.char.vtLast .. " " .. L["mana"];
	elseif(stat == "sf_tick") then
		vw_spammsg = L["vwFu: Shadowfiend Ticks: "] .. VampwatchFu.db.char.sfTicks .. L[" Average Tick: "] .. VampwatchFu.db.char.sfAvg .. L[" Highest Tick: "] .. VampwatchFu.db.char.sfHigh;
	elseif(stat == "sf_last") then
		vw_spammsg = L["vwFu: Shadowfiend Last: "] .. VampwatchFu.db.char.sfLast .. " " .. L["mana"];
	elseif(stat == "sf_total") then
		vw_spammsg = L["vwFu: Shadowfiend Total: "] .. VampwatchFu.db.char.sfTotal .. " " .. L["mana"];
	elseif(stat == "sf_perfight") then
		vw_spammsg = L["vwFu: Shadowfiend Avg. Per Fight: "] .. VampwatchFu.db.char.sfPerFight .. " " .. L["mana"];
	elseif(stat == "vt_perfight") then
		vw_spammsg = L["vwFu: Vampiric Touch Avg. Per Fight: "] .. VampwatchFu.db.char.sfPerFight .. " " .. L["mana"];
	elseif(stat == "ve_perfight") then
		vw_spammsg = L["vwFu: Vampiric Embrace Avg. Per Fight: "] .. VampwatchFu.db.char.sfPerFight .. " " .. L["mana"];
	else
		vw_spammsg = stat
	end
	if(vw_chat_channel == "EDITBOX") then
		local editBox = DEFAULT_CHAT_FRAME.editBox;
		local type = editBox:GetAttribute("chatType");
		if (type == "CHANNEL" ) then
			local channel,_,_ = GetChannelName(editBox:GetAttribute("channelTarget"));
			SendChatMessage(vw_spammsg, "CHANNEL", nil, channel);
			return
		elseif(type ~= "CHANNEL" and type ~= "WHISPER") then
			SendChatMessage(vw_spammsg, type, nil);
		elseif(type == "WHISPER") then
			local tT = editBox:GetAttribute("tellTarget");
			SendChatMessage(vw_spammsg, type, nil, tT);
		end
	else
		SendChatMessage(vw_spammsg, vw_chat_channel, nil);
	end
end



function VampwatchFu:OnTooltipUpdate()
	local cat = tablet:AddCategory(
			"columns", 2,
			"text", " ",
			"text2", " ",
			"child_justify", "LEFT",
			"child_justify2", "LEFT",
			"child_justify3", "RIGHT",
			"child_justify4", "RIGHT",
			"child_textR", 1,
			"child_textG", 1,
			"child_textB", 0,
			"child_text3R", 1,
			"child_text3G", 1,
			"child_text3B", 1,
			"child_text4R", 0.65,
			"child_text4G", 0.65,
			"child_text4B", 0.65
		)
	if(VampwatchFu.db.char.enableVT == true) then
		cat:AddLine('text', crayon:Purple(vampTouchSpell), "text2", crayon:Purple(L["Amount"]))
		cat:AddLine(
		'text', L["ticks"], "text2", crayon:Red(VampwatchFu.db.char.vtTicks),
		'func', function() VampwatchFu:VWSpam("vt_tick") end,
		'justify', "Left"
		)
		cat:AddLine(
			'text', L["high"], "text2", crayon:Red(VampwatchFu.db.char.vtHigh),
			'func', function() VampwatchFu:VWSpam("vt_tick") end,
			'justify', "Left"
		)
		cat:AddLine(
			'text', L["avg"], "text2", crayon:Red(VampwatchFu.db.char.vtAvg),
			'func', function() VampwatchFu:VWSpam("vt_tick") end,
			'justify', "Left"
		)
		cat:AddLine(
			'text', L["perfight"], "text2", crayon:Red(VampwatchFu.db.char.vtPerFight),
			'func', function() VampwatchFu:VWSpam("vt_perfight") end,
			'justify', "Left"
		)
		cat:AddLine(
			'text', L["last"], "text2", crayon:Red(VampwatchFu.db.char.vtLast),
			'func', function() VampwatchFu:VWSpam("vt_last") end,
			'justify', "Left"
		)
		cat:AddLine(
			'text', L["total"], "text2", crayon:Red(VampwatchFu.db.char.vtTotal),
			'func', function() VampwatchFu:VWSpam("vt_total") end,
			'justify', "Left"
		)
		cat:AddLine('text', " ")
	end
	if(VampwatchFu.db.char.enableVE == true) then
		cat:AddLine('text', crayon:Purple(vampEmbraceSpell), "text2", crayon:Purple(L["Amount"]))
		cat:AddLine(
			'text', L["ticks"], "text2", crayon:Red(VampwatchFu.db.char.veTicks),
			'func', function() VampwatchFu:VWSpam("ve_tick") end,
			'justify', "Left"
		)
		cat:AddLine(
			'text', L["high"], "text2", crayon:Red(VampwatchFu.db.char.veHigh),
			'func', function() VampwatchFu:VWSpam("ve_tick") end,
		'justify', "Left"
		)
		cat:AddLine(
			'text', L["avg"], "text2", crayon:Red(VampwatchFu.db.char.veAvg),
			'func', function() VampwatchFu:VWSpam("ve_tick") end,
			'justify', "Left"
		)
		cat:AddLine(
			'text', L["perfight"], "text2", crayon:Red(VampwatchFu.db.char.vePerFight),
			'func', function() VampwatchFu:VWSpam("ve_perfight") end,
			'justify', "Left"
		)
		if(VampwatchFu.db.char.monitorOverheal == true) then
			cat:AddLine(
				'text', L["elast"], "text2", crayon:Red(VampwatchFu.db.char.veLastE),
				'func', function() VampwatchFu:VWSpam("ve_laste") end,
				'justify', "Left"
			)
			cat:AddLine(
				'text', L["etotal"], "text2", crayon:Red(VampwatchFu.db.char.veTotalE),
				'func', function() VampwatchFu:VWSpam("ve_totale") end,
				'justify', "Left"
			)
		end
		cat:AddLine(
			'text', L["last"], "text2", crayon:Red(VampwatchFu.db.char.veLast),
			'func', function() VampwatchFu:VWSpam("ve_last") end,
			'justify', "Left"
		)
		cat:AddLine(
			'text', L["total"], "text2", crayon:Red(VampwatchFu.db.char.veTotal),
			'func', function() VampwatchFu:VWSpam("ve_total") end,
			'justify', "Left"
		)
		cat:AddLine('text', " ")
	end
	if(VampwatchFu.db.char.enableSF == true) then
		cat:AddLine('text', crayon:Purple(shadowFiendSpell), "text2", crayon:Purple(L["Amount"]))
		cat:AddLine(
		'text', L["ticks"], "text2", crayon:Red(VampwatchFu.db.char.sfTicks),
		'func', function() VampwatchFu:VWSpam("sf_tick") end,
		'justify', "Left"
		)
		cat:AddLine(
			'text', L["high"], "text2", crayon:Red(VampwatchFu.db.char.sfHigh),
			'func', function() VampwatchFu:VWSpam("sf_tick") end,
			'justify', "Left"
		)
		cat:AddLine(
			'text', L["avg"], "text2", crayon:Red(VampwatchFu.db.char.sfAvg),
			'func', function() VampwatchFu:VWSpam("sf_tick") end,
			'justify', "Left"
		)
		cat:AddLine(
			'text', L["perfight"], "text2", crayon:Red(VampwatchFu.db.char.sfPerFight),
			'func', function() VampwatchFu:VWSpam("sf_perfight") end,
			'justify', "Left"
		)
		cat:AddLine(
			'text', L["last"], "text2", crayon:Red(VampwatchFu.db.char.sfLast),
			'func', function() VampwatchFu:VWSpam("sf_last") end,
			'justify', "Left"
		)
		cat:AddLine(
			'text', L["total"], "text2", crayon:Red(VampwatchFu.db.char.sfTotal),
			'func', function() VampwatchFu:VWSpam("sf_total") end,
			'justify', "Left"
		)
	end
	if(VampwatchFu.db.char.enableVT == false and VampwatchFu.db.char.enableVE == false and VampwatchFu.db.char.enableSF == false) then
		cat:AddLine('text', L["nothing monitored."])
	end
	tablet:SetHint(L["FuBarHint"])
end