Usage = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceEvent-2.0", "AceDB-2.0")
local Usage = Usage
local self = Usage
local dewdrop = AceLibrary("Dewdrop-2.0")
local tablet = AceLibrary("Tablet-2.0")
Usage.hasIcon = "Interface\\Icons\\INV_Scroll_01"
Usage.hasNoText = true
Usage.defaultPosition = "RIGHT"
Usage.clickableTooltip = true

local db
local addons = {} -- main cache table for addon info
local cpu_enabled

-- column sortby table
local sortkey = { "Name", "Mem_initial", "Mem_gained", "Mem_rate", "Mem_total", "CPU_initial", "CPU_rate", "CPU_total", }
-- current column color flag
local col = { Name = "", Mem_initial = "2", Mem_gained = "3", Mem_rate = "4", Mem_total = "5", CPU_initial = "6", CPU_rate = "7", CPU_total = "8", }

local updateUsage
local fmod = math.fmod

-----------------------------
function Usage:OnInitialize()
-----------------------------
	self:RegisterDB("UsageDB")
	self:RegisterDefaults('profile', {
		sort = "Mem_total",
	})
	db = self.db.profile
	cpu_enabled = GetCVar("scriptProfile") ~= "0"
	if not cpu_enabled then
		tremove(sortkey, 6) 
		tremove(sortkey, 6)
		tremove(sortkey, 6)
	end
	
	self.OnMenuRequest = {
		type = 'group',
		args = {
			cpu = {
				order = 1,
				type = 'toggle', name = "Enable CPU Profiling", desc = "Allows CPU usage data (will reloadui)",
				set = function(v)
					SetCVar("scriptProfile", (v and "1") or "0")
					ReloadUI()
				end,	
				get = function() return cpu_enabled end,
			},
			memreset = {
				order = 2, 
				type = 'execute', name = "Collect Garbage", desc = "Collect Garbage",
				func = collectgarbage,
			},
			cpureset = {
				order = 3, 
				type = 'execute', name = "Reset CPU Data", desc = "Resets CPU profiling",
				func = ResetCPUUsage,
				disabled = not cpu_enabled,
			},
			sort = {
				order = 4,
				type = 'text', name = "Sort By", desc = "Sort",
				set = function(v) db.sort = v self:Update() end,
				get = function() return db.sort end,
				validate = sortkey,
			},
		},
	}
end

-------------------------
function Usage:OnEnable()
-------------------------
	self:ScheduleRepeatingEvent(self.UpdateTooltip, 5, self)
	self:RegisterEvent("AceEvent_FullyInitialized", updateUsage)
end

do
	-- alternate row colors
	local altcolor = { [0] = "ffffbb", [1] = "ffff44", }
	-- text formats
	local forms = { "|cff%s%s|r", "|cff%s%.3f|r", "|cff%s%.6f|r", "|cff%s%.1f|r" }
	-- current row color
	local c
	-- format function
	local function ftext(mode, text)
		if text == 0 then
			return format("|cff%s0.0|r", c)
		else
			return format(forms[mode], c, text)
		end
	end
	--------------------------------
	function Usage:OnTooltipUpdate()
	--------------------------------
		updateUsage()
		local columns = 8
		if not cpu_enabled then
			columns = 5
		end
		local s = col[db.sort]
		local cat = tablet:AddCategory(
			'columns', columns,
			'text', "Name",
			'text2', "MEM:  Init KiB",
			'text3', "Gain KiB",
			'text4', "Rate KiB/s",
			'text5', "Total KiB",
			'text6', "CPU:  Init ms",
			'text7', "Rate ms/s",
			'text8', "Total ms",
			format("text%sR", s), 0.5, format("text%sG", s), 1, format("text%sB", s), 0
		)
		if cpu_enabled then
			for k,t in pairs(addons) do
				c = altcolor[fmod(k, 2)]
				cat:AddLine(
					'text', ftext(1, t.Name),
					'text2', ftext(2, t.Mem_initial),
					'text3', ftext(2, t.Mem_gained),
					'text4', ftext(2, t.Mem_rate),
					'text5', ftext(4, t.Mem_total),
					'text6', ftext(4, t.CPU_initial),
					'text7', ftext(2, t.CPU_rate),
					'text8', ftext(4, t.CPU_total) 
				)
			end

		else
			for k,t in pairs(addons) do
				c = altcolor[fmod(k, 2)]
				cat:AddLine(
					'text', ftext(1, t.Name),
					'text2', ftext(4, t.Mem_initial),
					'text3', ftext(2, t.Mem_gained),
					'text4', ftext(2, t.Mem_rate),
					'text5', ftext(4, t.Mem_total)
				)
			end
		end
	end
end

do
	local tinsert = table.insert
	local tsort = table.sort
	-- returns matching table or creates a new one
	local function gettable(n)
		local t
		for k,v in ipairs(addons) do
			if v.Name == n then
				t = v
				break
			end
		end
		if not t then
			tinsert(addons, { Name = n })
			t = addons[#addons]
		end
		return t
	end
	-- simple sort function
	local byname = sortkey[1]
	local function lsort(a,b)
		local s = db.sort
		if s == byname or a[s] == b[s] then
			return strlower(a[byname]) < strlower(b[byname])
		else
			return a[s] > b[s]
		end
	end

	local upmem, upcpu = UpdateAddOnMemoryUsage, UpdateAddOnCPUUsage
	local getaddmem, getaddcpu = GetAddOnMemoryUsage, GetAddOnCPUUsage
	local time = GetTime
	local numadds, getaddinfo, isloaded = GetNumAddOns, GetAddOnInfo, IsAddOnLoaded
	function updateUsage()
		upmem()
		if cpu_enabled then
			upcpu()
		end
		local ttime = time()
		for i=1,numadds(),1 do
			if isloaded(i) then
				-- get table for this addon
				local t = gettable(getaddinfo(i))
				
				-- record memory data
				local mem = getaddmem(i)
				t.Mem_total = mem
				-- initial time
				if not t.Mem_initial or mem < t.Mem_initial then
					t.Mem_initial = mem
					t.inittime = ttime
				end
				-- memory gained and rate
				t.Mem_gained = mem - t.Mem_initial
				local dur = ttime - t.inittime
				t.Mem_rate = t.Mem_gained / dur
				-- cpu profiling
				if cpu_enabled then
					local cpu = getaddcpu(i)
					t.CPU_total = cpu
					if not t.CPU_initial or cpu < t.CPU_initial then
						t.CPU_initial = cpu
					end
					t.CPU_rate = (cpu - t.CPU_initial) / dur
				end
			end
		end
		tsort(addons, lsort)
	end
end