-- create the plugin object and configure
TraxieFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceDB-2.0", "AceEvent-2.0")
TraxieFu.version = "2.0." .. string.sub("$Revision: 31433 $", 12, -3)
TraxieFu.date = string.sub("$Date: 2007-03-30 19:09:32 -0400 (Fri, 30 Mar 2007) $", 8, 17)
TraxieFu.clickableTooltip = true
TraxieFu:RegisterDB("TraxieFuDB")
TraxieFu:RegisterDefaults('profile', {
   hideTraxieFrame = true,
   itemCount = 5,
   minQuality = POOR,
})

TraxieFu.quality = {
    ["POOR"] = 0,
    ["COMMON"] = 1,
    ["UNCOMMON"] = 2,
    ["RARE"] = 3,
    ["EPIC"] = 4,
    ["LEGENDARY"] = 5,
    ["ARTIFACT"] = 6,   
}
-- locals for library access
local Tablet = AceLibrary("Tablet-2.0")
--local Crayon = AceLibrary("Crayon-2.0")
--local L = AceLibrary("AceLocale-2.2"):new("FuBar_TraxieFu")

-- define options context menu
TraxieFu.OnMenuRequest = {
	type = "group", args = {
		["settings_count"] = {
			type = "range", 
			name = "Item Count", 
			desc = "Number of items to display",           
			max = 40, 
            min = 0,
            step = 1,
            isPercent = false,
            get = "GetCount",
            set = "SetCount",
            order = 1,
		},
		["settings_hide"] = {
			type = "toggle", 
			name = "Hide Traxie", 
			desc = "Hide Traxie Frame", 
			set = "ToggleTraxieFrame",
			get = function()
			    return (not TraxieFrame:IsVisible())
   			end,
   			map = { [false] = "Visible", [true] = "Hidden" },
   			order = 2,
		},
		["settings_reset"] = {
			type = "execute", 
			name = "Clear Traxie List", 
			desc = "Clear out Traxie's list of looted items", 
			func = "ClearTraxieList",
   			order = 3,
		},
		["settings_quality"] = {
			type = "group", 
			name = "Quality", 
			desc = "Minimum Item Quality to Show", 
			pass = true,
			func = function(key) 
			    TraxieFu:SetTraxieQuality(key)
			end,
			get = function()
			    TraxieFu:GetTraxieQuality()
			end,
			args = {
				POOR = {
					desc = "Set minimum quality to Poor",
					name = "|c999999ffPoor|r",
					type = "execute",
					order = 1,
				},
				COMMON = {
					desc = "Set minimum quality to Common",
					name = "|cffffffffCommon|r",
					type = "execute",
					order = 2,
				},
				UNCOMMON = {
					desc = "Set minimum quality to Uncommon",
					name = "|cff00ff00Uncommon|r",
					type = "execute",
					order = 3,
				},
				RARE = {
					desc = "Set minimum quality to Rare",
					name = "|cff0000ffRare|r",
					type = "execute",
					order = 4,
				},
				EPIC = {
					desc = "Set minimum quality to Epic",
					name = "|cff9900ffEpic|r",
					type = "execute",
					order = 5,
				},
				LEGENDARY = {
					desc = "Set minimum quality to Legendary",
					name = "|cffff9900Legendary|r",
					type = "execute",
					order = 6,
				},
				ARTIFACT = {
					desc = "Set minimum quality to Artifact",
					name = "|cffff0000Artifact|r",
					type = "execute",
					order = 7,
				},
			}, 
			order = 4,
		},
	}
}

function TraxieFu:GetCount() 
    return self.db.profile.itemCount 
end

function TraxieFu:SetCount(count) 
    self.db.profile.itemCount = count 
end

function TraxieFu:ToggleTraxieFrame() 
    Traxie_ToggleDisplay();
end

function TraxieFu:SetTraxieQuality(quality)
    self.db.profile.minQuality = quality
end

function TraxieFu:GetTraxieQuality()
    return self.db.profile.minQuality 
end

function TraxieFu:ClearTraxieList() 
   Traxie_ClearStack()
end

-- registers event callbacks
function TraxieFu:OnEnable()
    --show/hide traxie frame based on settings
    if (self.db.profile.hideTraxieFrame) then
        TraxieFrame:Hide()
    end
	--self:RegisterEvent("UNIT_INVENTORY_CHANGED", "Update");
	self:RegisterEvent("CHAT_MSG_LOOT", "Update")
	self:RegisterEvent("DELETE_ITEM_CONFIRM", "Update")
end

function TraxieFu:OnUpdate()
	self:UpdateTooltip()
end

-- updates FuBar tooltip
function TraxieFu:OnTooltipUpdate()
	if (#traxieItemstack > 0) then
        local cat = Tablet:AddCategory(
            'columns', 2
        )
    
		for i=1,self.db.profile.itemCount do
			if (#traxieItemstack >= i) then
				local itemName, itemRarity, invTexture, itemLink, quantity, itemStackCount = TRAXIE_GetInfoForItemFromStack(i)
				local color = ITEM_QUALITY_COLORS[itemRarity]
			
			    if (itemRarity >= TraxieFu.quality[self.db.profile.minQuality]) then
                   cat:AddLine(
                       'text', itemName,
                       'textR', color.r,
                       'textG', color.g,
                       'textB', color.b,
                       'text2', quantity,
                       'text2R', 1,
                       'text2G', 1,
                       'text2B', 1
                   )
                end
			end
		end
	end

    Tablet:SetHint("Clicking is not supported yet")
end
