TransporterFu = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceDB-2.0", "AceHook-2.1", "AceEvent-2.0", "AceDebug-2.0", "FuBarPlugin-2.0")

local L = AceLibrary("AceLocale-2.2"):new("TransporterFu")
local tablet = AceLibrary("Tablet-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")
local PT = AceLibrary("LibPeriodicTable-3.1")
local abacus = AceLibrary("LibAbacus-3.0")

TransporterFu.version = "2.0." .. string.sub("$Rev: 76209 $", 12, -3)
TransporterFu.date = string.sub("$Date: 2008-06-07 11:46:07 -0400 (Sat, 07 Jun 2008) $", 8, 17)
TransporterFu.hasIcon = true
TransporterFu.canHideText = true
TransporterFu.hasNoColor = true

TransporterFu:RegisterDB("TransporterFuDB", "TransporterFuCharDB")
TransporterFu:RegisterDefaults('profile', {
	showTag = true,
	showCooldown = true,
})

-- Todo: remove .text from the methods' tables, should be able to use the keys into METHODS instead

---------------------------------------------
--       Internal / Local Functions        --
---------------------------------------------
local function pairsByKeys(t)
--taken from an example in the Programming in Lua book
	local a = {}
	for n in pairs(t) do
		table.insert(a, n)
	end
	-- sort table alphabetically, but with spells first and items second
	table.sort(a, function(x, y)
		if t[x].spellid and t[y].itemid then
			return true
		elseif t[x].itemid and t[y].spellid then
			return false
		else
			return x < y
		end
	end)
	
	local i = 0      -- iterator variable
	local iter = function ()   -- iterator function
		i = i + 1
		if a[i] == nil then
			return nil
		else
			return a[i], t[a[i]]
		end
	end
	return iter
end

local function findSpell(spellname)
	for i = 1,180 do
		local s = GetSpellName(i, BOOKTYPE_SPELL)
		if s == spellname then
			return i
		end
	end
end

---------------------------------------------
--             Addon Functions             --
---------------------------------------------

function TransporterFu:OnInitialize()
	
	local transportSpells = {
		SHAMAN = {556},  --Astral Recall
		DRUID = {18960}, --TP:Moonglade
		PALADIN = {
			Alliance = {
				13819, --Summon Warhorse
				23214  --Summon Charger
			},
			Horde = {
				34769, --Summon Warhorse
				34767  --Summon Charger
			}
		},
		WARLOCK = {
				5784, --Summon Felsteed 
				23161 --Summon Dreadsteed
		},
		MAGE = {
			Alliance = {
				3561,  --TP:Stormwind
				3562,  --TP:Ironforge
				3565,  --TP:Darnassus
				32271, --TP:Exodar
				49359, --TP:Theramore
				33690, --TP:Shattrath
				10059, --P:Stormwind
				11416, --P:Ironforge
				11419, --P:Darnassus
				32266, --P:Exodar
				49360, --P:Theramore
				33691  --P:Shattrath
			},
			Horde = {
				3563,  --TP:Undercity
				3566,  --TP:Thunder Bluff
				3567,  --TP:Orgrimmar
				32272, --TP:Silvermoon
				49358, --TP:Stonard
				35715, --TP:Shattrath
				11418, --P:Undercity
				11420, --P:Thunder Bluff
				11417, --P:Orgrimmar
				32267, --P:Silvermoon
				49361, --P:Stonard
				35717  --P:Shattrath
			}
		}
	}
	
	_, self.Class = UnitClass("player")
	if transportSpells[self.Class] then
		
		if self.Class == "MAGE" or self.Class == "PALADIN" then
			self.ClassSpells = transportSpells[self.Class][UnitFactionGroup("player")]
		else
			self.ClassSpells = transportSpells[self.Class]
		end
		
	end
	transportSpells = nil
	
	if PT then
		self:Debug(L["PeriodicTable found, items will be supported."])
		
		-- PT3 doesn't seem to have the old PT1 transporter item sets, so we're using some locally created ones
		PT:AddData("TransporterFu.Items", "6948,18150,18149,35230")
		PT:AddData("TransporterFu.Equips", "18984,18986,17690,17905,17906,17907,17908,17909,17691,17900,17901,17902,17903,17904,30542,30544,28585,32757")
		
		self.ItemsToCheck = {"Misc.Mount.Normal", "Misc.Mount.Flying", "Misc.Mount.Ahn'Qiraj", "TransporterFu.Items", "TransporterFu.Equips"}
	else
		self:Print(L["PeriodicTable not found, Item support not enabled."])
	end
end

function TransporterFu:OnEnable()
	self.METHODS = {}
	self.SET1 = {}
	self.NeedsUpdate = {}
	self:RegisterEvent("PLAYER_ENTERING_WORLD", "UpdateInfo")
	self:RegisterEvent("PLAYER_LEAVING_WORLD", "UpdateInfo")
	self:RegisterEvent("ZONE_CHANGED_NEW_AREA", "UpdateInfo")
	self:RegisterEvent("BAG_UPDATE", "UpdateItems")
	self:RegisterEvent("UNIT_INVENTORY_CHANGED", "UpdateEquipped")
	self:UpdateSpells()
	self:UpdateBind()
	self:RegisterEvent("CHAT_MSG_SYSTEM")
	self:RegisterEvent("SPELLS_CHANGED")
	self:UpdateInfo()
	self:ScheduleRepeatingEvent(self.RunTasks, 1, self)
	
end

function TransporterFu:OnDisable()
	self.METHODS, self.SET1, self.NeedsUpdate = nil, nil, nil
end

function TransporterFu:UpdateInfo()
	self:Debug("Player Changing Zones")
	if PT then
		self:UpdateItems()
		self:UpdateEquipped()
	end
	self:UpdateCooldowns()
	self.NeedsUpdate.SetDisplay = self.SetDisplay
end

function TransporterFu:CHAT_MSG_SYSTEM()
	self:Debug("Scheduling bind update")
	self.NeedsUpdate.UpdateBind = self.UpdateBind
end

function TransporterFu:SPELLS_CHANGED()
	self:Debug("Scheduling spell update")
	self.NeedsUpdate.UpdateSpells = self.UpdateSpells
end

function TransporterFu:OnMenuRequest(level,value)
	if level == 1 then
		for k,v in pairsByKeys(self.METHODS) do
			if v.secure then
				dewdrop:AddLine(
					'text', v.text,
					'secure', v.secure,
					'func', function() self:SetDisplay(k) end,
					'disabled', not v.cooldown,
					'closeWhenClicked', true
				)
			end
		end
		dewdrop:AddLine()
		dewdrop:AddLine(
			'text', L["Show Description"],
			'arg1', self,
			'func', function() self:ToggleOption("showTag", true) end,
			'checked', self.db.profile.showTag
		)
		dewdrop:AddLine(
			'text', L["Show Cooldown"],
			'arg1', self,
			'func', function() self:ToggleOption("showCooldown", true) end,
			'checked', self.db.profile.showCooldown
		)
		dewdrop:AddLine()
		dewdrop:AddLine(
			'text', L["Manual Update"],
			'arg1', self,
			'func', function()
				self.METHODS = nil
				self.METHODS = {}
				if PT then
					self:UpdateItems()
					self:UpdateEquipped()
				end
				self:UpdateSpells()
				self:UpdateBind()
				self:SetDisplay()
				self:UpdateCooldowns()
				self:Update()
			end,
			'closeWhenClicked', true
		)
	end
end

function TransporterFu:UpdateText()
	self:Debug("Updating Text")
	local method = self.db.char.SET
	if method and self.METHODS[method] then
		local t = {}
		
		if self.db.profile.showTag then
			if method == "item6948" or method == "556" then
				table.insert(t,self.BLOC)
			else
				table.insert(t, self.METHODS[method].text)
			end
		end
		
		if self.db.profile.showCooldown then
			if not self.METHODS[method].cooldown then
				local cd = self:GetCooldown(method)
				table.insert(t,cd)
			end
		end
		
		self:SetText(table.concat(t, " "))
	else
		self:SetText(L["N/A"])
	end
end

function TransporterFu:OnTooltipUpdate()
	self:Debug("Updating Tooltip")
	local cat = tablet:AddCategory(
		'columns', 2,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 0,
		'child_text2R', 1,
		'child_text2G', 1,
		'child_text2B', 1
	)
	local bloc = self.BLOC
	if bloc then
		cat:AddLine('text', L["Inn: "], 'text2', bloc)
	end
	local cat = tablet:AddCategory(
		'columns', 2,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 0,
		'child_text2R', 0,
		'child_text2G', 1,
		'child_text2B', 0
	)
	for k,v in pairsByKeys(self.METHODS) do
		if v.cooldown then
			cat:AddLine('text', v.text, 'text2', L["Ready"])
		else
			cat:AddLine('text', v.text, 'text2', self:GetCooldown(k))
		end
	end
end

function TransporterFu:RunTasks()
	for k,v in pairs(self.NeedsUpdate) do
		self:Debug(string.format("Executing scheduled function: %s", k))
		v(self)
		self.NeedsUpdate[k] = nil
	end
	if self.db.char.SET and self.METHODS[self.db.char.SET] then
		if not self.METHODS[self.db.char.SET].cooldown and self.db.profile.showCooldown then
			self:UpdateDisplay()
		end
	end
end

function TransporterFu:GetLinkInfo(link, PTSets)
	if type(link) == "string" then
		local _, _, itemid, desc = string.find(link, "item:(%d+).+|h%[(.+)%]|h")
		if itemid and desc then
			
			if PTSets then
				if type(PTSets) == "string" then
				
					local _, itemset = PT:ItemInSet(itemid, PTSets)
					if itemset then
						return itemid, desc, itemset
					end
					
				elseif type(PTSets) == "table" then
				
					for _,v in pairs(PTSets) do
						local _, itemset = PT:ItemInSet(itemid, v)
						if itemset then
							return itemid, desc, itemset
						end
					end
					
				end
				
			else
				return itemid, desc
			end
			
		end
	end
end

function TransporterFu:ParseItem(b, s, link)
	if PT and link and b and s then
		local itemid, desc, itemset = self:GetLinkInfo(link, self.ItemsToCheck)
		if itemid and desc and itemset then
			
			self.METHODS[desc] = {
				itemid = itemid,
				text = desc,
				bag = b,
				slot = s,
				secure = {
					type = 'item',
					item = desc,
				}
			}
			_, self.METHODS[desc].cooldown = self:GetCooldown(desc)
			
		end
	end
end

function TransporterFu:UpdateItems()
	self:Debug("Updating Items")
	if PT then
		for b = 0, NUM_BAG_FRAMES do
			local SLOTS = GetContainerNumSlots(b)
			if SLOTS > 0 then
				for s = 1, SLOTS do
					self:ParseItem(b, s, GetContainerItemLink(b, s))
				end
			end
		end
	else
		self:Debug("No PT!")
	end
end

function TransporterFu:ParseEquipped(s, link)
	if PT and s and link then
		local itemid, desc, itemset = self:GetLinkInfo(link, "TransporterFu.Equips")
		if itemid and desc and itemset then
			
			self.METHODS[desc] = {
				itemid = itemid,
				text = desc,
				slot = s,
				secure = {
					type = 'item',
					item = desc,
				}
			}
			_, self.METHODS[desc].cooldown = self:GetCooldown(desc)
			
		end
	end
end

function TransporterFu:UpdateEquipped()
	self:Debug("Updating Equipped")
	if PT then
		for s = 0, 19 do
			self:ParseEquipped(s, GetInventoryItemLink("player", s))
		end
	else
		self:Debug("No PT!")
	end
end

function TransporterFu:UpdateSpells()
	self:Debug("Updating Spells")
	if self.ClassSpells then
		for _,unTransSpell in ipairs(self.ClassSpells) do
			
			local spell = GetSpellInfo(unTransSpell)
			local spellid = findSpell(spell)
			
			if spellid then	
				self.METHODS[spell] = {
					spellid = spellid,
					text = spell,
					secure = {
						type = 'spell',
						spell = spell,
					}
				}
				_, self.METHODS[spell].cooldown = self:GetCooldown(spell)
			end
		end
	end
end

function TransporterFu:SetDisplay(method)
	local default = "Interface\\Icons\\INV_Misc_Rune_01"
	self:Debug("Setting Display")
	self.SET1 = nil
	self.SET1 = {}
	if method then
		self.db.char.SET = method
	else
		method = self.db.char.SET
		if not method then
			self:SetIcon(default)
			self:UpdateDisplay()
			return
		end
	end
	self.SET1[method] = true
	if self.METHODS[method] then
		
		local mtable = self.METHODS[method]
		
		if mtable.itemid then
			local _, _, _, _, _, _, _, _, _, itemTexture = GetItemInfo(mtable.itemid)
			
			if itemTexture then
				self:SetIcon(itemTexture)
			else
				self:SetIcon(default)
			end
		else
			self:SetIcon(GetSpellTexture(mtable.spellid, BOOKTYPE_SPELL))
		end
	else
		self:SetIcon(default)
	end
	self:UpdateDisplay()
end

function TransporterFu:GetCooldown(method)
	local t, d, cat
	
	local I = self.METHODS[method]
	if I.itemid then
		if I.bag and I.slot then
			cat = "UpdateItems"
			t, d = GetContainerItemCooldown(I.bag, I.slot)
		elseif I.slot then
			cat = "UpdateEquipped"
			t, d = GetInventoryItemCooldown("player", I.slot)
		end
	elseif I.spellid then
		cat = "UpdateSpells"
		t, d = GetSpellCooldown(I.spellid, BOOKTYPE_SPELL)
	end

	if t and d then
		local cd = d - (GetTime() - t - 60)
		if cd < 1 then
			return "|cff00ff00"..tostring(L["Ready"]).."|r", true
		elseif (cd < 60) then
			return abacus:FormatDurationFull(cd, TRUE, FALSE), false
		else
			return abacus:FormatDurationFull(cd, TRUE, TRUE), false
		end
	else
		self.NeedsUpdate[cat] = self[cat]
		return "|cffff0000"..tostring(L["N/A"]).."|r", FALSE
	end
end

function TransporterFu:UpdateBind()
	self:Debug("Updating bind location")
	local bloc = GetBindLocation()
	if bloc then
		self.BLOC = bloc
	else
		self.NeedsUpdate.UpdateBind = self.UpdateBind
	end
end

function TransporterFu:UpdateCooldowns()
	self:Debug("Updating cooldowns")
	for k,v in pairs(self.METHODS) do
		_, v.cooldown = self:GetCooldown(k)
	end
end

function TransporterFu:ToggleOption(var, doUpdate)
	self.db.profile[var] = not self.db.profile[var]
	if doUpdate then
		self:Update()
	end
	return self.db.profile[var]
end
