local BC = AceLibrary("Babble-Class-2.2")
local BT = AceLibrary("Babble-Tradeskill-2.2")
local L = AceLibrary("AceLocale-2.2"):new("TrainerFu-MapNotes")

L:RegisterTranslations("enUS", function() return {
	["MapNotes"] = true,
	["MapNote options. (Requires Cartographer)"] = true,
	["Enable trainer mapnotes"] = true,
	["Enable autofilter"] = true,
	["Add a mapnote to show where your trainers are"] = true,
	["Filter"] = true,
	["Filter out trainers"] = true,
	["Select all"] = true,
	["Select none"] = true,
	["Auto select"] = true,
	["Automaticly select notes by depending on class and professions"] = true,
	["Icon alpha"] = true,
	["Alpha transparency of the icon"] = true,
	["Icon size"] = true,
	["Size of the icons on the map"] = true,
	["Show minimap icons"] = true,
	["Show mining icons on the minimap"] = true,
	["Upgrade Notes"] = true,
	["Try to upgrade all old/questionmark notes"] = true,

	["Poison"] = true,
	["Misc"] = true,
	["Demon"] = true,
	["Pet"] = true,
	["Portal Trainer"] = true,
	["Riding"] = true,
	["Weapon Master"] = true,
	["Stable Master"] = true,
	["Trainer"] = true,
	["Journeyman"] = true,
	["Expert"] = true,
	["Artisan"] = true,
	["Master"] = true,
	["Professions"] = true,
	["Secondary Skills"] = true,
} end)

L:RegisterTranslations("zhTW", function() return {
	["MapNotes"] = "地圖標記",
	["MapNote options. (Requires Cartographer)"] = "地圖標記選項(需要 Cartographer)",
	["Enable trainer mapnotes"] = "啟用導師標記",
	["Enable autofilter"] = "啟用自動篩選",
	["Add a mapnote to show where your trainers are"] = "在地圖標記上增加導師位置",
	["Filter"] = "篩選",
	["Filter out trainers"] = "篩選導師",
	["Select all"] = "全選",
	["Select none"] = "不選",
	["Auto select"] = "自動選取",
	["Automaticly select notes by depending on class and professions"] = "以職業及專業技能自動選取",
	["Icon alpha"] = "圖示透明度",
	["Alpha transparency of the icon"] = "設定圖示的透明度",
	["Icon size"] = "圖示大小",
	["Size of the icons on the map"] = "圖示在地圖上顯示的大小",
	["Show minimap icons"] = "顯示小地圖圖示",
	["Show mining icons on the minimap"] = "在小地圖顯示礦點",
	["Upgrade Notes"] = "更新標記",
	["Try to upgrade all old/questionmark notes"] = "更新過時及問號標記",

	["Poison"] = "毒藥",
	["Misc"] = "其它",
	["Demon"] = "惡魔",
	["Pet"] = "寵物",
	["Portal Trainer"] = "傳送門導師",
	["Riding"] = "飛騎管理員",
	["Weapon Master"] = "武器大師",
	["Stable Master"] = "獸欄管理員",
	["Trainer"] = "導師",
	["Journeyman"] = "初級",
	["Expert"] = "高級",
	["Artisan"] = "專業",
	["Master"] = "大師",
	["Professions"] = "專業技能",
	["Secondary Skills"] = "第二技能",
} end)

L:RegisterTranslations("deDE", function() return {
	["MapNotes"] = "MapNotes",
	["MapNote options. (Requires Cartographer)"] = "MapNote-Optionen. (ben\195\182tigt Cartographer)",
	["Enable trainer mapnotes"] = "Kartennotizen f\195\188r Lehrer aktivieren",
	["Enable autofilter"] = "Automatische Filterung aktivieren",
	["Add a mapnote to show where your trainers are"] = "F\195\188gt eine Notiz auf der Karte hinzu, um die Standorte der Lehrer anzuzeigen",
	["Filter"] = "Filter",
	["Filter out trainers"] = "Lehrer herausfiltern",
	["Select all"] = "Alle ausw\195\164hlen",
	["Select none"] = "Keinen ausw\195\164hlen",
	["Auto select"] = "Automatisch ausw\195\164hlen",
	["Automaticly select notes by depending on class and professions"] = "W\195\164hlt automatisch die Notizen aus, abh\195\164ngig von Klasse und Berufen",
	["Icon alpha"] = "Icon-Transparenz",
	["Alpha transparency of the icon"] = "Alpha-Tranparenz des Icons",
	["Icon size"] = "Icon-Gr\195\182\195\159e",
	["Size of the icons on the map"] = "Gr\195\182\195\159e des Icons auf der Karte",
	["Show minimap icons"] = "Minimap-Icon anzeigen",
	["Show mining icons on the minimap"] = "Zeigt Bergbau-Icons auf der Minimap",

	--["Portal"] = "Portal",
	["Pet"] = "Haustier",
	["Misc"] = "Sonstiges",
	["Demon"] = "D\195\164mon",
	["Poison"] = "Gifte",
	["Riding"] = "Reiten",
	["Weapon Master"] = "Waffenmeister",
	["Stable Master"] = "Stallmeister",
	["Trainer"] = "Lehrer",
	["Journeyman"] = "Geselle",
	["Expert"] = "Experte",
	["Artisan"] = "Fachmann",
	["Master"] = "Meister",
	["Professions"] = "Berufe",
	["Secondary Skills"] = "Sekund\195\164re Fertigkeiten",
} end)

L:RegisterTranslations("frFR", function() return {
	["MapNotes"] = "MapNotes",
	["MapNote options. (Requires Cartographer)"] = "Options MapNote. (n\195\169cessite Cartographer)",
	["Enable trainer mapnotes"] = "Activer les notes pour les ma\195\174tres",
	["Enable autofilter"] = "Activer le filtre automatique",
	["Add a mapnote to show where your trainers are"] = "Ajouter une note pour indiquer o?se situent vos ma\195\174tres",
	["Filter"] = "Filtre",
	["Filter out trainers"] = "Filtrer les ma\195\174tres",
	["Select all"] = "Selectionner tout",
	["Select none"] = "Selectionner aucun",
	["Auto select"] = "Selection automatique",
	["Automaticly select notes by depending on class and professions"] = "Selectionne automatiquement les notes en fonction de la classe et des professions",
	["Icon alpha"] = "Transparence",
	["Alpha transparency of the icon"] = "Transparence pour l'icone",
	["Icon size"] = "Taille de l'icone",
	["Size of the icons on the map"] = "Tailles des icones sur la carte",
	["Show minimap icons"] = "Affiche les icones sur la minimap",
	["Show mining icons on the minimap"] = "Afficher les icones de minage sur la minimap",

	--["Portal"] = "Portal",
	["Pet"] = "Familier",
	["Misc"] = "Divers",
	["Demon"] = "D\195\169mon",
	["Poison"] = "Poison",
	["Riding"] = "Monte",
	["Weapon Master"] = "Ma\195\174tre d'arme",
	["Stable Master"] = "Ma\195\174tre des \195\169curies",
	["Trainer"] = "Ma\195\174tre",
	["Journeyman"] = "Compagnon",
	["Expert"] = "Expert",
	["Artisan"] = "Artisan",
	["Master"] = "Ma\195\174tre",
	["Professions"] = "M\195\169tiers",
	["Secondary Skills"] = "Comp\195\169tences secondaires",
} end)

L:RegisterTranslations("esES", function() return {
	["MapNotes"] = "Notas en el Mapa",
	["MapNote options. (Requires Cartographer)"] = "Opciones de Notas en el Mapa. (Requiere Cartographer)",
	["Enable trainer mapnotes"] = "Activar notas en el mapa de entrenadores",
	["Enable autofilter"] = "Activar filtro autom\195\161tico",
	["Add a mapnote to show where your trainers are"] = "A\195\177adir nota en mapa que muestre donde est\195\161n los entrenadores",
	["Filter"] = "Filtrar",
	["Filter out trainers"] = "Quitar filtros de entrenadores",
	["Select all"] = "Seleccionar todos",
	["Select none"] = "Seleccionar ninguno",
	["Auto select"] = "Seleccionar autom\195\161ticamente",
	["Automaticly select notes by depending on class and professions"] = "Seleccionar notas autom\195\161ticamente dependiendo de la clase y la profesi\195\179n",
	["Icon alpha"] = "Alfa del icono",
	["Alpha transparency of the icon"] = "Transparencia alfa del icono",
	["Icon size"] = "Tama\195\177o del icono",
	["Size of the icons on the map"] = "Tama\195\177o de los iconos en el mapa",
	["Show minimap icons"] = "Mostrar iconos en el minimapa",
	["Show mining icons on the minimap"] = "Mostrar iconos de mineria en el minimapa",
	["Upgrade Notes"] = "Actualizar Notas",
	["Try to upgrade all old/questionmark notes"] = "Intenta actualizar todas las notas/marcas de pregunta viejas",

	["Poison"] = "Veneno",
	["Misc"] = "Miscelanea",
	["Demon"] = "Demonio",
	["Pet"] = "Mascota",
	["Portal Trainer"] = "Entrenador de Portal",
	["Riding"] = "Equitaci\195\179n",
	["Weapon Master"] = "Maestro de Armas",
	["Stable Master"] = "Maestro de Establos",
	["Trainer"] = "Entrenador",
	["Journeyman"] = "Oficial",
	["Expert"] = "Experto",
	["Artisan"] = "Artesano",
	["Master"] = "Maestro",
	["Professions"] = "Profesiones",
	["Secondary Skills"] = "Habilidades Secundarias",
} end)

TrainerFu_TrainerNotes = TrainerFu:NewModule("MapNotes", "AceEvent-2.0", "AceConsole-2.0")

TrainerFu_TrainerNotes.icon = {
	["Alchemy"] = {
        text = BT["Alchemy"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Alchemy",
    },
    ["Blacksmithing"] = {
        text = BT["Blacksmithing"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Blacksmithing",
    },
	["Poison"] = {
        text = L["Poison"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Poison",
    },
	["Cooking"] = {
        text = BT["Cooking"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Cooking",
    },
    ["Misc"] = {
        text = L["Misc"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Misc",
    },
    ["Demon"] = {
        text = L["Demon"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Demon",
    },
	["Druid"] = {
        text = BC["Druid"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Druid",
    },
	["Enchanting"] = {
        text = BT["Enchanting"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Enchanting",
    },
	["Engineering"] = {
        text = BT["Engineering"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Engineering",
    },
	["First Aid"] = {
        text = BT["First Aid"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Firstaid",
    },
	["Fishing"] = {
        text = BT["Fishing"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Fishing",
    },
	["Herbalism"] = {
        text = BT["Herbalism"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Herbalism",
    },
	["Hunter"] = {
        text = BC["Hunter"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Hunter",
    },
	["Jewelcrafting"] = {
        text = BT["Jewelcrafting"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Jewelcrafting",
    },
	["Leatherworking"] = {
        text = BT["Leatherworking"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Leatherworking",
    },
	["Mage"] = {
        text = BC["Mage"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Mage",
    },
	["Mining"] = {
        text = BT["Mining"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Mining",
    },
	["Paladin"] = {
        text = BC["Paladin"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Paladin",
    },
	["Pet"] = {
        text = L["Pet"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Pet",
    },
	["Priest"] = {
        text = BC["Priest"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Priest",
    },
	["Portal Trainer"] = {
        text = L["Portal Trainer"],
        path = "Interface\\Icons\\Spell_Arcane_PortalIronForge",
    },
	["Rogue"] = {
        text = BC["Rogue"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Rogue",
    },
	["Shaman"] = {
        text = BC["Shaman"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Shaman",
    },
	["Skinning"] = {
        text = BT["Skinning"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Skinning",
    },
	["Tailoring"] = {
        text = BT["Tailoring"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Tailoring",
    },
	["Warlock"] = {
        text = BC["Warlock"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Warlock",
    },
	["Warrior"] = {
        text = BC["Warrior"],
        path = "Interface\\AddOns\\FuBar_TrainerFu\\icons\\Warrior",
    },
	["Weapon Master"] = {
        text = L["Weapon Master"],
        path = "Interface\\Icons\\INV_Sword_12",
    },
}

function TrainerFu_TrainerNotes:OnInitialize()
	if not Cartographer then return end

	self.db = TrainerFu:AcquireDBNamespace("MapNotes")

	TrainerFu:RegisterDefaults("MapNotes", "account", {
		TrainerNotes = {}
    })

	TrainerFu:RegisterDefaults("MapNotes", "profile", {
		autoFilterIcons = true,
		iconAlpha = 1,
		iconScale = 1,
		minicons = true,
	})

	TrainerFu:RegisterDefaults("MapNotes", "char", {
		filter = {
			['*'] = true,
		},
	})

	for _,icon in pairs(self.icon) do
		icon.width = 14
		icon.height = 14
	end

	local filter = {
		name = L["Filter"],
		desc = L["Filter out trainers"],
		type = 'group',
		args = {
			all = {
				name = L["Select all"],
				desc = L["Select all"],
				type = 'execute',
				func = function()
					for k in pairs(self.icon) do
						self:ToggleShowingTrainer(k, true)
					end
				end,
				order = 1,
			},
			none = {
				name = L["Select none"],
				desc = L["Select none"],
				type = 'execute',
				func = function()
					for k in pairs(self.icon) do
						self:ToggleShowingTrainer(k, false)
					end
				end,
				order = 2,
			},
			auto = {
				name = L["Auto select"],
				desc = L["Automaticly select notes by depending on class and professions"],
				type = 'execute',
				func = function() self:AutoNoteFilter() end,
				order = 3,
			},
			blank = {
				type = 'header',
				order = 4,
			}
		}
	}

	for k,v in pairs(self.icon) do
		local k = k
		filter.args[string.gsub(k, "%s", "-")] = {
			name = v.text,
			desc = v.text,
			type = 'toggle',
			get = function()
				return self:IsShowingTrainer(k)
			end,
			set = function(value)
				return self:ToggleShowingTrainer(k, value)
			end,
		}
	end

	local options = {
		type = 'group',
		name = L["MapNotes"],
		desc = L["MapNote options. (Requires Cartographer)"],
		disabled = function() return not Cartographer_Notes end,
		handler = self,
		args = {
			filter = filter,
			addmapnote = {
				type = 'toggle',
				name = L["Enable trainer mapnotes"],
				desc = L["Add a mapnote to show where your trainers are"],
				get = function() return TrainerFu:IsModuleActive(self) end,
				set = function() TrainerFu:ToggleModuleActive(self) end,
				order = 10,
			},
			minicons = {
				name = L["Show minimap icons"],
				desc = L["Show mining icons on the minimap"],
				type = 'toggle',
				set = "ToggleShowingMinimapIcons",
				get = "IsShowingMinimapIcons",
				order = 20,
			},
			autofilter = {
				type = 'toggle',
				name = L["Enable autofilter"],
				desc = L["Automaticly select notes by depending on class and professions"],
				get = function() return self.db.profile.autoFilterIcons end,
				set = function() self.db.profile.autoFilterIcons = not self.db.profile.autoFilterIcons
				end,
				order = 30,
			},
			trans = {
				name = L["Icon alpha"],
				desc = L["Alpha transparency of the icon"],
				type = 'range',
				min = 0.1,
				max = 1,
				step = 0.05,
				isPercent = true,
				get = "GetIconAlpha",
				set = "SetIconAlpha",
				order = 40
			},
			scal = {
				name = L["Icon size"],
				desc = L["Size of the icons on the map"],
				type = 'range',
				min = 0.5,
				max = 2,
				step = 0.05,
				isPercent = true,
				get = "GetIconScale",
				set = "SetIconScale",
				order = 50
			},
			upgradenotes = {
			    type = 'execute',
			    name = L["Upgrade Notes"],
				desc = L["Try to upgrade all old/questionmark notes"],
			    func = "UpgradeDatabase"
			}
		}
	}

	TrainerFu.OnMenuRequest.args["MapNotes"] = options

	if Cartographer then
		Cartographer.options.args["TrainerFu"] = {
			name = "TrainerFu",
			desc = "TrainerFu",
			type = 'group',
			args = options.args,
			handler = self,
		}
	end
end

function TrainerFu_TrainerNotes:OnEnable()
	if Cartographer_Notes then
        if not self.iconsregistered then
			for k,v in pairs(self.icon) do
                Cartographer_Notes:RegisterIcon(k, v)
            end
            self.iconsregistered = true
        end

        Cartographer_Notes:RegisterNotesDatabase("TrainerFu", self.db.account.TrainerNotes, self)

		self:RegisterEvent("TrainerFu_VisitingTrainer", "AddTrainerMapNote")

		if self.db.profile.autoFilterIcons then
			self:ScheduleEvent(self.AutoNoteFilter, 5, self)
		end
	end
end

function TrainerFu_TrainerNotes:OnDisable()
	self:Print("trainernotes unload")
	self:UnregisterAllEvents()
    if Cartographer_Notes then
        Cartographer_Notes:UnregisterNotesDatabase("TrainerFu")
    end
end

local newNoteNames = {
	["Alchemist"] = "Alchemy",
	["Blacksmith"] = "Blacksmithing",
	["Enchanter"] = "Enchanting",
	["Engineer"] = "Engineering",
	["Jewelcrafter"] = "Jewelcrafting",
	["Leatherworker"] = "Leatherworking",
	["Tailor"] = "Tailoring",
}

function TrainerFu_TrainerNotes:UpgradeDatabase()
	self:Print("Attempt to update/fix mapnotes...")
	for zoneName, zoneData in pairs(self.db.account.TrainerNotes) do
		if zoneData and type(zoneData) == "table" then
			for noteID, noteData in pairs(zoneData) do
				if noteData.icon and newNoteNames[noteData.icon] then
					noteData.icon = newNoteNames[noteData.icon]
					self:Print("Upgrading/fixing note icon " .. noteData.icon)
				end
			end
		end
	end
	self:Print("Done!")
end

function TrainerFu_TrainerNotes:AddTrainerMapNote(trainerType, trainerSubType, trainerName)
	--Get coordinates
	local x, y = GetPlayerMapPosition("player")
	local location = GetRealZoneText() or ""

	if trainerSubType == L["Weapon Master"] or trainerSubType == L["Portal Trainer"] then
		trainerType = trainerSubType
	end

	if BT:HasReverseTranslation(trainerType) then
		trainerType = BT:GetReverseTranslation(trainerType)
	elseif BC:HasReverseTranslation(trainerType) then
		trainerType = BC:GetReverseTranslation(trainerType)
	elseif L:HasReverseTranslation(trainerType) then
		trainerType = L:GetReverseTranslation(trainerType)
	end

	if self.icon[trainerType] and location and x and y then
		for zone, x, y, _, _, data in Cartographer_Notes:IterateNearbyNotes(location, x, y, 10, "TrainerFu", 10, true) do
			if data.info == trainerName then
				Cartographer_Notes:DeleteNote(zone, x, y)
			end
		end

		Cartographer_Notes:SetNote(
			location, x, y, trainerType, "TrainerFu",
			'title',  trainerSubType,
			'titleR', 0,
			'titleG', 1,
			'titleB', 0,
			'info', trainerName,
			'infoR', 1,
			'infoG', 1,
			'infoB', 1
		)
	end
end

function TrainerFu_TrainerNotes:IsNoteHidden(zone, id)
	return not self.db.char.filter[self.db.account.TrainerNotes[zone][id].icon]
end

function TrainerFu_TrainerNotes:IsShowingTrainer(trainer)
	return self.db.char.filter[trainer]
end

function TrainerFu_TrainerNotes:ToggleShowingTrainer(trainer, value)
	if value == nil then
		value = not self.db.char.filter[trainer]
	end
	self.db.char.filter[trainer] = value
		Cartographer_Notes:RefreshMap()
end

function TrainerFu_TrainerNotes:GetIconScale()
	return self.db.profile.iconScale
end
function TrainerFu_TrainerNotes:SetIconScale(value)
	self.db.profile.iconScale = value
	Cartographer_Notes:RefreshMap()
end

function TrainerFu_TrainerNotes:GetIconAlpha()
	return self.db.profile.iconAlpha
end
function TrainerFu_TrainerNotes:SetIconAlpha(value)
	self.db.profile.iconAlpha = value
	Cartographer_Notes:RefreshMap()
end

function TrainerFu_TrainerNotes:GetNoteTransparency(zone,id,data)
	return self.db.profile.iconAlpha
end
function TrainerFu_TrainerNotes:GetNoteScaling(zone,id,data)
	return self.db.profile.iconScale
end
function TrainerFu_TrainerNotes:IsShowingMinimapIcons()
	return self.db.profile.minicons
end
function TrainerFu_TrainerNotes:ToggleShowingMinimapIcons()
	self.db.profile.minicons = not self.db.profile.minicons
end
function TrainerFu_TrainerNotes:IsMiniNoteHidden(zone,id,data)
	return not self.db.profile.minicons
end
function TrainerFu_TrainerNotes:IsTracking(zone,id,data)
	return true
end

function TrainerFu_TrainerNotes:AutoNoteFilter()
	--Select none
	for k in pairs(self.icon) do
		self:ToggleShowingTrainer(k, false)
	end

	local header = nil
	local numSkills = GetNumSkillLines()
	for i=1, numSkills do
		local skillName, isHeader, isExpanded, skillRank, numTempPoints, skillModifier, skillMaxRank,
			isAbandonable, stepCost, rankCost, minLevel, skillCostType, skillDescription = GetSkillLineInfo(i);
		--Only save important skills, omitt unimportant stuff like languages and that you can wear cloth armor
		if isHeader then
			header = skillName
		elseif header and header == L["Professions"] or header == L["Secondary Skills"] then
			self:ToggleShowingTrainer(skillName, true)
		end
	end

	local localizedClass, class = UnitClass("player")
	if class then
		self:ToggleShowingTrainer(localizedClass, true)
		if class == "WARLOCK" then self:ToggleShowingTrainer("Demon", true) end
		if class == "HUNTER" then self:ToggleShowingTrainer("Pet", true) end
		if class == "ROGUE" then self:ToggleShowingTrainer("Poison", true) end
		if class == "MAGE" then self:ToggleShowingTrainer("Portal Trainer", true) end
	end

	--Always show
	self:ToggleShowingTrainer("Misc", true)
	self:ToggleShowingTrainer("Weapon Master", true)
end
