TrainerFu_DemonTrainer = TrainerFu:NewModule("DemonTrainer", "AceEvent-2.0")

local BT = AceLibrary("Babble-Trainer-2.2")
local BC = LibStub("LibBabble-Class-3.0"):GetLookupTable()
local BCT = LibStub("LibBabble-CreatureType-3.0"):GetLookupTable()
local BS = LibStub("LibBabble-Spell-3.0"):GetLookupTable()
local gratuity = AceLibrary("Gratuity-2.0")

local L = AceLibrary("AceLocale-2.2"):new("TrainerFu-DemonTrainer")

L:RegisterTranslations("enUS", function() return {
        --This should be translated into the prefix item name of the demon pet books you buy from demon trainer
        ["Grimoire%sof%s(.*)"] = true,
        ["(Rank%s%d)"] = true,
	["Rank%s(%d)"] = "Rank%s(%d)",
	["Rank "] = true,

        --Text shown in the grimoire item tooltip if its already known
        ["Already known"] = true,
} end)

L:RegisterTranslations("zhTW", function() return {
        --This should be translated into the prefix item name of the demon pet books you buy from demon trainer
        ["Grimoire%sof%s(.*)"] = "]%s%s",
        ["(Rank%s%d)"] = "(Ƨ%s%d)",

        --Text shown in the grimoire item tooltip if its already known
        ["Already known"] = "vgǷ|",
} end)

L:RegisterTranslations("deDE", function() return {
        --This should be translated into the prefix item name of the demon pet books you buy from demon trainer
        ["Grimoire%sof%s(.*)"] = "Zauberfoliant%sde.%s(.*)",
        ["(Rank%s%d)"] = "(Rang%s%d)",

        --Text shown in the grimoire item tooltip if its already known
        ["Already known"] = "Bereits bekannt",
} end)

L:RegisterTranslations("frFR", function() return {
        --This should be translated into the prefix item name of the demon pet books you buy from demon trainer
        ["Grimoire%sof%s(.*)"] = "Grimoire%sd[e]?[%s'](.*)",
        ["(Rank%s%d)"] = "(rang%s%d)",

        --Text shown in the grimoire item tooltip if its already known
        ["Already known"] = "D\195\169j\195\160 connu",
} end)

L:RegisterTranslations("esES", function() return {
        --This should be translated into the prefix item name of the demon pet books you buy from demon trainer
        ["Grimoire%sof%s(.*)"] = "Grimoire%sof%s(.*)",
        ["(Rank%s%d)"] = "(Rank%s%d)",
	["Rank%s(%d)"] = "Rank%s(%d)",
	["Rank "] = "Rango ",

        --Text shown in the grimoire item tooltip if its already known
        ["Already known"] = "Ya conocido",
} end)

function TrainerFu_DemonTrainer:OnInitialize()
        self.db = TrainerFu.db
end

function TrainerFu_DemonTrainer:OnEnable()
        if select(2, UnitClass("player")) == "WARLOCK" then
                self:RegisterEvent("MERCHANT_SHOW", function() self:ScheduleEvent(self.GetDemonTrainerSkills, 2, self) end, 2)
                --Delay this some, may not work well with high latencies
                self:RegisterEvent("PET_BAR_UPDATE", function() self:ScheduleEvent(self.GetKnowndemonSpellRanks, 2, self) end, 2)
        end
end

function TrainerFu_DemonTrainer:GetDemonTrainerSkills()
        TrainerFu.trainerInfo = TrainerFu:GetTrainerInfo()
        local trainerInfo = TrainerFu.trainerInfo

        --Return if its not a Demon Trainer
        if not string.find(trainerInfo.subType, BT["Demon Trainer"]) then return end
        local trainerType = BC["Warlock"]
        trainerInfo.type = trainerType

        local db = self.db.account

        --Trainer information
        db.trainer[trainerType] = db.trainer[trainerType] or {}
        db.trainer[trainerType][trainerInfo.name] = trainerInfo

        db.skill[trainerType] = db.skill[trainerType] or {}
        db.skill[trainerType].skills = db.skill[trainerType].skills or {}
        db.skill[trainerType].header = db.skill[trainerType].header or {}

        local tempHeader = {}

        local errorCount = 0
        for i=1, GetMerchantNumItems() do
                local skillName = nil
                local skillRank = nil
                local skillHeader = nil
                local iconPath = nil
                local skillCost = nil
                local levelRequirement = nil
                local description = nil
                local skillRank = nil

                local name, texture, price, quantity, numAvailable, isUsable, extendedCost = GetMerchantItemInfo(i)

                if not name then
                        errorCount = errorCount + 1
                else
                        --skillName = string.match(name, L["Grimoire%sof%s(.*)"])
                        skillName = string.match(name, L["Grimoire%sof%s(.*)"])
			if string.find(name, L["(Rank%s%d)"]) then
                        	skillName = string.match(skillName, "(.*)%s%(")
                        	skillRank = string.match(name, L["Rank%s(%d)"])
			end
			skillName = BS[skillName]
                        iconPath = self.db.class.demonSpellIcons[skillName] or texture
			if skillRank then
				skillName = skillName.." ("..L["Rank "]..skillRank..")"
			end
                        skillCost = price

                        gratuity:SetMerchantItem(i)
                        local levelString = gratuity:GetLine(5)
                        if levelString then
                                local lvl = string.match(levelString, "%a*(%d+)")
                                levelRequirement = tonumber(lvl)
                        else
                                levelRequirement = 0
                        end

                        local descOrKnown = gratuity:GetLine(6)
                        if descOrKnown == L["Already known"] then
                                self.db.char.knownSpell[skillName] = true
                                description = gratuity:GetLine(7)
                        else
                                description = descOrKnown
                        end

                        skillHeader = BT["Demon Trainer"]
                        tempHeader[skillHeader] = tempHeader[skillHeader] or {}
                        table.insert(tempHeader[skillHeader], skillName)

                        db.skill[trainerType].skills[skillName] = {
                                name = skillName,
                                rank = skillRank,
                                iconPath = iconPath,
                                cost = skillCost,
                                levelRequirement = levelRequirement,
                                description = description,
                        }
                end
        end

        for name,header in pairs(tempHeader) do
                db.skill[trainerType].header[name] = header
        end

        self:TriggerEvent("TrainerFu_UpdateData")
--         if TrainerFu:IsModuleActive("MapNotes") then
--                 TrainerFu_TrainerNotes:AddTrainerMapNote(BCT["Demon"], BT["Demon Trainer"], trainerInfo.name)
--         end

        if errorCount and errorCount > 0 then
                TrainerFu:Print("Demon trainer errors (missed grimoires): " .. errorCount)
        end
end

function TrainerFu_DemonTrainer:GetKnowndemonSpellRanks()
        if not self.db.class.demonSpellRanks then self.db.class.demonSpellRanks = {} end
        if not self.db.class.demonSpellIcons then self.db.class.demonSpellIcons = {} end
        local numSpells, petToken = HasPetSpells()
        if numSpells ~= nil and petToken == "DEMON" then
                for i=1, numSpells do
                        local spellName, spellRank = GetSpellName(i, BOOKTYPE_PET)
                        if spellName and spellRank and spellRank ~= "" then
                                local rank = string.match(spellRank, "%a*(%d+)")
                                rank = tonumber(rank)
                                if type(rank) == "number" then
                                        for i = 1, rank do
                                                self.db.char.knownSpell[spellName .." ("..L["Rank "].. i ..")"] = true
                                        end
                                end
                        elseif spellName then
                                self.db.char.knownSpell[spellName] = true
                        end
                        local spellIcon = GetSpellTexture(i, BOOKTYPE_PET)
                        if spellIcon then
                                self.db.class.demonSpellIcons[spellName] = spellIcon
                        end
                end
        end
        self:TriggerEvent("TrainerFu_UpdateData")
end
