local TrainerFu = TrainerFu

local L = AceLibrary("AceLocale-2.2"):new("FuBar_TrainerFu")
local gratuity = AceLibrary("Gratuity-2.0")
local BT = AceLibrary("Babble-Trainer-2.2")

--Thanks SellFish
local function ToID(link)
	if link then
		return tonumber(link) or tonumber(link:match('item:(%d+)') or tonumber(select(2, GetItemInfo(link)):match('item:(%d+)')))
	end
end

function TrainerFu:TRAINER_SHOW()
	--Get information about trainer
	self.trainerInfo = self:GetTrainerInfo()
end

function TrainerFu:TRAINER_CLOSED()
	--Expand all categories
	ExpandTrainerSkillLine(0);

	--Need to set all skill types visible
	SetTrainerServiceTypeFilter("available", 1);
	SetTrainerServiceTypeFilter("unavailable", 1);
	SetTrainerServiceTypeFilter("used", 1);

	local db = self.db.account

	local trainerType = nil
	--If trainer is a profession trainer
	if IsTradeskillTrainer() then
		--Get type of tradeskill
		trainerType = GetTrainerServiceSkillLine(2)
	else
		trainerType, englishClass = self.class
	end

	if not trainerType then return end
	self.trainerInfo.type = trainerType
	if string.find(self.trainerInfo.subType, L["Lvl %d"]) then
		self.trainerInfo.subType = "Instructor de "..self.trainerInfo.type
	end

	--Trainer information
	local trainerName = self.trainerInfo.name
	self.trainerInfo.name = nil --Don't want to save this
	db.trainer[trainerType] = db.trainer[trainerType] or {}
	db.trainer[trainerType][trainerName] = self.trainerInfo

	db.skill[trainerType] = db.skill[trainerType] or {}
	db.skill[trainerType].skills = db.skill[trainerType].skills or {}
	db.skill[trainerType].header = db.skill[trainerType].header or {}

	local tempHeader = nil

	--Save skill information
	for index = 1, GetNumTrainerServices() do
		local itemLink, skillName, skillHeader, iconPath, skillCost, levelRequirement, description, skillRank, skillRequired, SkillRankRequired, abilityRequirement, knownStatus = self:GetSkillInfo(index)
		if skillName then
			local skillFullName = nil
			if skillRank and string.find(skillRank, L["(Rank%s%d)"]) then
				skillFullName = skillName .." (".. skillRank ..")"
			else
				skillFullName = skillName
			end

			--If babble knows icon path, don't store it
			if self:GetBabbleIcon(skillFullName) then
				iconPath = nil
			end

			if skillHeader then
				if skillHeader == trainerType then
					skillHeader = self.trainerInfo.subType
				end

				--Hax for Portal and weapon trainer
				if string.find(self.trainerInfo.subType, BT["Portal Trainer"]) then
					skillHeader = L["Portal"]
				elseif string.find(self.trainerInfo.subType, BT["Weapon Master"]) then
					skillHeader = self.trainerInfo.subType .. " (" .. self.trainerInfo.location .. ")"
				end

				--Check header and create table if not present
				db.skill[trainerType].header[skillHeader] = db.skill[trainerType].header[skillHeader] or {}

				--Search for spell in header
				function SpellInHeader()
					for _,skill in ipairs(db.skill[trainerType].header[skillHeader]) do
						if skill == skillFullName then
							return true
						end
					end
					return false
				end

				--If spell not in header we insert it
				if not SpellInHeader() then
					table.insert(db.skill[trainerType].header[skillHeader], skillFullName)
				end

				--self:Print(skillHeader)
			end

			if levelRequirement == 0 then
				levelRequirement = nil
			end


			local skillTable = {
				itemLink = ToID(itemLink),
				iconPath = iconPath,
				cost = skillCost,
				levelRequirement = levelRequirement,
				description = description,
				skillRequired = skillRequired,
				skillRankRequired = SkillRankRequired,
				abilityRequirement = abilityRequirement,
			}

			db.skill[trainerType].skills[skillFullName] = db.skill[trainerType].skills[skillFullName] or {}

			for k,l in pairs(skillTable) do
				if l then
					db.skill[trainerType].skills[skillFullName][k] = l
				end
			end

			if knownStatus == "used" then
				self.db.char.knownSpell[skillFullName] = true
			end
		end
	end

	self:TriggerEvent("TrainerFu_UpdateData")
	if self:HasModule("MapNotes") and self:IsModuleActive("MapNotes") then
		TrainerFu_TrainerNotes:AddTrainerMapNote(trainerType, self.trainerInfo.subType, trainerName)
	end
end

function TrainerFu:GetSkillInfo(index)
	local serviceName, serviceSubText, serviceType, isExpanded = GetTrainerServiceInfo(index)

	if not serviceName or not serviceType or serviceType == "header" then
		return
	end

	--ItemLink
	local itemLink = GetTrainerServiceItemLink(index)
	--Skill name
	local skillName = serviceName
	--Skill rank
	local skillRank
	if serviceSubText ~= "" then
		skillRank = serviceSubText
	end
	--Header
	local skillHeader = GetTrainerServiceSkillLine(index)
	--Icon path
	local iconPath = GetTrainerServiceIcon(index)
	--Cost
	local skillCost = GetTrainerServiceCost(index)
	--Level requirement
	local levelRequirement = GetTrainerServiceLevelReq(index)
	--Description
	local description
	if not itemLink then
		description = GetTrainerServiceDescription(index)
	end
	--[[
	if not description then
		--Get info from tooltip if profession
		gratuity:SetTrainerService(index)
		local numLines = gratuity:NumLines()
		if numLines == 3 then
			description = gratuity:GetLine(3)
		elseif numLines > 3 then
			local textTable = gratuity:GetText(1, numLines)
			local lines = {}
			for _,j in ipairs(textTable) do
				table.insert(lines, table.concat(j, "       "))
			end
			description = table.concat(lines, "\n")
		end
	end
	 ]]--
	--Required skillrank
	local skillreq, skillrankreq, hasReq = GetTrainerServiceSkillReq(index);
	local skillRequired
	local SkillRankRequired
	if skillrankreq > 0 then
		skillRequired = skillreq
		SkillRankRequired = skillrankreq
	end

	local numRequirements = GetTrainerServiceNumAbilityReq(index);
	local abilityRequirement
	if numRequirements > 0 then
		local abilityReq, hasAbilityReq = GetTrainerServiceAbilityReq(index, 1)
		abilityRequirement = abilityReq
	end

	return itemLink, skillName, skillHeader, iconPath, skillCost, levelRequirement, description, skillRank, skillRequired, SkillRankRequired, abilityRequirement, serviceType
end


function TrainerFu:GetTrainerInfo()
	--Get coordinates
	local x, y = GetPlayerMapPosition("player")

	--Get trainer name and type
	gratuity:SetUnit("npc")

	local trainer = {}
	trainer.name = gratuity:GetLine(1) or ""
	trainer.subType = gratuity:GetLine(2) or ""
	trainer.location = GetRealZoneText()
	trainer.xcoord = x
	trainer.ycoord = y

	return trainer
end
