local TrainerFu = TrainerFu
local L = AceLibrary("AceLocale-2.2"):new("FuBar_TrainerFu")

function TrainerFu:CreateMenu()
	local spells = {
		type = 'group',
		name = L["Spells"],
		desc = L["What spells to show"],
		args = {
			showSpellAlreadyKnown = {
				order = 11,
				type = 'toggle',
				name = L["Already trained"],
				desc = L["Show the skills you have already trained"],
				get = function() return self.db.profile.showSpellAlreadyKnown end,
				set = function() self.db.profile.showSpellAlreadyKnown = not self.db.profile.showSpellAlreadyKnown end,
			},
			showSpellTrainable = {
				order = 12,
				type = 'toggle',
				name = L["Trainable now"],
				desc = L["Show the skills you can train now"],
				get = function() return self.db.profile.showSpellTrainable end,
				set = function() self.db.profile.showSpellTrainable = not self.db.profile.showSpellTrainable end,
			},
			showSpellTrainableNext = {
				order = 13,
				type = 'toggle',
				name = L["Trainable next"],
				desc = L["Show the skills you can train when you hit the next goal"],
				get = function() return self.db.profile.showSpellTrainableNext end,
				set = function() self.db.profile.showSpellTrainableNext = not self.db.profile.showSpellTrainableNext end,
			},
			showSpellNotTrainable = {
				order = 14,
				type = 'toggle',
				name = L["Not Trainable yet"],
				desc = L["Show the skills you can not train yet"],
				get = function() return self.db.profile.showSpellNotTrainable end,
				set = function() self.db.profile.showSpellNotTrainable = not self.db.profile.showSpellNotTrainable end,
			},
		}
	}
	
	local tooltip = {
		type = 'group',
		name = L["Tooltip"],
		desc = L["What info is to be shown in the tooltip"],
		args = {		
			showSkillCost = {
				order = 31,
				type = 'toggle',
				name = L["Skill training cost"],
				desc = L["Show how much training a skill cost"],
				get = function() return self.db.profile.showSkillCost end,
				set = function() self.db.profile.showSkillCost = not self.db.profile.showSkillCost end,
			},
			showSpellRequirement = {
				order = 32,
				type = 'toggle',
				name = L["Skill level requirement"],
				desc = L["Show required level to train skill"],
				get = function() return self.db.profile.showSpellRequirement end,
				set = function() self.db.profile.showSpellRequirement = not self.db.profile.showSpellRequirement end,
			},
			showTrainerNames = {
				order = 33,
				type = 'toggle',
				name = L["Trainers name and location"],
				desc = L["Show all known trainers and their location"],
				get = function() return self.db.profile.showtrainernames end,
				set = function() self.db.profile.showtrainernames = not self.db.profile.showtrainernames end,
			},
		}
	}
	
	local fubar = {
		type = 'group',
		name = L["FuBar panel"],
		desc = L["What info is to be shown on FuBar"],
		args = {	
			showFubarTrainableQuests = {
				order = 41,
				type = 'toggle',
				name = L["Show trainable skills"],
				desc = L["Show number of trainable skills in FuBar."],
				get = function() return self.db.profile.showFubarTrainableSkills end,
				set = function() self.db.profile.showFubarTrainableSkills = not self.db.profile.showFubarTrainableSkills self:Update() end,
			},
			showFubarTrainingCost = {
				order = 42,
				type = 'toggle',
				name = L["Show training cost"],
				desc = L["Show total training cost in FuBar."],
				get = function() return self.db.profile.showFubarTrainingCost end,
				set = function() self.db.profile.showFubarTrainingCost = not self.db.profile.showFubarTrainingCost self:Update() end,
			},
		}
	}
	
	local config = {
		type = 'group',
		args = {
			spells = spells,
			tooltip = tooltip,
			fubar = fubar,
			
			cleanKnownData = {
				order = 10,
				type = 'execute',
				name = L["Wipe known"],
				desc = L["Wipe know spells and skills. Can be useful for example after a talent respec."],
				func = "CleanKnownSpells",
				confirm = true,
			},	
			cleanDatabase = {
				order = 11,
				type = 'execute',
				name = L["Clean Database"],
				desc = L["Clean up unneeded or redundant data in saved variables"],
				func = "CleanDatabase",
				confirm = true,
			},			
			trainableNextLevelRange = {
				order = 21,
				type = 'range',
				name = L["Level Range"],
				desc = L["Character level above current to show upcoming learnable skills"],
				get = function() return self.db.profile.trainableNextLevelRange end,
				set = function(v) self.db.profile.trainableNextLevelRange = v end,
				min = 0,
				max = 70,
				step = 1,
			},
			trainableNextSkillRange = {
				order = 22,
				type = 'range',
				name = L["Skill Range"],
				desc = L["Skill level above current to show upcoming learnable skills"],
				get = function() return self.db.profile.trainableNextSkillRange end,
				set = function(v) self.db.profile.trainableNextSkillRange = v end,
				min = 0,
				max = 375,
				step = 5,
			},
		}
	}

	self.OnMenuRequest = config
	self:RegisterChatCommand({ L["/trainerfu"] }, config)
end
